<?php
if ( ! function_exists( 'wpj_display_payment_general_instructions' ) ) {
	function wpj_display_payment_general_instructions() {
		wpj_update_last_checkout_viewed();

		$title       = get_post_meta( wpj_get_option( 'wpjobster_checkout_page_id' ), 'payment_instructions_title', true );
		$description = get_post_meta( wpj_get_option( 'wpjobster_checkout_page_id' ), 'payment_instructions_description', true );

		wpj_get_template( 'elements/checkout/payment-general-instructions-template.php', [
			'title'       => $title,
			'description' => $description
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_details_form' ) ) {
	function wpj_display_job_order_details_form( $pid = '', $display_location = '' ) {
		// Payment type
		$payment_type = wpj_get_payment_info_by_url( 'payment_type' );

		if ( ! $payment_type ) $payment_type = 'job_purchase';

		$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

		if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

		$default_price    = get_post_meta( $pid, 'job_packages', true ) == 'yes' ? get_post_meta( $pid, 'package_price', true )[$default_package] : '';
		$default_delivery = get_post_meta( $pid, 'job_packages', true ) == 'yes' ? get_post_meta( $pid, 'package_max_days', true )[$default_package] : '';

		// Display order details
		wpj_get_template( 'elements/checkout/job-order-details-form-template.php', [
			'pid'              => wpj_get_post_id( $pid ),
			'display_location' => $display_location,
			'payment_type'     => $payment_type,
			'tabs_slug'        => [ 'basic', 'standard', 'premium' ],
			'default_package'  => $default_package,
			'default_price'    => $default_price,
			'default_delivery' => $default_delivery
		] );
	}
}

if ( ! function_exists( 'wpj_display_payment_buttons' ) ) {
	function wpj_display_payment_buttons( $payment_type = '', $include_credits = true, $credits_only = false ) {
		if ( ! $payment_type ) $payment_type = wpj_get_payment_info_by_url( 'payment_type' );
		if ( ! $payment_type ) $payment_type = 'job_purchase';

		$pid  = wpj_get_post_id();
		$post = get_post( $pid );

		$is_post_author = get_current_user_id() == $post->post_author;

		$author_vacation = wpj_get_user_vacation( $post->post_author );
		$author_vacation = apply_filters( 'wpj_author_vacation_filter', $author_vacation, $pid );
		$author_vacation_reason = $author_vacation && $author_vacation['mode'] == 1 ? $author_vacation['reason'] : __( 'No reason provided', 'wpjobster' );

		$is_enough_credit = wpj_get_user_credit( get_current_user_id() ) >= wpj_get_checkout_total_price( $payment_type, $pid );

		if (
			(
				( $payment_type == 'job_purchase' && ! $is_post_author && ! $author_vacation && get_post_meta( $pid, "active", true ) == 1 )
				|| wpj_is_custom_offer( $pid )
				|| $payment_type != 'job_purchase'
			)
			&& wpj_get_payment_gateways()
		) {

			foreach ( wpj_get_payment_gateways() as $priority => $gateway ) {
				if ( wpj_is_payment_type_enabled( $gateway['unique_id'], $payment_type ) && empty( $gateway['no_pay_button'] ) ) { $gateway_enabled = true;
					if ( $gateway['unique_id'] == 'cod' && ! wpj_is_COD_payment_allowed( $pid, $payment_type ) ) { $gateway_enabled = false; }
				}
			}
		}

		if ( $include_credits && wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) { $gateway_enabled = true; }

		// No gateways
		if ( ! isset( $gateway_enabled ) ) {
			$error_msg = __( 'Payment methods are not available at this time. Please contact the administrator of this site for help.', 'wpjobster' );

		} elseif ( $is_post_author && $payment_type == 'job_purchase' ) {
			$error_msg = __( 'You can\'t buy your own job.', 'wpjobster' );

		} elseif ( $author_vacation && $payment_type == 'job_purchase' ) {
			$error_msg = sprintf( __( 'Job temporarily disabled. Reason: %s', 'wpjobster' ), $author_vacation_reason );

		} elseif ( ! wpj_is_custom_offer( $pid ) && ( $payment_type == 'job_purchase' && get_post_meta( $pid, "active", true ) != 1 ) ) {
			$error_msg = __( 'Job deactivated.', 'wpjobster' );

		} else {
			$error_msg = '';

		}

		wpj_get_template( 'elements/checkout/payment-buttons-template.php', [
			'pid'              => $pid,
			'payment_type'     => $payment_type,
			'is_post_author'   => $is_post_author,
			'author_vacation'  => $author_vacation,
			'include_credits'  => $include_credits,
			'credits_only'     => $credits_only,
			'is_enough_credit' => $is_enough_credit,
			'error_msg'        => $error_msg,
		] );
	}
}

if ( ! function_exists( 'wpj_display_badges_payment_list' ) ) {
	function wpj_display_badges_payment_list() {
		$badges_data = wpj_get_badge_info();

		$user_badge = get_user_meta( get_current_user_id(), 'user_badge', true );

		if ( $user_badge && ! is_array( $user_badge ) ) $user_badge = [$user_badge];

		$ratings_no = wpj_get_seller_rating_avg( get_current_user_id() );
		$reviews_no = wpj_get_seller_reviews_number( get_current_user_id() );

		wpj_get_template( 'elements/checkout/badges-payment-list-template.php', [
			'badges_data' => $badges_data,
			'user_badge'  => $user_badge,
			'ratings_no'  => $ratings_no,
			'reviews_no'  => $reviews_no,
		] );
	}
}

if ( ! function_exists( 'wpj_display_topup_payment_list' ) ) {
	function wpj_display_topup_payment_list() {
		wpj_get_template( 'elements/checkout/topup-payment-list-template.php', [
			'topup_packages' => wpj_get_option( 'topup-packages-settings' ),
			'currency'       => wpj_get_site_currency()
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_withdrawal_gateways_list' ) ) {
	function wpj_display_request_withdrawal_gateways_list() {
		$uid = get_current_user_id();

		$bank_bank_name_enabled      = apply_filters( 'wpj_payments_display_' . 'bank_bank_name' . '_field', true );
		$bank_account_name_enabled   = apply_filters( 'wpj_payments_display_' . 'bank_account_name' . '_field', true );
		$bank_account_number_enabled = apply_filters( 'wpj_payments_display_' . 'bank_account_number' . '_field', true );

		$default_gateways = [];

		if ( wpj_is_payment_type_enabled( 'paypal', 'withdraw' ) ) {
			$default_gateways['paypal'] = [
				'name'  => 'paypal',
				'label' => __( 'PayPal', 'wpjobster' ),
				'meta'  => get_user_meta( $uid, 'paypal_email', true )
			];
		}

		if ( apply_filters( 'wpj_payoneer_option_enabled_filter', wpj_is_payment_type_enabled( 'payoneer', 'withdraw', true ) ) == 'yes' ) {
			$default_gateways['payoneer'] = [
				'name'  => 'payoneer',
				'label' => __( 'Payoneer', 'wpjobster' ),
				'meta'  => apply_filters( 'wpj_payoneer_user_enabled_filter', get_user_meta( $uid, 'payoneer_email', true ) )
			];
		}

		if ( wpj_is_payment_type_enabled( 'banktransfer', 'withdraw' ) ) {
			if ( ( ( $bank_bank_name_enabled && get_user_meta( $uid, 'bank_bank_name', true ) != '' ) || ! $bank_bank_name_enabled )
				&& ( ( $bank_account_name_enabled && get_user_meta( $uid, 'bank_account_name', true ) != '' ) || ! $bank_account_name_enabled )
				&& ( ( $bank_account_number_enabled && get_user_meta( $uid, 'bank_account_number', true ) != '' ) || ! $bank_account_number_enabled )
			) {
				$meta = true;

			} else {
				$meta = false;

			}

			$default_gateways['banktransfer'] = [
				'name'  => 'banktransfer',
				'label' => __( 'Bank Account', 'wpjobster' ),
				'meta'  => $meta
			];
		}

		$default_gateways = apply_filters( 'wpj_withdrawals_gateways_info_filter', $default_gateways );

		wpj_get_template( 'elements/checkout/request-withdrawal-gateways-list-template.php', [
			'uid'              => $uid,
			'default_gateways' => $default_gateways
		] );
	}
}