<?php
if ( ! function_exists( 'wpj_display_currency_selector' ) ) {
	function wpj_display_currency_selector( $device = 'pc', $class = '' ) {
		global $wpjobster_currencies_array, $wpjobster_currencies_symbols_array;

		$jobster_design = wpj_get_design_option();

		$is_multicurrency = count( $wpjobster_currencies_array ) > 1;

		$icon = ! empty( $jobster_design['header_currency_icon_name'] ) && $jobster_design['header_currency_icon_name'] == true ? $jobster_design['header_currency_icon_name'] : 'money bill alternate outline';

		if ( strpos( $class, 'upward' ) !== false ) {
			$icon = ! empty( $jobster_design['footer_currency_icon_name'] ) && $jobster_design['footer_currency_icon_name'] == true ? $jobster_design['footer_currency_icon_name'] : 'money bill alternate outline';
		}

		if ( $is_multicurrency ) {
			wpj_get_template( 'elements/currency/currency-selector-' . $device . '-template.php', [
				'class'                              => $class,
				'wpjobster_currencies_array'         => $wpjobster_currencies_array,
				'wpjobster_currencies_symbols_array' => $wpjobster_currencies_symbols_array,
				'selected_currency'                  => wpj_get_site_currency(),
				'is_checkout_page'                   => is_page( wpj_get_option( 'wpjobster_checkout_page_id' ) ),
				'icon'                               => $icon
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_currency_selector_with_POST' ) ) {
	function wpj_display_currency_selector_with_POST() {
		global $wpjobster_currencies_array;

		if ( count( $wpjobster_currencies_array ) > 1 ) {
			wpj_get_template( 'elements/currency/currency-selector-post-template.php', ['wpjobster_currencies_array' => $wpjobster_currencies_array] );
		}
	}
}

if ( ! function_exists( 'wpj_display_exchange_rates_json' ) ) {
	function wpj_display_exchange_rates_json() {
		wpj_get_template( 'elements/currency/exchange-rates-json-template.php' );
	}
}