<?php
if ( ! function_exists( 'wpj_display_custom_offer_button' ) ) {
	function wpj_display_custom_offer_button( $args = [] ) {
		global $wp_query;

		$defaults = [
			'unique_id'       => wpj_get_user_id(),
			'id'              => wpj_get_user_id(),
			'title'           => '',
			'offer_type'      => '',
			'current_user_id' => get_current_user_id(),
			'post_author_id'  => wpj_get_user_id(),
			'page'            => '',
			'oid'             => isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '',
			'extra'           => '',
			'label_type'      => 'text',
			'label_icon'      => isset( $args['offer_type'] ) && $args['offer_type'] == 'request' ? 'tag' : 'tags'
		];

		$args = wp_parse_args( $args, $defaults );

		/**
		 * @var int $unique_id
		 * @var int $id
		 * @var string $title
		 * @var string $offer_type
		 * @var int $current_user_id
		 * @var int $post_author_id
		 * @var string $page
		 * @var int $oid
		 * @var string $extra
		 * @var string $label_type
		 * @var string $label_icon
		 */
		extract( $args );

		/* Button style */
		if ( $page == 'single_job' || $page == 'single_job_mobile' || $page == 'single_job_pc' )
			$btn_style = 'text-button text-button-gray-outlined single-job-custom-offer-button';

		elseif ( $page == 'private_messages' )
			$btn_style = 'text-button';

		elseif ( $page == 'job' )
			$btn_style = 'ui primary button';

		elseif ( $page == 'single_request' || $page == 'all_requests' || $page == 'search_request' )
			$btn_style = 'ui fluid primary button';

		elseif ( $page == 'order' )
			$btn_style = 'text-button text-button-secondary';

		elseif ( $page == 'user_profile' || $page == 'chat' )
			$btn_style = '';

		else
			$btn_style = 'ui primary button db';

		$btn_class  = is_user_logged_in() ? 'open-custom-offer-modal' : 'login-link';
		$btn_class .= ' ' . $offer_type . '-custom-offer';

		$array_to_send = array_merge( $args, [
			'class'     => $btn_style . ' ' . $btn_class,
			'is_error'  => false
		] );

		if ( wpj_get_option( 'wpjobster_enable_custom_offers' ) != 'no' ) {
			if ( $offer_type == 'request' ) {
				if ( $post_author_id != $current_user_id && apply_filters( 'hide_for_buyers', true, $post_author_id ) ) {
					wpj_get_template( 'elements/custom-offer/custom-offer-button-template.php', $array_to_send );
					wpj_init_request_custom_offer_modal( $array_to_send );
				}
			}

			if ( $offer_type == 'send' ) {
				if ( $post_author_id != $current_user_id && apply_filters( 'hide_for_buyers', true, get_current_user_id() ) ) {
					if ( wpj_get_option( 'wpjobster_active_job_cutom_offer' ) == 'yes' ) {
						if ( wpj_get_user_jobs_count( $current_user_id, 'active' ) > 0 ) {
							wpj_get_template( 'elements/custom-offer/custom-offer-button-template.php', $array_to_send );

						} else {
							$array_to_send['is_error'] = true;
							wpj_get_template( 'elements/custom-offer/custom-offer-button-template.php', $array_to_send );

						}

					} else {
						wpj_get_template( 'elements/custom-offer/custom-offer-button-template.php', $array_to_send );

					}

					wpj_init_send_custom_offer_modal( $array_to_send );
				}
			}
		}
	}
}