<?php
if ( ! function_exists( 'wpj_display_featured_homepage_row' ) ) {
	function wpj_display_featured_homepage_row() {
		$pid = wpj_get_post_id();
		$uid = get_current_user_id();

		$h_start_date = wpj_get_featured_start_date( 'homepage', $pid );
		$h_end_date   = wpj_get_featured_end_date( $h_start_date );

		$homepage_row = wpj_get_feature_job_by_page( 'h', $pid, $uid, 'pending' );

		wpj_get_template( 'elements/featured/payment-homepage-row-template.php', [
			'pid'                        => $pid,
			'uid'                        => $uid,
			'home_featured'              => get_post_meta( $pid, 'home_featured_until', true ),
			'homepage_row'               => $homepage_row,
			'h_start_date'               => $h_start_date,
			'h_end_date'                 => $h_end_date,
			'homepage_price_unformatted' => wpj_get_option( 'wpjobster_featured_price_homepage' ),
			'homepage_price_formatted'   => wpj_show_price( wpj_get_option( 'wpjobster_featured_price_homepage' ) ),
			'category'                   => isset( $homepage_row->feature_pages ) && strpos( $homepage_row->feature_pages, 'c' ) !== false ? __( 'category', 'wpjobster' ) : '',
			'subcategory'                => isset( $homepage_row->feature_pages ) && strpos( $homepage_row->feature_pages, 's' ) !== false ? __( 'subcategory', 'wpjobster' ) : ''
		] );
	}
}

if ( ! function_exists( 'wpj_display_featured_category_row' ) ) {
	function wpj_display_featured_category_row() {
		$pid = wpj_get_post_id();
		$uid = get_current_user_id();

		$c_start_date = wpj_get_featured_start_date( 'category', $pid );
		$c_end_date   = wpj_get_featured_end_date( $c_start_date );

		$category_row = wpj_get_feature_job_by_page( 'c', $pid, $uid, 'pending' );

		wpj_get_template( 'elements/featured/payment-category-row-template.php', [
			'pid'                        => $pid,
			'uid'                        => $uid,
			'category_featured'          => get_post_meta( $pid, 'category_featured_until', true ),
			'category_row'               => $category_row,
			'c_start_date'               => $c_start_date,
			'c_end_date'                 => $c_end_date,
			'category_price_unformatted' => wpj_get_option( 'wpjobster_featured_price_category' ),
			'category_price_formatted'   => wpj_show_price( wpj_get_option( 'wpjobster_featured_price_category' ) ),
			'homepage'                   => isset( $category_row->feature_pages ) && strpos( $category_row->feature_pages, 'h' ) !== false ? __( 'homepage', 'wpjobster' ) : '',
			'subcategory'                => isset( $category_row->feature_pages ) && strpos( $category_row->feature_pages, 's' ) !== false ? __( 'subcategory', 'wpjobster' ) : ''
		] );
	}
}

if ( ! function_exists( 'wpj_display_featured_subcategory_row' ) ) {
	function wpj_display_featured_subcategory_row() {
		$pid = wpj_get_post_id();
		$uid = get_current_user_id();

		$s_start_date = wpj_get_featured_start_date( 'subcategory', $pid );
		$s_end_date   = wpj_get_featured_end_date( $s_start_date );

		$subcategory_row = wpj_get_feature_job_by_page( 's', $pid, $uid, 'pending' );

		wpj_get_template( 'elements/featured/payment-subcategory-row-template.php', [
			'pid'                           => $pid,
			'uid'                           => $uid,
			'subcategory_featured'          => get_post_meta( $pid, 'subcategory_featured_until', true ),
			'subcategory_row'               => $subcategory_row,
			's_start_date'                  => $s_start_date,
			's_end_date'                    => $s_end_date,
			'subcategory_price_unformatted' => wpj_get_option( 'wpjobster_featured_price_subcategory' ),
			'subcategory_price_formatted'   => wpj_show_price( wpj_get_option( 'wpjobster_featured_price_subcategory' ) ),
			'homepage'                      => isset( $subcategory_row->feature_pages ) && strpos( $subcategory_row->feature_pages, 'h' ) !== false ? __( 'homepage', 'wpjobster' ) : '',
			'category'                      => isset( $subcategory_row->feature_pages ) && strpos( $subcategory_row->feature_pages, 'c' ) !== false ? __( 'category', 'wpjobster' ) : ''
		] );
	}
}