<?php
if ( ! function_exists( 'wpj_display_variable' ) ) {
	function wpj_display_variable( $args = [] ) {
		if (
			! empty ( $args['value'] )
			&& ( function_exists( $args['value'] ) && wpj_function_has_content( $args['value'] ) )
				|| ( ! function_exists( $args['value'] ) && $args['value'] )
		) {
			wpj_get_template( 'elements/form/variable-template.php', $args );
		}

	}
}

if ( ! function_exists( 'wpj_display_content' ) ) {
	function wpj_display_content( $args = [] ) {
		$args = wp_parse_args( $args, ['page_id' => ''] );

		if ( $args['page_id'] ) {
			$page_post    = get_post( wpj_get_option( $args['page_id'] ) );
			$blocks       = parse_blocks( $page_post->post_content );
			$page_content = '';

			if ( $blocks ) {
				foreach ( $blocks as $block ) {
					$page_content .= render_block( $block );
				}
			}

			if ( $page_content ) {
				remove_filter( 'the_content', 'wpautop' );

				$page_content = apply_filters( 'the_content', $page_content );

				add_filter( 'the_content', 'wpautop', 12 );

				wpj_get_template( 'elements/form/content-template.php', ['page_id' => $args['page_id'], 'page_content' => $page_content] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_message' ) ) {
	function wpj_display_message( $args = [] ) {
		$defaults = [
			'message_header'    => '',
			'message_content'   => '',
			'content_paragraph' => true,
			'message_class'     => '',
			'message_id'        => '',
			'is_hidden'         => true,
			'with_close_icon'   => false,
			'icon_class'        => 'close'
		];

		$args = wp_parse_args( $args, $defaults );

		wpj_get_template( 'elements/form/message-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_title' ) ) {
	function wpj_display_title( $args = [] ) {
		global $wp_query;

		$defaults = [
			'title'         => '',
			'pid'           => wpj_get_post_id(),
			'uid'           => get_current_user_id(),
			'icon'          => '',
			'link'          => '',
			'heading_class' => '',
			'title_class'   => '',
			'title_colour'  => '',
			'icon_class'    => '',
			'icon_colour'   => ''
		];

		$args = wp_parse_args( $args, $defaults );

		if ( $args['pid'] && empty( $args['title'] ) ) $args['title'] = get_the_title( $args['pid'] );
		elseif ( empty( $args['title'] ) ) $args['title'] = get_the_title();

		if ( $args['link'] == 'true' ) $args['link'] = get_permalink( $args['pid'] );

		if ( ! empty( $args['title_colour'] ) ) $args['title_colour'] = wpj_get_custom_colour( $args['title_colour'] );
		if ( ! empty( $args['icon_colour'] ) ) $args['icon_colour']   = wpj_get_custom_colour( $args['icon_colour'] );

		if ( wpj_is_custom_offer( $args['pid'] ) ) {
			$order               = isset( $wp_query->query_vars['oid'] ) ? wpj_get_job_order_by_id( $wp_query->query_vars['oid'] ) : '';
			$job_post            = get_post( $args['pid'] );

			$seller_id           = $job_post->post_author;
			$seller_data         = get_userdata( $seller_id );
			$seller_name         = is_object( $seller_data ) ? wpj_get_user_display_type( $seller_id ) : __( 'Deleted User', 'wpjobster' );

			$buyer_id            = isset( $order->uid ) ? $order->uid : '';
			$buyer_data          = get_userdata( $buyer_id );
			$buyer_name          = is_object( get_userdata( $buyer_id ) ) ? wpj_get_user_display_type( $buyer_id ) : __( 'Deleted User', 'wpjobster' );

			$args['seller_id']   = $seller_id;
			$args['seller_data'] = $seller_data;
			$args['seller_name'] = $seller_name;

			$args['buyer_id']    = $buyer_id;
			$args['buyer_data']  = $buyer_data;
			$args['buyer_name']  = $buyer_name;
		}

		wpj_get_template( 'elements/form/title-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_dividing_title' ) ) {
	function wpj_display_dividing_title( $title = '', $title_class = '' ) {
		if ( ! $title ) $title = get_the_title();

		wpj_get_template( 'elements/form/dividing-title-template.php', ['title' => $title, 'title_class' => $title_class] );
	}
}

if ( ! function_exists( 'wpj_display_dropdown' ) ) {
	function wpj_display_dropdown( $arr, $name, $default = '', $other_atts = '', $multiple = false ) {
		$opts = wpj_get_option( $name );

		$selected = '';

		if ( ! $multiple && $opts !== false && isset( $arr[$opts] ) ) {
			$selected = $opts;
		}

		$arr_values    = $multiple ? '[]' : '';
		$multiple_attr = $multiple ? ' multiple="multiple" ' : ' ';

		wpj_get_template( 'elements/form/dropdown-template.php', [
			'arr'           => $arr,
			'name'          => $name,
			'default'       => $default,
			'other_atts'    => $other_atts,
			'multiple'      => $multiple,
			'opts'          => $opts,
			'selected'      => $selected,
			'arr_values'    => $arr_values,
			'multiple_attr' => $multiple_attr
		] );
	}
}

if ( ! function_exists( 'wpj_display_button' ) ) {
	function wpj_display_button( $label = '', $type = 'link', $target = '', $class = '' ) {
		wpj_get_template( 'elements/form/button-template.php', [
			'label'  => $label,
			'type'   => $type,
			'target' => $target,
			'class'  => $class
		] );
	}
}

if ( ! function_exists( 'wpj_display_accordion' ) ) {
	function wpj_display_accordion( $args = [] ) {
		$defaults = [
			'segment_class'     => '',
			'title_class'       => '',
			'title'             => '',
			'description_class' => '',
			'description'       => '',
		];

		$args = wp_parse_args( $args, $defaults );

		if (
			( function_exists( $args['description'] ) && wpj_function_has_content( $args['description'] ) )
			|| ( ! function_exists( $args['description'] ) && $args['description'] )
		) {
			wpj_get_template( 'elements/form/accordion-template.php', $args );
		}
	}
}

if ( ! function_exists( 'wpj_display_tooltip' ) ) {
	function wpj_display_tooltip( $args = [] ) {
		$defaults = [
			'class'    => 'tooltip',
			'tooltip'  => '',
			'position' => 'top center',
			'value'    => ''
		];

		$args = wp_parse_args( $args, $defaults );

		wpj_get_template( 'elements/form/tooltip-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_wysiwyg_textarea' ) ) {
	function wpj_display_wysiwyg_textarea( $pid = '', $name = '', $id = '', $toolbar_id = '', $class = '', $placeholder = '', $value = '', $d_validate = '', $action = '', $indx = '', $required = false, $disabled = false ) {
		if ( $action == 'packages' ) {
			$minLength = wpj_get_option( 'wpj_job_package_description_character_limits' )[1];
			$maxLength = wpj_get_option( 'wpj_job_package_description_character_limits' )[2];

		} else {
			$minLength = wpj_get_option( 'wpj_job_description_character_limits' )[1];
			$maxLength = wpj_get_option( 'wpj_job_description_character_limits' )[2];

		}

		$rejected_description = '';

		if ( $action == 'edit-job' ) {
			$rejected_description = wpj_get_job_rejected_input( 'description' ) == 'rejected-input' ? 1 : '';
		}

		wpj_get_template( 'elements/form/wysiwyg-textarea-template.php', [
			'pid'                  => $pid,
			'name'                 => $name,
			'id'                   => $id,
			'toolbar_id'           => $toolbar_id,
			'class'                => $class,
			'placeholder'          => $placeholder,
			'value'                => $value,
			'd_validate'           => $d_validate,
			'action'               => $action,
			'indx'                 => $indx,
			'required'             => $required,
			'disabled'             => $disabled,
			'minLength'            => $minLength,
			'maxLength'            => $maxLength,
			'rejected_description' => $rejected_description
		] );
	}
}

if ( ! function_exists( 'wpj_display_tinyMCE_textarea' ) ) {
	function wpj_display_tinyMCE_textarea( $name = '', $class = '', $value = '' ) {
		$name  = WPJ_Form::request( 'name', $name );
		$class = WPJ_Form::request( 'class', $class );
		$value = WPJ_Form::request( 'value', $value );

		wpj_get_template( 'elements/form/tinyMCE-textarea-template.php', [
			'name'       => $name,
			'class'      => $class,
			'value'      => $value,
			'max_length' => isset( wpj_get_option( 'wpj_' . $name . '_character_limits' )[2]) ? wpj_get_option( 'wpj_' . $name . '_character_limits' )[2] : 1000
		] );
	}
}

if ( ! function_exists( 'wpj_display_table' ) ) {
	function wpj_display_table( $table_data = '', $table_header = '', $table_content = '', $table_no_results_msg = '', $tab_name = '' ) {
		wpj_get_template( 'elements/form/table-template.php', [
			'table_header'         => $table_header,
			'table_content'        => $table_content,
			'table_data'           => $table_data,
			'table_no_results_msg' => $table_no_results_msg,
			'tab_name'             => $tab_name
		] );
	}
}

if ( ! function_exists( 'wpj_display_gateway_form' ) ) {
	function wpj_display_gateway_form( $fields = [], $action_url = '', $autosubmit = true, $method = 'POST', $enctype = false ) {
		wpj_get_template( 'elements/form/gateway-form-template.php', [
			'fields'     => $fields,
			'action_url' => $action_url,
			'autosubmit' => $autosubmit,
			'method'     => $method,
			'enctype'    => $enctype
		] );
	}
}