<?php

if ( ! function_exists( 'wpj_display_user_graph' ) ) {
	function wpj_display_user_graph( $graph_type = 'sales', $full_width = true ) {
		if ( is_page( wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) ) ) $graph_type = 'shopping';

		if ( ! $graph_type ) $graph_type = 'sales';

		do_action( 'wpj_before_user_graph', $graph_type );

		wpj_get_template( 'elements/graph/user-graph-template.php', [
			'graph_type' => $graph_type,
			'full_width' => $full_width
		] );

		do_action( 'wpj_after_user_graph', $graph_type );
	}
}

if ( ! function_exists( 'wpj_display_user_graph_table' ) ) {
	function wpj_display_user_graph_table( $graph_type = '', $uid = '' ) {
		if ( wpj_get_option( 'wpjobster_enable_user_stats' ) == 'yes' ) {
			if ( ! $uid ) $uid = get_current_user_id();

			$earned = wpj_get_user_earned_amount( $uid );

			if ( $graph_type == 'shopping' ) {
				$graph_data = [
					__( 'Total spent'     , 'wpjobster' ) => wpj_show_price( wpj_get_job_orders_total_spent_by_user( $uid ) ),
					__( 'Active Orders'   , 'wpjobster' ) => wpj_get_active_orders_price( $uid ),
					__( 'Completed Orders', 'wpjobster' ) => get_user_meta( $uid, 'user_total_spendings', true ) ? wpj_show_price( get_user_meta( $uid, 'user_total_spendings', true ) ) : '0',
					__( 'Current Balance' , 'wpjobster' ) => wpj_show_price( wpj_get_user_credit( $uid ) )
				];

				$table_data = apply_filters( 'wpj_user_shopping_graph_data_filter', $graph_data );

			} else {
				$graph_data = [
					__( 'Gross Earned'     , 'wpjobster' ) => $earned['gross'] ? wpj_show_price( $earned['gross'] ) : 0,
					__( 'Net Earned'       , 'wpjobster' ) => $earned['net'] ? wpj_show_price( $earned['net'] ) : 0,
					__( 'Withdrawals'      , 'wpjobster' ) => wpj_get_withdrawal_amount( $uid ),
					__( 'Pending Clearance', 'wpjobster' ) => wpj_get_pending_clearance_amount( $uid ),
					__( 'Available Funds'  , 'wpjobster' ) => wpj_show_price( wpj_get_user_credit( $uid ) )
				];

				$table_data = apply_filters( 'wpj_user_sales_graph_data_filter', $graph_data );

			}

			wpj_get_template( 'elements/graph/user-graph-table-template.php', [
				'table_data' => $table_data,
				'uid'        => $uid
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_chart' ) ) {
	function wpj_display_user_chart( $graph_type = '', $uid = '' ) {
		if ( wpj_get_option( 'wpjobster_enable_user_stats' ) == 'yes' ) {
			$jobster_design = wpj_get_design_option();

			if ( ! $uid ) $uid = get_current_user_id();

			$graph_data = wpj_get_graph(
				$uid,
				( isset( $_GET['disp_type'] ) ? $_GET['disp_type'] : "" ),
				( isset( $_GET['select_year'] ) ? $_GET['select_year'] : "" ),
				( isset( $_GET['select_month'] ) ? $_GET['select_month'] : "" ),
				$graph_type
			);

			/**
			 * @var string $disp_type
			 * @var string $select_year
			 * @var string $select_month
			 * @var string $data_table
			 * @var string $type
			 */
			extract( $graph_data );

			$row        = wpj_get_user( 'user_registered', ['ID' => $uid], 'row' );
			$start_from = ! empty( $row->user_registered ) ? date( 'Y', strtotime( $row->user_registered ) ) : 2011;

			$year_arr  = range( $start_from, date( 'Y' ) );
			$year_arr  = array_combine( $year_arr, $year_arr );

			$month_arr = range( 01, 12 );
			$month_arr = array_combine( $month_arr, $month_arr );

			wpj_get_template( 'elements/graph/user-chart-template.php', [
				'uid'          => $uid,
				'disp_type'    => $disp_type,
				'select_year'  => $select_year,
				'select_month' => $select_month,
				'data_table'   => $data_table,
				'type'         => $type,
				'graph_type'   => $graph_type,
				'year_arr'     => $year_arr,
				'month_arr'    => $month_arr,
				'icon'         => ! empty( $jobster_design['user_account_icon_name'] ) ? $jobster_design['user_account_icon_name'] : 'chart line'
			] );
		}
	}
}