<?php
if ( ! function_exists( 'wpj_display_job_author' ) ) {
	function wpj_display_job_author( $pid = '' ) {
		if ( ! $pid ) $pid  = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		wpj_get_template( 'elements/job/job-author-template.php', [
			'pid'       => $pid,
			'post'      => $post,
			'author_id' => $post->post_author
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_cover_image' ) ) {
	function wpj_display_job_cover_image( $pid = '' ) {
		global $_wp_additional_image_sizes;

		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$cover_image_id = get_post_meta( $pid, 'cover-image', true );

		$cover_image_url = '';

		if ( ! empty( $cover_image_id ) )
			$cover_image_url = wpj_get_attachment_image_url( $cover_image_id , [$_wp_additional_image_sizes['job_cover_image']['width'], $_wp_additional_image_sizes['job_cover_image']['height']] );

		wpj_get_template( 'elements/job/job-cover-image-template.php', [
			'cover_image_id'  => $cover_image_id,
			'cover_image_url' => $cover_image_url,
			'pid'             => $pid
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_location' ) ) {
	function wpj_display_job_location( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$location_display = get_post_meta( $pid, 'location_input', true );

		if ( wpj_get_option( 'wpjobster_location' ) == 'yes' && ! empty( $location_display ) ) {
			wpj_get_template( 'elements/job/job-location-template.php', ['location_display' => $location_display, 'pid' => $pid] );
		}
	}
}

if ( ! function_exists( 'wpj_display_job_order_queue_number' ) ) {
	function wpj_display_job_order_queue_number( $pid = '' ) {
		wpj_get_template( 'elements/job/job-order-queue-number-template.php', ['pid' => wpj_get_post_id( $pid )] );
	}
}

if ( ! function_exists( 'wpj_display_job_delivery_days_number' ) ) {
	function wpj_display_job_delivery_days_number( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$instant  = get_post_meta( $pid, "instant", true );
		$max_days = get_post_meta( $pid, "max_days", true );

		if ( $instant == 1 ) {
			$deliv_msg = __( 'Instant', 'wpjobster' );

		} elseif ( intval( $max_days ) > 0 ) {
			$deliv_msg = sprintf( _n( '%d day', '%d days', $max_days, 'wpjobster' ), $max_days );

		} else {
			$deliv_msg = __( 'No delivery time', 'wpjobster' );

		}

		wpj_get_template( 'elements/job/job-delivery-days-template.php', ['pid' => $pid, 'deliv_msg' => $deliv_msg] );
	}
}

if ( ! function_exists( 'wpj_display_job_favorite_icon' ) ) {
	function wpj_display_job_favorite_icon( $pid = '', $delete_text = '', $add_text = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		if ( function_exists( 'upb_get_bookmark_count' ) ) {
			$number       = upb_get_bookmark_count( $pid );
			$number_plus  = $number + 1;
			$number_minus = $number - 1;

			if ( $delete_text == '' || $add_text == ''  ) {
				$add_text         = $number;
				$delete_text      = $number;
				$add_text_minus   = $number_minus;
				$delete_text_plus = $number_plus;

				$add_class    = 'bookmark-icon bookmark-add tooltip';
				$remove_class = 'bookmark-icon bookmark-remove tooltip';

			} else {
				$add_text_minus   = $add_text;
				$delete_text_plus = $delete_text;
				$add_class        = '';
				$remove_class     = '';

			}

			wpj_get_template( 'elements/job/job-favourite-icon-template.php', [
				'pid'              => $pid,
				'add_text'         => $add_text,
				'delete_text'      => $delete_text,
				'add_text_minus'   => $add_text_minus,
				'delete_text_plus' => $delete_text_plus,
				'add_class'        => $add_class,
				'remove_class'     => $remove_class,
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_job_social_share_icons' ) ) {
	function wpj_display_job_social_share_icons( $include_favorites = true ) {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/job/job-social-share-icons-template.php', [
			'jobster_design'    => $jobster_design,
			'include_favorites' => $include_favorites,
			'pid'               => wpj_get_post_id()
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_description' ) ) {
	function wpj_display_job_description( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		if ( ! $post ) {
			global $post;

			$pid = wpj_get_post_id( $post->ID );
		}

		$desc_content = $post->post_content;

		if ( wpj_get_option( 'wpjobster_job_description_type' ) == 'wysiwyg' || wpj_get_option( 'wpjobster_job_description_type' ) == 'tinymce' )
			$desc_content = wpautop( $desc_content );

		else
			$desc_content = wpautop( strip_tags( $desc_content ) );

		$desc_content = wpj_apply_filter_to_string( $desc_content, false, 'joblistings' );

		$read_more_enabled = wpj_get_option( 'wpjobster_view_more_description_enabled' );
		$desc_excerpt      = wpj_stripslashes( wpj_truncate_text( $desc_content, 250 ) );
		$desc_content      = wpj_stripslashes( $desc_content );

		wpj_get_template( 'elements/job/job-description-template.php', [
			'read_more_enabled' => $read_more_enabled,
			'desc_excerpt'      => $desc_excerpt,
			'desc_content'      => $desc_content,
			'pid'               => $pid,
			'title'             => $post->post_title
		] );
	}
}

if ( ! function_exists( 'wpj_display_buyer_instructions' ) ) {
	function wpj_display_buyer_instructions( $pid = '' ) {
		wpj_get_template( 'elements/job/job-buyer-instructions-template.php', ['pid' => wpj_get_post_id( $pid )] );
	}
}

if ( ! function_exists( 'wpj_display_job_faq' ) ) {
	function wpj_display_job_faq( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-faq-template.php', [
			'pid'          => $pid,
			'post_job_faq' => get_post_meta( $pid, 'faq', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_audio' ) ) {
	function wpj_display_job_audio( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-audio-template.php', [
			'pid'            => $pid,
			'audios'         => wpj_get_job_audios( $pid ),
			'audios_details' => wpj_get_job_audio_details( $pid )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_preview' ) ) {
	function wpj_display_job_preview( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-preview-template.php', [
			'pid'                 => $pid,
			'job_any_attachments' => get_post_meta( $pid, 'preview_job_attachments', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_map' ) ) {
	function wpj_display_job_map( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-map-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_job_custom_fields' ) ) {
	function wpj_display_job_custom_fields( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$Custom_Fields = new WPJ_Custom_Fields( $pid, 'job' );

		wpj_get_template( 'elements/job/job-custom-fields-template.php', ['pid' => $pid, 'Custom_Fields' => $Custom_Fields] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_form' ) ) {
	function wpj_display_job_order_form( $pid = '', $display_location = '', $with_label = true ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-order-form-template.php', ['display_location' => $display_location, 'pid' => $pid, 'with_label' => $with_label] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_button' ) ) {
	function wpj_display_job_order_button( $button_type = '', $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		$is_post_author = get_current_user_id() == $post->post_author;

		$submit_data = apply_filters( 'wpj_buy_job_submit_form_filter', 'data-submit="[name=myFormPurchase]"', 'login-link', $post->post_author );

		if ( is_user_logged_in() ) {
			$submit_action = isset( $submit_data['action'] ) ? $submit_data['action'] : 'data-submit="[name=myFormPurchase]"';
			$submit_class  = isset( $submit_data['class'] ) ? $submit_data['class'] : '';

		} else {
			$submit_action = isset( $submit_data['action'] ) ? $submit_data['action'] : '';
			$submit_class  = isset( $submit_data['class'] ) ? $submit_data['class'] : ( wpj_get_option( 'wpjobster_continue_button_not_loggefin' ) ?: 'login-link' );

		}

		$author_vacation        = wpj_get_user_vacation( $post->post_author );
		$author_vacation        = apply_filters( 'wpj_author_vacation_filter', $author_vacation, $pid );
		$author_vacation_reason = $author_vacation && $author_vacation['mode'] == 1 ? $author_vacation['reason'] : false;

		if ( get_post_meta( $pid, 'price_type', true ) != 'custom' ) {
			wpj_get_template( 'elements/job/job-order-button-template.php', [
				'pid'                    => $pid,
				'post'                   => $post,
				'author_vacation'        => $author_vacation,
				'author_vacation_reason' => $author_vacation_reason,
				'is_post_author'         => $is_post_author,
				'button_type'            => $button_type,
				'submit_class'           => $submit_class,
				'submit_action'          => $submit_action
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_job_basic_details' ) ) {
	function wpj_display_job_basic_details( $pid = '', $display_location = '', $package_nr = '' ) {
		// PID
		$pid = wpj_get_post_id( $pid );

		// Payment type
		$payment_type = wpj_get_payment_info_by_url( 'payment_type' );

		if ( ! $payment_type ) $payment_type = 'job_purchase';

		// Package nr
		if ( ! is_numeric( $package_nr ) ) {
			$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

			if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) {
				$default_package = 1;
			}

			$package_nr = $default_package;
		}

		// Title
		$packages_arr = [__( 'Basic', 'wpjobster' ), __( 'Standard', 'wpjobster' ), __( 'Premium', 'wpjobster' )];
		$title        = get_post_meta( $pid, 'job_packages', true ) == 'yes' && is_numeric( $package_nr ) ? $packages_arr[$package_nr] : __( 'Basic', 'wpjobster' );

		// Price
		$prc = wpj_get_checkout_total_price( $payment_type, $pid );

		// Package price
		if ( is_array( $prc ) ) {
			$prc = $prc[$package_nr];
		}

		wpj_get_template( 'elements/job/job-basic-details-template.php', [
			'pid'              => $pid,
			'display_location' => $display_location,
			'title'            => $title,
			'payment_type'     => $payment_type,
			'prc'              => $prc
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_quantity_details' ) ) {
	function wpj_display_job_quantity_details( $pid = '', $display_location = '', $package_nr = '' ) {
		// PID
		$pid = wpj_get_post_id( $pid );

		// Payment type
		$payment_type = wpj_get_payment_info_by_url( 'payment_type' );

		if ( ! $payment_type ) $payment_type = 'job_purchase';

		// Wrapper class
		$wrapper_class = '';

		if ( $display_location == 'sidebar_basic' ) {
			$wrapper_class = 'single-job-sidebar-price-content border-top';
		}

		if ( $display_location == 'sidebar_extra' ) {
			$wrapper_class = 'single-job-sidebar-price-content';
		}

		// Max amount
		$job_amount_max = 1;

		if ( $payment_type == 'job_purchase' && wpj_get_user_feature_status( 'wpjobster_enable_multiples', 'wpjobster_subscription_job_multiples_enabled' ) == 'yes' ) {
			$job_amount_max = wpj_get_user_feature_value( 'jobmultiples', 'job_multiples', '', get_current_user_id() );
		}

		wpj_get_template( 'elements/job/job-quantity-details-template.php', [
			'pid'              => $pid,
			'display_location' => $display_location,
			'wrapper_class'    => $wrapper_class,
			'is_price_type'    => get_post_meta( $pid, 'price_type', true ) && get_post_meta( $pid, 'price_type', true ) != 'fixed',
			'quantity'         => wpj_get_user_feature_status( 'wpjobster_enable_multiples', 'wpjobster_subscription_job_multiples_enabled' ),
			'job_amount_max'   => $job_amount_max,
			'allow_extra'      => $display_location == 'checkout' && wpj_get_option( 'wpjobster_checkout_extra_enabled' ) == 'no' ? false : true,
			'package_nr'       => $package_nr,
			'price_type'       => get_post_meta( $pid, 'price_type', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_extra_details' ) ) {
	function wpj_display_job_order_extra_details( $pid = '', $display_location = '', $ret_element = '' ) {
		// PID
		$pid = wpj_get_post_id( $pid );

		// Payment type
		$payment_type = wpj_get_payment_info_by_url( 'payment_type' );

		if ( ! $payment_type ) $payment_type = 'job_purchase';

		// Price
		$prc = wpj_get_checkout_total_price( $payment_type, $pid );

		// Extras
		$allow_extra = $display_location == 'checkout' && wpj_get_option( 'wpjobster_checkout_extra_enabled' ) == 'no' ? false : true;

		// Extra fast delivery
		$extra_fast_enabled = $extra_fast_price = '';

		$fast_delivery_amount_max = 1;

		if ( $payment_type == 'job_purchase' ) {
			$extra_fast_price = get_post_meta( $pid, 'extra_fast_price', true );

			if ( wpj_get_user_feature_status( 'wpjobster_enable_extra_fast_delivery', 'wpjobster_subscription_ex_fast_delivery_enabled' ) != "no" ) {
				$extra_fast_enabled       = get_post_meta( $pid, 'extra_fast_enabled', true );
				$fast_delivery_amount_max = wpj_get_user_feature_value( 'fast_delivery_multiples', 'fast_del_multiples', '', get_current_user_id() );
			}
		}

		$display_fast_delivery = $extra_fast_enabled && $fast_delivery_amount_max > 0 && $extra_fast_price && ( $allow_extra || WPJ_Form::post( 'extrafast' ) );

		// Extra revision
		$extra_revision_enabled = $extra_revision_price = '';
		$add_rev_amount_max     = 1;

		if ( $payment_type == 'job_purchase' ) {
			$extra_revision_price  = get_post_meta( $pid, 'extra_revision_price', true );

			if ( wpj_get_user_feature_status( 'wpjobster_enable_extra_additional_revision', 'wpjobster_subscription_additional_revision_enabled' ) != "no" ) {
				$extra_revision_enabled = get_post_meta( $pid, 'extra_revision_enabled', true );
				$add_rev_amount_max     = wpj_get_user_feature_value( 'add_rev_multiples', 'add_rev_multiples', '', get_current_user_id() );
			}
		}

		$display_additional_revision = $extra_revision_enabled && $add_rev_amount_max > 0 && $extra_revision_price && ( $allow_extra || WPJ_Form::post( 'extrarevision' ) );

		// Extras
		$extras = wpj_get_checkout_extras_info( $pid, $payment_type );

		$extra_amount_max = 1;

		if ( $payment_type == 'job_purchase' && wpj_get_user_feature_status( 'wpjobster_enable_extra_multiples', 'wpjobster_subscription_extra_multiples_enabled' ) == 'yes' ) {
			$extra_amount_max = wpj_get_user_feature_value( 'extramultiples', 'extra_multiples', '', get_current_user_id() );
		}

		// Shipping
		if ( $payment_type == 'job_purchase' ) {
			$shipping = get_post_meta( $pid, 'shipping', true );
		}

		if ( empty( $shipping ) ) $shipping = 0;

		// Processing fees
		$buyer_processing_fees = wpj_get_site_processing_fee_by_amount( $prc, $extras['extra_price'], $shipping );

		// Tax
		$tax_amount = wpj_get_site_tax_by_amount( $prc, $extras['extra_price'], $shipping, $buyer_processing_fees );

		wpj_get_template( 'elements/job/job-order-extra-details-template.php', [
			'pid'                         => $pid,
			'display_location'            => $display_location,
			'payment_type'                => $payment_type,
			'allow_extra'                 => $allow_extra,
			'display_fast_delivery'       => $display_fast_delivery,
			'fast_delivery_amount_max'    => $fast_delivery_amount_max,
			'display_additional_revision' => $display_additional_revision,
			'add_rev_amount_max'          => $add_rev_amount_max,
			'extra_job_add'               => $extras['extra_job_add'],
			'extra_amount_max'            => $extra_amount_max,
			'shipping'                    => $shipping,
			'buyer_processing_fees'       => $buyer_processing_fees,
			'tax_amount'                  => $tax_amount,
			'ret_element'                 => $ret_element
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_price' ) ) {
	function wpj_display_job_order_price( $pid = '', $class = '', $include_price_type = true, $package_nr = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$payment_type = wpj_get_payment_info_by_url( 'payment_type' );

		if ( ! $payment_type ) $payment_type = 'job_purchase';

		$custom_extra = wpj_get_payment_info_by_url( 'custom_extra' );
		$tip          = wpj_get_payment_info_by_url( 'tip' );

		$sample_prc  = 0;

		if ( $payment_type == 'job_purchase' ) {
			$sample_prc = get_post_meta( $pid, 'price', true );

			if ( ! is_numeric( $sample_prc ) || $sample_prc < 0 )
				$sample_prc = wpj_get_option( 'wpjobster_job_fixed_amount' );

			if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
				if ( ! is_numeric( $package_nr ) ) {
					$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

					if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

					$package_nr = $default_package;
				}

				$sample_prc = get_post_meta( $pid, 'package_price', true )[$package_nr];
			}

			$sample_prc = apply_filters( 'wpjobster_purchase_this_job_price', $sample_prc, $pid );

		} elseif ( $payment_type == 'custom_extra' ) {
			$sample_prc = $custom_extra->price;

		} elseif ( $payment_type == 'tips' ) {
			$sample_prc = $tip->amount;
		}

		wpj_get_template( 'elements/job/job-order-price-template.php', [
			'pid'                => wpj_get_post_id( $pid ),
			'sample_prc'         => $sample_prc,
			'main_amount'        => WPJ_Form::post( 'main_value_inp', 1 ),
			'class'              => $class,
			'include_price_type' => $include_price_type
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_order_total_price' ) ) {
	function wpj_display_job_order_total_price( $payment_type = '', $package_nr = '' ) {
		if ( ! $payment_type ) $payment_type = wpj_get_payment_info_by_url( 'payment_type' );
		if ( ! $payment_type ) $payment_type = 'job_purchase';

		$pid = wpj_get_post_id();

		$sample_prc = 0;

		if ( $payment_type == 'job_purchase' ) {
			$sample_prc = get_post_meta( $pid, 'price', true );

			if ( ! is_numeric( $sample_prc ) || $sample_prc < 0 )
				$sample_prc = wpj_get_option( 'wpjobster_job_fixed_amount' );

			if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
				if ( ! is_numeric( $package_nr ) ) {
					$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

					if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

					$package_nr = $default_package;
				}

				$sample_prc = WPJ_Form::post( 'package_price', get_post_meta( $pid, 'package_price', true )[$package_nr] );
			}

			$sample_prc = apply_filters( 'wpjobster_purchase_this_job_price', $sample_prc, $pid );

		} elseif ( $payment_type == 'custom_extra' ) {
			$custom_extra = wpj_get_payment_info_by_url( 'custom_extra' );
			$sample_prc   = $custom_extra->price;

		} elseif ( $payment_type == 'tips' ) {
			$tip        = wpj_get_payment_info_by_url( 'tip' );
			$sample_prc = $tip->amount;

		}

		$shipping = get_post_meta( $pid, 'shipping', true );

		if ( ! $shipping ) $shipping = 0;

		$decimal_sum_separator = wpj_get_option( 'wpjobster_decimal_sum_separator' );

		if ( empty( $decimal_sum_separator ) ) $decimal_sum_separator = '.';

		$thousands_sum_separator = wpj_get_option( 'wpjobster_thousands_sum_separator' );

		if ( empty( $thousands_sum_separator ) ) $thousands_sum_separator = ',';

		wpj_get_template( 'elements/job/job-order-total-price-template.php', [
			'pid'                     => $pid,
			'prc'                     => apply_filters( 'wpjobster_order_price_filter', $sample_prc, $pid ),
			'shipping'                => $shipping,
			'decimal_sum_separator'   => $decimal_sum_separator,
			'thousands_sum_separator' => $thousands_sum_separator,
			'payment_type'            => $payment_type
		] );
	}
}

if ( ! function_exists( 'wpj_display_suggested_jobs_list' ) ) {
	function wpj_display_suggested_jobs_list( $pid = '', $author = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		if ( $author ) $uid = $author;
		else $uid = $post->post_author;

		$author = wpj_get_userdata( $uid );

		wpj_get_template( 'elements/job/job-suggested-list-template.php', ['pid' => $pid, 'author' => $author] );
	}
}

if ( ! function_exists( 'wpj_display_job_or_offer_button' ) ) {
	function wpj_display_job_or_offer_button( $pid = '', $page = 'single_job', $location = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		wpj_get_template( 'elements/job/job-or-offer-button-template.php', [
			'pid'                  => $pid,
			'post'                 => $post,
			'page'                 => $page,
			'location'             => $location,
			'display_custom_offer' => wpj_get_option( 'wpjobster_enable_custom_offers' ) != 'no' && $post->post_author != get_current_user_id() && apply_filters( 'hide_for_buyers', true, $post->post_author )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_secure' ) ) {
	function wpj_display_job_secure() {
		wpj_get_template( 'elements/job/job-secure-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_job_terms' ) ) {
	function wpj_display_job_terms() {
		wpj_get_template( 'elements/job/job-terms-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_job_tags' ) ) {
	function wpj_display_job_tags( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-tags-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_job_views' ) ) {
	function wpj_display_job_views( $pid = '', $display_label = true ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-views-template.php', [
			'pid'           => $pid,
			'display_label' => $display_label
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_recently_bought' ) ) {
	function wpj_display_job_recently_bought( $uid = '', $display_title = 'no' ) {
		$jobster_design = wpj_get_design_option();

		$uid = $uid ? $uid : get_current_user_id();

		$row = wpj_get_job_order( 'job_title, pid', ['uid' => $uid, 'payment_status' => 'uid'], 'row' );

		$pic_id = isset( $row->pid ) ? get_the_post_thumbnail_url( $row->pid, 'thumb_picture_size' ) : '';

		if ( $pic_id != false ) {
			$img = $pic_id;

		} else {
			$img = ! empty( $jobster_design['no_image_icon_options_job']['url'] ) ? $jobster_design['no_image_icon_options_job']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
			$img = apply_filters( 'wpj_placeholder_image_url_filter', $img, 'jobs' );

		}

		wpj_get_template( 'elements/job/job-recently-bought-template.php', [
			'row'           => $row,
			'img'           => $img,
			'display_title' => $display_title
		] );

	}
}

if ( ! function_exists( 'wpj_display_job_recently_viewed' ) ) {
	function wpj_display_job_recently_viewed( $uid = '', $display_title = 'no' ) {
		$uid = $uid ? $uid : get_current_user_id();

		$last_viewed = get_user_meta( $uid, 'last_viewed', true );

		$args = [
			'post_type'           => 'job',
			'posts_per_page'      => 5,
			'post__in'            => $last_viewed,
			'ignore_sticky_posts' => true,
			'orderby'             => 'post__in'
		];

		wpj_get_template( 'elements/job/job-recently-viewed-template.php', [
			'uid'           => $uid,
			'last_viewed'   => $last_viewed,
			'args'          => $args,
			'display_title' => $display_title
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_bulk_action_button' ) ) {
	function wpj_display_job_bulk_action_button() {
		wpj_get_template( 'elements/job/job-bulk-action-button-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_job_edit_button' ) ) {
	function wpj_display_job_edit_button( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );
		wpj_get_template( 'elements/job/job-edit-button-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_job_delete_button' ) ) {
	function wpj_display_job_delete_button( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/job/job-delete-button-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_job_map_overview' ) ) {
	function wpj_display_job_map_overview( $args = [] ) {
		$defaults = [
			'show_title'       => true,
			'show_excerpt'     => true,
			'show_description' => false,
			'show_price'       => true,
			'show_author'      => true,
			'show_location'    => true
		];

		$args = wp_parse_args( $args, $defaults );

		$locations = [];

		$jobs = get_posts([
			'post_status'    =>'publish',
			'posts_per_page' => -1,
			'post_type'      => 'job'
		]);

		if ( $jobs ) {
			foreach ( $jobs as $job ) {
				$location  = get_post_meta( $job->ID, 'location_input', true );
				$latitude  = get_post_meta( $job->ID, 'lat', true );
				$longitude = get_post_meta( $job->ID, 'long', true );

				$package_type       = get_post_meta( $job->ID, 'job_packages', true );
				$package_price      = get_post_meta( $job->ID, 'package_price', true );
				$package_price_vals = $package_type == 'yes' && $package_price ? array_diff( $package_price, [ null ] ) : '';

				if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $job->ID, 'job_packages', true ) == 'yes' && $package_price_vals ) {
					$price = sprintf( __( 'Starting at %s', 'wpjobster' ), wpj_show_price( min( $package_price_vals ) ) );

				} elseif ( get_post_meta( $job->ID, 'price_type', true ) ) {
					$price = wpj_show_price( get_post_meta( $job->ID, 'price', true ), 2, true ) . ' ' . wpj_translate_string( get_post_meta( $job->ID, 'price_type', true ) );

				} else {
					$price = wpj_show_price( get_post_meta( $job->ID, 'price', true ), 2, true );

				}

				if ( $location && $latitude && $longitude ) {
					$locations[] = [
						'title'       => $job->post_title,
						'excerpt'     => get_the_excerpt( $job->ID ),
						'description' => $job->post_content,
						'price'       => $price,
						'author_name' => wpj_get_user_display_type( $job->post_author ),
						'author_url'  => wpj_get_user_profile_link( $job->post_author ),
						'location'    => $location,
						'latitude'    => $latitude,
						'longitude'   => $longitude,
						'url'         => get_permalink( $job->ID )
					];
				}
			}
		}

		$args['locations'] = $locations;

		wpj_get_template( 'elements/job/job-map-overview-template.php', $args );
	}
}