<?php
if ( ! function_exists( 'wpj_display_languages_selector' ) ) {
	function wpj_display_languages_selector( $device = 'pc' ) {
		if ( ( class_exists( 'TRP_Translate_Press' ) || function_exists( 'qtranxf_getSortedLanguages' ) ) && wpj_is_multilanguage_allowed() ) {
			$jobster_design = wpj_get_design_option();

			if ( class_exists( 'TRP_Translate_Press' ) ) {
				global $TRP_LANGUAGE;

				$trp = TRP_Translate_Press::get_trp_instance();

				$trp_languages       = $trp->get_component( 'languages' );
				$setting             = $trp->get_component( 'settings' );
				$url_converter       = $trp->get_component( 'url_converter' );

				$published_languages = $trp_languages->get_language_names( $setting->get_setting( 'publish-languages' ) );
				$languages_count     = count( $published_languages );
				$current_language    = current( explode( '_', $TRP_LANGUAGE ) );

				$languages_arr = [];

				foreach ( $published_languages as $key => $language ) {
					$languages_arr[] = [
						'code' => current( explode( '_', $key ) ),
						'name' => $language,
						'url'  => esc_url( $url_converter->get_url_for_language( $key, false ) )
					];
				}

			} elseif ( function_exists( 'qtranxf_getSortedLanguages' ) ) {
				global $q_config;

				$published_languages = qtranxf_getSortedLanguages();
				$languages_count     = count( qtranxf_getSortedLanguages() );
				$current_language    = $q_config['language'];
				$lng_url             = is_404() ? wpj_get_option( 'home' ) : '';

				$languages_arr = [];

				foreach ( $published_languages as $key => $code ) {
					$languages_arr[] = [
						'code' => $code,
						'name' => $q_config['language_name'][$code],
						'url'  => function_exists( 'qtranxf_convertURL' ) ? esc_url( qtranxf_convertURL( $lng_url, $code, false, true ) ) : ''
					];
				}
			}

			if ( class_exists( 'TRP_Translate_Press' ) || function_exists( 'qtranxf_getSortedLanguages' ) ) {
				if ( $languages_count > 1 ) {
					wpj_get_template('elements/language/language-selector-' . $device . '-template.php', [
						'published_languages' => $published_languages,
						'current_language' => $current_language,
						'languages_count' => $languages_count,
						'languages_arr' => $languages_arr,
						'icon' => $jobster_design['header_language_icon_name'] == true ? $jobster_design['header_language_icon_name'] : 'globe americas'
					] );
				}
			}
		}
	}
}