<?php
if ( ! function_exists( 'wpj_display_attachments_list' ) ) {
	function wpj_display_attachments_list( $attachments_arr = '', $pid = '', $meta_name = '', $title = false, $title_label = 'Attachments', $file_size = true, $delete_action = true ) {
		if ( $attachments_arr ) {
			wpj_get_template( 'elements/media/attachments-list-template.php', [
				'attachments'   => explode( ",", $attachments_arr ),
				'pid'           => $pid,
				'meta_name'     => $meta_name,
				'title'         => $title,
				'title_label'   => $title_label,
				'file_size'     => $file_size,
				'delete_action' => $delete_action,
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_round_job_image' ) ) {
	function wpj_display_round_job_image( $pid = '', $width = 100, $height = 100, $oid = '' ) {
		$jobster_design = wpj_get_design_option();

		$pid = wpj_get_post_id( $pid );

		$no_image_src = ! empty( $jobster_design['no_image_icon_options_job']['url'] ) ? $jobster_design['no_image_icon_options_job']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
		$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'jobs' );

		wpj_get_template( 'elements/media/round-job-image-template.php', [
			'pid'            => wpj_get_post_id( $pid ),
			'oid'            => $oid,
			'width'          => $width ? $width : 100,
			'height'         => $height ? $height : 100,
			'link'           => get_permalink( $pid ),
			'jobster_design' => $jobster_design,
			'no_image_src'   => $no_image_src
		] );
	}
}

if ( ! function_exists( 'wpj_display_loader' ) ) {
	function wpj_display_loader( $location = '', $redirect = 'no' ) {
		wpj_get_template( 'elements/media/loader-template.php', [
			'redirect'         => $redirect,
			'location'         => $location,
			'loader_image_url' => get_template_directory_uri() . '/assets/images/loader/loader-big.gif'
		] );
	}
}

if ( ! function_exists( 'wpj_display_segment_loader' ) ) {
	function wpj_display_segment_loader( $id = '', $class = '', $icon_class = '' ) {
		wpj_get_template( 'elements/media/segment-loader-template.php', [
			'id'         => $id,
			'class'      => $class,
			'icon_class' => $icon_class
		] );
	}
}

if ( ! function_exists( 'wpj_display_secure_shopping_banner' ) ) {
	function wpj_display_secure_shopping_banner() {
		wpj_get_template( 'elements/media/secure-shopping-banner-template.php' );
	}
}