<?php
if ( ! function_exists( 'wpj_display_main_menu' ) ) {
	function wpj_display_main_menu() {
		wpj_get_template( 'elements/menu/main-menu-template.php', [
			'menu_location' => is_page( wpj_get_user_account_pages() ) ? apply_filters( 'wpj_header_user_account_menu_filter', 'wpjobster_header_user_account_menu' ) : apply_filters( 'wpj_header_main_menu_filter', 'wpjobster_header_main_menu' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_secondary_menu' ) ) {
	function wpj_display_secondary_menu( $menu_location = '' ) {
		wpj_get_template( 'elements/menu/secondary-menu-template.php', [
			'menu_location' => $menu_location
		] );
	}
}

if ( ! function_exists( 'wpj_display_dropdown_menu' ) ) {
	function wpj_display_dropdown_menu( $args ) {
		$jobster_design = wpj_get_design_option();

		$defaults = [
			'menu'     => '',
			'language' => false,
			'currency' => false,
			'logout'   => true
		];

		$args = wp_parse_args( $args, $defaults );

		$args['menu'] = apply_filters( 'wpjobster_dropdown_menu_list_filter', $args['menu'] );

		$args['items_no'] = count( $args['menu'] );

		$args['split_menu'] = isset( $jobster_design['dropdown_menu_style'] ) && $jobster_design['dropdown_menu_style'] == '1' ? false : true;

		wpj_get_template( 'elements/menu/dropdown-menu-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_notification_icons_menu' ) ) {
	function wpj_display_notification_icons_menu() {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/menu/notification-icons-template.php', [
			'icon_message'       => ! empty( $jobster_design['header_message_icon_name'] ) && $jobster_design['header_message_icon_name'] == true ? $jobster_design['header_message_icon_name'] : '',
			'icon_notifications' => ! empty( $jobster_design['header_notification_icon_name'] ) && $jobster_design['header_notification_icon_name'] == true ? $jobster_design['header_notification_icon_name'] : ''
		] );
	}
}

if ( ! function_exists( 'wpj_display_authentication_buttons_menu' ) ) {
	function wpj_display_authentication_buttons_menu( $device = 'pc' ) {
		if ( wpj_get_user_authentication_links( $device ) ) {
			wpj_get_template( 'elements/menu/authentication-buttons-template.php', ['device' => $device] );
		}
	}
}

// Display empty menu link
if ( ! function_exists( 'wpj_display_empty_menu_assignment_link' ) ) {
	function wpj_display_empty_menu_assignment_link( $args = [] ) {
		if ( ! current_user_can( 'manage_options' ) ) {
			return false;
		}

		$defaults = [
			'menu'            => '',
			'container'       => 'div',
			'container_class' => '',
			'container_id'    => '',
			'menu_class'      => 'menu',
			'menu_id'         => '',
			'fallback_cb'     => 'wp_page_menu',
			'before'          => '',
			'after'           => '',
			'link_before'     => '',
			'link_after'      => '',
			'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			'item_spacing'    => 'preserve',
			'depth'           => 0,
			'walker'          => '',
			'theme_location'  => '',
		];

		$args = wp_parse_args( $args, $defaults );

		wpj_get_template( 'elements/menu/empty-menu-assignment-link-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_user_menu_sidebar' ) ) {
	function wpj_display_user_menu_sidebar( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		wpj_get_template( 'elements/menu/user-menu-sidebar-template.php', ['uid' => $uid] );
	}
}

if ( ! function_exists( 'wpj_display_menu_by_name' ) ) {
	function wpj_display_menu_by_name( $name = '', $container = '' ) {
		wpj_get_template( 'elements/menu/menu-by-name-template.php', ['name' => $name, 'container' => $container] );
	}
}

if ( ! function_exists( 'wpj_display_user_info_account_menu' ) ) {
	function wpj_display_user_info_account_menu() {
		if ( wpj_is_ajax_call() ) {
			wpj_get_template( 'elements/menu/user-info-account-menu-template.php' );

			wp_die();

		} else {
			wpj_get_template( 'elements/menu/user-info-account-menu-placeholder-template.php' );

		}
	}
}

if ( ! function_exists( 'wpj_display_filter_buttons' ) ) {
	function wpj_display_filter_buttons( $page = '' ) {
		global $wp_query;

		// Tabs Info
		$tabs = wpj_get_tabs_by_page( $page );

		// Active Tab
		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		// Count function name
		$function_name = '';

		if ( $page == 'user_jobs' )      $function_name = 'wpj_get_user_jobs_count';
		if ( $page == 'user_shopping' )  $function_name = 'wpj_get_shopping_orders';
		if ( $page == 'user_sales' )     $function_name = 'wpj_get_sales_orders';
		if ( $page == 'user_requests' )  $function_name = 'wpj_get_user_requests';
		if ( $page == 'user_proposals' ) $function_name = 'wpj_get_user_proposals';

		// Template
		if ( $tabs ) {
			wpj_get_template( 'elements/menu/filter-buttons-template.php', [
				'page'          => $page,
				'tabs'          => $tabs,
				'active_tab'    => $active_tab,
				'function_name' => $function_name
			] );
		}
	}
}
