<?php

// STRING VALIDATION

if ( ! function_exists( 'wpj_display_filter_warning' ) ) {
	function wpj_display_filter_warning( $validation_errors ) {
		if ( $validation_errors ) {
			wpj_get_template( 'elements/notice/filter-warning-template.php', ['validation_errors' => $validation_errors] );
		}
	}
}

// JOB

if ( ! function_exists( 'wpj_display_job_post_new_notices' ) ) {
	function wpj_display_job_post_new_notices() {
		$JobsNewEditClass = new WPJJobsNewEdit();

		wpj_get_template( 'elements/notice/job-post-new-notices-template.php', [
			'uid'              => get_current_user_id(),
			'post'             => get_post( WPJ_Form::get( 'jobid' ) ),
			'JobsNewEditClass' => $JobsNewEditClass
		] );
	}
}

if ( ! function_exists( 'wpj_display_no_credits_warning' ) ) {
	function wpj_display_no_credits_warning() {
		if ( ! empty ( $_GET['no_credits'] ) ) {
			wpj_get_template( 'elements/notice/no-credits-warning-template.php' );
		}
	}
}

if ( ! function_exists( 'wpj_display_job_user_account_notices' ) ) {
	function wpj_display_job_user_account_notices() {
		if ( ! empty ( $_GET['active-jobs-exceeded'] ) ) {
			wpj_get_template( 'elements/notice/active-jobs-exceeded-warning-template.php' );
		}

		$is_seller = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

		if ( ! empty( $is_seller ) ) {
			$sellers_messages = get_posts([
				'post_status'    => 'publish',
				'posts_per_page' => -1,
				'post_type'      => 'sellers-messages'
			]);

			if ( ! empty ( $sellers_messages ) ) {
				wpj_get_template( 'elements/notice/sellers-messages-notice-template.php', [
					'sellers_messages' => $sellers_messages
				] );
			}
		}

		do_action( 'wpj_after_user_account_notices' );
	}
}

// REQUEST

if ( ! function_exists( 'wpj_display_request_post_new_notices' ) ) {
	function wpj_display_request_post_new_notices() {
		$RequestsNewEditClass = new WPJRequestsNewEdit();

		wpj_get_template( 'elements/notice/request-post-new-notices-template.php', [
			'uid'                  => get_current_user_id(),
			'post'                 => get_post( WPJ_Form::get( 'requestid' ) ),
			'RequestsNewEditClass' => $RequestsNewEditClass
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_notices' ) ) {
	function wpj_display_request_notices() {
		if ( isset( $_GET['submitted'] ) && ( ctype_digit( $_GET['submitted'] ) || is_int( $_GET['submitted'] ) ) ) {
			$submitted_request = isset( $_GET['submitted'] ) ? get_post( $_GET['submitted'] ) : '';

			if ( $submitted_request && $submitted_request->post_type == 'request' && $submitted_request->post_author == get_current_user_id() ) {
				wpj_get_template( 'elements/notice/request-notices-template.php', ['submitted_request' => $submitted_request] );
			}
		}
	}
}

// USER
if ( ! function_exists( 'wpj_display_skill_info_notice' ) ) {
	function wpj_display_skill_info_notice() {
		wpj_get_template( 'elements/notice/skill-info-notice-template.php' );
	}
}

// MESSAGE
if ( ! function_exists( 'wpj_display_quick_response_info_notice' ) ) {
	function wpj_display_quick_response_info_notice() {
		wpj_get_template( 'elements/notice/quick-response-info-notice-template.php' );
	}
}

// PROPOSAL

if ( ! function_exists( 'wpj_display_proposal_disabled_notice' ) ) {
	function wpj_display_proposal_disabled_notice() {
		wpj_get_template( 'elements/notice/proposal-disabled-notice-template.php' );
	}
}

// TRANSACTION

if ( ! function_exists( 'wpj_display_transaction_not_allowed_notice' ) ) {
	function wpj_display_transaction_not_allowed_notice() {
		wpj_get_template( 'elements/notice/transaction-not-allowed-notice-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_extend_delivery_not_allowed_notice' ) ) {
	function wpj_display_extend_delivery_not_allowed_notice( $oid = '' ) {
		if ( wpj_get_seller_id( $oid ) != get_current_user_id() )
			wpj_get_template( 'elements/notice/extend-delivery-not-allowed-notice-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_checkout_not_allowed_notice' ) ) {
	function wpj_display_checkout_not_allowed_notice() {
		wpj_get_template( 'elements/notice/checkout-not-allowed-notice-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_payment_notices' ) ) {
	function wpj_display_payment_notices( $error ) {
		wpj_get_template( 'elements/notice/payment-notices-template.php', ['error' => $error] );
	}
}

if ( ! function_exists( 'wpj_display_order_notices' ) ) {
	function wpj_display_order_notices( $oid = '' ) {
		global $wp_query;

		if ( ! $oid && isset( $wp_query->query_vars['oid'] ) ) $oid = $wp_query->query_vars['oid'];

		$arbitration = wpj_get_arbitration_order( 'buyer_arbitration', ['order_id' => $oid], 'row' );

		wpj_get_template( 'elements/notice/order-notices-template.php', [
			'oid'               => $oid,
			'order'             => wpj_get_job_order_by_id( $oid ),
			'buyer_arbitration' => isset( $arbitration->buyer_arbitration ) && $arbitration->buyer_arbitration == 1,
		] );
	}
}

// SUBSCRIPTION

if ( ! function_exists( 'wpj_display_subscription_notices' ) ) {
	function wpj_display_subscription_notices() {
		$message_type = ''; $message = '';

		if ( isset( $_GET['sub_error'] ) && $_GET['sub_error'] == '1' || isset( $_GET['thankyou'] ) && $_GET['thankyou'] == '1' ) {
			$error        = isset( $_GET['sub_error'] ) && $_GET['sub_error'] == '1' ? '1' : '0';
			$message_code = $_GET['message_code'];

			if ( $error == 1 ) {
				$message_type = 'negative';
				$messages     = wpj_get_subscription_messages( 'errors' );

			} else {
				$message_type = 'positive';
				$messages     = wpj_get_subscription_messages( 'messages' );
			}

			$message = $messages[$message_code];
		}

		wpj_get_template( 'elements/notice/subscription-notices-template.php', [
			'message'              => $message,
			'message_type'         => $message_type,
			'current_subscription' => wpj_get_subscription_by_uid( get_current_user_id() )
		] );
	}
}

if ( ! function_exists( 'wpj_display_subscription_upgrade_notice' ) ) {
	function wpj_display_subscription_upgrade_notice( $page = '' ) {
		wpj_get_template( 'elements/notice/subscription-upgrade-notice-template.php', ['page' => $page] );
	}
}

if ( ! function_exists( 'wpj_display_subscription_invalid_notice' ) ) {
	function wpj_display_subscription_invalid_notice() {
		wpj_get_template( 'elements/notice/subscription-invalid-notice-template.php' );
	}
}

// BADGE

if ( ! function_exists( 'wpj_display_badge_notices' ) ) {
	function wpj_display_badge_notices() {
		$user_badge = get_user_meta( get_current_user_id(), 'user_badge', true );

		if ( $user_badge && ! is_array( $user_badge ) ) $user_badge = [$user_badge];

		wpj_get_template( 'elements/notice/badge-notices-template.php', [
			'badges_data' => wpj_get_option( 'badge-list-settings' ),
			'user_badge'  => $user_badge
		] );
	}
}

// FEATURED

if ( ! function_exists( 'wpj_display_featured_notices' ) ) {
	function wpj_display_featured_notices() {
		$status_class = ''; $status_message = '';

		if ( isset( $_GET['status'] ) ) {
			if ( $_GET['status'] == 'success' ) {
				$status_class   = 'success';
				$status_message = __( 'Your payment was successful!', 'wpjobster' );

			}

			if ( $_GET['status'] == 'fail' ) {
				$status_class = 'negative';

				if ( WPJ_Form::get( 'message' ) == 'credits_err' )
					$status_message = __( 'You don\'t have enough money in your balance. Choose one of the other payment methods.', 'wpjobster' );

				else
					$status_message = __( 'Payment failed! Please try again.', 'wpjobster' );
			}
		}

		wpj_get_template( 'elements/notice/featured-notices-template.php', [
			'pid'            => wpj_get_post_id(),
			'status_class'   => $status_class,
			'status_message' => $status_message
		] );
	}
}

// TOPUP

if ( ! function_exists( 'wpj_display_topup_notices' ) ) {
	function wpj_display_topup_notices() {
		$order = wpj_get_topup_order_details();

		wpj_get_template( 'elements/notice/topup-notices-template.php', ['order' => $order['current_order']] );
	}
}

// VERIFICATION

if ( ! function_exists( 'wpj_display_email_verification_notice' ) ) {
	function wpj_display_email_verification_notice() {
		wpj_get_template( 'elements/notice/email-verification-notice-template.php', [
			'email_verification_option' => wpj_get_option( 'wpjobster_verify_email' ),
			'email_verification_data'   => get_user_meta( get_current_user_id(), 'uz_email_verification', true ),
			'email_verification_url'    => get_permalink( wpj_get_option( 'wpjobster_verify_email_page_id' ) ) . '?action=resend'
		] );
	}
}

if ( ! function_exists( 'wpj_display_phone_verification_notice' ) ) {
	function wpj_display_phone_verification_notice() {
		wpj_get_template( 'elements/notice/phone-verification-notice-template.php', [
			'phone_verification_option' => wpj_get_option( 'wpjobster_verify_phone_numbers' ),
			'phone_verification_number' => get_user_meta( get_current_user_id(), 'cell_number', true ),
			'phone_verification_data'   => get_user_meta( get_current_user_id(), 'uz_phone_verification', true ),
			'phone_verification_url'    => get_permalink( wpj_get_option( 'wpjobster_verify_phone_page_id' ) ) . '?action=resend'
		] );
	}
}

// PAGE

if ( ! function_exists( 'wpj_display_page_no_fields_warning' ) ) {
	function wpj_display_page_no_fields_warning() {
		wpj_get_template( 'elements/notice/page-no-fields-warning-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_no_categories_notice_warning' ) ) {
	function wpj_display_no_categories_notice_warning() {
		wpj_get_template( 'elements/notice/no-categories-notice-temnplate.php' );
	}
}