<?php
/* PREVIEW PANEL */
if ( ! function_exists( 'wpj_display_preview_pm_list' ) ) {
	function wpj_display_preview_pm_list() {
		wpj_get_template( 'elements/notify/preview-pm-list-template.php', [
			'uid'      => get_current_user_id(),
			'messages' => wpj_get_preview_pms_list( get_current_user_id() ),
			'i'        => 0,
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_preview_notification_list' ) ) {
	function wpj_display_preview_notification_list() {
		$buyer_uid  = implode( ", ", wpj_get_chatbox_uid_by_user_type( 'buyer' ) );
		$seller_uid = implode( ", ", wpj_get_chatbox_uid_by_user_type( 'seller' ) );

		wpj_get_template( 'elements/notify/preview-notification-list-template.php', [
			'uid'           => get_current_user_id(),
			'notifications' => wpj_get_preview_notifications_list( $buyer_uid, $seller_uid ),
			'i'             => 0,
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

/* CHAT */
if ( ! function_exists( 'wpj_display_chat_sidebar_placeholder' ) ) {
	function wpj_display_chat_sidebar_placeholder( $sidebar_status = '', $icon = 'comments' ) {
		$jobster_design = wpj_get_design_option();

		$args = [
			'jobster_design' => $jobster_design,
			'sidebar_status' => $sidebar_status,
			'icon'           => $icon
		];

		if ( $jobster_design['chat_sidebar_style'] == 1 )
			wpj_get_template( 'elements/notify/chat-sidebar-placeholder-template.php', $args );

		else
			wpj_get_template( 'elements/notify/chat-sidebar-minimal-placeholder-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_chat_sidebar' ) ) {
	function wpj_display_chat_sidebar( $users, $sidebar_status = '', $user_on_cnt = 0 , $icon = 'comments' ) {
		$jobster_design = wpj_get_design_option();

		$args = [
			'jobster_design' => $jobster_design,
			'users'          => $users,
			'sidebar_status' => $sidebar_status,
			'user_on_cnt'    => $user_on_cnt,
			'icon'           => $icon
		];

		if ( $jobster_design['chat_sidebar_style'] == 1 )
			wpj_get_template( 'elements/notify/chat-sidebar-template.php', $args );

		else
			wpj_get_template( 'elements/notify/chat-sidebar-minimal-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_chat_messagebox' ) ) {
	function wpj_display_chat_messagebox( $uid = '', $box_status = '' ) {
		if ( ! $uid ) $uid = WPJ_Form::post( 'user_id' );
		if ( ! $box_status ) $box_status = WPJ_Form::post( 'box_status', 'maximized' );

		if ( $uid ) {
			$user_arr = get_userdata( $uid );

			// User last seen
			$time_elapsed    = ! empty ( $user_arr->last_user_login ) ? time() - $user_arr->last_user_login : 60000;
			$time_difference = $time_elapsed / 60;
			$time_difference = (int)$time_difference;

			$attach_class  = wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ? 'is-file-upload-enabled' : '';
			$attach_class .= wpj_get_option( 'wpjobster_message_image_attachments_enable' ) != 'no' ? ' is-image-upload-enabled' : '';

			wpj_get_template( 'elements/notify/chat-messagebox-template.php', [
				'uid'           => $uid,
				'box_status'    => $box_status,
				'user_nicename' => $user_arr->user_nicename,
				'status_class'  => $time_difference <= 5 ? 'online' : 'offline',
				'attach_class'  => $attach_class
			] );
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

/* MESSAGES */
if ( ! function_exists( 'wpj_display_user_new_messages' ) ) {
	function wpj_display_user_new_messages( $receiver_id = '', $source = '' ) {
		$receiver_id = WPJ_Form::post( 'receiver_id', $receiver_id );

		if ( ! $receiver_id ) {
			$receiver_id = get_current_user_id();
		}

		$source = WPJ_Form::post( 'source', $source );

		$results = wpj_get_pm_notify( '*', ['user' => $receiver_id, 'show_to_destination' => 1, 'rd' => 0], 'results' );

		if ( $results ) {
			foreach ( $results as $key => $row ) {
				if ( $source == 'private-messages' ) {
					wpj_display_message_item( $row, $receiver_id, $row->initiator );

				} elseif ( wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && ! wpj_is_mobile() ) {
					wpj_display_chat_message_item( $row, $row->initiator, $receiver_id );

				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_message_settings_options' ) ) {
	function wpj_display_message_settings_options() {
		wpj_get_template( 'elements/notify/message-settings-options-template.php', [
			'interlocutor_id' => wpj_get_pm_interlocutor_from_url( 'id' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_send_message_form' ) ) {
	function wpj_display_send_message_form() {
		$jobster_design = wpj_get_design_option();

		$attach_class  = wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ? 'is-file-upload-enabled' : '';
		$attach_class .= wpj_get_option( 'wpjobster_message_image_attachments_enable' ) != 'no' ? ' is-image-upload-enabled' : '';

		wpj_get_template( 'elements/notify/send-message-form-template.php', [
			'interlocutor_id'   => wpj_get_pm_interlocutor_from_url( 'id' ),
			'interlocutor_data' => wpj_get_pm_interlocutor_from_url( 'data' ),
			'attach_class'      => $attach_class,
			'icon'              => ! empty( $jobster_design['messages_scroll_down_button_icon'] ) ? $jobster_design['messages_scroll_down_button_icon'] : 'arrow down'
		] );
	}
}

if ( ! function_exists( 'wpj_display_search_message_form' ) ) {
	function wpj_display_search_message_form() {
		wpj_get_template( 'elements/notify/search-message-form-template.php', [
			'interlocutor_id'   => wpj_get_pm_interlocutor_from_url( 'id' ),
			'interlocutor_data' => wpj_get_pm_interlocutor_from_url( 'data' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_search_conversation_form' ) ) {
	function wpj_display_search_conversation_form() {
		wpj_get_template( 'elements/notify/search-conversation-form-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_conversations_by_username' ) ) {
	function wpj_display_conversations_by_username( $username = '' ) {
		$username = WPJ_Form::post( 'username', $username );
		$username = esc_attr( trim( $username ) );

		$users = new WP_User_Query( [
			'search'         => "*{$username}*",
			'search_columns' => [ 'user_login', 'user_nicename', 'user_email' ]
		] );

		$users_found = $users->get_results();

		if ( $users_found ) {
			foreach ( $users_found as $user ) {
				$message = wpj_get_private_messages_by_users( get_current_user_id(), $user->ID, 'row', 1 );

				if ( isset( $message[0] ) ) {
					$message[0]->other  = $message[0]->user;
					$message[0]->author = $message[0]->initiator;

					wpj_display_user_conversation_item( $message[0], 'all' );
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_messages_by_keywords' ) ) {
	function wpj_display_messages_by_keywords( $keyword = '', $interlocutor_id = '' ) {
		$keyword         = WPJ_Form::post( 'keyword', $keyword );
		$interlocutor_id = WPJ_Form::post( 'interlocutor_id', $interlocutor_id );

		wpj_get_template( 'elements/notify/messages-by-keywords-template.php', [
			'messages_found'  => wpj_get_messages_by_keyword( $keyword, $interlocutor_id ),
			'interlocutor_id' => $interlocutor_id,
			'keyword'         => $keyword
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_message_by_search_result' ) ) {
	function wpj_display_message_by_search_result( $message_id = '', $interlocutor_id = '' ) {
		$message_id      = WPJ_Form::post( 'message_id', $message_id );
		$interlocutor_id = WPJ_Form::post( 'interlocutor_id', $interlocutor_id );

		wpj_get_template( 'elements/notify/message-by-search-results-template.php', [
			'message_id'      => $message_id,
			'interlocutor_id' => $interlocutor_id
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

/* QUICK RESPONSE */
if ( ! function_exists( 'wpj_display_quick_response' ) ) {
	function wpj_display_quick_response( $uid = '', $location = '' ) {
		// Create new/edit - modal
		wpj_init_new_quick_response_modal( $uid );

		// Delete all - modal
		wpj_init_delete_quick_responses_modal( $uid );

		wpj_get_template( 'elements/notify/quick-response-template.php',
			[
				'uid'               => $uid,
				'username'          => wpj_get_user_display_type( $uid ),
				'quick_responses'   => get_user_meta( get_current_user_id(), 'quick_responses', true ),
				'dropdown_icon'     => $location == 'order' ? 'clock outline' : 'bolt',
				'dropdown_position' => is_rtl() && $location != 'chat' ? 'left' : 'right'
			]
		);
	}
}

/* EMAIL SETTINGS */
if ( ! function_exists( 'wpj_display_email_notification_list' ) ) {
	function wpj_display_email_notification_list() {
		wpj_get_template( 'elements/notify/email-notifications-list-template.php', [
			'user_id'             => get_current_user_id(),
			'notifications_array' => wpj_get_notifications_by_user_type( wpj_get_notifications_array() ),
		] );
	}
}

if ( ! function_exists( 'wpj_display_sms_notification_list' ) ) {
	function wpj_display_sms_notification_list() {
		wpj_get_template( 'elements/notify/sms-notifications-list-template.php', [
			'user_id'             => get_current_user_id(),
			'notifications_array' => wpj_get_notifications_by_user_type( wpj_get_notifications_array() ),
			'sms_gateway_op'      => wpj_get_option( 'wpjobster_sms_gateways_enable' )
		] );
	}
}

/* SMS CODE */
if ( ! function_exists( 'wpj_display_sms_code_field' ) ) {
	function wpj_display_sms_code_field() {
		if ( wpj_get_phone_verification_status( 'status' ) == 'resent' || wpj_get_phone_verification_status( 'status' ) == 'wrongkey' ) {
			wpj_get_template( 'elements/notify/sms-code-field-template.php' );
		}
	}
}