<?php
if ( ! function_exists( 'wpj_display_bank_details' ) ) {
	function wpj_display_bank_details() {
		$payment_type = $payment_gateway = $order = $user_id = '';

		if ( wpj_is_page( 'wpjobster_topup_order_page_id' ) ) {
			global $wp_query;

			$payment_type = 'topup';
			$order        = wpj_get_order_by_payment_type( $payment_type, $wp_query->query_vars['oid'] );

			if ( ! empty( $order ) ) {
				$payment_gateway = $order->payment_gateway_name;
				$user_id         = $order->user_id;
			}
		}

		if ( wpj_is_page( 'wpjobster_order_page_id' ) ) {
			global $wp_query;

			$payment_type = 'job_purchase';
			$order        = wpj_get_order_by_payment_type( $payment_type, $wp_query->query_vars['oid'] );

			if ( ! empty( $order ) ) {
				$payment_gateway = $order->payment_gateway;
				$user_id         = $order->uid;
			}
		}

		if ( wpj_is_page( 'wpjobster_feature_page_id' ) ) {
			$homepage_row = wpj_get_feature_job_by_page( 'h', wpj_get_post_id(), get_current_user_id(), 'pending' );

			if ( ! empty( $homepage_row->id ) ) {
				$payment_type = 'feature';
				$order        = wpj_get_order_by_payment_type( $payment_type, $homepage_row->id );

				if ( ! empty( $order ) ) {
					$payment_gateway = $order->payment_gateway;
					$user_id         = $order->user_id;
				}
			}
		}

		wpj_get_template( 'elements/order/bank-details-template.php', [
			'order'           => $order,
			'payment_type'    => $payment_type,
			'payment_gateway' => $payment_gateway,
			'user_id'         => $user_id
		] );
	}
}

if ( ! function_exists( 'wpj_display_bank_job_payment_proof' ) ) {
	function wpj_display_bank_job_payment_proof( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order && $order->payment_status == 'pending' ) {
			wpj_get_template( 'elements/order/bank-job-payment-proof-template.php', [
				'order' => $order,
				'attachments' => get_option( 'bank_transfer_job_proof_attachments_' . $order->id )
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_topup_camouflaged_order' ) ) {
	function wpj_display_topup_camouflaged_order( $oid = '', $with_link = true ) {
		$order = wpj_get_topup_order_details( false, $oid );

		if ( $order ) {
			wpj_get_template( 'elements/order/order-camouflaged-template.php', [
				'current_order' => $order,
				'orderid'       => $order['orderid'],
				'payment_type'  => $order['payment_type'],
				'date_made'     => $order['date_made'],
				'with_link'     => $with_link
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_camouflaged_order' ) ) {
	function wpj_display_camouflaged_order( $order = '', $with_link = true ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			wpj_get_template( 'elements/order/order-camouflaged-template.php', [
				'current_order' => $order,
				'orderid'       => $order->id,
				'date_made'     => $order->date_made,
				'payment_type'  => 'job_purchase',
				'with_link'     => $with_link
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_timer' ) ) {
	function wpj_display_order_timer( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$arbitration = $expected = $instant = $rtl_clock_dir_class = $class_arr = $short_class_arr = $interval_arr = $show_timer = false;

		if ( $order ) {
			$show_timer = apply_filters( 'wpj_show_order_timer_filter', ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' && $order->seller_confirmation == '0' ? false : true ), $order );

			if ( $show_timer ) {
				$pid         = $order->pid;
				$arbitration = wpj_get_arbitration_order( 'buyer_arbitration', ['order_id' => $order->id], 'var' ) == 1;
				$expected    = wpj_get_order_expected_time( $order->id );
				$instant     = get_post_meta( $pid, 'instant', true );
				$show_timer  = 0;

				if (
					wpj_bool_option( 'wpjobster_enable_delivery_time' )
					&& ( get_post_meta( $pid, 'max_days', true ) || get_post_meta( $pid, 'job_packages', true ) == 'yes' )
				) {

					if ( $instant != 1 ) {
						if ( $order->extra_fast == 1 && ( $order->extra_fast_days != 'instant' && $order->extra_fast_days != 0 ) ) {
							$show_timer = 1;

						} elseif ( $order->expected_delivery >= current_time( 'timestamp', 1 ) ) {
							$show_timer = 1;

						} elseif ( wpj_is_order_time_up( $order ) == 1 ) {
							$show_timer = 1;

						} else {
							$show_timer = 0;

						}
					} elseif ( $order->expected_delivery >= current_time( 'timestamp', 1 ) ) {
						$show_timer = 1;

					} else {
						$show_timer = 0;

					}
				}

				$now           = current_time( 'timestamp', 1 );
				$expected_date = strtotime( $expected );
				$days_diff     = $now - $expected_date;

				if ( $show_timer == 1 && round( abs( $days_diff / ( 60 * 60 * 24 ) ) ) > 100 ) {
					$show_timer = 0;
				}

				if (
					$show_timer == 1
					&& $order->payment_status != 'pending'
					&& $order->payment_status != 'processing'
					&& $order->closed != 1
					&& ! $arbitration
					&& (
						( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'delivered' && wpj_is_order_delivered( $order ) != 1 )
						|| ( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'completed' && wpj_is_order_completed( $order ) != 1 )
					)
				) {

					$class_arr       = ['days', 'hours','minutes', 'seconds'];
					$short_class_arr = ['day', 'hour', 'min', 'sec'];
					$interval_arr    = [
						__( 'days', 'wpjobster' ),
						__( 'hours', 'wpjobster' ),
						__( 'minutes', 'wpjobster' ),
						__( 'seconds', 'wpjobster' )
					];

					$rtl_clock_dir_class = ' ltr-clock-dir';

					if ( wpj_get_option( 'wpjobster_set_time_direction' ) == 'rtl' && is_rtl() ) {
						$class_arr       = array_reverse( $class_arr );
						$interval_arr    = array_reverse( $interval_arr );
						$short_class_arr = array_reverse( $short_class_arr );

						$rtl_clock_dir_class = ' rtl-clock-dir';
					}
				}
			}
		}

		wpj_get_template( 'elements/order/order-timer-template.php', [
			'buyer_arbitration'   => $arbitration,
			'expected'            => $expected,
			'order'               => $order,
			'instant'             => $instant,
			'rtl_clock_dir_class' => $rtl_clock_dir_class,
			'class_arr'           => $class_arr,
			'short_class_arr'     => $short_class_arr,
			'interval_arr'        => $interval_arr,
			'show_timer'          => $show_timer
		] );
	}
}

if ( ! function_exists( 'wpj_display_order_job_price' ) ) {
	function wpj_display_order_job_price( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			wpj_get_template( 'elements/order/order-job-price-template.php', ['order' => $order] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_custom_extras_list' ) ) {
	function wpj_display_order_custom_extras_list( $order = '', $include_ul = false, $ul_class = '', $li_class = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$custom_extra_data = [];
			$custom_extras     = ! empty ( $order->custom_extras ) ? wpj_json_decode( wpj_stripslashes( $order->custom_extras ) ) : '';

			if ( $custom_extras ) { $i = -1;
				foreach ( $custom_extras as $custom_extra ) { $i++;
					if ( $custom_extra->paid ) {
						$row = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $i], 'row' );

						if ( $row ) {
							$ce_description = $custom_extra->description;
							$ce_description = wpj_apply_filter_to_string( $ce_description, false, 'transactionpages' );

							$custom_extra_data[] = ['custom_extra_id' => $i, 'amount' => $custom_extra->price, 'description' => $ce_description];
						}
					}
				}
			}

			wpj_get_template( 'elements/order/order-custom-extras-list-template.php', [
				'order'             => $order,
				'custom_extra_data' => $custom_extra_data,
				'include_ul'        => $include_ul,
				'ul_class'          => $ul_class,
				'li_class'          => $li_class
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_tips_list' ) ) {
	function wpj_display_order_tips_list( $order = '', $include_ul = false, $ul_class = '', $li_class = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$tips_data = [];
			$tips      = ! empty ( $order->tips ) ? wpj_json_decode( wpj_stripslashes( $order->tips ) ) : '';

			if ( $tips ) { $i = -1;
				foreach ( $tips as $tip ) { $i++;
					if ( $tip->paid ) {
						$row = wpj_get_tips_order( '*', ['order_id' => $order->id, 'tips_id' => $i], 'row' );

						if ( $row ) {
							$tips_data[] = [
								'amount' => $tip->amount,
								'reason' => wpj_apply_filter_to_string( $tip->reason, false, 'transactionpages' )
							];
						}
					}
				}
			}

			wpj_get_template( 'elements/order/order-tips-list-template.php', [
				'order'      => $order,
				'tips_data'  => $tips_data,
				'include_ul' => $include_ul,
				'ul_class'   => $ul_class,
				'li_class'   => $li_class
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_buyer_instructions' ) ) {
	function wpj_display_order_buyer_instructions( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$job_instructions = '';

			if ( $order->job_instructions ) {
				$job_instructions = str_replace( ['\r', '\n'], ["\r", "\n"], $order->job_instructions );

			} elseif ( get_post_meta( $order->pid, 'instruction_box', true ) ) {
				$job_instructions = wpautop( strip_tags( get_post_meta( $order->pid, 'instruction_box', true ) ) );

			}

			if ( $job_instructions ) {
				$job_instructions = wpj_apply_filter_to_string( $job_instructions, true, 'transactionpages' );
			}

			wpj_get_template( 'elements/order/order-buyer-instructions-template.php', [
				'order'            => $order,
				'job_instructions' => $job_instructions
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_instant_delivery_files' ) ) {
	function wpj_display_order_instant_delivery_files( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			wpj_get_template( 'elements/order/order-instant-delivery-files-template.php', [
				'order'                        => $order,
				'instant_attachments'          => wpj_get_post( 'DISTINCT *', ['post_parent' => $order->pid], 'row' ),
				'instant_delivery_attachments' => get_post_meta( $order->pid, 'job_any_attachments', true ),
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_custom_offer_description' ) ) {
	function wpj_display_order_custom_offer_description( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$custom_offer_description = '';
			if ( $order->job_description )
				$custom_offer_description = str_replace( ['\r', '\n'], ["\r", "\n"], $order->job_description );

			if ( $custom_offer_description ) {
				$custom_offer_description = wpj_apply_filter_to_string( $custom_offer_description, true, 'transactionpages' );
			}

			wpj_get_template( 'elements/order/order-custom-offer-description-template.php', [
				'order'                    => $order,
				'custom_offer_description' => $custom_offer_description
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_custom_fields' ) ) {
	function wpj_display_order_custom_fields( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$Custom_Fields = new WPJ_Custom_Fields( $order->pid, 'job' );

			wpj_get_template( 'elements/order/order-custom-fields-template.php', [
				'order'         => $order,
				'Custom_Fields' => $Custom_Fields
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_date_made' ) ) {
	function wpj_display_order_date_made( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			wpj_get_template( 'elements/order/order-date-made-template.php', ['order' => $order] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_date_closed' ) ) {
	function wpj_display_order_date_closed( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			wpj_get_template( 'elements/order/order-date-closed-template.php', ['order' => $order] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_notification_messages' ) ) {
	function wpj_display_order_notification_messages( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			// Mark notification as read
			if ( get_current_user_id() != wpj_get_seller_id( $order ) )
				wpj_mark_notification_as_read_by_uid( get_current_user_id(), $order->id, 'buyer' );

			if ( get_current_user_id() == wpj_get_seller_id( $order ) )
				wpj_mark_notification_as_read_by_uid( get_current_user_id(), $order->id, 'seller' );

			// Mark order completed
			wpj_get_template( 'elements/order/order-notification-messages-template.php', [
				'order'             => $order,
				'chatbox_row'       => wpj_get_order_notification_by_order_id( $order->id ),
				'rating_oid_row'    => wpj_get_job_rating( '*', ['orderid' => $order->id], 'row' ),
				'custom_extras'     => ! empty( $order->custom_extras ) ? wpj_json_decode( wpj_stripslashes( $order->custom_extras ) ) : '',
				'buyer_arbitration' => wpj_get_arbitration_order( 'buyer_arbitration', ['order_id' => $order->id], 'var' ) == 1
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_action_buttons' ) ) {
	function wpj_display_order_action_buttons( $args = [] ) {
		global $wp_query;

		$defaults = [
			'order'                 => ! empty( $wp_query->query_vars['oid'] ) ? $wp_query->query_vars['oid'] : '',
			'buttons_only'          => false,
			'wrapper_class'         => '',
			'buttons_wrapper_class' => '',
			'button_accept_class'   => '',
			'button_deny_class'     => '',
			'button_abort_class'    => '',
			'button1_order'         => '',
			'button2_order'         => ''
		];

		$args = wp_parse_args( $args, $defaults );

		if ( ! is_object( $args['order'] ) ) {
			$args['order'] = wpj_get_job_order_by_id( $args['order'] );
		}

		if ( $args['order'] ) {
			$can_be_completed  = true;
			$custom_extras_arr = wpj_get_custom_extra_order( 'payment_gateway_transaction_id', ['order_id' => $args['order']->id], 'results' );

			if ( $custom_extras_arr ) {
				foreach ( $custom_extras_arr as $key => $ce_value ) {
					if ( $ce_value->payment_gateway_transaction_id == -1 ) {
						$can_be_completed = false;
					}
				}
			}

			$args['can_be_completed']   = $can_be_completed;
			$args['arbitration']        = wpj_get_arbitration_order( 'buyer_arbitration, seller_arbitration, request_from_buyer, request_from_seller', ['order_id' => $args['order']->id], 'row' );
			$args['modification_count'] = wpj_get_order_notification_message( 'COUNT( * )', ['oid' => $args['order']->id, 'uid' => '-15'], 'var' );
			$args['buyer_level']        = wpj_get_user_feature_value( 'tips', 'tips', 'no', get_current_user_id() );
			$args['seller_level']       = wpj_get_user_feature_value( 'tips', 'tips', 'no', wpj_get_seller_id( $args['order'] ) );

			wpj_get_template( 'elements/order/order-action-buttons.php', $args );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_feedback_form' ) ) {
	function wpj_display_order_feedback_form( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			$uid = get_current_user_id();

			$seller_id   = wpj_get_seller_id( $order );
			$seller_data = get_userdata( $seller_id );
			$seller_name = is_object( $seller_data ) ? wpj_get_user_display_type( $seller_id ) : __( 'Deleted User', 'wpjobster' );

			$buyer_feedback = wpj_get_order_notification_message( 'COUNT( * )', ['oid' => $order->id, 'uid' => '-18'], 'var' );

			$rating_row   = '';
			$user_rated   = '';
			$user_sample  = '';
			$rating_class = '';

			if ( $uid != $seller_id && wpj_is_order_completed( $order ) == 1 && $order->done_seller == 1 ) { // buyer
				$rating_row = wpj_get_job_rating( 'id', ['orderid' => $order->id, 'uid' => $seller_id, 'awarded' => 0], 'row' );

				$user_rated   = $seller_name;
				$user_sample  = 'buyer';
				$rating_class = 'buyer_rating';

			} elseif ( $uid == $seller_id && wpj_is_order_completed( $order ) == 1 && $order->done_seller == 1 && $buyer_feedback > 0 ) { // seller
				$rating_row = wpj_get_buyer_awarded_job_rating_by_order_id( $order->id );

				$user_rated   = wpj_get_user_display_type( $order->uid );
				$user_sample  = 'seller';
				$rating_class = 'seller_rating';

			}


			$textarea_wrapper_classes = wpj_function_has_content( 'wpj_display_work_sample_carousel', [$order->id, $user_sample]) ? 'thirteen wide' : '';

			wpj_get_template( 'elements/order/order-feedback-form-template.php', [
				'order'                    => $order,
				'user_rated'               => $user_rated,
				'user_sample'              => $user_sample,
				'rating_class'             => $rating_class,
				'rating_row'               => $rating_row,
				'user_skills'              => get_user_meta( $seller_id, 'user_skills', true ),
				'textarea_wrapper_classes' => $textarea_wrapper_classes
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_message_form' ) ) {
	function wpj_display_order_message_form( $order = '' ) {
		global $wp_query;

		if ( ! $order ) {
			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			wpj_get_template( 'elements/order/order-message-form-template.php', [
				'order'              => $order,
				'delivered'          => wpj_is_order_delivered( $order ),
				'completed'          => wpj_is_order_completed( $order ),
				'buyer_arbitration'  => wpj_get_arbitration_order( 'buyer_arbitration', ['order_id' => $order->id], 'var' ) == 1,
				'uid'                => get_current_user_id(),
				'seller_id'          => wpj_get_seller_id( $order ),
				'buyer_id'           => $order->uid,
				'qr_uid'             => get_current_user_id() == wpj_get_seller_id( $order ) ? $order->uid : wpj_get_seller_id( $order )
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_order_errors' ) ) {
	function wpj_display_order_errors( $payment_type = 'job_purchase', $error = '' ) {
		global $wp_query;

		if ( $payment_type == 'job_purchase' ) {
			$pid = isset( $wp_query->query_vars['jobid'] ) && $wp_query->query_vars['jobid'] ? $wp_query->query_vars['jobid'] : WPJ_Form::get( 'jobid', 0 );

			if ( ! $pid || $pid === 0 ) {
				$pid = wpj_get_post_id();
			}

			$post = get_post( $pid );

			$seller_id = $post->post_author;

			$amount = WPJ_Form::get( 'amount', 1 );

			$extras = explode( '|', WPJ_Form::get( 'extras' ) );

			if ( count( $extras ) <= 1 ) $extras = explode( '_', WPJ_Form::get( 'extras' ) );

			$extras_amounts = explode( '|', WPJ_Form::get( 'extras_amounts' ) );

			if ( count( $extras_amounts ) <= 1 ) $extras_amounts = explode( '_', WPJ_Form::get( 'extras_amounts' ) );

			$multiples = wpj_get_user_feature_status( 'wpjobster_enable_multiples', 'wpjobster_subscription_job_multiples_enabled' );

			if ( get_current_user_id() == $seller_id ) {
				$error = __( 'You cannot buy your own stuff.', 'wpjobster' );

			} elseif ( ( $multiples != 'yes' && $amount > 1 ) || ( ! ctype_digit( $amount ) && ! is_int( $amount ) ) || $amount < 1 ) {
				$error = __( 'The selected quantity is greater than the amount you are allowed or the quantity does not contain a number.', 'wpjobster' );

			} elseif ( $multiples == 'yes' && $amount > wpj_get_user_feature_value( 'jobmultiples', 'job_multiples', 1, $seller_id ) ) {
				$error = __( 'The selected quantity is greater than the amount you are allowed.', 'wpjobster' );

			} elseif ( count( $extras ) && count( $extras_amounts ) ) { $i = 0;
				foreach ( $extras as $extra ) {
					if ( $extra == 'f' ) {
						$extra_enabled   = get_post_meta( $pid, 'extra_fast_enabled', true );
						$extra_m_enabled = 1;

					} else if ( $extra == 'r' ) {
						$extra_enabled   = get_post_meta( $pid, 'extra_revision_enabled', true );
						$extra_m_enabled = get_post_meta( $pid, 'extra_revision_multiples_enabled', true );

					} else {
						$extra_enabled   = get_post_meta( $pid, 'extra' . $extra . '_extra_enabled', true );
						$extra_m_enabled = get_post_meta( $pid, 'extra' . $extra . '_enabled', true );

					}

					if ( ! empty( $extra ) ) {
						if ( $extra_enabled ) {
							if ( $multiples != 'yes' && $extras_amounts[$i] > 1 )
								$error = __( 'You are not allowed to use an amount greater than 1.', 'wpjobster' );

							if ( $multiples == 'yes' ) {
								if ( ! $extra_m_enabled && $extras_amounts[$i] > 1 )
									$error = __( 'You are not allowed to use an amount greater than 1.', 'wpjobster' );

								if ( $extras_amounts[$i] > wpj_get_user_feature_value( 'extramultiples', 'extra_multiples', 1, $seller_id ) )
									$error = __( 'The selected quantity is greater than the amount you are allowed.', 'wpjobster' );
							}
						}
					} $i++;
				}
			}
		}

		if ( $payment_type == 'feature' ) {
			$pid = isset( $wp_query->query_vars['jobid'] ) && $wp_query->query_vars['jobid'] ? $wp_query->query_vars['jobid'] : WPJ_Form::get( 'jobid', 0 );

			$feature_pages   = WPJ_Form::get( 'feature_pages', '' );
			$process_pending = WPJ_Form::get( 'process_pending', '' );

			// Get start and end date
			$h_start_date = wpj_get_featured_start_date( 'homepage', $pid );
			$h_date_start = WPJ_Form::get( 'h_date_start', '' );

			$c_start_date = wpj_get_featured_start_date( 'category', $pid );
			$c_date_start = WPJ_Form::get( 'c_date_start', '' );

			$s_start_date = wpj_get_featured_start_date( 'subcategory', $pid );
			$s_date_start = WPJ_Form::get( 's_date_start', '' );

			// Errors
			if ( ! $feature_pages && ! $process_pending ) {
				$error = __( 'Please select at least one page.', 'wpjobster' );

			} else if (
				( $h_start_date != $h_date_start && strpos( $feature_pages, 'h' ) !== false ) ||
				( $c_start_date != $c_date_start && strpos( $feature_pages, 'c' ) !== false ) ||
				( $s_start_date != $s_date_start && strpos( $feature_pages, 's' ) !== false )
			) {
				$error = __( 'The interval was changed in the meantime.', 'wpjobster' );

			} else {
				$price = 0;

				if ( strpos( $feature_pages ,'h' ) !== false )
					$price += wpj_get_option( 'wpjobster_featured_price_homepage' );

				if ( strpos( $feature_pages ,'c' ) !== false )
					$price += wpj_get_option( 'wpjobster_featured_price_category' );

				if ( strpos( $feature_pages ,'s' ) !== false )
					$price += wpj_get_option( 'wpjobster_featured_price_subcategory' );

				if ( WPJ_Form::get( 'pay_for_item' ) == 'credits' ) {
					if ( wpj_get_user_credit( get_current_user_id() ) < $price )
						$error = __( 'You don\'t have enough money in your balance. Choose one of the other payment methods.5', 'wpjobster' );
				}
			}
		}

		if ( $payment_type == 'topup' ) {
			$package_id = WPJ_Form::get( 'package_id' );

			if ( ! is_numeric( $package_id ) || $package_id < 0 ) {
				$error = __( 'Please select the package first.', 'wpjobster' );
			}
		}

		if ( $payment_type == 'subscription' ) {
			$process_pending = WPJ_Form::get( 'process_pending' );

			if ( ! $process_pending && ( empty( WPJ_Form::get( 'sub_amount' ) ) || empty( 'sub_type' ) || empty( 'sub_level' ) ) ) {
				$error = __( 'Please select a plan.', 'wpjobster' );
			}

			elseif ( wpj_get_option( 'wpjobster_subscription_eligibility_enabled' ) == 'yes' ) {
				$sub_eligibility = wpj_get_option( 'wpjobster_subscription_eligibility_amount_' . WPJ_Form::get( 'sub_level' ) );

				if ( wpj_number_format_special( get_user_meta( get_current_user_id(), 'user_total_earnings', true ), 2 ) < wpj_number_format_special( $sub_eligibility, 2 ) ) {
					$error = __( 'You are not eligible for this level.', 'wpjobster' );
				}

			} elseif ( WPJ_Form::get( 'pay_for_item' ) == 'credits' && wpj_get_user_credit( get_current_user_id() ) < WPJ_Form::get( 'sub_amount' ) ) {
				$error = __( 'You do not have enough balance to purchase this subscription.', 'wpjobster' );
			}

		}

		if ( ! empty( $error ) ) {
			wpj_get_template( 'elements/order/order-errors-template.php', ['error' => $error] );
		}

		return false;
	}
}