<?php
if ( ! function_exists( 'wpj_display_job_packages' ) ) {
	function wpj_display_job_packages( $pid = '', $display_location = '' ) {
		$pid = wpj_get_post_id( $pid );

		if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
			wpj_get_template( 'elements/package/job-packages-template.php', [
				'pid'              => $pid,
				'display_location' => $display_location
			] );
		}
	}
}

/* PACKAGES DETAILS */
if ( ! function_exists( 'wpj_display_packages_details' ) ) {
	function wpj_display_packages_details( $pid = '', $package_nr = '' ) {
		$pid = wpj_get_post_id( $pid );

		if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
			$packages_arr = ['basic', 'standard', 'premium'];

			if ( is_numeric( $package_nr ) ) {
				wpj_get_template( 'elements/package/job-packages-details-template.php', [
					'pid'                   => $pid,
					'package_name'          => get_post_meta( $pid, 'package_name', true ),
					'package_description'   => get_post_meta( $pid, 'package_description', true ),
					'package_max_days'      => get_post_meta( $pid, 'package_max_days', true ),
					'package_price'         => get_post_meta( $pid, 'package_price', true ),
					'package_revisions'     => get_post_meta( $pid, 'package_revisions', true ),
					'package_custom_fields' => get_post_meta( $pid, 'package_custom_fields', true ),
					'package_nr'            => $package_nr,
					'name'                  => $packages_arr[$package_nr]
				] );
			}
		}
	}
}

/* PACKAGES MOBILE */
if ( ! function_exists( 'wpj_display_packages_for_mobile' ) ) {
	function wpj_display_packages_for_mobile( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

		if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

		wpj_get_template( 'elements/package/job-packages-mobile-template.php', [
			'pid'                   => $pid,
			'packages'              => [ 'basic', 'standard', 'premium' ],
			'package_name'          => get_post_meta( $pid, 'package_name', true ),
			'package_description'   => get_post_meta( $pid, 'package_description', true ),
			'package_max_days'      => get_post_meta( $pid, 'package_max_days', true ),
			'package_price'         => get_post_meta( $pid, 'package_price', true ),
			'package_revisions'     => get_post_meta( $pid, 'package_revisions', true ),
			'package_custom_fields' => get_post_meta( $pid, 'package_custom_fields', true ),
			'default_package'       => $default_package
		] );
	}
}

/* PACKAGES PC */
if ( ! function_exists( 'wpj_display_packages_for_pc' ) ) {
	function wpj_display_packages_for_pc( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

		if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

		wpj_get_template( 'elements/package/job-packages-pc-template.php', [
			'pid'                   => $pid,
			'package_name'          => get_post_meta( $pid, 'package_name', true ),
			'package_description'   => get_post_meta( $pid, 'package_description', true ),
			'package_max_days'      => get_post_meta( $pid, 'package_max_days', true ),
			'package_price'         => get_post_meta( $pid, 'package_price', true ),
			'package_revisions'     => get_post_meta( $pid, 'package_revisions', true ),
			'package_custom_fields' => get_post_meta( $pid, 'package_custom_fields', true ),
			'default_package'       => $default_package
		] );
	}
}

/* PACKAGES SIDEBAR */
if ( ! function_exists( 'wpj_display_packages_for_sidebar' ) ) {
	function wpj_display_packages_for_sidebar( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) {
			$default_package = wpj_get_option( 'wpjobster_package_selected_page_load' );

			if ( ! is_numeric( $default_package ) || $default_package < 0 || $default_package > 2 ) $default_package = 1;

			wpj_get_template( 'elements/package/job-packages-sidebar-template.php', [
				'pid'                   => $pid,
				'packages_arr'          => [ __( 'Basic', 'wpjobster' ), __( 'Standard', 'wpjobster' ), __( 'Premium', 'wpjobster' ) ],
				'package_name'          => get_post_meta( $pid, 'package_name', true ),
				'package_description'   => get_post_meta( $pid, 'package_description', true ),
				'package_max_days'      => get_post_meta( $pid, 'package_max_days', true ),
				'package_price'         => get_post_meta( $pid, 'package_price', true ),
				'package_revisions'     => get_post_meta( $pid, 'package_revisions', true ),
				'package_custom_fields' => get_post_meta( $pid, 'package_custom_fields', true ),
				'default_package'       => $default_package
			] );
		}
	}
}

/* PACKAGES POST NEW */
if ( ! function_exists( 'wpj_display_packages_for_post_new' ) ) {
	function wpj_display_packages_for_post_new( $pid = '' ) {
		$packages_option = wpj_get_option( 'wpjobster_packages_enabled' );

		$pid         = wpj_get_post_id( $pid );
		$post        = $pid ? get_post( $pid ) : [];
		$action      = WPJ_Form::get( 'action' );
		$action_type = $action == 'edit-job' ? 'edit' : 'new';

		$post_job_packages = WPJ_Form::post( 'price_type', get_post_meta( $pid, 'job_packages', true ) );

		if ( $packages_option == 'yes' ) {
			$package_custom_fields = get_post_meta( $pid, 'package_custom_fields', true );

			$instr_arr = [];

			if ( function_exists( 'have_rows' ) && have_rows( 'job_fields', wpj_get_option( 'wpjobster_post_new_page_id' ) ) ) {
				while ( have_rows( 'job_fields', wpj_get_option( 'wpjobster_post_new_page_id' ) ) ) { the_row();
					if ( get_row_layout() == 'job_packages' ) {
						$instr_arr[] = [
							'pck_name'    => get_sub_field( 'package_name_instructions' ),
							'pck_desc'    => get_sub_field( 'package_description_instructions' ),
							'pck_deliv'   => get_sub_field( 'package_delivery_time_instructions' ),
							'pck_rev'     => get_sub_field( 'package_revision_instructions' ),
							'pck_price'   => get_sub_field( 'package_price_instructions' ),
							'pck_cf_name' => get_sub_field( 'package_custom_field_name' ),
							'pck_cf_chk'  => get_sub_field( 'package_custom_field_checklist' ),
						];
					}
				}

			} else {
				$instr_arr[] = [
					'pck_name'    => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_name_instructions', true ),
					'pck_desc'    => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_description_instructions', true ),
					'pck_deliv'   => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_max_days_instructions', true ),
					'pck_rev'     => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_revisions_instructions', true ),
					'pck_price'   => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_price_instructions', true ),
					'pck_cf_name' => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_cf_name_instructions', true ),
					'pck_cf_chk'  => get_post_meta( wpj_get_option( 'wpjobster_post_new_page_id' ), 'package_cf_checklist_instructions', true )
				];

			}

			$pck_cf_name_value = isset( $_POST['pck-inp-custom-name'] ) ? $_POST['pck-inp-custom-name'][0] : '';

			if ( ! $pck_cf_name_value ) { $pck_cf_name_value = $package_custom_fields ? $package_custom_fields[0]['name'] : ''; }

			$pck_cf_basic_value = isset( $_POST['pck-chk-value']['basic'][0] ) ? $_POST['pck-chk-value']['basic'][0] : '';

			if ( ! $pck_cf_basic_value ) { $pck_cf_basic_value = $package_custom_fields ? $package_custom_fields[0]['basic'] : ''; }

			$checked_basic = $pck_cf_basic_value == 'on' ? 'checked' : '';

			$pck_cf_standard_value = isset( $_POST['pck-chk-value']['standard'][0] ) ? $_POST['pck-chk-value']['standard'][0] : '';

			if ( ! $pck_cf_standard_value ) { $pck_cf_standard_value = $package_custom_fields ? $package_custom_fields[0]['standard'] : ''; }

			$checked_standard = $pck_cf_standard_value == 'on' ? 'checked' : '';

			$pck_cf_premium_value = isset( $_POST['pck-chk-value']['premium'][0] ) ? $_POST['pck-chk-value']['premium'][0] : '';

			if ( ! $pck_cf_premium_value ) { $pck_cf_premium_value = $package_custom_fields ? $package_custom_fields[0]['premium'] : ''; }

			$checked_premium = $pck_cf_premium_value == 'on' ? 'checked' : '';

			wpj_get_template( 'elements/package/job-packages-post-new-template.php', [
				'wpjobster_packages'    => $packages_option,
				'pid'                   => $pid,
				'post'                  => $post,
				'action'                => $action,
				'action_type'           => $action_type,
				'post_job_packages'     => $post_job_packages,
				'instr_arr'             => $instr_arr,
				'package_custom_fields' => $package_custom_fields,
				'pck_name_val'          => isset( $_POST['package_name'] ) ? $_POST['package_name'] : get_post_meta( $pid, 'package_name', true ),
				'pck_description_val'   => isset( $_POST['package_description'] ) ? $_POST['package_description'] : get_post_meta( $pid, 'package_description', true ),
				'pck_max_days_val'      => isset( $_POST['package_max_days'] ) ? $_POST['package_max_days'] : get_post_meta( $pid, 'package_max_days', true ),
				'pck_revisions_val'     => isset( $_POST['package_revisions'] ) ? $_POST['package_revisions'] : get_post_meta( $pid, 'package_revisions', true ),
				'pck_price_val'         => isset( $_POST['package_price'] ) ? $_POST['package_price'] : get_post_meta( $pid, 'package_price', true ),
				'pck_cf_name_value'     => $pck_cf_name_value,
				'pck_cf_basic_value'    => $pck_cf_basic_value,
				'checked_basic'         => $checked_basic,
				'pck_cf_standard_value' => $pck_cf_standard_value,
				'checked_standard'      => $checked_standard,
				'pck_cf_premium_value'  => $pck_cf_premium_value,
				'checked_premium'       => $checked_premium
			] );
		}
	}
}