<?php
if ( ! function_exists( 'wpj_display_rating_stars' ) ) {
	function wpj_display_rating_stars( $grade ) {
		$halves = (float) ( $grade + 0.25 ) * 2;
		$full   = (int) ( $halves / 2 );
		$half   = ( $grade - floor( $grade ) >= 0.5 ) ? 1 : 0;

		wpj_get_template( 'elements/rating/rating-stars-template.php', [
			'grade'  => $grade,
			'halves' => $halves,
			'full'   => $full,
			'half'   => $half
		] );
	}
}

// JOB
if ( ! function_exists( 'wpj_display_job_reviews_number' ) ) {
	function wpj_display_job_reviews_number( $pid = false ) {
		$pid = wpj_get_post_id( $pid );

		$rating_count = wpj_get_option( 'wpjobster_job_min_rating' );
		$rating_count = $rating_count && is_numeric( $rating_count ) ? $rating_count : 3;

		wpj_get_template( 'elements/rating/job-reviews-number-template.php', [
			'pid'          => $pid,
			'rating_count' => $rating_count
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_review_text' ) ) {
	function wpj_display_job_review_text() {
		wpj_get_template( 'elements/rating/job-review-text-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_job_review_response_text' ) ) {
	function wpj_display_job_review_response_text( $order_id, $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		if ( $order_id ) {
			$post_author = get_post_field( 'post_author', $pid );
			$r_seller    = wpj_get_job_review_response( $order_id, $pid, $post_author );

			if ( $r_seller ) {
				wpj_get_template( 'elements/rating/job-review-response-text-template.php', [
					'row_seller'  => $r_seller,
					'post_author' => $post_author,
					'pid'         => $pid
				] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_job_rating_stars' ) ) {
	function wpj_display_job_rating_stars( $pid = false ) {
		$pid = wpj_get_post_id( $pid );

		$ratinggrade = wpj_get_job_rating_percent( $pid );
		$ratinggrade = $ratinggrade / 20;

		$rating_count = wpj_get_option( 'wpjobster_job_min_rating' );
		$rating_count = $rating_count && is_numeric( $rating_count ) ? $rating_count : 3;

		wpj_get_template( 'elements/rating/job-rating-stars-template.php', [
			'pid'          => $pid,
			'ratinggrade'  => $ratinggrade,
			'rating_count' => $rating_count
		] );
	}
}

// USER
if ( ! function_exists( 'wpj_display_user_reviews_number' ) ) {
	function wpj_display_user_reviews_number( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$rating_count = wpj_get_option( 'wpjobster_user_min_rating' );
		$rating_count = $rating_count && is_numeric( $rating_count ) ? $rating_count : 3;

		wpj_get_template( 'elements/rating/user-reviews-number-template.php', [
			'uid'          => $uid,
			'rating_count' => $rating_count
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_review_text' ) ) {
	function wpj_display_user_review_text() {
		wpj_get_template( 'elements/rating/user-review-text-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_user_review_response_text' ) ) {
	function wpj_display_user_review_response_text( $row ) {
		$pid = $row->pid;

		if ( ! $pid ) $pid = wpj_get_post_id();

		if ( $row->orderid ) {
			$response = wpj_get_user_review_response( $row->orderid, $pid, get_post_field( 'post_author', $pid ) );

			if ( $response ) {
				wpj_get_template( 'elements/rating/user-review-response-text-template.php', [
					'row'      => $row,
					'response' => $response,
					'uid'      => apply_filters( 'wpj_user_review_author_filter', get_post_field( 'post_author', $pid ), $row->uid ),
					'is_offer' => wpj_is_custom_offer( $row->pid )
				] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_user_rating_stars' ) ) {
	function wpj_display_user_rating_stars( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$rtg = wpj_get_seller_rating_percent( $uid );
		$ratinggrade = $rtg / 20;

		$rating_count = wpj_get_option( 'wpjobster_user_min_rating' );
		$rating_count = $rating_count && is_numeric( $rating_count ) ? $rating_count : 3;

		wpj_get_template( 'elements/rating/user-rating-stars-template.php', [
			'uid'              => $uid,
			'ratinggrade'      => $ratinggrade,
			'rating_count'     => $rating_count
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_unresponsive_label' ) ) {
	function wpj_display_user_unresponsive_label( $uid = '' ) {
		if ( wpj_get_option( 'wpjobster_seller_order_unresponsive_label' ) == 'yes' ) {
			if ( ! $uid ) $uid = wpj_get_user_id();

			wpj_get_template( 'elements/rating/user-unresponsive-label-template.php', [
				'uid'                     => $uid,
				'jobs_count'              => wpj_get_job_order_post( 'COUNT(*)', ['p.post_author' => $uid, 'o.force_cancellation' => 7], 'var' ),
				'orders_rejection_number' => wpj_get_option( 'wpjobster_seller_order_rejection_number' ) ? wpj_get_option( 'wpjobster_seller_order_rejection_number' ) : 1
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_seller_reputation' ) ) {
	function wpj_display_seller_reputation( $uid = '', $pid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/rating/seller-reputation-template.php', ['uid' => $uid, 'pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_user_rating_info' ) ) {
	function wpj_display_user_rating_info( $uid = '', $pid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/rating/user-rating-info-template.php', ['uid' => $uid, 'pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_work_sample_preview_image' ) ) {
	function wpj_display_work_sample_preview_image( $sample_id = '' ) {
		if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' && $sample_id != '' ) {
			$sample     = wpj_get_attachment_image_url( $sample_id, [42, 42]);
			$sample_big = wpj_get_attachment_image_url( $sample_id, 'job_slider_image' );

			wpj_get_template( 'elements/rating/work-sample-preview-image-template.php', [
				'sample'     => $sample,
				'sample_id'  => $sample_id,
				'sample_big' => $sample_big
			] );
		}
	}
}