<?php
if ( ! function_exists( 'wpj_display_request_description' ) ) {
	function wpj_display_request_description( $pid = '' ) {
		$jobster_design = wpj_get_design_option();

		$pid  = wpj_get_post_id( $pid );
		$post = get_post( $pid );

		wpj_get_template( 'elements/request/request-description-template.php', [
			'pid'            => $pid,
			'post'           => $post,
			'post_content'   => wpj_apply_filter_to_string( wpautop( strip_tags( $post->post_content ) ), false, 'requestlistings' ),
			'jobster_design' => $jobster_design
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_budget' ) ) {
	function wpj_display_request_budget( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$budget_from = get_post_meta( $pid, 'request_budget_from', true );
		$budget_to   = get_post_meta( $pid, 'request_budget_to', true );

		wpj_get_template( 'elements/request/request-budget-template.php', [
			'pid'         => $pid,
			'budget_from' => $budget_from,
			'budget_to'   => $budget_to
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_delivery_days_number' ) ) {
	function wpj_display_request_delivery_days_number( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$delivery = get_post_meta( $pid, 'request_delivery', true );

		wpj_get_template( 'elements/request/request-delivery-days-template.php', [
			'pid'        => $pid,
			'delivery'   => $delivery,
			'day_plural' => sprintf( _n( '%d day', '%d days', $delivery, 'wpjobster' ), $delivery )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_deadline' ) ) {
	function wpj_display_request_deadline( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-deadline-template.php', [
			'pid'      => $pid,
			'deadline' => get_post_meta( $pid, 'request_deadline', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_tags' ) ) {
	function wpj_display_request_tags( $pid = '' ) {
		$i            = 0;
		$separator    = '';
		$request_tags = '';

		$pid = wpj_get_post_id( $pid );
		$tags = wp_get_post_tags( $pid );

		if ( $tags ) {
			foreach ( $tags as $tag ) {
				$request_tags .= $separator . $tag->name;

				$i++;

				if ( $i > 0 ) { $separator = ', '; }
			}
		}

		wpj_get_template( 'elements/request/request-tags-template.php', ['pid' => $pid, 'tags' => $request_tags] );
	}
}

if ( ! function_exists( 'wpj_display_request_start_date' ) ) {
	function wpj_display_request_start_date( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-start-date-template.php', [
			'pid'        => $pid,
			'start_date' => get_post_meta( $pid, 'request_start_date', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_end_date' ) ) {
	function wpj_display_request_end_date( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-end-date-template.php', [
			'pid'      => $pid,
			'end_date' => get_post_meta( $pid, 'request_end_date', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_proposals_number' ) ) {
	function wpj_display_request_proposals_number( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-proposals-number-template.php', [
			'pid'          => $pid,
			'offers_count' => wpj_get_request_offers_received( $pid, 'count' )
		]);
	}
}

if ( ! function_exists( 'wpj_display_request_custom_fields' ) ) {
	function wpj_display_request_custom_fields( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$term = get_queried_object();

		if ( ! empty( $term->taxonomy ) && $term->taxonomy == 'request_cat' ) {
			$page = 'request_category';

		} elseif ( ( ! empty( $term->name ) && $term->name == 'request' ) || is_page( wpj_get_option( 'wpjobster_all_requests_page_id' ) ) ) {
			$page = 'all_requests';

		} elseif ( ! empty( $term->ID ) && $term->ID == wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) ) {
			$page = 'search_request';

		} elseif ( is_singular( 'request' ) ) {
			$page = 'single_request';

		} else {
			$page = '';

		}

		$Custom_Fields = new WPJ_Custom_Fields( $pid, 'request' );

		wpj_get_template( 'elements/request/request-custom-fields-template.php', [
			'pid'           => $pid,
			'Custom_Fields' => $Custom_Fields,
			'page'          => $page
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_attachments' ) ) {
	function wpj_display_request_attachments( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$attachments = get_post_meta( $pid, 'request_attachments', true );

		wpj_get_template( 'elements/request/request-attachments-template.php', ['pid' => $pid, 'attachments' => $attachments] );
	}
}

if ( ! function_exists( 'wpj_display_request_location' ) ) {
	function wpj_display_request_location( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-location-template.php', [
			'pid'           => $pid,
			'address_value' => get_post_meta( $pid, 'request_location', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_pick_up_location' ) ) {
	function wpj_display_request_pick_up_location( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-pick-up-location-template.php', [
			'pid'           => $pid,
			'address_value' => get_post_meta( $pid, 'request_pick_up_location', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_drop_off_location' ) ) {
	function wpj_display_request_drop_off_location( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-drop-off-location-template.php', [
			'pid'           => $pid,
			'address_value' => get_post_meta( $pid, 'request_drop_off_location', true )
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_map' ) ) {
	function wpj_display_request_map( $pid = '', $location_type = '', $location_display = '' ) {
		$pid = wpj_get_post_id( $pid );

		if ( ! $location_display ) {
			$term = get_queried_object();

			if ( ! empty( $term->taxonomy ) && $term->taxonomy == 'request_cat' ) {
				$location_display = 'request_category';

			} elseif ( ! empty( $term->name ) && $term->name == 'request' ) {
				$location_display = 'all_requests';

			} elseif ( ! empty( $term->ID ) && $term->ID == wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) ) {
				$location_display = 'search_request';

			} elseif ( is_singular( 'request' ) ) {
				$location_display = 'single_request';

			} else {
				$location_display = '';

			}
		}

		$location_enable = wpj_get_option( 'wpjobster_request_' . $location_type );
		$address_value   = get_post_meta( $pid, 'request_' . $location_type, true );

		if ( $location_enable && $address_value ) {
			wpj_get_template( 'elements/request/request-map-template.php', [
				'pid'                  => $pid,
				'location_display'     => $location_display,
				'location_enable'      => $location_enable,
				'address_value'        => $address_value,
				'location_display_map' => wpj_get_option( 'wpjobster_request_location_display_map' ),
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_request_category' ) ) {
	function wpj_display_request_category( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-category-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_request_post_date' ) ) {
	function wpj_display_request_post_date( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/request/request-post-date-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_request_offer_list' ) ) {
	function wpj_display_request_offer_list( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$results = wpj_get_user_offers_received( $pid, get_current_user_id() );

		wpj_get_template( 'elements/request/request-offer-list-template.php', [
			'r'                  => $results,
			'show_custom_offers' => is_user_logged_in() && count( $results ) > 0
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_or_offer_button' ) ) {
	function wpj_display_request_or_offer_button( $pid = '' ) {
		$pid  = wpj_get_post_id( $pid );
		$post = get_post( $pid );

		$results = wpj_get_user_offers_received( $pid, get_current_user_id() );

		wpj_get_template( 'elements/request/request-or-offer-button-template.php', [
			'pid'                  => $pid,
			'post'                 => $post,
			'r'                    => $results,
			'display_custom_offer' => wpj_get_option( 'wpjobster_enable_custom_offers' ) != 'no' && $post->post_author != get_current_user_id()
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_activate_deactivate_button' ) ) {
	function wpj_display_request_activate_deactivate_button( $pid = '' ) {
		if ( ( get_post_meta( $pid, 'active', true ) == '1' || ! get_post_meta( $pid, 'active', true ) ) && get_post_meta( $pid, 'active', true ) != '0' )
			$btn_class = ' js-deactivate-request-link';

		else
			$btn_class = ' js-activate-request-link';

		wpj_get_template( 'elements/request/request-activate-deactivate-button-template.php', [
			'pid'       => wpj_get_post_id( $pid ),
			'btn_class' => $btn_class
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_edit_button' ) ) {
	function wpj_display_request_edit_button( $pid = '' ) {
		wpj_get_template( 'elements/request/request-edit-button-template.php', ['pid' => wpj_get_post_id( $pid )] );
	}
}

if ( ! function_exists( 'wpj_display_request_delete_button' ) ) {
	function wpj_display_request_delete_button( $pid = '' ) {
		wpj_get_template( 'elements/request/request-delete-button-template.php', ['pid' => wpj_get_post_id( $pid )] );
	}
}

if ( ! function_exists( 'wpj_display_request_bulk_action_button' ) ) {
	function wpj_display_request_bulk_action_button() {
		wpj_get_template( 'elements/request/request-bulk-action-button-template.php' );
	}
}