<?php

if ( ! function_exists( 'wpj_display_site_search_form' ) ) {
	function wpj_display_site_search_form( $post_type = '', $layout = 'horizontal' ) {
		/* Filters */
		$filter_term        = apply_filters( 'wpj_' . $post_type . '_search_display_search_term_filter', true );
		$filter_location    = apply_filters( 'wpj_' . $post_type . '_search_display_location_filter', true );
		$filter_radius      = apply_filters( 'wpj_' . $post_type . '_search_display_radius_filter', true );
		$filter_category    = apply_filters( 'wpj_' . $post_type . '_search_display_categories_filter', true );
		$filter_tag         = apply_filters( 'wpj_' . $post_type . '_search_display_tags_filter', true );
		$filter_min_rating  = apply_filters( 'wpj_' . $post_type . '_search_display_min_rating_filter', true );
		$filter_price_type  = apply_filters( 'wpj_' . $post_type . '_search_display_price_type_filter', true );
		$filter_price_min   = apply_filters( 'wpj_' . $post_type . '_search_display_min_price_filter', true );
		$filter_price_max   = apply_filters( 'wpj_' . $post_type . '_search_display_max_price_filter', true );
		$filter_deadline    = apply_filters( 'wpj_' . $post_type . '_search_display_deadline_filter', true );
		$filter_delivery    = apply_filters( 'wpj_' . $post_type . '_search_display_delivery_days_filter', true );
		$filter_date        = apply_filters( 'wpj_' . $post_type . '_search_display_date_filter', true );
		$filter_user_level  = apply_filters( 'wpj_' . $post_type . '_search_display_user_level_filter', true );
		$filter_user_status = apply_filters( 'wpj_' . $post_type . '_search_display_user_status_filter', true );

		/* Options */
		$op_radius_type    = wpj_get_option( 'wpjobster_locations_unit' );
		$op_price_type     = wpj_get_option( 'wpjobster_price_type' );
		$op_fixed_rate     = wpj_get_option( 'wpjobster_enable_fixed_rate' );
		$op_hourly_rate    = wpj_get_option( 'wpjobster_enable_hourly_rate' );
		$op_daily_rate     = wpj_get_option( 'wpjobster_enable_daily_rate' );
		$op_weekly_rate    = wpj_get_option( 'wpjobster_enable_weekly_rate' );
		$op_monthly_rate   = wpj_get_option( 'wpjobster_enable_monthly_rate' );
		$op_custom_only    = wpj_get_option( 'wpjobster_enable_custom_rate' );
		$op_budget         = wpj_get_option( 'wpjobster_' . $post_type . '_budget' );
		$op_deadline       = wpj_get_option( 'wpjobster_' . $post_type . '_deadline' );
		$op_date           = wpj_get_option( 'wpjobster_enable_search_' . $post_type . '_date' );
		$op_empty_date     = wpj_get_option( 'wpjobster_include_' . $post_type . '_undefined_date' );
		$op_empty_budget   = wpj_get_option( 'wpjobster_include_' . $post_type . '_undefined_budget' );
		$op_empty_delivery = wpj_get_option( 'wpjobster_include_' . $post_type . '_undefined_delivery' );
		$op_tags           = get_terms( ['taxonomy' => 'post_tag', 'post_type' => $post_type, 'hide_empty' => true] );

		/* Select category or tag when the page is archive */
		$archive_val = isset( get_queried_object()->slug ) ? get_queried_object()->slug : '';

		if ( $post_type == 'request' ) { $archive_val = $archive_val ? substr( $archive_val, 0, -4 ) : ''; }

		$archive_val_arr = $archive_val ? [$archive_val] : '';

		/* Values */
		$val_term            = wpj_validate_input_content( stripslashes( WPJ_Form::get( 'term', '' ) ) );
		$val_location        = wpj_validate_input_content( WPJ_Form::get( 'location', '' ) );
		$val_latitude        = WPJ_Form::get( 'latitude', '' );
		$val_longitude       = WPJ_Form::get( 'longitude', '' );
		$val_radius          = wpj_validate_input_content( WPJ_Form::get( 'radius', '' ) );
		$val_category        = WPJ_Form::get( 'category', $archive_val_arr );
		$val_tag             = WPJ_Form::get( 'tag', $archive_val_arr );
		$val_min_rating      = WPJ_Form::get( 'min_rating', '' );
		$val_price_type      = WPJ_Form::get( 'price_type', '' );
		$val_min_price       = wpj_validate_input_content( WPJ_Form::get( 'min_price', '' ) );
		$val_max_price       = wpj_validate_input_content( WPJ_Form::get( 'max_price', '' ) );
		$val_budget_toggle   = WPJ_Form::get( 'without_budget', '' );
		$val_user_level      = WPJ_Form::get( 'user_level', '' );
		$val_user_status     = WPJ_Form::get( 'user_status' );
		$val_deadline        = wpj_validate_input_content( WPJ_Form::get( 'deadline', '' ) );
		$val_start_date      = wpj_validate_input_content( WPJ_Form::get( 'start_date', '' ) );
		$val_end_date        = wpj_validate_input_content( WPJ_Form::get( 'end_date', '' ) );
		$val_date_toggle     = WPJ_Form::get( 'without_date', '' );
		$val_max_days        = WPJ_Form::get( 'max_days', '' );
		$val_delivery_toggle = WPJ_Form::get( 'without_delivery', '' );

		if ( ! $_GET ) $val_delivery_toggle = 'yes';

		/* Vars */
		if ( ! $val_max_days )
			$val_max_days = wpj_get_option( 'wpjobster_' . $post_type . '_max_delivery_days' );

		if ( ! $val_max_days )
			$val_max_days = 30;

		$op_location  = wpj_get_option( 'wpjobster_location' );
		$op_delivery  = wpj_get_option( 'wpjobster_enable_delivery_time' );
		$page_url     = get_permalink( wpj_get_option( 'wpjobster_advanced_search_id' ) );
		$filter_price = $filter_price_min || $filter_price_max;

		if ( $post_type != 'job' && $post_type != 'tag' ) { // request
			$op_location  = wpj_get_option( 'wpjobster_' . $post_type . '_location' );
			$op_delivery  = wpj_get_option( 'wpjobster_' . $post_type . '_max_deliv' );
			$page_url     = get_permalink( wpj_get_option( 'wpjobster_advanced_search_' . $post_type . '_page_id' ) );
			$filter_price = $filter_price && $op_budget == 'yes';

		} else { // job & tags
			$op_empty_budget = false;

		}

		$filter_location    = $filter_location && $op_location == 'yes';
		$filter_deadline    = $filter_deadline && $post_type == 'request' && $op_deadline == 'yes';
		$filter_date        = $filter_date && $post_type == 'request' && $op_date == 'yes';
		$filter_user_level  = $filter_user_level && $post_type == 'job';
		$filter_user_status = $filter_user_status && $post_type == 'job';
		$filter_min_rating  = $filter_min_rating && $post_type == 'job';
		$filter_price_type  = $filter_price_type && $post_type == 'job' && $op_price_type == 'free_input' && ( $op_fixed_rate == 'yes' || $op_hourly_rate == 'yes' || $op_daily_rate == 'yes' || $op_weekly_rate == 'yes' || $op_monthly_rate == 'yes' || $op_custom_only == 'yes' );
		$filter_delivery    = $filter_delivery && $op_delivery == 'yes';

		$price_type_arr = wpj_get_job_price_types();

		$user_levels_arr = [
			'0' => __( 'New Arrival', 'wpjobster' ),
			'1' => __( 'Rookie Seller', 'wpjobster' ),
			'2' => __( 'Master Seller', 'wpjobster' ),
			'3' => __( 'Top Rated Seller', 'wpjobster' )
		];

		$user_statuses_arr = [
			'online'  => __( 'Online', 'wpjobster' ),
			'offline' => __( 'Offline', 'wpjobster' )
		];

		$min_rating_arr = [
			'5' => sprintf( _n( '%d Star', '%d Stars', 5, 'wpjobster' ), 5 ),
			'4' => sprintf( _n( '%d Star', '%d Stars', 4, 'wpjobster' ), 4 ),
			'3' => sprintf( _n( '%d Star', '%d Stars', 3, 'wpjobster' ), 3 ),
			'2' => sprintf( _n( '%d Star', '%d Stars', 2, 'wpjobster' ), 2 ),
			'1' => sprintf( _n( '%d Star', '%d Stars', 1, 'wpjobster' ), 1 ),
		];

		// Display form
		if ( $layout == 'vertical' )
			$template_name = 'site-vertical-search-template';

		else
			$template_name = 'site-horizontal-search-template';

		wpj_get_template( 'elements/search/' . $template_name . '.php', [
			'filter_term'         => $filter_term,
			'filter_location'     => $filter_location,
			'filter_radius'       => $filter_radius,
			'filter_category'     => $filter_category,
			'filter_tag'          => $filter_tag,
			'filter_min_rating'   => $filter_min_rating,
			'filter_price_type'   => $filter_price_type,
			'filter_price_min'    => $filter_price_min,
			'filter_price_max'    => $filter_price_max,
			'filter_deadline'     => $filter_deadline,
			'filter_delivery'     => $filter_delivery,
			'filter_date'         => $filter_date,
			'filter_user_level'   => $filter_user_level,
			'filter_user_status'  => $filter_user_status,
			'filter_price'        => $filter_price,

			'op_radius_type'      => $op_radius_type,
			'op_price_type'       => $op_price_type,
			'op_fixed_rate'       => $op_fixed_rate,
			'op_hourly_rate'      => $op_hourly_rate,
			'op_daily_rate'       => $op_daily_rate,
			'op_weekly_rate'      => $op_weekly_rate,
			'op_monthly_rate'     => $op_monthly_rate,
			'op_custom_only'      => $op_custom_only,
			'op_budget'           => $op_budget,
			'op_deadline'         => $op_deadline,
			'op_date'             => $op_date,
			'op_empty_date'       => $op_empty_date,
			'op_empty_budget'     => $op_empty_budget,
			'op_empty_delivery'   => $op_empty_delivery,
			'op_tags'             => $op_tags,
			'op_location'         => $op_location,
			'op_delivery'         => $op_delivery,

			'val_term'            => $val_term,
			'val_location'        => $val_location,
			'val_latitude'        => $val_latitude,
			'val_longitude'       => $val_longitude,
			'val_radius'          => $val_radius,
			'val_category'        => $val_category,
			'val_tag'             => $val_tag,
			'val_min_rating'      => $val_min_rating,
			'val_price_type'      => $val_price_type,
			'val_min_price'       => $val_min_price,
			'val_max_price'       => $val_max_price,
			'val_budget_toggle'   => $val_budget_toggle,
			'val_user_level'      => $val_user_level,
			'val_user_status'     => $val_user_status,
			'val_deadline'        => $val_deadline,
			'val_start_date'      => $val_start_date,
			'val_end_date'        => $val_end_date,
			'val_date_toggle'     => $val_date_toggle,
			'val_max_days'        => $val_max_days,
			'val_delivery_toggle' => $val_delivery_toggle,

			'page'                => $post_type,
			'page_url'            => $page_url,
			'price_type_arr'      => $price_type_arr,
			'user_levels_arr'     => $user_levels_arr,
			'user_statuses_arr'   => $user_statuses_arr,
			'min_rating_arr'      => $min_rating_arr
		] );
	}
}

if ( ! function_exists( 'wpj_display_autosuggest_search_without_button' ) ) {
	function wpj_display_autosuggest_search_without_button( $display_title = 'no' ) {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/search/autosuggest-search-without-button-template.php', [
			'icon' => ! empty( $jobster_design['header_search_icon_name'] ) && $jobster_design['header_search_icon_name'] == true ? $jobster_design['header_search_icon_name'] : 'search',
			'display_title' => $display_title
		] );
	}
}

if ( ! function_exists( 'wpj_display_autosuggest_search_with_button' ) ) {
	function wpj_display_autosuggest_search_with_button() {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/search/autosuggest-search-with-button-template.php', [
			'icon' => ! empty( $jobster_design['header_search_icon_name'] ) && $jobster_design['header_search_icon_name'] == true ? $jobster_design['header_search_icon_name'] : 'search'
		] );
	}
}

if ( ! function_exists( 'wpj_display_search_with_categories' ) ) {
	function wpj_display_search_with_categories() {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/search/search-with-categories-template.php', [
			'icon' => ! empty( $jobster_design['header_search_icon_name'] ) && $jobster_design['header_search_icon_name'] == true ? $jobster_design['header_search_icon_name'] : 'search'
		] );
	}
}

if ( ! function_exists( 'wpj_display_autosuggest_search_mobile' ) ) {
	function wpj_display_autosuggest_search_mobile() {
		$jobster_design = wpj_get_design_option();

		wpj_get_template( 'elements/search/autosuggest-search-mobile-template.php', [
			'icon' => ! empty( $jobster_design['header_search_icon_name'] ) && $jobster_design['header_search_icon_name'] == true ? $jobster_design['header_search_icon_name'] : 'search'
		] );
	}
}