<?php
if ( ! function_exists( 'wpj_display_post_sort_filter' ) ) {
	function wpj_display_post_sort_filter( $args = [] ) {
		$defaults = [
			'post_type' => 'job',
			'classes'   => ''
		];

		$args = wp_parse_args( $args, $defaults );

		$location_default = $lat_default = $lng_default = '';

		if ( wpj_get_option( 'wpjobster_html5_geolocation_enable' ) == 'yes' ) {
			$location_default = WPJ_Form::cookie( 'wpj_location', '' );
			$lat_default      = WPJ_Form::cookie( 'wpj_lat', '' );
			$lng_default      = WPJ_Form::cookie( 'wpj_lng', '' );
		}

		wpj_get_template( 'elements/sort/post-sort-filter-template.php', [
			'order'          => wpj_get_current_post_sort_order( $args['post_type'] ),
			'page'           => $args['post_type'],
			'location_get'   => WPJ_Form::get( 'location', $location_default ),
			'latitude_get'   => WPJ_Form::get( 'latitude', $lat_default ),
			'longitude_get'  => WPJ_Form::get( 'longitude', $lng_default ),
			'classes'        => $args['classes'],
			'sort_by_value'  => WPJ_Form::cookie( 'switch_filter', wpj_get_option( 'wpjobster_default_sort_by_' . $args['post_type'] ) )
		] );
	}
}