<?php
if ( ! function_exists( 'wpj_display_subscription_features_table_for_mobile' ) ) {
	function wpj_display_subscription_features_table_for_mobile( $action_type = '' ) {
		$is_subscribed = '0';

		$current_amount = $current_level = $current_type = '';

		$current_subscription = wpj_get_subscription_by_uid( get_current_user_id() );

		if ( is_object( $current_subscription ) ) {
			$is_subscribed     = '1';
			$current_level     = $current_subscription->subscription_level;
			$current_type      = $current_subscription->subscription_type;
			$current_amount    = $current_subscription->subscription_amount;
		}

		wpj_get_template( 'elements/subscription/subscription-features-table-mobile-template.php', [
			'features'                         => wpj_get_subscription_features(),
			'padding'                          => isset( $is_eligibility ) ? ' pt20' : '',
			'subscription_levels'              => wpj_get_subscription_levels_info(),
			'subscription_eligibility_enabled' => wpj_get_option( 'wpjobster_subscription_eligibility_enabled' ),
			'is_subscribed'                    => $is_subscribed,
			'current_user_sales'               => floatval( get_user_meta( get_current_user_id(), 'user_total_earnings', true ) ),
			'action_type'                      => $action_type,
			'current_level'                    => $current_level,
			'current_type'                     => $current_type,
			'current_amount'                   => $current_amount,
			'pending_subscription'             => wpj_get_subscription_order( '*', ['user_id' => get_current_user_id(), 'subscription_status' => 'inactive', 'payment_status' => 'pending'], 'row' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_subscription_features_table_for_pc' ) ) {
	function wpj_display_subscription_features_table_for_pc( $action_type = '' ) {
		$is_subscribed = '0';

		$current_amount = $current_level = $current_type = '';

		$current_subscription = wpj_get_subscription_by_uid( get_current_user_id() );

		if ( is_object( $current_subscription ) ) {
			$is_subscribed     = '1';
			$current_level     = $current_subscription->subscription_level;
			$current_type      = $current_subscription->subscription_type;
			$current_amount    = $current_subscription->subscription_amount;
		}

		wpj_get_template( 'elements/subscription/subscription-features-table-pc-template.php', [
			'features'                         => wpj_get_subscription_features(),
			'subscription_levels'              => wpj_get_subscription_levels_info(),
			'subscription_eligibility_enabled' => wpj_get_option( 'wpjobster_subscription_eligibility_enabled' ),
			'is_subscribed'                    => $is_subscribed,
			'current_user_sales'               => floatval( get_user_meta( get_current_user_id(), 'user_total_earnings', true ) ),
			'action_type'                      => $action_type,
			'current_level'                    => $current_level,
			'current_type'                     => $current_type,
			'current_amount'                   => $current_amount,
			'subscription_packages_number'     => 4,
			'pending_subscription'             => wpj_get_subscription_order( '*', ['user_id' => get_current_user_id(), 'subscription_status' => 'inactive', 'payment_status' => 'pending'], 'row' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_subscription_billing_period' ) ) {
	function wpj_display_subscription_billing_period( $device = 'pc',  $subscription_levels = '', $subscr_key = '', $is_subscribed = 0, $action_type = 'new-subscription', $current_level = '', $current_type = '' ) {
		if ( $subscription_levels && $subscr_key ) {
			if ( $subscr_key != 'level0' && wpj_subscription_package_enabled( $subscr_key ) ) {
				$intervals = ['weekly', 'monthly', 'quarterly', 'yearly', 'lifetime'];

				foreach ( $intervals as $keyd => $valued ) {
					if ( $action_type == 'upgrade-subscription' && $is_subscribed == 1 )
						$amount_chargeable = floatval( $subscription_levels[$subscr_key][$valued] ) - floatval( $subscription_levels[$current_level][$current_type] );

					else
						$amount_chargeable = $subscription_levels[$subscr_key][$valued];

					if ( wpj_get_option( 'wpjobster_subscription_eligibility_enabled' ) == 'yes' ) {
						if ( wpj_number_format_special( floatval( get_user_meta( get_current_user_id(), 'user_total_earnings', true ) ), 2 ) >= wpj_number_format_special( $subscription_levels[$subscr_key]['eligility'], 2 ) )
							$eligible_for_sub = '';

						else
							$eligible_for_sub = ' disabled="disabled" ';

					} else $eligible_for_sub = '';

					if ( $amount_chargeable <= 0 ) $eligible_for_sub = ' disabled="disabled" ';

					wpj_get_template( 'elements/subscription/subscription-billing-period-template.php', [
						'subscription_levels' => $subscription_levels,
						'subscr_key'          => $subscr_key,
						'valued'              => $valued,
						'eligible_for_sub'    => $eligible_for_sub,
						'device'              => $device,
						'amount_chargeable'   => $amount_chargeable
					] );
				}

			} elseif ( $device == 'mobile' && $subscr_key == 'level0' ) _e( 'NA', 'wpjobster' );
		}
	}
}

if ( ! function_exists( 'wpj_display_subscription_features_details' ) ) {
	function wpj_display_subscription_features_details() {
		$column1 = 'seven wide mobile three wide computer';
		$column2 = 'nine wide mobile thirteen wide computer';

		$current_level = $current_type = '';

		$current_subscription = wpj_get_subscription_by_uid( get_current_user_id() );

		$is_subscribed = '0';

		if ( is_object( $current_subscription ) ) {
			$is_subscribed = '1';
			$current_level = $current_subscription->subscription_level;
			$current_type  = $current_subscription->subscription_type;
		}

		$subscription_levels = wpj_get_subscription_levels_info();

		$features = wpj_get_subscription_features();

		$subscription_order = wpj_get_subscription_order( '*', ['user_id' => get_current_user_id(), 'subscription_status' => 'active'] );

		if ( ! $subscription_order && is_object( $current_subscription ) ) {
			wpj_delete_active_subscription( $current_subscription->id );
		}

		wpj_get_template( 'elements/subscription/subscription-features-details-template.php', [
			'column1'                          => $column1,
			'column2'                          => $column2,
			'current_level'                    => $current_level,
			'current_type'                     => $current_type,
			'current_subscription'             => $current_subscription,
			'subscription_eligibility_enabled' => wpj_get_option( 'wpjobster_subscription_eligibility_enabled' ),
			'subscription_levels'              => $subscription_levels,
			'features'                         => $features,
			'is_subscribed'                    => $is_subscribed,
			'subscription_order'               => $subscription_order
		] );
	}
}

if ( ! function_exists( 'wpj_display_subscription_schedule_details' ) ) {
	function wpj_display_subscription_schedule_details() {
		$current_subscription = wpj_get_subscription_by_uid( get_current_user_id() );

		if ( is_object( $current_subscription ) ) {
			wpj_get_template( 'elements/subscription/subscription-schdule-details-template.php', [
				'current_subscription' => wpj_get_subscription_by_uid( get_current_user_id() ),
				'cancelled'            => wpj_get_subscription_next_billing_date( $current_subscription->subscription_type ) == '0000-00-00' ? 1 : 0,
				'column1'              => 'seven wide mobile three wide computer',
				'column2'              => 'nine wide mobile thirteen wide computer'
			] );
		}
	}
}