<?php
if ( ! function_exists( 'wpj_display_file_upload_form' ) ) {
	function wpj_display_file_upload_form( $secure = 0, $input_file_upload = '', $input_hidden_store_id = '', $unique_name = '', $only_icon = false, $button_label = '' ) {
		$form_class = $only_icon ? $input_file_upload . ' show-only-icon-attachment' : $input_file_upload;

		if ( ! $button_label ) {
			$button_label = __( 'Select file', 'wpjobster' );
		}

		wpj_get_template( 'elements/upload/file-upload-form-template.php', [
			'form_class'            => 'file-upload-input ' . $form_class,
			'secure'                => $secure,
			'button_label'          => $button_label,
			'input_file_upload'     => $input_file_upload,
			'input_hidden_store_id' => $input_hidden_store_id,
			'unique_name'           => $unique_name,
			'only_icon'             => $only_icon
		] );
	}
}

if ( ! function_exists( 'wpj_display_image_upload_form' ) ) {
	function wpj_display_image_upload_form( $pid, $uploader_purpose = 'job', $wrapper_class = '', $wrapper_id = 'job_images' ) {
		if ( $uploader_purpose == 'job' )
			$attachments = wpj_get_job_images( $pid );

		elseif ( $uploader_purpose == 'portfolio' )
			$attachments = wpj_get_portfolio_images( $pid );

		elseif ( $uploader_purpose == 'message' )
			$attachments = '';

		wpj_get_template( 'elements/upload/image-upload-form-template.php', [
			'pid'              => $pid,
			'post'             => get_post( $pid ),
			'wrapper_class'    => $wrapper_class,
			'wrapper_id'       => $wrapper_id,
			'attachments'      => ! empty( $attachments ) ? $attachments : '',
			'uploader_purpose' => $uploader_purpose
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_cover_upload_form' ) ) {
	function wpj_display_job_cover_upload_form( $pid ) {
		if ( wpj_get_option( 'wpjobster_enable_job_cover' ) == 'yes' ) {
			wpj_get_template( 'elements/upload/job-cover-upload-form-template.php', [
				'pid'               => $pid,
				'post'              => get_post( $pid ),
				'cover_image_id'    => get_post_meta( $pid, 'cover-image', 1 ),
				'cover_image_url'   => wpj_get_attachment_image_url( get_post_meta( $pid, 'cover-image', 1 ), 'job_cover_image' ),
				'cover_image_thumb' => wpj_get_attachment_image_url( get_post_meta( $pid, 'cover-image', 1 ), [ 980, 180 ] )
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_cover_upload_form' ) ) {
	function wpj_display_user_cover_upload_form( $uid = '' ) {
		if ( wpj_get_option( 'wpjobster_enable_user_cover' ) == 'yes' ) {
			if ( ! $uid ) $uid = wpj_get_user_id();

			$banner_id = get_user_meta( $uid, 'banner_id', true );
			$banner    = get_user_meta( $uid, 'banner', true );

			if ( $banner_id ) {
				$banner = wpj_get_attachment_image_url( $banner_id, 'job_cover_image' );
			}

			wpj_get_template( 'elements/upload/user-cover-upload-form-template.php', [
				'banner'    => $banner,
				'banner_id' => $banner_id
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_photo_upload_form' ) ) {
	function wpj_display_user_photo_upload_form( $width = 150, $height = 150, $page = '' ) {
		wpj_get_template( 'elements/upload/user-photo-upload-form-template.php', [
			'page'   => $page,
			'width'  => $width,
			'height' => $height
		] );
	}
}

if ( ! function_exists( 'wpj_display_audio_upload_form' ) ) {
	function wpj_display_audio_upload_form( $pid ) {
		wpj_get_template( 'elements/upload/audio-upload-form-template.php', [
			'pid'         => $pid,
			'attachments' => wpj_get_job_audios( $pid )
		] );
	}
}

if ( ! function_exists( 'wpj_display_skill_upload_form' ) ) {
	function wpj_display_skill_upload_form() {
		wpj_get_template( 'elements/upload/skill-upload-form-template.php' );
	}
}