<?php

if ( ! function_exists( 'wpj_display_user_sidebar' ) ) {
	function wpj_display_user_sidebar( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		wpj_get_template( 'elements/user-account/user-sidebar-template.php', ['uid' => $uid] );
	}
}

if ( ! function_exists( 'wpj_display_user_info_sidebar' ) ) {
	function wpj_display_user_info_sidebar( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$delivered_on_time_percent = wpj_get_sales_orders( $uid, 'delivered_on_time_percent', 'var' );

		if ( ! $delivered_on_time_percent ) {
			$percent_option = wpj_get_option( 'wpj_order_response_rate_stats_percent' );

			if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
				$delivered_on_time_percent = 0;

			} else {
				$delivered_on_time_percent = 100;

			}
		}

		$completed_percent = wpj_get_sales_orders( $uid, 'completed_percent', 'var' );

		if ( ! $completed_percent ) {
			$percent_option = wpj_get_option( 'wpj_order_completion_stats_percent' );

			if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
				$completed_percent = 0;

			} else {
				$completed_percent = 100;

			}
		}

		$response_rate = wpj_get_sales_orders( $uid, 'response_rate', 'var' );

		if ( ! $response_rate ) {
			$percent_option = wpj_get_option( 'wpj_order_response_rate_stats_percent' );

			if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
				$response_rate = 0;

			} else {
				$response_rate = 100;

			}
		}

		wpj_get_template( 'elements/user-account/user-info-sidebar-template.php', [
			'uid'                       => $uid,
			'delivered_on_time_percent' => $delivered_on_time_percent,
			'completed_percent'         => $completed_percent,
			'response_rate'             => $response_rate
		] );
	}
}

if ( ! function_exists( 'wpj_display_legend_link' ) ) {
	function wpj_display_legend_link( $page = '', $active_tab = '' ) {
		wpj_init_legend_modal( $page, $active_tab );

		wpj_get_template( 'elements/user-account/legend-link-template.php', [
			'page'       => $page,
			'active_tab' => $active_tab
		] );
	}
}

/**
 * WPJ Get Popup (ui popup)
 *
 * Generating the HTML for the tooltips from post/edit job page and post/edit request page
 *
 * @param string $var The content to be displayed
 * @param string $action_type Example: new, edit
 * @param string $post_type Example: job, request
 * @param string $pid For edit pages, needed for rejected jobs
 * @param string $field
 * @return void The generated .ui.popup HTML
 */
if ( ! function_exists( 'wpj_display_popup_content' ) ) {
	function wpj_display_popup_content( $var, $action_type = 'new', $post_type = 'job', $pid = '', $field = '', $j_field = '' ) {
		if ( is_array( $j_field ) && isset( $j_field['acf_fc_layout'] ) ) {
			if ( $j_field['acf_fc_layout'] == 'job_custom_field' && isset( $j_field['slug'] ) ) $unique_slug = 'job_cfield_' . $j_field['slug'];
			elseif ( $j_field['acf_fc_layout'] == 'request_custom_field' && isset( $j_field['slug'] ) ) $unique_slug = 'request_cfield_' . $j_field['slug'];
			else $unique_slug = $j_field['acf_fc_layout'];

		} else {
			$unique_slug = $j_field;

		}

		$rejected_title = $rejected_comment = $rej_class = '';

		if ( $var || $action_type == "edit" ) {
			if ( $action_type == "edit" && $post_type == "job" && $pid && $field ) {
				$rejected_title   = get_post_meta( $pid, "rejected_" . $field, true );
				$rejected_comment = get_post_meta( $pid, "rejected_" . $field . "_comment", true );

				// Packages
				if ( is_array( $rejected_title ) ) {
					$pck_field_nr = ( int ) filter_var( $j_field, FILTER_SANITIZE_NUMBER_INT );
					foreach ( $rejected_title as $rejected_key => $rejected_value ) {
						if ( $pck_field_nr == $rejected_key && $rejected_value ) {
							$rejected_title   = 1;
							$rejected_comment = $rejected_value;
						}
					}
				}

			} elseif ( $action_type == "edit" && $post_type == "request" && $pid && $field ) {
				$rejected_title   = get_post_meta( $pid, "req_rejected_" . $field, true );
				$rejected_comment = get_post_meta( $pid, "req_rejected_" . $field . "_comment", true );

			}

			$rej_class = get_post_status( $pid ) == 'pending' && $rejected_title == 1 ? 'rejected-input' : '';

		}

		wpj_get_template( 'elements/user-account/popup-content-template.php', [
			'action_type'      => $action_type,
			'var'              => $var,
			'pid'              => $pid,
			'unique_slug'      => $unique_slug,
			'rejected_title'   => $rejected_title,
			'rejected_comment' => $rejected_comment,
			'rej_class'        => $rej_class
		] );
	}
}