<?php
/* User Profile Page */
if ( ! function_exists( 'wpj_display_user_cover_image' ) ) {
	function wpj_display_user_cover_image( $uid = '' ) {
		if ( wpj_get_option( 'wpjobster_enable_user_cover' ) == 'yes' ) {
			global $_wp_additional_image_sizes;

			if ( ! $uid ) $uid = wpj_get_user_id();

			// User Cover Image VARS
			$banner_id = get_user_meta( $uid, 'banner_id', true );
			$banner    = get_user_meta( $uid, 'banner', true );

			if ( $banner_id ) {
				$banner = wpj_get_attachment_image_url( $banner_id, [$_wp_additional_image_sizes['job_cover_image']['width'], $_wp_additional_image_sizes['job_cover_image']['height']] );
			}

			$style = $class = '';

			if ( $banner ) {
				$style = 'background-image: url( \'' . $banner . '\' );';
				$class = 'ub-cover-photo';
			}

			wpj_get_template( 'elements/user/user-cover-template.php', [
				'class'     => $class,
				'banner_id' => $banner_id,
				'style'     => $style,
				'uid'       => $uid,
				'banner'    => $banner
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_avatar' ) ) {
	function wpj_display_user_avatar( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/user/user-avatar-template.php', [
			'uid'        => $uid,
			'level_icon' => apply_filters( 'hide_for_buyers', true, $uid )
		] );
	}
}

if ( ! function_exists( 'wpj_display_company_name' ) ) {
	function wpj_display_company_name( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' ) {
			$user_company = get_user_meta( $uid, 'user_company', true );

			if ( $user_company ) {
				wpj_get_template( 'elements/user/user-company-name-template.php', ['uid' => $uid] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_user_level_image' ) ) {
	function wpj_display_user_level_image( $uid = '' ) {
		$jobster_design = wpj_get_design_option();

		if ( ! $uid ) $uid = wpj_get_user_id();

		$user_level = wpj_get_user_level( $uid );

		if ( ! $user_level ) $user_level = 0;

		if ( ! empty ( $jobster_design['level' . $user_level . '_icon_options_user']['url'] ) ) {
			$icon_url = $jobster_design['level' . $user_level . '_icon_options_user']['url'];

		} else {
			$icon_url = get_template_directory_uri() . '/assets/images/user-level/level-' . $user_level . '-icon.png';

		}

		$user_type = wpj_get_user_account_type( $uid ) == 'buyer' ? __( 'Buyer', 'wpjobster' ) : __( 'Seller', 'wpjobster' );

		if ( $user_level == 1 ) $tooltip_content = sprintf( __( "Level 1 %s", "wpjobster" ), $user_type );
		elseif ( $user_level == 2 ) $tooltip_content = sprintf( __( "Level 2 %s", "wpjobster" ), $user_type );
		elseif ( $user_level == 3 ) $tooltip_content = sprintf( __( "Top Rated %s", "wpjobster" ), $user_type );
		else $tooltip_content = sprintf( __( "New %s", "wpjobster" ), $user_type );

		$tooltip_position = is_rtl() ? 'top right' : 'top center';

		wpj_get_template( 'elements/user/user-level-image-template.php', [
			'tooltip_content'   => $tooltip_content,
			'tooltip_position' => $tooltip_position,
			'user_level'        => $user_level,
			'icon_url'          => $icon_url
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_tagline' ) ) {
	function wpj_display_user_tagline( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$tagline_meta    = get_user_meta( $uid, 'user_tagline', true );
		$edit            = $uid == get_current_user_id() ? 'user-edit-item' : '';
		$tagline_content = trim( $tagline_meta ) ? $tagline_meta : '';
		$tagline_class   = ! $tagline_content ? ' no_item' : '';

		if ( ! $tagline_content ) {
			$tagline_content = $uid == get_current_user_id() ? __( 'Click here to add a tagline!', 'wpjobster' ) : '';
		}

		if ( $tagline_content ) {
			wpj_get_template( 'elements/user/user-tagline-template.php', [
				'edit'            => $edit,
				'tagline_class'   => $tagline_class,
				'tagline_content' => $tagline_content
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_description' ) ) {
	function wpj_display_user_description( $uid = '', $pid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		if ( get_user_meta( $uid, 'description', true ) ) {
			$desc_content = wpj_apply_filter_to_string( get_user_meta( $uid, 'description', true ), false, 'userprofiles' );

			wpj_get_template( 'elements/user/user-description-template.php', [
				'uid'          => $uid,
				'pid'          => $pid,
				'desc_content' => $desc_content
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_info_icons' ) ) {
	function wpj_display_user_info_icons( $uid = '', $filter = [], $pid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/user/user-info-icons-template.php', [
			'uid'                       => $uid,
			'pid'                       => $pid,
			'display_user_status'       => ! isset( $filter['status'] ) || ( isset( $filter['status'] ) && $filter['status'] != 'no' ),
			'display_user_badges'       => ! isset( $filter['badge'] ) || ( isset( $filter['badge'] ) && $filter['badge'] != 'no' ),
			'display_email_status'      => ! isset( $filter['email'] ) || ( isset( $filter['email'] ) && $filter['email'] != 'no' ),
			'display_subscription_icon' => ! isset( $filter['subscription'] ) || ( isset( $filter['subscription'] ) && $filter['subscription'] != 'no' ),
			'display_country_flag'      => ! isset( $filter['country'] ) || ( isset( $filter['country'] ) && $filter['country'] != 'no' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_status_icon' ) ) {
	function wpj_display_user_status_icon( $uid = '', $type = '', $tooltip = true ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user_status = wpj_get_option( 'wpjobster_en_user_online_status' );

		if ( $user_status && $user_status != 'no' ) {
			if ( $user_status == 'yes_with_text' || $user_status == 'yes_with_icon' ) {
				$current_time    = current_time( 'timestamp', 1 );
				$last_login_time = get_user_meta( $uid, 'last_user_login', true ) ?: 60000;
				$time_difference = $last_login_time ? ( $current_time - $last_login_time ) / 60 : 1000; // 1000 to show offline deleted users
				$mins            = ( int )$time_difference;

			} else $mins = 0;

			if ( empty( $type ) ) $type = $user_status;

			$class_on  = $type == 'yes_with_text' ? 'online-text-wrapper' : 'online-icon-wrapper';
			$class_off = $type == 'yes_with_text' ? 'offline-text-wrapper' : 'offline-icon-wrapper';

			$tooltip_position = is_rtl() ? 'top right' : 'top center';

			if ( $type && $type != 'no' ) {
				wpj_get_template( 'elements/user/user-status-icon-template.php', [
					'mins'              => $mins,
					'type'              => $type,
					'class_on'          => $class_on,
					'class_off'         => $class_off,
					'tooltip'           => $tooltip,
					'tooltip_position' => $tooltip_position,
				] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_user_email_status_icon' ) ) {
	function wpj_display_user_email_status_icon( $uid = '' ) {
		$jobster_design = wpj_get_design_option();

		if ( ! $uid ) $uid = wpj_get_user_id();

		if ( get_user_meta( $uid, 'uz_email_verification', true ) == 1 ) {
			wpj_get_template( 'elements/user/user-email-status-icon-template.php', [
				'tooltip_position' => is_rtl() ? 'top right' : 'top center',
				'icon'              => $jobster_design['email_verified_icon_options_user'] ? $jobster_design['email_verified_icon_options_user'] : 'envelope outline'
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_subscription_icon' ) ) {
	function wpj_display_user_subscription_icon( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$subscription_info = wpj_get_subscription_info( $uid );

		/**
		* @var string $wpjobster_subscription_icon_url
		* @var string $wpjobster_subscription_profile_label
		*/
		extract( $subscription_info );

		if ( $wpjobster_subscription_icon_url && wpj_validate_image_file( $wpjobster_subscription_icon_url ) ) {

			wpj_get_template( 'elements/user/user-subscription-icon-template.php', [
				'wpjobster_subscription_profile_label' => $wpjobster_subscription_profile_label,
				'tooltip_position'                    => is_rtl() ? 'top right' : 'top center',
				'wpjobster_subscription_icon_url'      => $wpjobster_subscription_icon_url
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_user_country_flag_icon' ) ) {
	function wpj_display_user_country_flag_icon( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		if ( wpj_get_option( 'wpjobster_en_country_flags' ) == 'yes' ) {
			$country_code = get_user_meta( $uid, 'country_code', true );
			$country_name = wpj_get_country_name_by_code( $country_code );

			if ( $country_name ) {
				$flag_code = strtolower( $country_code );

				if ( $flag_code && strlen( $flag_code ) == 2 ) {
					wpj_get_template( 'elements/user/user-country-flag-icon-template.php', [
						'country_name'      => $country_name,
						'tooltip_position' => is_rtl() ? 'top right' : 'top center',
						'flag_code'         => $flag_code
					] );
				}
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_user_badge_icons' ) ) {
	function wpj_display_user_badge_icons( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user_badge = get_user_meta( $uid, 'user_badge', true );

		if ( $user_badge && ! is_array( $user_badge ) ) $user_badge = [$user_badge];

		$tooltip_position = is_rtl() ? 'top right' : 'top center';

		$badges_data = wpj_get_badge_info();

		if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) == 'yes' && apply_filters( 'hide_for_buyers', true, $uid ) ) {
			if ( $badges_data && is_array( $badges_data ) ) {
				foreach ( $badges_data['redux_repeater_data'] as $key => $badge ) {
					if ( $user_badge && in_array( $key, $user_badge ) ) {
						wpj_get_template( 'elements/user/user-badge-icons-template.php', [
							'uid'               => $uid,
							'tooltip_position' => $tooltip_position,
							'icon'              => $badges_data['wpj_badge_icon'][$key],
							'text'              => $badges_data['wpj_badge_text'][$key]
						] );
					}
				}
			}

			if ( get_current_user_id() == $uid ) {
				wpj_get_template( 'elements/user/user-badge-icons-template.php', [
					'uid'               => $uid,
					'tooltip_position' => $tooltip_position,
					'icon'              => 'plus',
					'text'              => __( 'Click to buy more badges', 'wpjobster' ),
					'link'              => get_permalink( wpj_get_option( 'wpjobster_badges_page_id' ) )
				] );
			}
		}
	}
}

/* User Single Job Page */
if ( ! function_exists( 'wpj_display_user_photo' ) ) {
	function wpj_display_user_photo( $args = [] ) {
		$defaults = [
			'uid'              => '',
			'width'            => 130,
			'height'           => 130,
			'with_link'        => true,
			'with_level_image' => true,
			'border'           => false,
			'link_class'       => '',
			'img_class'        => ''
		];

		$args = wp_parse_args( $args, $defaults );

		if ( ! $args['uid'] ) $args['uid'] = wpj_get_user_id();

		$args['level_icon'] = apply_filters( 'hide_for_buyers', true, $args['uid'] );

		if ( $args['border'] ) $args['img_class'] .= ' white-border';

		wpj_get_template( 'elements/user/user-photo-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_display_user_account_type' ) ) {
	function wpj_display_user_account_type( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user_type = wpj_get_user_account_type( $uid ) == 'buyer' ? __( 'Buyer', 'wpjobster' ) : __( 'Seller', 'wpjobster' );

		wpj_get_template( 'elements/user/user-account-type-template.php', ['user_type' => $user_type] );
	}
}

if ( ! function_exists( 'wpj_display_username_as_link' ) ) {
	function wpj_display_username_as_link( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user = wpj_get_userdata( $uid );

		wpj_get_template( 'elements/user/user-name-as-link-template.php', ['user' => $user] );
	}
}

if ( ! function_exists( 'wpj_display_user_country' ) ) {
	function wpj_display_user_country( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$country_code = get_user_meta( $uid, 'country_code', true );
		$country_name = wpj_get_country_name_by_code( $country_code );

		wpj_get_template( 'elements/user/user-country-template.php', [
			'uid'          => $uid,
			'country_code' => $country_code,
			'country_name' => $country_name,
			'enable_flags' => wpj_get_option( 'wpjobster_en_country_flags' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_registration_date' ) ) {
	function wpj_display_user_registration_date( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user = get_userdata( $uid );

		wpj_get_template( 'elements/user/user-registration-date-template.php', ['user' => $user] );
	}
}

if ( ! function_exists( 'wpj_display_user_distance' ) ) {
	function wpj_display_user_distance( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/user/user-distance-template.php', ['uid' => $uid] );
	}
}

if ( ! function_exists( 'wpj_display_user_last_seen' ) ) {
	function wpj_display_user_last_seen( $uid = '', $display_label = true ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/user/user-last-seen-template.php', [
			'uid'           => $uid,
			'display_label' => $display_label
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_level_label' ) ) {
	function wpj_display_user_level_label( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/user/user-level-label-template.php', ['uid' => $uid] );
	}
}

if ( ! function_exists( 'wpj_display_user_contact_button' ) ) {
	function wpj_display_user_contact_button( $uid = '', $pid = '', $post_type = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id( $pid );
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user = wpj_get_userdata( $uid );

		if ( $uid != get_current_user_id() ) {
			wpj_get_template( 'elements/user/user-contact-button-template.php', [
				'user'      => $user,
				'pid'       => $pid,
				'post_type' => $post_type
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_vacation_mode_button' ) ) {
	function wpj_display_vacation_mode_button( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_init_vacation_mode_modal();

		wpj_get_template( 'elements/user/user-vacation-mode-button-template.php', ['uid' => $uid] );
	}
}

/* User Verification */
if ( ! function_exists( 'wpj_display_user_verification_redirect_buttons' ) ) {
	function wpj_display_user_verification_redirect_buttons() {
		if ( wpj_is_page( wpj_get_option( 'wpjobster_verify_email_page_id' ) ) || wpj_is_page( wpj_get_option( 'wpjobster_verify_phone_page_id' ) ) ) {
			wpj_get_template( 'elements/user/user-verification-redirect-buttons-template.php', ['key' => isset( $_GET['key'] )] );
		}
	}
}