<?php
// IN_ARRAY FOR MULTIDIMENSIONAL ARRAYS
if ( ! function_exists( 'wpj_in_array_r' ) ) {
	function wpj_in_array_r( $item , $array ) {
		return preg_match( '/"' . $item . '"/i' , json_encode( $array ) );
	}
}

if ( ! function_exists( 'wpj_array_move' ) ) {
	function wpj_array_move( &$a, $oldpos, $newpos ) {
		if ( $oldpos == $newpos ) return false;

		array_splice(
			$a, // the array
			max( $newpos, 0 ), // location
			0, // do not remove any element
			array_splice( $a, max( $oldpos, 0 ), 1 ) // remove this and insert it to location
		);
	}
}

if ( ! function_exists( 'wpj_change_array_key' ) ) {
	function wpj_change_array_key( $array, $old_key, $new_key ) {
		if ( ! array_key_exists( $old_key, $array ) ) return $array;

		$keys = array_keys( $array );

		$keys[array_search( $old_key, $keys )] = $new_key;

		return array_combine( $keys, $array );
	}
}

if ( ! function_exists( 'wpj_multidimensional_array_has_value' ) ) {
	function wpj_multidimensional_array_has_value( $arr ) {
		if ( is_array( $arr ) && $arr ) {
			foreach ( $arr as $key => $value ) {
				if ( $value ) return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_multidimensional_array_has_all_values' ) ) {
	function wpj_multidimensional_array_has_all_values( $arr ) {
		if ( is_array( $arr ) && $arr ) {
			foreach ( $arr as $key => $value ) {
				if ( ! $value ) return false;
			}
		}

		return true;
	}
}

if ( ! function_exists( 'wpj_group_array_by_key' ) ) {
	function wpj_group_array_by_key( $array, $key ) {
		$return = [];

		foreach ( $array as $val ) {
			$return[$val[$key]][] = $val;
		}

		return $return;
	}
}

if ( ! function_exists( 'wpj_array_is_multidimensional' ) ) {
	function wpj_array_is_multidimensional( $a ) {
		foreach ( $a as $v ) if ( is_array( $v ) ) return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_array_contain_duplicated_values' ) ) {
	function wpj_array_contain_duplicated_values( $array ) {
		if ( wpj_multidimensional_array_has_value( $array ) ) {
			$dupls = array_diff_key( $array, array_unique( array_map( 'strtoupper', $array ) ) );

			if ( count( $array ) !== count( array_unique( $array ) ) ) {
				return strtoupper( array_values( $dupls )[0] );
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_associative_array' ) ) {
	function wpj_is_associative_array( $arr ) {
		return array_keys( $arr ) !== range( 0, count( $arr ) - 1 );
	}
}

if ( ! function_exists( 'wpj_array_in_URI' ) ) {
	function wpj_array_in_URI( $arr = [] ) {
		if ( $arr ) {
			foreach ( $arr as $key => $value ) {
				if ( isset( $_REQUEST[$value] ) ) {
					return true;
				}
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_json' ) ) {
	function wpj_is_json( $string ) {
		wpj_json_decode( $string );

		return ( json_last_error() == JSON_ERROR_NONE );
	}
}

if ( ! function_exists( 'wpj_json_decode' ) ) {
	function wpj_json_decode( $json, $associative = null, $depth = 512, $flags = 0 ) {
		if ( $json ) {
			$json = json_decode( $json, $associative, $depth, $flags );
		}

		return $json;
	}
}

if ( ! function_exists( 'wpj_sort_array_by_key' ) ) {
	function wpj_sort_array_by_key( $array_to_be_sort, $order = SORT_ASC, $order_key = 'order' ) {
		$array_column = array_column($array_to_be_sort, $order_key);

		array_multisort( $array_column, $order, $array_to_be_sort );

		return $array_to_be_sort;
	}
}