<?php
if ( ! function_exists( 'wpj_insert_badge_purchase_order' ) ) {
	function wpj_insert_badge_purchase_order( $args = [] ) {
		// Badge nr
		$badge_nr = ! empty( $args['badge_nr'] ) ? $args['badge_nr'] : WPJ_Form::get( 'badge_nr' );

		// Price
		$price = ! empty( $args['price'] ) ? $args['price'] : WPJ_Form::get( 'price' );

		// Payment type: 0 - sale | 1 - admin
		$badge_payment_type = ! empty( $args['badge_payment_type'] ) ? $args['badge_payment_type'] : WPJ_Form::get( 'badge_payment_type', 0 );

		// User info
		$user_id = ! empty( $args['user_id'] ) ? $args['user_id'] : get_current_user_id();

		// Date info
		$date_made = ! empty( $args['date_made'] ) ? $args['date_made'] : current_time( 'timestamp', 1 );

		// Payment info
		$payment_status  = ! empty( $args['payment_status'] ) ? $args['payment_status'] : 'pending';
		$payment_gateway = ! empty( $args['payment_gateway'] ) ? $args['payment_gateway'] : WPJ_Form::get( 'pay_for_item' );

		// Currency
		$currency = ! empty( $args['currency'] ) ? $args['currency'] : apply_filters( 'wpjobster_take_allowed_currency_' . $payment_gateway, '' );

		if ( empty( $currency ) ) $currency = wpj_get_site_currency();

		// Final order price
		if ( $currency )
			$payable_amount_exchanged = wpj_number_format_special_exchange( floatval( wpj_get_badge_info( 'wpj_badge_price', $badge_nr ) ), '1', $currency );
		else
			$payable_amount_exchanged = wpj_number_format_special_exchange( floatval( wpj_get_badge_info( 'wpj_badge_price', $badge_nr ) ) );

		// Insert order to database
		$database_info = [
			'user_id'          => $user_id,
			'badge_nr'         => $badge_nr,
			'description'      => wpj_get_badge_info( 'wpj_badge_text', $badge_nr ),
			'icon'             => wpj_get_badge_info( 'wpj_badge_icon', $badge_nr ),
			'price'            => floatval( wpj_get_badge_info( 'wpj_badge_price', $badge_nr ) ),
			'min_rating'       => wpj_get_badge_info( 'wpj_badge_min_rating', $badge_nr ),
			'min_reviews'      => wpj_get_badge_info( 'wpj_badge_min_reviews', $badge_nr ),
			'date_made'        => $date_made,
			'payment_type'     => $badge_payment_type,
			'payment_amount'   => floatval( $price ),
			'payment_currency' => $currency,
			'payment_status'   => $payment_status,
			'payment_gateway'  => $payment_gateway
		];

		$database_info_type = ['%d', '%d', '%s', '%s', '%f', '%d', '%d', '%d', '%d', '%f', '%s', '%s', '%s'];

		$orderid = wpj_insert_badge_order( $database_info, $database_info_type );

		do_action( 'wpj_after_insert_badge_order', $orderid );

		// Insert payment to database
		wpj_insert_payment(
			[
				'payment_status'         => $payment_status == 'completed' ? 1 : 0,
				'payment_gateway'        => $payment_gateway,
				'payment_type'           => 'badge',
				'payment_type_id'        => $orderid,
				'fees'                   => 0,
				'amount'                 => floatval( wpj_get_badge_info( 'wpj_badge_price', $badge_nr ) ),
				'datemade'               => current_time( 'timestamp', 1 ),
				'tax'                    => 0,
				'currency'               => wpj_get_site_default_currency(),
				'final_amount'           => floatval( wpj_get_badge_info( 'wpj_badge_price', $badge_nr ) ),
				'final_amount_exchanged' => $payable_amount_exchanged,
				'final_amount_currency'  => $currency,
			],
			['%d', '%s', '%s', '%d', '%f', '%f', '%d', '%f', '%s', '%f', '%f', '%s']
		);

		return $orderid;
	}
}

if ( ! function_exists( 'wpj_get_badge_info' ) ) {
	function wpj_get_badge_info( $return = '', $badge_nr = '' ) {
		$badges_data = wpj_get_option( 'badge-list-settings' );

		if ( $return && is_numeric( $badge_nr ) ) return $badges_data[$return][$badge_nr];
		if ( $return ) return $badges_data[$return];

		return $badges_data;
	}
}