<?php
if ( ! function_exists( 'wpj_add_chat_class_to_wrapper' ) ) {
	function wpj_add_chat_class_to_wrapper( $classes ) {
		if ( wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && is_user_logged_in() ) {
			$jobster_design = wpj_get_design_option();

			$sidebar_status = isset( $_COOKIE['sidebar'] ) ? $_COOKIE['sidebar'] : 'maximized';

			if ( $jobster_design['chat_sidebar_style'] == 2 )
				return wpj_chat_get_users_list() && is_user_logged_in() ? 'is-chat-active is-sidebar-minimalist ' . $classes : $classes;

			if ( $sidebar_status == 'minimized' )
				return wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && is_user_logged_in() ? $classes . ' is-chat-active is-chat-minimized' : $classes;

			return wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && is_user_logged_in() ? $classes . ' is-chat-active is-chat-maximized' : $classes;
		}

		return $classes;
	}
}

if ( ! function_exists( 'wpj_init_chat_system_placeholder' ) ) {
	function wpj_init_chat_system_placeholder() {
		if ( wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && is_user_logged_in() ) {
			$jobster_design = wpj_get_design_option();

			$sidebar_status = isset( $_COOKIE['sidebar'] ) ? $_COOKIE['sidebar'] : 'maximized';
			$icon           = $jobster_design['chat_sidebar_icon_name'] == true ? $jobster_design['chat_sidebar_icon_name'] : 'comments';

			wpj_display_chat_sidebar_placeholder( $sidebar_status, $icon );
		}
	}
}

if ( ! function_exists( 'wpj_init_chat_system' ) ) {
	function wpj_init_chat_system() {
		if ( wpj_get_option( 'wpjobster_chat_enable' ) == 'yes' && is_user_logged_in() ) {
			$jobster_design = wpj_get_design_option();

			// Create users array
			$users = [];

			$users_list = wpj_chat_get_users_list();

			if ( $users_list ) {
				foreach ( $users_list as $user_id ) {
					$user_arr = get_userdata( $user_id );

					if ( ! empty( $user_arr->last_user_login ) ) {
						$time_elapsed    = time() - ( $user_arr->last_user_login ?: 60000 );
						$time_difference = $time_elapsed / 60;
						$time_difference = ( int ) $time_difference;

					} else {
						$time_difference = '';
						$time_elapsed    = '';

					}

					$users[$user_arr->ID] = [
						'ID'              => $user_arr->ID,
						'user_login'      => wpj_get_user_display_type( $user_arr->ID ),
						'user_nicename'   => $user_arr->user_nicename,
						'time_elapsed'    => $time_elapsed,
						'time_difference' => $time_difference,
						'unread_messages' => wpj_get_pm_notify( 'COUNT( * )', ['initiator' => $user_arr->ID, 'user' => get_current_user_id(), 'show_to_source' => 1, 'rd' => 0], 'var' )
					];
				}
			}

			// Online users count
			$user_on_cnt = 0;

			if ( $users ) {
				foreach ( $users as $user ) {
					if ( $user['time_elapsed'] && $user['time_elapsed'] <= 359 ) {
						$user_on_cnt++;
					}
				}
			}

			// Sidebar position
			$sidebar_status = isset( $_COOKIE['sidebar'] ) ? $_COOKIE['sidebar'] : 'maximized';

			// Sidebar icon
			$icon = $jobster_design['chat_sidebar_icon_name'] == true ? $jobster_design['chat_sidebar_icon_name'] : 'comments';

			wpj_display_chat_sidebar( $users, $sidebar_status, $user_on_cnt, $icon );

			if ( wpj_is_ajax_call() ) wp_die();
		}
	}
}

if ( ! function_exists( 'wpj_chat_get_users_list' ) ) {
	function wpj_chat_get_users_list() {
		$current_user_id = get_current_user_id();

		// Tangential users
		$tangential_users_sql = wpj_get_tangential_users_by_user_id( $current_user_id );

		$tangential_users_arr = [];

		if ( $tangential_users_sql ) {
			foreach ( $tangential_users_sql as $key => $user ) {
				$user_arr = get_userdata( $user->user );

				if ( $user_arr ) {
					if ( isset( $user_arr->last_user_login ) ) {
						$tangential_users_arr[$user_arr->ID] = $user_arr->last_user_login;

					} else {
						$tangential_users_arr[$user_arr->ID] = $user_arr->ID;

					}
				}
			}
		}

		arsort( $tangential_users_arr ); // sort the array by last login

		$tangential_users = array_keys( $tangential_users_arr );

		// Return
		if ( wpj_get_option( 'wpjobster_all_users_to_sidebar' ) == 'yes' ) {
			$all_users_arr = [];

			$all_users_sql = wpj_get_users_last_login();

			if ( $all_users_sql ) { $i = 0;
				foreach ( $all_users_sql as $key => $user ) {
					$user_arr = get_userdata( $user->ID );

					if ( $user_arr && $i < 50 ) {
						$is_seller = apply_filters( 'hide_for_buyers', true, $user->ID );

						if ( $is_seller ) { $i++;
							if ( isset( $user_arr->last_user_login ) ) {
								$all_users_arr[$user_arr->ID] = $user_arr->last_user_login;

							} else {
								$all_users_arr[$user_arr->ID] = $user_arr->ID;

							}
						}
					}
				}
			}

			if ( isset( $all_users_arr[$current_user_id] ) )
				unset( $all_users_arr[$current_user_id] );

			arsort( $all_users_arr ); // sort the array by last login

			$all_users = array_keys( $all_users_arr );

			$ret_array = array_merge( $tangential_users, $all_users );

		} else {
			$ret_array = $tangential_users;

		}

		return array_unique( $ret_array );
	}
}

if ( ! function_exists( 'wpj_chat_get_message_date' ) ) {
	function wpj_chat_get_message_date( $row ) {
		$begin_of_day = strtotime( 'midnight', time() );
		$end_of_day   = strtotime( 'tomorrow', $begin_of_day ) - 1;

		$begin_of_week = strtotime( 'last Monday', time() );
		$end_of_week   = strtotime( 'next Sunday', time() ) + 86400;

		if ( $row->datemade ) {
			if ( $row->datemade > $begin_of_day && $row->datemade < $end_of_day ) {
				return wpj_date( wpj_get_option( 'time_format' ), $row->datemade );

			} elseif ( $row->datemade > $begin_of_week && $row->datemade < $end_of_week ) {
				return wpj_date( 'l, ' . wpj_get_option( 'time_format' ), $row->datemade );

			} else {
				return wpj_date( wpj_get_option( 'date_format' ), $row->datemade );

			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_chat_get_custom_offer_info' ) ) {
	function wpj_chat_get_custom_offer_info( $row ) {
		$message = '';
		$sender_id   = $row->initiator;
		$receiver_id = $row->user;

		if ( $row->custom_offer == -1 ) {
			if ( get_current_user_id() == $row->initiator ) {
				$user_id = $receiver_id;
				$message = __( 'You requested a custom offer from %s', 'wpjobster' );

			} elseif ( get_current_user_id() == $row->user ) {
				$user_id = $sender_id;
				$message = __( '%s sent you a custom offer request', 'wpjobster' );

			}

		} elseif ( $row->custom_offer > 0 ) {
			if ( get_current_user_id() == $row->initiator ) {
				$user_id = $receiver_id;
				$message = __( 'You sent a custom price offer to %s', 'wpjobster' );

			} elseif ( get_current_user_id() == $row->user ) {
				$user_id = $sender_id;
				$message = __( '%s sent you a custom price offer', 'wpjobster' );

			}

		}

		if ( ! empty( $user_id ) ) {
			return '
				<a href="' . wpj_get_pm_link( $user_id ) . '">
					<span class="line-clamp-2">' . sprintf( $message, wpj_get_user_display_type( $user_id ) ) . '</span>
				</a>
			';
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_chat_get_custom_offer_response' ) ) {
	function wpj_chat_get_custom_offer_response( $row ) {
		if ( $row ) {
			if ( get_post_meta( $row->custom_offer, "offer_accepted", true ) == 1 )
				return __( "Accepted", "wpjobster" );

			elseif ( get_post_meta( $row->custom_offer, "offer_declined", true ) == 1 )
				return __( "Declined", "wpjobster" );

			elseif ( get_post_meta( $row->custom_offer, "offer_withdrawn", true ) == 1 )
				return __( "Withdrawn", "wpjobster" );

			elseif ( get_post_meta( $row->custom_offer, "offer_expired", true ) == 1 )
				return __( "Expired", "wpjobster" );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_chat_get_custom_offer_response_status' ) ) {
	function wpj_chat_get_custom_offer_response_status( $row ) {
		if ( $row ) {
			if ( get_post_meta( $row->custom_offer, "offer_accepted", true ) == 1 )
				return "offer_accepted";

			elseif ( get_post_meta( $row->custom_offer, "offer_declined", true ) == 1 )
				return "offer_declined";

			elseif ( get_post_meta( $row->custom_offer, "offer_withdrawn", true ) == 1 )
				return "offer_withdrawn";

			elseif ( get_post_meta( $row->custom_offer, "offer_expired", true ) == 1 )
				return "offer_expired";
		}

		return false;
	}
}