<?php
if ( ! function_exists( 'wpj_get_country_name_by_code' ) ) {
	function wpj_get_country_name_by_code( $code = '' ) {
		$country_names = [
			'' => '-',
			'AF' => __( 'Afghanistan', 'wpjobster' ),
			'AX' => __( 'Aland Islands', 'wpjobster' ),
			'AL' => __( 'Albania', 'wpjobster' ),
			'DZ' => __( 'Algeria', 'wpjobster' ),
			'AS' => __( 'American Samoa', 'wpjobster' ),
			'AD' => __( 'Andorra', 'wpjobster' ),
			'AO' => __( 'Angola', 'wpjobster' ),
			'AI' => __( 'Anguilla', 'wpjobster' ),
			'AQ' => __( 'Antarctica', 'wpjobster' ),
			'AG' => __( 'Antigua and Barbuda', 'wpjobster' ),
			'AR' => __( 'Argentina', 'wpjobster' ),
			'AM' => __( 'Armenia', 'wpjobster' ),
			'AW' => __( 'Aruba', 'wpjobster' ),
			'AU' => __( 'Australia', 'wpjobster' ),
			'AT' => __( 'Austria', 'wpjobster' ),
			'AZ' => __( 'Azerbaijan', 'wpjobster' ),
			'BS' => __( 'Bahamas', 'wpjobster' ),
			'BH' => __( 'Bahrain', 'wpjobster' ),
			'BD' => __( 'Bangladesh', 'wpjobster' ),
			'BB' => __( 'Barbados', 'wpjobster' ),
			'BY' => __( 'Belarus', 'wpjobster' ),
			'BE' => __( 'Belgium', 'wpjobster' ),
			'BZ' => __( 'Belize', 'wpjobster' ),
			'BJ' => __( 'Benin', 'wpjobster' ),
			'BM' => __( 'Bermuda', 'wpjobster' ),
			'BT' => __( 'Bhutan', 'wpjobster' ),
			'BO' => __( 'Bolivia', 'wpjobster' ),
			'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'wpjobster' ),
			'BA' => __( 'Bosnia and Herzegovina', 'wpjobster' ),
			'BW' => __( 'Botswana', 'wpjobster' ),
			'BV' => __( 'Bouvet Island', 'wpjobster' ),
			'BR' => __( 'Brazil', 'wpjobster' ),
			'IO' => __( 'British Indian Ocean Territory', 'wpjobster' ),
			'VG' => __( 'British Virgin Islands', 'wpjobster' ),
			'BN' => __( 'Brunei', 'wpjobster' ),
			'BG' => __( 'Bulgaria', 'wpjobster' ),
			'BF' => __( 'Burkina Faso', 'wpjobster' ),
			'BI' => __( 'Burundi', 'wpjobster' ),
			'KH' => __( 'Cambodia', 'wpjobster' ),
			'CM' => __( 'Cameroon', 'wpjobster' ),
			'CA' => __( 'Canada', 'wpjobster' ),
			'CV' => __( 'Cape Verde', 'wpjobster' ),
			'KY' => __( 'Cayman Islands', 'wpjobster' ),
			'CF' => __( 'Central African Republic', 'wpjobster' ),
			'TD' => __( 'Chad', 'wpjobster' ),
			'CL' => __( 'Chile', 'wpjobster' ),
			'CN' => __( 'China', 'wpjobster' ),
			'CX' => __( 'Christmas Island', 'wpjobster' ),
			'CC' => __( 'Cocos Islands', 'wpjobster' ),
			'CO' => __( 'Colombia', 'wpjobster' ),
			'KM' => __( 'Comoros', 'wpjobster' ),
			'CK' => __( 'Cook Islands', 'wpjobster' ),
			'CR' => __( 'Costa Rica', 'wpjobster' ),
			'HR' => __( 'Croatia', 'wpjobster' ),
			'CU' => __( 'Cuba', 'wpjobster' ),
			'CW' => __( 'Curacao', 'wpjobster' ),
			'CY' => __( 'Cyprus', 'wpjobster' ),
			'CZ' => __( 'Czech Republic', 'wpjobster' ),
			'CD' => __( 'Democratic Republic of the Congo', 'wpjobster' ),
			'DK' => __( 'Denmark', 'wpjobster' ),
			'DJ' => __( 'Djibouti', 'wpjobster' ),
			'DM' => __( 'Dominica', 'wpjobster' ),
			'DO' => __( 'Dominican Republic', 'wpjobster' ),
			'TL' => __( 'East Timor', 'wpjobster' ),
			'EC' => __( 'Ecuador', 'wpjobster' ),
			'EG' => __( 'Egypt', 'wpjobster' ),
			'SV' => __( 'El Salvador', 'wpjobster' ),
			'GQ' => __( 'Equatorial Guinea', 'wpjobster' ),
			'ER' => __( 'Eritrea', 'wpjobster' ),
			'EE' => __( 'Estonia', 'wpjobster' ),
			'ET' => __( 'Ethiopia', 'wpjobster' ),
			'FK' => __( 'Falkland Islands', 'wpjobster' ),
			'FO' => __( 'Faroe Islands', 'wpjobster' ),
			'FJ' => __( 'Fiji', 'wpjobster' ),
			'FI' => __( 'Finland', 'wpjobster' ),
			'FR' => __( 'France', 'wpjobster' ),
			'GF' => __( 'French Guiana', 'wpjobster' ),
			'PF' => __( 'French Polynesia', 'wpjobster' ),
			'TF' => __( 'French Southern Territories', 'wpjobster' ),
			'GA' => __( 'Gabon', 'wpjobster' ),
			'GM' => __( 'Gambia', 'wpjobster' ),
			'GE' => __( 'Georgia', 'wpjobster' ),
			'DE' => __( 'Germany', 'wpjobster' ),
			'GH' => __( 'Ghana', 'wpjobster' ),
			'GI' => __( 'Gibraltar', 'wpjobster' ),
			'GR' => __( 'Greece', 'wpjobster' ),
			'GL' => __( 'Greenland', 'wpjobster' ),
			'GD' => __( 'Grenada', 'wpjobster' ),
			'GP' => __( 'Guadeloupe', 'wpjobster' ),
			'GU' => __( 'Guam', 'wpjobster' ),
			'GT' => __( 'Guatemala', 'wpjobster' ),
			'GG' => __( 'Guernsey', 'wpjobster' ),
			'GN' => __( 'Guinea', 'wpjobster' ),
			'GW' => __( 'Guinea-Bissau', 'wpjobster' ),
			'GY' => __( 'Guyana', 'wpjobster' ),
			'HT' => __( 'Haiti', 'wpjobster' ),
			'HM' => __( 'Heard Island and McDonald Islands', 'wpjobster' ),
			'HN' => __( 'Honduras', 'wpjobster' ),
			'HK' => __( 'Hong Kong', 'wpjobster' ),
			'HU' => __( 'Hungary', 'wpjobster' ),
			'IS' => __( 'Iceland', 'wpjobster' ),
			'IN' => __( 'India', 'wpjobster' ),
			'ID' => __( 'Indonesia', 'wpjobster' ),
			'IR' => __( 'Iran', 'wpjobster' ),
			'IQ' => __( 'Iraq', 'wpjobster' ),
			'IE' => __( 'Ireland', 'wpjobster' ),
			'IM' => __( 'Isle of Man', 'wpjobster' ),
			'IL' => __( 'Israel', 'wpjobster' ),
			'IT' => __( 'Italy', 'wpjobster' ),
			'CI' => __( 'Ivory Coast', 'wpjobster' ),
			'JM' => __( 'Jamaica', 'wpjobster' ),
			'JP' => __( 'Japan', 'wpjobster' ),
			'JE' => __( 'Jersey', 'wpjobster' ),
			'JO' => __( 'Jordan', 'wpjobster' ),
			'KZ' => __( 'Kazakhstan', 'wpjobster' ),
			'KE' => __( 'Kenya', 'wpjobster' ),
			'KI' => __( 'Kiribati', 'wpjobster' ),
			'XK' => __( 'Kosovo', 'wpjobster' ),
			'KW' => __( 'Kuwait', 'wpjobster' ),
			'KG' => __( 'Kyrgyzstan', 'wpjobster' ),
			'LA' => __( 'Laos', 'wpjobster' ),
			'LV' => __( 'Latvia', 'wpjobster' ),
			'LB' => __( 'Lebanon', 'wpjobster' ),
			'LS' => __( 'Lesotho', 'wpjobster' ),
			'LR' => __( 'Liberia', 'wpjobster' ),
			'LY' => __( 'Libya', 'wpjobster' ),
			'LI' => __( 'Liechtenstein', 'wpjobster' ),
			'LT' => __( 'Lithuania', 'wpjobster' ),
			'LU' => __( 'Luxembourg', 'wpjobster' ),
			'MO' => __( 'Macao', 'wpjobster' ),
			'MK' => __( 'Macedonia', 'wpjobster' ),
			'MG' => __( 'Madagascar', 'wpjobster' ),
			'MW' => __( 'Malawi', 'wpjobster' ),
			'MY' => __( 'Malaysia', 'wpjobster' ),
			'MV' => __( 'Maldives', 'wpjobster' ),
			'ML' => __( 'Mali', 'wpjobster' ),
			'MT' => __( 'Malta', 'wpjobster' ),
			'MH' => __( 'Marshall Islands', 'wpjobster' ),
			'MQ' => __( 'Martinique', 'wpjobster' ),
			'MR' => __( 'Mauritania', 'wpjobster' ),
			'MU' => __( 'Mauritius', 'wpjobster' ),
			'YT' => __( 'Mayotte', 'wpjobster' ),
			'MX' => __( 'Mexico', 'wpjobster' ),
			'FM' => __( 'Micronesia', 'wpjobster' ),
			'MD' => __( 'Moldova', 'wpjobster' ),
			'MC' => __( 'Monaco', 'wpjobster' ),
			'MN' => __( 'Mongolia', 'wpjobster' ),
			'ME' => __( 'Montenegro', 'wpjobster' ),
			'MS' => __( 'Montserrat', 'wpjobster' ),
			'MA' => __( 'Morocco', 'wpjobster' ),
			'MZ' => __( 'Mozambique', 'wpjobster' ),
			'MM' => __( 'Myanmar', 'wpjobster' ),
			'NA' => __( 'Namibia', 'wpjobster' ),
			'NR' => __( 'Nauru', 'wpjobster' ),
			'NP' => __( 'Nepal', 'wpjobster' ),
			'NL' => __( 'Netherlands', 'wpjobster' ),
			'NC' => __( 'New Caledonia', 'wpjobster' ),
			'NZ' => __( 'New Zealand', 'wpjobster' ),
			'NI' => __( 'Nicaragua', 'wpjobster' ),
			'NE' => __( 'Niger', 'wpjobster' ),
			'NG' => __( 'Nigeria', 'wpjobster' ),
			'NU' => __( 'Niue', 'wpjobster' ),
			'NF' => __( 'Norfolk Island', 'wpjobster' ),
			'KP' => __( 'North Korea', 'wpjobster' ),
			'MP' => __( 'Northern Mariana Islands', 'wpjobster' ),
			'NO' => __( 'Norway', 'wpjobster' ),
			'OM' => __( 'Oman', 'wpjobster' ),
			'PK' => __( 'Pakistan', 'wpjobster' ),
			'PW' => __( 'Palau', 'wpjobster' ),
			'PS' => __( 'Palestinian Territory', 'wpjobster' ),
			'PA' => __( 'Panama', 'wpjobster' ),
			'PG' => __( 'Papua New Guinea', 'wpjobster' ),
			'PY' => __( 'Paraguay', 'wpjobster' ),
			'PE' => __( 'Peru', 'wpjobster' ),
			'PH' => __( 'Philippines', 'wpjobster' ),
			'PN' => __( 'Pitcairn', 'wpjobster' ),
			'PL' => __( 'Poland', 'wpjobster' ),
			'PT' => __( 'Portugal', 'wpjobster' ),
			'PR' => __( 'Puerto Rico', 'wpjobster' ),
			'QA' => __( 'Qatar', 'wpjobster' ),
			'CG' => __( 'Republic of the Congo', 'wpjobster' ),
			'RE' => __( 'Reunion', 'wpjobster' ),
			'RO' => __( 'Romania', 'wpjobster' ),
			'RU' => __( 'Russia', 'wpjobster' ),
			'RW' => __( 'Rwanda', 'wpjobster' ),
			'BL' => __( 'Saint Barthelemy', 'wpjobster' ),
			'SH' => __( 'Saint Helena', 'wpjobster' ),
			'KN' => __( 'Saint Kitts and Nevis', 'wpjobster' ),
			'LC' => __( 'Saint Lucia', 'wpjobster' ),
			'MF' => __( 'Saint Martin', 'wpjobster' ),
			'PM' => __( 'Saint Pierre and Miquelon', 'wpjobster' ),
			'VC' => __( 'Saint Vincent and the Grenadines', 'wpjobster' ),
			'WS' => __( 'Samoa', 'wpjobster' ),
			'SM' => __( 'San Marino', 'wpjobster' ),
			'ST' => __( 'Sao Tome and Principe', 'wpjobster' ),
			'SA' => __( 'Saudi Arabia', 'wpjobster' ),
			'SN' => __( 'Senegal', 'wpjobster' ),
			'RS' => __( 'Serbia', 'wpjobster' ),
			'SC' => __( 'Seychelles', 'wpjobster' ),
			'SL' => __( 'Sierra Leone', 'wpjobster' ),
			'SG' => __( 'Singapore', 'wpjobster' ),
			'SX' => __( 'Sint Maarten', 'wpjobster' ),
			'SK' => __( 'Slovakia', 'wpjobster' ),
			'SI' => __( 'Slovenia', 'wpjobster' ),
			'SB' => __( 'Solomon Islands', 'wpjobster' ),
			'SO' => __( 'Somalia', 'wpjobster' ),
			'ZA' => __( 'South Africa', 'wpjobster' ),
			'GS' => __( 'South Georgia and the South Sandwich Islands', 'wpjobster' ),
			'KR' => __( 'South Korea', 'wpjobster' ),
			'SS' => __( 'South Sudan', 'wpjobster' ),
			'ES' => __( 'Spain', 'wpjobster' ),
			'LK' => __( 'Sri Lanka', 'wpjobster' ),
			'SD' => __( 'Sudan', 'wpjobster' ),
			'SR' => __( 'Suriname', 'wpjobster' ),
			'SJ' => __( 'Svalbard and Jan Mayen', 'wpjobster' ),
			'SZ' => __( 'Swaziland', 'wpjobster' ),
			'SE' => __( 'Sweden', 'wpjobster' ),
			'CH' => __( 'Switzerland', 'wpjobster' ),
			'SY' => __( 'Syria', 'wpjobster' ),
			'TW' => __( 'Taiwan', 'wpjobster' ),
			'TJ' => __( 'Tajikistan', 'wpjobster' ),
			'TZ' => __( 'Tanzania', 'wpjobster' ),
			'TH' => __( 'Thailand', 'wpjobster' ),
			'TG' => __( 'Togo', 'wpjobster' ),
			'TK' => __( 'Tokelau', 'wpjobster' ),
			'TO' => __( 'Tonga', 'wpjobster' ),
			'TT' => __( 'Trinidad and Tobago', 'wpjobster' ),
			'TN' => __( 'Tunisia', 'wpjobster' ),
			'TR' => __( 'Turkey', 'wpjobster' ),
			'TM' => __( 'Turkmenistan', 'wpjobster' ),
			'TC' => __( 'Turks and Caicos Islands', 'wpjobster' ),
			'TV' => __( 'Tuvalu', 'wpjobster' ),
			'VI' => __( 'U.S. Virgin Islands', 'wpjobster' ),
			'UG' => __( 'Uganda', 'wpjobster' ),
			'UA' => __( 'Ukraine', 'wpjobster' ),
			'AE' => __( 'United Arab Emirates', 'wpjobster' ),
			'GB' => __( 'United Kingdom', 'wpjobster' ),
			'US' => __( 'United States', 'wpjobster' ),
			'UM' => __( 'United States Minor Outlying Islands', 'wpjobster' ),
			'UY' => __( 'Uruguay', 'wpjobster' ),
			'UZ' => __( 'Uzbekistan', 'wpjobster' ),
			'VU' => __( 'Vanuatu', 'wpjobster' ),
			'VA' => __( 'Vatican', 'wpjobster' ),
			'VE' => __( 'Venezuela', 'wpjobster' ),
			'VN' => __( 'Vietnam', 'wpjobster' ),
			'WF' => __( 'Wallis and Futuna', 'wpjobster' ),
			'EH' => __( 'Western Sahara', 'wpjobster' ),
			'YE' => __( 'Yemen', 'wpjobster' ),
			'ZM' => __( 'Zambia', 'wpjobster' ),
			'ZW' => __( 'Zimbabwe', 'wpjobster' )
		];

		if ( $code && $code != '-' ) {
			if ( strlen( $code ) > 2 ) {
				foreach ( $country_names as $country_code => $country_name ) {
					if ( $code == $country_name )
						return $country_name;

					else
						return $code;
				}

			} else {
				return $country_names[$code];

			}

		} else {
			return apply_filters( 'wpj_countries_list_filter', $country_names );

		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_country_code_by_ip' ) ) {
	function wpj_get_country_code_by_ip( $ip ) {
		wpj_save_autodetected_user_info();

		if ( wpj_ipcache_table_exist() ) {
			$row = wpj_get_ip( 'info', ['ipnr' => $ip], 'row' );

			if ( $row ) {
				$info = wpj_json_decode( $row->info );

				$country_code = ! empty( $info->country_code ) ? $info->country_code : false;

				if ( ! $country_code ) $country_code = ! empty( $info->countryCode ) ? $info->countryCode : false;

				return $country_code ? $country_code : false;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_country_by_uid' ) ) {
	function wpj_get_country_by_uid( $uid ) {
		if ( wpj_get_option( 'wpjobster_en_country_flags' ) == 'yes' ) {
			$code = strtolower( wpj_get_country_code_by_ip( get_user_meta( $uid, 'ip_reg', true ) ) );

			if ( empty( $code ) ) $code = 'us';

			$code = apply_filters( 'wpjobster_code_country_ip', $code );

			return $code;
		}

		return false;
	}
}