<?php
if ( ! function_exists( 'wpj_get_custom_colour' ) ) {
	function wpj_get_custom_colour( $colour = '' ) {
		return $colour ? 'style="color: ' . $colour . '"' : '';
	}
}

if ( ! function_exists( 'wpj_add_front_page_body_class' ) ) {
	function wpj_add_front_page_body_class( $classes ) {
		$jobster_design = wpj_get_design_option();

		$classes[] = 'without-header';

		if ( is_front_page() ) {
			if ( isset( $jobster_design['header_on_homepage'] ) ) {
				if ( $jobster_design['header_on_homepage'] == true ) {
					unset( $classes[array_key_last( $classes )] );
				}
			}
		}

		if ( is_page( wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ) ) ) {
			$classes[] = 'overflow-hidden';
		}

		return $classes;
	}
}

if ( ! function_exists( 'wpj_get_custom_css' ) ) {
	function wpj_get_custom_css() {
		$jobster_design = wpj_get_design_option();

		$primary_color = ! empty( $jobster_design['site_primary_color'] ) ? $jobster_design['site_primary_color'] : '#20c497';

		$logo_spacing = ! empty( $jobster_design['logo_spacing'] ) ? $jobster_design['logo_spacing'] : ['padding-top' => 10, 'padding-bottom' => 10];
		$logo_height  = ! empty( $jobster_design['logo_height']['height'] ) ? intval( $jobster_design['logo_height']['height'] ) : 45;

		$wrapper = $logo_height + intval( $logo_spacing['padding-top'] ) + intval( $logo_spacing['padding-bottom'] );

		$job_instructions_box_icon = ! empty( $jobster_design['job_instructions_box_icon']['url'] ) ? $jobster_design['job_instructions_box_icon']['url'] : get_template_directory_uri() . '/assets/images/misc/info.svg';

		$request_instructions_box_icon = ! empty( $jobster_design['request_instructions_box_icon']['url'] ) ? $jobster_design['request_instructions_box_icon']['url'] : get_template_directory_uri() . '/assets/images/misc/info.svg';

		$upload_form_icon = ! empty( $jobster_design['upload_button_icon_name']['url'] ) ? $jobster_design['upload_button_icon_name']['url'] : get_template_directory_uri() . '/assets/images/media/paperclip.svg';

		ob_start();

		/* Header bg image */
		if ( isset( $jobster_design['header_background_type'] ) && $jobster_design['header_background_type'] == 'image' && ! empty( $jobster_design['header_background_image'] ) ) { ?>

			.header-wrapper,
			.header-wrapper .fixed {
				background-image: url( "<?php echo $jobster_design['header_background_image']['url']; ?>" );
				background-size: cover;
				background-position: center center;
				background-repeat: no-repeat;
			}

		<?php }

		/* Header hover menu item bottom line */
		if ( ! empty ( $jobster_design['header_links_color']['hover'] ) ) { ?>

			.main-menu-container > div > ul > li:hover:after {
				background-color: <?php echo $jobster_design['header_links_color']['hover']; ?>;
			}

		<?php }

		/* Left mobile menu icon text-shadow */ ?>
		.header-wrapper.header-mobile i.thick.bars.icon {
			text-shadow: 0 0.1em 0 <?php echo $jobster_design['left_mobile_menu_colour_icon_options_header']; ?>;
		}

		<?php /* Left mobile menu icon text-shadow - front page */ ?>
		.home.without-header:not(.logged-in) .header-mobile .header-wrapper-top:not(.fixed) .menu-left i.thick.bars.icon {
			text-shadow: 0 0.1em 0 <?php echo $jobster_design['left_mobile_menu_front_colour_icon_options_header']; ?>;
		}

		<?php /* Auth login button */
		if ( ! empty ( $jobster_design['login_border_radius_header']['top'] ) ) { ?>

			.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple,
			.header-wrapper-top .login-link.text-button.text-button-simple {
				border-radius: <?php echo $jobster_design['login_border_radius_header']['top']; ?>
			}

		<?php }

		if ( ! empty ( $jobster_design['login_front_border_radius_header']['top'] ) ) { ?>

			.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple {
				border-radius: <?php echo $jobster_design['login_front_border_radius_header']['top']; ?>
			}

		<?php }

		/* Auth register button */
		if ( ! empty ( $jobster_design['register_border_radius_header']['top'] ) ) { ?>

			.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button,
			.header-wrapper-top .register-link.text-button {
				border-radius: <?php echo $jobster_design['register_border_radius_header']['top']; ?>
			}

		<?php }

		if ( ! empty ( $jobster_design['register_front_border_radius_header']['top'] ) ) { ?>

			.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button {
				border-radius: <?php echo $jobster_design['register_front_border_radius_header']['top']; ?>
			}

		<?php }

		/* Messages - Scroll down icon */
		if ( ! empty ( $jobster_design['messages_scroll_down_button_icon_border_radius']['top'] ) ) { ?>

			.scroll-down-wrapper {
				border-radius: <?php echo $jobster_design['messages_scroll_down_button_icon_border_radius']['top']; ?>
			}

		<?php }

		/* Header - Balance */
		if ( ! empty ( $jobster_design['balance_border_radius_header']['top'] ) ) { ?>

			.user-info-menu .header-user-credit {
				border-radius: <?php echo $jobster_design['balance_border_radius_header']['top']; ?>
			}

		<?php }

		/* Video play icon Slider */
		if ( $jobster_design['enable_video_icon_cards'] != true ) { ?>

			.wpj-card-style-3.ui.card .wpj-carousel.owl-carousel .owl-video-play-icon,
			.wpj-card-style-4.ui.card .wpj-carousel.owl-carousel .owl-video-play-icon {
				display: none;
			}

		<?php }

		/* Footer bg image */
		if ( isset( $jobster_design['footer_background_type'] ) && $jobster_design['footer_background_type'] == 'image' && ! empty( $jobster_design['footer_background_image'] ) ) { ?>

			.footer-wrapper {
				background-image: url( '<?php echo $jobster_design['footer_background_image']['url']; ?>' );
				background-size: cover;
				background-position: center center;
				background-repeat: no-repeat;
			}

		<?php }

		/* Footer logo grayscale */
		if ( $jobster_design['logo_grayscale_enable'] == true ) { ?>

			.footer-wrapper .logo-holder img {
				-webkit-filter: grayscale(100%);
				filter: grayscale(100%);
				opacity: .7;
			}

		<?php }

		if ( $logo_height > 0 ) { ?>

			.header-wrapper-top, .header-wrapper-top-holder {
				height: <?php echo $wrapper. 'px'; ?>;
			}

			<?php if ( ! isset( $jobster_design['enable_categories_menu_not_loggedin_front_page'] ) || ( isset( $jobster_design['enable_categories_menu_not_loggedin_front_page'] ) && $jobster_design['enable_categories_menu_not_loggedin_front_page'] == false ) ) { ?>

				.home.without-header:not(.logged-in) .header-wrapper .logo-holder img {
					height: calc( <?php echo $logo_height . 'px'; ?> + 16px );
				}

				.home.without-header:not(.logged-in) .header-wrapper-top.fixed .logo-holder img,
				.home.without-header:not(.logged-in) .header-mobile .header-wrapper-top .logo-holder img {
					height: calc( <?php echo $logo_height . 'px'; ?> - 4px );
				}

			<?php }

			/* Private message */ ?>
			@media only screen and (min-width:992px) {
				.ui.segment.wpj-messenger,
				.wpj-messenger {
					height: calc(100vh - <?php echo $wrapper. 'px'; ?> - 101px); /* Fallback */
					height: calc((var(--vh, 1vh) * 100) - <?php echo $wrapper. 'px'; ?> - 101px);
				}
			}

		<?php }

		/* Chat */

		if ( ! empty ( $jobster_design['chat_box_footer_buttons_color']['hover'] ) ) { ?>

			.message-box-container .message-box-footer .emojionearea-button:hover * {
				color: <?php echo $jobster_design['chat_box_footer_buttons_color']['hover']; ?>;
			}

		<?php }

		if ( ! empty ( $jobster_design['chat_box_head_buttons_color']['focus'] ) ) { ?>

			.message-box-container .message-box-wrapper.has-focus .message-box-head .message-box-head-content .message-box-head-buttons i,
			.message-box-container .message-box-wrapper.has-focus .message-box-head .message-box-head-content .message-box-head-buttons span {
				color: <?php echo $jobster_design['chat_box_head_buttons_color']['focus']; ?>;
			}

		<?php }

		if ( ! empty ( $jobster_design['chat_box_head_buttons_color']['hover'] ) ) { ?>

			.message-box-container .message-box-wrapper .message-box-head .message-box-head-content .message-box-head-buttons i:hover,
			.message-box-container .message-box-wrapper .message-box-head .message-box-head-content .message-box-head-buttons span:hover {
				color: <?php echo $jobster_design['chat_box_head_buttons_color']['hover']; ?>;
			}

		<?php }

		if ( ! empty ( $jobster_design['chat_box_footer_message_option_btn_text_color']['hover'] ) ) { ?>

			.message-box-container .message-box-footer .message-box-footer-options .option-wrapper > div:hover > i {
				color: <?php echo $jobster_design['chat_box_footer_message_option_btn_text_color']['hover']; ?>;
			}

		<?php }

		/* Semantic UI Progress */ ?>
		.ui.progress.success .bar {
			background-color: <?php echo $primary_color; ?> !important;
		}

		<?php /* Post new instructions */ ?>
		.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):after,
		.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):after {
			background-image: url( '<?php echo $job_instructions_box_icon; ?>' );
		}

		.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):after,
		.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):after {
			background-image: url( '<?php echo $request_instructions_box_icon; ?>' );
		}

		<?php /* Upload form icon */ ?>
		#queue ~ .ui.labeled.icon.button.uploadifive-button > .icon.attach.icon {
			background-image: url( '<?php echo $upload_form_icon; ?>' );
		}

		<?php /* Popular categories */
		if ( ! empty ( $jobster_design['job_popular_categories_border_radius']['top'] ) ) { ?>

			.most-popular-terms a {
				border-radius: <?php echo $jobster_design['job_popular_categories_border_radius']['top']; ?>
			}

		<?php }

		/* Job subcategories */
		if ( ! empty ( $jobster_design['job_subcategories_border_radius']['top'] ) ) { ?>

			.job-subcategories.subcategory-listing a {
				border-radius: <?php echo $jobster_design['job_subcategories_border_radius']['top']; ?>
			}

		<?php }

		/* Request subcategories */
		if ( ! empty ( $jobster_design['request_subcategories_border_radius']['top'] ) ) { ?>

			.request-subcategories.subcategory-listing a {
				border-radius: <?php echo $jobster_design['request_subcategories_border_radius']['top']; ?>
			}

		<?php }

		/* Blog date */
		if ( ! empty ( $jobster_design['blog_date_border_radius']['top'] ) ) { ?>

			.article-date {
				border-radius: <?php echo $jobster_design['blog_date_border_radius']['top']; ?>
			}

		<?php }

		/* Blog tags */
		if ( ! empty ( $jobster_design['blog_tags_border_radius']['top'] ) ) { ?>

			.blog-tags ul li a {
				border-radius: <?php echo $jobster_design['blog_tags_border_radius']['top']; ?>
			}

		<?php }

		/* Blog categories */
		if ( ! empty ( $jobster_design['blog_categories_border_radius']['top'] ) ) { ?>

			.blog-categories ul li a {
				border-radius: <?php echo $jobster_design['blog_categories_border_radius']['top']; ?>
			}

		<?php }

		/* Blog share */
		if ( ! empty ( $jobster_design['blog_share_border_radius']['top'] ) ) { ?>

			.share-article a {
				border-radius: <?php echo $jobster_design['blog_share_border_radius']['top']; ?>
			}

		<?php }

		/* Sidebar */
		if ( ! empty ( $jobster_design['user_account_sidebar_border_radius']['top'] ) ) { ?>

			.user-sidebars-wrapper .user-info-sidebar-wrapper {
				border-radius: <?php echo $jobster_design['user_account_sidebar_border_radius']['top']; ?>
			}

		<?php }

		if ( ! empty ( $jobster_design['user_account_sidebar_style'] ) && $jobster_design['user_account_sidebar_style'] == 'block' ) { ?>

			.user-info-simple-wrapper {
				display: block;
				text-align: center;
			}
			.user-info-simple-wrapper a {
				display: inline;
			}
			.user-info-simple-wrapper .user-info-simple-content {
				margin-top: 15px;
			}

		<?php }

		if ( ! empty ( $jobster_design['user_account_sidebar_progress_bar_active_colour'] ) ) { ?>

			.ui.progress.success .bar {
				background-color: <?php echo $jobster_design['user_account_sidebar_progress_bar_active_colour']; ?> !important;
			}

		<?php }

		/* Load more button */
		if ( ! empty ( $jobster_design['user_account_load_more_button_border_radius']['top'] ) ) { ?>

			.load-more-button.text-button {
				border-radius: <?php echo $jobster_design['user_account_load_more_button_border_radius']['top']; ?>
			}

		<?php }

		/* Pagination */
		if ( ! empty ( $jobster_design['user_account_pagination_page_numbers_border_radius']['top'] ) ) { ?>

			.pagination-wrapper .page-numbers {
				border-radius: <?php echo $jobster_design['user_account_pagination_page_numbers_border_radius']['top']; ?>
			}

		<?php }

		if ( ! empty ( $jobster_design['user_account_pagination_prev_next_border_radius']['top'] ) ) { ?>

			.pagination-wrapper .page-numbers.prev,
			.pagination-wrapper .page-numbers.next {
				border-radius: <?php echo $jobster_design['user_account_pagination_prev_next_border_radius']['top']; ?>
			}

		<?php }

		do_action( 'wpj_after_custom_colours_define' );

		$css = ob_get_clean();

		return wpj_stripslashes( wpj_minify_css( $css ) );
	}
}