<?php
if ( ! function_exists( 'wpj_get_timezone_by_name' ) ) {
	function wpj_get_timezone_by_name( $tm_name = '' ) {
		$timezone_arr = [
			'Pacific/Midway'                 => __( '(GMT -11:00) Pacific/Midway', 'wpjobster' ),
			'Pacific/Niue'                   => __( '(GMT -11:00) Pacific/Niue', 'wpjobster' ),
			'Pacific/Pago_Pago'              => __( '(GMT -11:00) Pacific/Pago_Pago', 'wpjobster' ),
			'America/Adak'                   => __( '(GMT -10:00) America/Adak', 'wpjobster' ),
			'Pacific/Honolulu'               => __( '(GMT -10:00) Pacific/Honolulu', 'wpjobster' ),
			'Pacific/Johnston'               => __( '(GMT -10:00) Pacific/Johnston', 'wpjobster' ),
			'Pacific/Rarotonga'              => __( '(GMT -10:00) Pacific/Rarotonga', 'wpjobster' ),
			'Pacific/Tahiti'                 => __( '(GMT -10:00) Pacific/Tahiti', 'wpjobster' ),
			'Pacific/Marquesas'              => __( '(GMT -09:30) Pacific/Marquesas', 'wpjobster' ),
			'America/Anchorage'              => __( '(GMT -09:00) America/Anchorage', 'wpjobster' ),
			'America/Juneau'                 => __( '(GMT -09:00) America/Juneau', 'wpjobster' ),
			'America/Metlakatla'             => __( '(GMT -09:00) America/Metlakatla', 'wpjobster' ),
			'America/Nome'                   => __( '(GMT -09:00) America/Nome', 'wpjobster' ),
			'America/Sitka'                  => __( '(GMT -09:00) America/Sitka', 'wpjobster' ),
			'America/Yakutat'                => __( '(GMT -09:00) America/Yakutat', 'wpjobster' ),
			'Pacific/Gambier'                => __( '(GMT -09:00) Pacific/Gambier', 'wpjobster' ),
			'America/Dawson'                 => __( '(GMT -08:00) America/Dawson', 'wpjobster' ),
			'America/Los_Angeles'            => __( '(GMT -08:00) America/Los_Angeles', 'wpjobster' ),
			'America/Tijuana'                => __( '(GMT -08:00) America/Tijuana', 'wpjobster' ),
			'America/Vancouver'              => __( '(GMT -08:00) America/Vancouver', 'wpjobster' ),
			'America/Whitehorse'             => __( '(GMT -08:00) America/Whitehorse', 'wpjobster' ),
			'Pacific/Pitcairn'               => __( '(GMT -08:00) Pacific/Pitcairn', 'wpjobster' ),
			'America/Boise'                  => __( '(GMT -07:00) America/Boise', 'wpjobster' ),
			'America/Cambridge_Bay'          => __( '(GMT -07:00) America/Cambridge_Bay', 'wpjobster' ),
			'America/Chihuahua'              => __( '(GMT -07:00) America/Chihuahua', 'wpjobster' ),
			'America/Creston'                => __( '(GMT -07:00) America/Creston', 'wpjobster' ),
			'America/Dawson_Creek'           => __( '(GMT -07:00) America/Dawson_Creek', 'wpjobster' ),
			'America/Denver'                 => __( '(GMT -07:00) America/Denver', 'wpjobster' ),
			'America/Edmonton'               => __( '(GMT -07:00) America/Edmonton', 'wpjobster' ),
			'America/Fort_Nelson'            => __( '(GMT -07:00) America/Fort_Nelson', 'wpjobster' ),
			'America/Hermosillo'             => __( '(GMT -07:00) America/Hermosillo', 'wpjobster' ),
			'America/Inuvik'                 => __( '(GMT -07:00) America/Inuvik', 'wpjobster' ),
			'America/Mazatlan'               => __( '(GMT -07:00) America/Mazatlan', 'wpjobster' ),
			'America/Ojinaga'                => __( '(GMT -07:00) America/Ojinaga', 'wpjobster' ),
			'America/Phoenix'                => __( '(GMT -07:00) America/Phoenix', 'wpjobster' ),
			'America/Yellowknife'            => __( '(GMT -07:00) America/Yellowknife', 'wpjobster' ),
			'America/Bahia_Banderas'         => __( '(GMT -06:00) America/Bahia_Banderas', 'wpjobster' ),
			'America/Belize'                 => __( '(GMT -06:00) America/Belize', 'wpjobster' ),
			'America/Chicago'                => __( '(GMT -06:00) America/Chicago', 'wpjobster' ),
			'America/Costa_Rica'             => __( '(GMT -06:00) America/Costa_Rica', 'wpjobster' ),
			'America/El_Salvador'            => __( '(GMT -06:00) America/El_Salvador', 'wpjobster' ),
			'America/Guatemala'              => __( '(GMT -06:00) America/Guatemala', 'wpjobster' ),
			'America/Indiana/Knox'           => __( '(GMT -06:00) America/Indiana/Knox', 'wpjobster' ),
			'America/Indiana/Tell_City'      => __( '(GMT -06:00) America/Indiana/Tell_City', 'wpjobster' ),
			'America/Managua'                => __( '(GMT -06:00) America/Managua', 'wpjobster' ),
			'America/Matamoros'              => __( '(GMT -06:00) America/Matamoros', 'wpjobster' ),
			'America/Menominee'              => __( '(GMT -06:00) America/Menominee', 'wpjobster' ),
			'America/Merida'                 => __( '(GMT -06:00) America/Merida', 'wpjobster' ),
			'America/Mexico_City'            => __( '(GMT -06:00) America/Mexico_City', 'wpjobster' ),
			'America/Monterrey'              => __( '(GMT -06:00) America/Monterrey', 'wpjobster' ),
			'America/North_Dakota/Beulah'    => __( '(GMT -06:00) America/North_Dakota/Beulah', 'wpjobster' ),
			'America/North_Dakota/Center'    => __( '(GMT -06:00) America/North_Dakota/Center', 'wpjobster' ),
			'America/North_Dakota/New_Salem' => __( '(GMT -06:00) America/North_Dakota/New_Salem', 'wpjobster' ),
			'America/Rainy_River'            => __( '(GMT -06:00) America/Rainy_River', 'wpjobster' ),
			'America/Rankin_Inlet'           => __( '(GMT -06:00) America/Rankin_Inlet', 'wpjobster' ),
			'America/Regina'                 => __( '(GMT -06:00) America/Regina', 'wpjobster' ),
			'America/Resolute'               => __( '(GMT -06:00) America/Resolute', 'wpjobster' ),
			'America/Swift_Current'          => __( '(GMT -06:00) America/Swift_Current', 'wpjobster' ),
			'America/Tegucigalpa'            => __( '(GMT -06:00) America/Tegucigalpa', 'wpjobster' ),
			'America/Winnipeg'               => __( '(GMT -06:00) America/Winnipeg', 'wpjobster' ),
			'Pacific/Galapagos'              => __( '(GMT -06:00) Pacific/Galapagos', 'wpjobster' ),
			'America/Atikokan'               => __( '(GMT -05:00) America/Atikokan', 'wpjobster' ),
			'America/Bogota'                 => __( '(GMT -05:00) America/Bogota', 'wpjobster' ),
			'America/Cancun'                 => __( '(GMT -05:00) America/Cancun', 'wpjobster' ),
			'America/Cayman'                 => __( '(GMT -05:00) America/Cayman', 'wpjobster' ),
			'America/Detroit'                => __( '(GMT -05:00) America/Detroit', 'wpjobster' ),
			'America/Eirunepe'               => __( '(GMT -05:00) America/Eirunepe', 'wpjobster' ),
			'America/Guayaquil'              => __( '(GMT -05:00) America/Guayaquil', 'wpjobster' ),
			'America/Havana'                 => __( '(GMT -05:00) America/Havana', 'wpjobster' ),
			'America/Indiana/Indianapolis'   => __( '(GMT -05:00) America/Indiana/Indianapolis', 'wpjobster' ),
			'America/Indiana/Marengo'        => __( '(GMT -05:00) America/Indiana/Marengo', 'wpjobster' ),
			'America/Indiana/Petersburg'     => __( '(GMT -05:00) America/Indiana/Petersburg', 'wpjobster' ),
			'America/Indiana/Vevay'          => __( '(GMT -05:00) America/Indiana/Vevay', 'wpjobster' ),
			'America/Indiana/Vincennes'      => __( '(GMT -05:00) America/Indiana/Vincennes', 'wpjobster' ),
			'America/Indiana/Winamac'        => __( '(GMT -05:00) America/Indiana/Winamac', 'wpjobster' ),
			'America/Iqaluit'                => __( '(GMT -05:00) America/Iqaluit', 'wpjobster' ),
			'America/Jamaica'                => __( '(GMT -05:00) America/Jamaica', 'wpjobster' ),
			'America/Kentucky/Louisville'    => __( '(GMT -05:00) America/Kentucky/Louisville', 'wpjobster' ),
			'America/Kentucky/Monticello'    => __( '(GMT -05:00) America/Kentucky/Monticello', 'wpjobster' ),
			'America/Lima'                   => __( '(GMT -05:00) America/Lima', 'wpjobster' ),
			'America/Nassau'                 => __( '(GMT -05:00) America/Nassau', 'wpjobster' ),
			'America/New_York'               => __( '(GMT -05:00) America/New_York', 'wpjobster' ),
			'America/Nipigon'                => __( '(GMT -05:00) America/Nipigon', 'wpjobster' ),
			'America/Panama'                 => __( '(GMT -05:00) America/Panama', 'wpjobster' ),
			'America/Pangnirtung'            => __( '(GMT -05:00) America/Pangnirtung', 'wpjobster' ),
			'America/Port-au-Prince'         => __( '(GMT -05:00) America/Port-au-Prince', 'wpjobster' ),
			'America/Rio_Branco'             => __( '(GMT -05:00) America/Rio_Branco', 'wpjobster' ),
			'America/Thunder_Bay'            => __( '(GMT -05:00) America/Thunder_Bay', 'wpjobster' ),
			'America/Toronto'                => __( '(GMT -05:00) America/Toronto', 'wpjobster' ),
			'Pacific/Easter'                 => __( '(GMT -05:00) Pacific/Easter', 'wpjobster' ),
			'America/Anguilla'               => __( '(GMT -04:00) America/Anguilla', 'wpjobster' ),
			'America/Antigua'                => __( '(GMT -04:00) America/Antigua', 'wpjobster' ),
			'America/Aruba'                  => __( '(GMT -04:00) America/Aruba', 'wpjobster' ),
			'America/Barbados'               => __( '(GMT -04:00) America/Barbados', 'wpjobster' ),
			'America/Blanc-Sablon'           => __( '(GMT -04:00) America/Blanc-Sablon', 'wpjobster' ),
			'America/Boa_Vista'              => __( '(GMT -04:00) America/Boa_Vista', 'wpjobster' ),
			'America/Campo_Grande'           => __( '(GMT -04:00) America/Campo_Grande', 'wpjobster' ),
			'America/Caracas'                => __( '(GMT -04:00) America/Caracas', 'wpjobster' ),
			'America/Cuiaba'                 => __( '(GMT -04:00) America/Cuiaba', 'wpjobster' ),
			'America/Curacao'                => __( '(GMT -04:00) America/Curacao', 'wpjobster' ),
			'America/Dominica'               => __( '(GMT -04:00) America/Dominica', 'wpjobster' ),
			'America/Glace_Bay'              => __( '(GMT -04:00) America/Glace_Bay', 'wpjobster' ),
			'America/Goose_Bay'              => __( '(GMT -04:00) America/Goose_Bay', 'wpjobster' ),
			'America/Grand_Turk'             => __( '(GMT -04:00) America/Grand_Turk', 'wpjobster' ),
			'America/Grenada'                => __( '(GMT -04:00) America/Grenada', 'wpjobster' ),
			'America/Guadeloupe'             => __( '(GMT -04:00) America/Guadeloupe', 'wpjobster' ),
			'America/Guyana'                 => __( '(GMT -04:00) America/Guyana', 'wpjobster' ),
			'America/Halifax'                => __( '(GMT -04:00) America/Halifax', 'wpjobster' ),
			'America/Kralendijk'             => __( '(GMT -04:00) America/Kralendijk', 'wpjobster' ),
			'America/La_Paz'                 => __( '(GMT -04:00) America/La_Paz', 'wpjobster' ),
			'America/Lower_Princes'          => __( '(GMT -04:00) America/Lower_Princes', 'wpjobster' ),
			'America/Manaus'                 => __( '(GMT -04:00) America/Manaus', 'wpjobster' ),
			'America/Marigot'                => __( '(GMT -04:00) America/Marigot', 'wpjobster' ),
			'America/Martinique'             => __( '(GMT -04:00) America/Martinique', 'wpjobster' ),
			'America/Moncton'                => __( '(GMT -04:00) America/Moncton', 'wpjobster' ),
			'America/Montserrat'             => __( '(GMT -04:00) America/Montserrat', 'wpjobster' ),
			'America/Port_of_Spain'          => __( '(GMT -04:00) America/Port_of_Spain', 'wpjobster' ),
			'America/Porto_Velho'            => __( '(GMT -04:00) America/Porto_Velho', 'wpjobster' ),
			'America/Puerto_Rico'            => __( '(GMT -04:00) America/Puerto_Rico', 'wpjobster' ),
			'America/Santo_Domingo'          => __( '(GMT -04:00) America/Santo_Domingo', 'wpjobster' ),
			'America/St_Barthelemy'          => __( '(GMT -04:00) America/St_Barthelemy', 'wpjobster' ),
			'America/St_Kitts'               => __( '(GMT -04:00) America/St_Kitts', 'wpjobster' ),
			'America/St_Lucia'               => __( '(GMT -04:00) America/St_Lucia', 'wpjobster' ),
			'America/St_Thomas'              => __( '(GMT -04:00) America/St_Thomas', 'wpjobster' ),
			'America/St_Vincent'             => __( '(GMT -04:00) America/St_Vincent', 'wpjobster' ),
			'America/Thule'                  => __( '(GMT -04:00) America/Thule', 'wpjobster' ),
			'America/Tortola'                => __( '(GMT -04:00) America/Tortola', 'wpjobster' ),
			'Atlantic/Bermuda'               => __( '(GMT -04:00) Atlantic/Bermuda', 'wpjobster' ),
			'America/St_Johns'               => __( '(GMT -03:30) America/St_Johns', 'wpjobster' ),
			'America/Araguaina'              => __( '(GMT -03:00) America/Araguaina', 'wpjobster' ),
			'America/Argentina/Buenos_Aires' => __( '(GMT -03:00) America/Argentina/Buenos_Aires', 'wpjobster' ),
			'America/Argentina/Catamarca'    => __( '(GMT -03:00) America/Argentina/Catamarca', 'wpjobster' ),
			'America/Argentina/Cordoba'      => __( '(GMT -03:00) America/Argentina/Cordoba', 'wpjobster' ),
			'America/Argentina/Jujuy'        => __( '(GMT -03:00) America/Argentina/Jujuy', 'wpjobster' ),
			'America/Argentina/La_Rioja'     => __( '(GMT -03:00) America/Argentina/La_Rioja', 'wpjobster' ),
			'America/Argentina/Mendoza'      => __( '(GMT -03:00) America/Argentina/Mendoza', 'wpjobster' ),
			'America/Argentina/Rio_Gallegos' => __( '(GMT -03:00) America/Argentina/Rio_Gallegos', 'wpjobster' ),
			'America/Argentina/Salta'        => __( '(GMT -03:00) America/Argentina/Salta', 'wpjobster' ),
			'America/Argentina/San_Juan'     => __( '(GMT -03:00) America/Argentina/San_Juan', 'wpjobster' ),
			'America/Argentina/San_Luis'     => __( '(GMT -03:00) America/Argentina/San_Luis', 'wpjobster' ),
			'America/Argentina/Tucuman'      => __( '(GMT -03:00) America/Argentina/Tucuman', 'wpjobster' ),
			'America/Argentina/Ushuaia'      => __( '(GMT -03:00) America/Argentina/Ushuaia', 'wpjobster' ),
			'America/Asuncion'               => __( '(GMT -03:00) America/Asuncion', 'wpjobster' ),
			'America/Bahia'                  => __( '(GMT -03:00) America/Bahia', 'wpjobster' ),
			'America/Belem'                  => __( '(GMT -03:00) America/Belem', 'wpjobster' ),
			'America/Cayenne'                => __( '(GMT -03:00) America/Cayenne', 'wpjobster' ),
			'America/Fortaleza'              => __( '(GMT -03:00) America/Fortaleza', 'wpjobster' ),
			'America/Godthab'                => __( '(GMT -03:00) America/Godthab', 'wpjobster' ),
			'America/Maceio'                 => __( '(GMT -03:00) America/Maceio', 'wpjobster' ),
			'America/Miquelon'               => __( '(GMT -03:00) America/Miquelon', 'wpjobster' ),
			'America/Montevideo'             => __( '(GMT -03:00) America/Montevideo', 'wpjobster' ),
			'America/Paramaribo'             => __( '(GMT -03:00) America/Paramaribo', 'wpjobster' ),
			'America/Recife'                 => __( '(GMT -03:00) America/Recife', 'wpjobster' ),
			'America/Santarem'               => __( '(GMT -03:00) America/Santarem', 'wpjobster' ),
			'America/Santiago'               => __( '(GMT -03:00) America/Santiago', 'wpjobster' ),
			'America/Sao_Paulo'              => __( '(GMT -03:00) America/Sao_Paulo', 'wpjobster' ),
			'Antarctica/Palmer'              => __( '(GMT -03:00) Antarctica/Palmer', 'wpjobster' ),
			'Antarctica/Rothera'             => __( '(GMT -03:00) Antarctica/Rothera', 'wpjobster' ),
			'Atlantic/Stanley'               => __( '(GMT -03:00) Atlantic/Stanley', 'wpjobster' ),
			'America/Noronha'                => __( '(GMT -02:00) America/Noronha', 'wpjobster' ),
			'Atlantic/South_Georgia'         => __( '(GMT -02:00) Atlantic/South_Georgia', 'wpjobster' ),
			'America/Scoresbysund'           => __( '(GMT -01:00) America/Scoresbysund', 'wpjobster' ),
			'Atlantic/Azores'                => __( '(GMT -01:00) Atlantic/Azores', 'wpjobster' ),
			'Atlantic/Cape_Verde'            => __( '(GMT -01:00) Atlantic/Cape_Verde', 'wpjobster' ),
			'Africa/Abidjan'                 => __( '(GMT -00:00) Africa/Abidjan', 'wpjobster' ),
			'Africa/Accra'                   => __( '(GMT -00:00) Africa/Accra', 'wpjobster' ),
			'Africa/Bamako'                  => __( '(GMT -00:00) Africa/Bamako', 'wpjobster' ),
			'Africa/Banjul'                  => __( '(GMT -00:00) Africa/Banjul', 'wpjobster' ),
			'Africa/Bissau'                  => __( '(GMT -00:00) Africa/Bissau', 'wpjobster' ),
			'Africa/Casablanca'              => __( '(GMT -00:00) Africa/Casablanca', 'wpjobster' ),
			'Africa/Conakry'                 => __( '(GMT -00:00) Africa/Conakry', 'wpjobster' ),
			'Africa/Dakar'                   => __( '(GMT -00:00) Africa/Dakar', 'wpjobster' ),
			'Africa/El_Aaiun'                => __( '(GMT -00:00) Africa/El_Aaiun', 'wpjobster' ),
			'Africa/Freetown'                => __( '(GMT -00:00) Africa/Freetown', 'wpjobster' ),
			'Africa/Lome'                    => __( '(GMT -00:00) Africa/Lome', 'wpjobster' ),
			'Africa/Monrovia'                => __( '(GMT -00:00) Africa/Monrovia', 'wpjobster' ),
			'Africa/Nouakchott'              => __( '(GMT -00:00) Africa/Nouakchott', 'wpjobster' ),
			'Africa/Ouagadougou'             => __( '(GMT -00:00) Africa/Ouagadougou', 'wpjobster' ),
			'Africa/Sao_Tome'                => __( '(GMT -00:00) Africa/Sao_Tome', 'wpjobster' ),
			'America/Danmarkshavn'           => __( '(GMT -00:00) America/Danmarkshavn', 'wpjobster' ),
			'Antarctica/Troll'               => __( '(GMT -00:00) Antarctica/Troll', 'wpjobster' ),
			'Atlantic/Canary'                => __( '(GMT -00:00) Atlantic/Canary', 'wpjobster' ),
			'Atlantic/Faroe'                 => __( '(GMT -00:00) Atlantic/Faroe', 'wpjobster' ),
			'Atlantic/Madeira'               => __( '(GMT -00:00) Atlantic/Madeira', 'wpjobster' ),
			'Atlantic/Reykjavik'             => __( '(GMT -00:00) Atlantic/Reykjavik', 'wpjobster' ),
			'Atlantic/St_Helena'             => __( '(GMT -00:00) Atlantic/St_Helena', 'wpjobster' ),
			'Europe/Dublin'                  => __( '(GMT -00:00) Europe/Dublin', 'wpjobster' ),
			'Europe/Guernsey'                => __( '(GMT -00:00) Europe/Guernsey', 'wpjobster' ),
			'Europe/Isle_of_Man'             => __( '(GMT -00:00) Europe/Isle_of_Man', 'wpjobster' ),
			'Europe/Jersey'                  => __( '(GMT -00:00) Europe/Jersey', 'wpjobster' ),
			'Europe/Lisbon'                  => __( '(GMT -00:00) Europe/Lisbon', 'wpjobster' ),
			'Europe/London'                  => __( '(GMT -00:00) Europe/London', 'wpjobster' ),
			'UTC'                            => __( '(GMT -00:00) UTC', 'wpjobster' ),
			'Africa/Algiers'                 => __( '(GMT +01:00) Africa/Algiers', 'wpjobster' ),
			'Africa/Bangui'                  => __( '(GMT +01:00) Africa/Bangui', 'wpjobster' ),
			'Africa/Brazzaville'             => __( '(GMT +01:00) Africa/Brazzaville', 'wpjobster' ),
			'Africa/Ceuta'                   => __( '(GMT +01:00) Africa/Ceuta', 'wpjobster' ),
			'Africa/Douala'                  => __( '(GMT +01:00) Africa/Douala', 'wpjobster' ),
			'Africa/Kinshasa'                => __( '(GMT +01:00) Africa/Kinshasa', 'wpjobster' ),
			'Africa/Lagos'                   => __( '(GMT +01:00) Africa/Lagos', 'wpjobster' ),
			'Africa/Libreville'              => __( '(GMT +01:00) Africa/Libreville', 'wpjobster' ),
			'Africa/Luanda'                  => __( '(GMT +01:00) Africa/Luanda', 'wpjobster' ),
			'Africa/Malabo'                  => __( '(GMT +01:00) Africa/Malabo', 'wpjobster' ),
			'Africa/Ndjamena'                => __( '(GMT +01:00) Africa/Ndjamena', 'wpjobster' ),
			'Africa/Niamey'                  => __( '(GMT +01:00) Africa/Niamey', 'wpjobster' ),
			'Africa/Porto-Novo'              => __( '(GMT +01:00) Africa/Porto-Novo', 'wpjobster' ),
			'Africa/Tunis'                   => __( '(GMT +01:00) Africa/Tunis', 'wpjobster' ),
			'Arctic/Longyearbyen'            => __( '(GMT +01:00) Arctic/Longyearbyen', 'wpjobster' ),
			'Europe/Amsterdam'               => __( '(GMT +01:00) Europe/Amsterdam', 'wpjobster' ),
			'Europe/Andorra'                 => __( '(GMT +01:00) Europe/Andorra', 'wpjobster' ),
			'Europe/Belgrade'                => __( '(GMT +01:00) Europe/Belgrade', 'wpjobster' ),
			'Europe/Berlin'                  => __( '(GMT +01:00) Europe/Berlin', 'wpjobster' ),
			'Europe/Bratislava'              => __( '(GMT +01:00) Europe/Bratislava', 'wpjobster' ),
			'Europe/Brussels'                => __( '(GMT +01:00) Europe/Brussels', 'wpjobster' ),
			'Europe/Budapest'                => __( '(GMT +01:00) Europe/Budapest', 'wpjobster' ),
			'Europe/Busingen'                => __( '(GMT +01:00) Europe/Busingen', 'wpjobster' ),
			'Europe/Copenhagen'              => __( '(GMT +01:00) Europe/Copenhagen', 'wpjobster' ),
			'Europe/Gibraltar'               => __( '(GMT +01:00) Europe/Gibraltar', 'wpjobster' ),
			'Europe/Ljubljana'               => __( '(GMT +01:00) Europe/Ljubljana', 'wpjobster' ),
			'Europe/Luxembourg'              => __( '(GMT +01:00) Europe/Luxembourg', 'wpjobster' ),
			'Europe/Madrid'                  => __( '(GMT +01:00) Europe/Madrid', 'wpjobster' ),
			'Europe/Malta'                   => __( '(GMT +01:00) Europe/Malta', 'wpjobster' ),
			'Europe/Monaco'                  => __( '(GMT +01:00) Europe/Monaco', 'wpjobster' ),
			'Europe/Oslo'                    => __( '(GMT +01:00) Europe/Oslo', 'wpjobster' ),
			'Europe/Paris'                   => __( '(GMT +01:00) Europe/Paris', 'wpjobster' ),
			'Europe/Podgorica'               => __( '(GMT +01:00) Europe/Podgorica', 'wpjobster' ),
			'Europe/Prague'                  => __( '(GMT +01:00) Europe/Prague', 'wpjobster' ),
			'Europe/Rome'                    => __( '(GMT +01:00) Europe/Rome', 'wpjobster' ),
			'Europe/San_Marino'              => __( '(GMT +01:00) Europe/San_Marino', 'wpjobster' ),
			'Europe/Sarajevo'                => __( '(GMT +01:00) Europe/Sarajevo', 'wpjobster' ),
			'Europe/Skopje'                  => __( '(GMT +01:00) Europe/Skopje', 'wpjobster' ),
			'Europe/Stockholm'               => __( '(GMT +01:00) Europe/Stockholm', 'wpjobster' ),
			'Europe/Tirane'                  => __( '(GMT +01:00) Europe/Tirane', 'wpjobster' ),
			'Europe/Vaduz'                   => __( '(GMT +01:00) Europe/Vaduz', 'wpjobster' ),
			'Europe/Vatican'                 => __( '(GMT +01:00) Europe/Vatican', 'wpjobster' ),
			'Europe/Vienna'                  => __( '(GMT +01:00) Europe/Vienna', 'wpjobster' ),
			'Europe/Warsaw'                  => __( '(GMT +01:00) Europe/Warsaw', 'wpjobster' ),
			'Europe/Zagreb'                  => __( '(GMT +01:00) Europe/Zagreb', 'wpjobster' ),
			'Europe/Zurich'                  => __( '(GMT +01:00) Europe/Zurich', 'wpjobster' ),
			'Africa/Blantyre'                => __( '(GMT +02:00) Africa/Blantyre', 'wpjobster' ),
			'Africa/Bujumbura'               => __( '(GMT +02:00) Africa/Bujumbura', 'wpjobster' ),
			'Africa/Cairo'                   => __( '(GMT +02:00) Africa/Cairo', 'wpjobster' ),
			'Africa/Gaborone'                => __( '(GMT +02:00) Africa/Gaborone', 'wpjobster' ),
			'Africa/Harare'                  => __( '(GMT +02:00) Africa/Harare', 'wpjobster' ),
			'Africa/Johannesburg'            => __( '(GMT +02:00) Africa/Johannesburg', 'wpjobster' ),
			'Africa/Kigali'                  => __( '(GMT +02:00) Africa/Kigali', 'wpjobster' ),
			'Africa/Lubumbashi'              => __( '(GMT +02:00) Africa/Lubumbashi', 'wpjobster' ),
			'Africa/Lusaka'                  => __( '(GMT +02:00) Africa/Lusaka', 'wpjobster' ),
			'Africa/Maputo'                  => __( '(GMT +02:00) Africa/Maputo', 'wpjobster' ),
			'Africa/Maseru'                  => __( '(GMT +02:00) Africa/Maseru', 'wpjobster' ),
			'Africa/Mbabane'                 => __( '(GMT +02:00) Africa/Mbabane', 'wpjobster' ),
			'Africa/Tripoli'                 => __( '(GMT +02:00) Africa/Tripoli', 'wpjobster' ),
			'Africa/Windhoek'                => __( '(GMT +02:00) Africa/Windhoek', 'wpjobster' ),
			'Asia/Amman'                     => __( '(GMT +02:00) Asia/Amman', 'wpjobster' ),
			'Asia/Beirut'                    => __( '(GMT +02:00) Asia/Beirut', 'wpjobster' ),
			'Asia/Damascus'                  => __( '(GMT +02:00) Asia/Damascus', 'wpjobster' ),
			'Asia/Gaza'                      => __( '(GMT +02:00) Asia/Gaza', 'wpjobster' ),
			'Asia/Hebron'                    => __( '(GMT +02:00) Asia/Hebron', 'wpjobster' ),
			'Asia/Jerusalem'                 => __( '(GMT +02:00) Asia/Jerusalem', 'wpjobster' ),
			'Asia/Nicosia'                   => __( '(GMT +02:00) Asia/Nicosia', 'wpjobster' ),
			'Europe/Athens'                  => __( '(GMT +02:00) Europe/Athens', 'wpjobster' ),
			'Europe/Bucharest'               => __( '(GMT +02:00) Europe/Bucharest', 'wpjobster' ),
			'Europe/Chisinau'                => __( '(GMT +02:00) Europe/Chisinau', 'wpjobster' ),
			'Europe/Helsinki'                => __( '(GMT +02:00) Europe/Helsinki', 'wpjobster' ),
			'Europe/Kaliningrad'             => __( '(GMT +02:00) Europe/Kaliningrad', 'wpjobster' ),
			'Europe/Kiev'                    => __( '(GMT +02:00) Europe/Kiev', 'wpjobster' ),
			'Europe/Mariehamn'               => __( '(GMT +02:00) Europe/Mariehamn', 'wpjobster' ),
			'Europe/Riga'                    => __( '(GMT +02:00) Europe/Riga', 'wpjobster' ),
			'Europe/Sofia'                   => __( '(GMT +02:00) Europe/Sofia', 'wpjobster' ),
			'Europe/Tallinn'                 => __( '(GMT +02:00) Europe/Tallinn', 'wpjobster' ),
			'Europe/Uzhgorod'                => __( '(GMT +02:00) Europe/Uzhgorod', 'wpjobster' ),
			'Europe/Vilnius'                 => __( '(GMT +02:00) Europe/Vilnius', 'wpjobster' ),
			'Europe/Zaporozhye'              => __( '(GMT +02:00) Europe/Zaporozhye', 'wpjobster' ),
			'Africa/Addis_Ababa'             => __( '(GMT +03:00) Africa/Addis_Ababa', 'wpjobster' ),
			'Africa/Asmara'                  => __( '(GMT +03:00) Africa/Asmara', 'wpjobster' ),
			'Africa/Dar_es_Salaam'           => __( '(GMT +03:00) Africa/Dar_es_Salaam', 'wpjobster' ),
			'Africa/Djibouti'                => __( '(GMT +03:00) Africa/Djibouti', 'wpjobster' ),
			'Africa/Juba'                    => __( '(GMT +03:00) Africa/Juba', 'wpjobster' ),
			'Africa/Kampala'                 => __( '(GMT +03:00) Africa/Kampala', 'wpjobster' ),
			'Africa/Khartoum'                => __( '(GMT +03:00) Africa/Khartoum', 'wpjobster' ),
			'Africa/Mogadishu'               => __( '(GMT +03:00) Africa/Mogadishu', 'wpjobster' ),
			'Africa/Nairobi'                 => __( '(GMT +03:00) Africa/Nairobi', 'wpjobster' ),
			'Antarctica/Syowa'               => __( '(GMT +03:00) Antarctica/Syowa', 'wpjobster' ),
			'Asia/Aden'                      => __( '(GMT +03:00) Asia/Aden', 'wpjobster' ),
			'Asia/Baghdad'                   => __( '(GMT +03:00) Asia/Baghdad', 'wpjobster' ),
			'Asia/Bahrain'                   => __( '(GMT +03:00) Asia/Bahrain', 'wpjobster' ),
			'Asia/Famagusta'                 => __( '(GMT +03:00) Asia/Famagusta', 'wpjobster' ),
			'Asia/Kuwait'                    => __( '(GMT +03:00) Asia/Kuwait', 'wpjobster' ),
			'Asia/Qatar'                     => __( '(GMT +03:00) Asia/Qatar', 'wpjobster' ),
			'Asia/Riyadh'                    => __( '(GMT +03:00) Asia/Riyadh', 'wpjobster' ),
			'Europe/Istanbul'                => __( '(GMT +03:00) Europe/Istanbul', 'wpjobster' ),
			'Europe/Kirov'                   => __( '(GMT +03:00) Europe/Kirov', 'wpjobster' ),
			'Europe/Minsk'                   => __( '(GMT +03:00) Europe/Minsk', 'wpjobster' ),
			'Europe/Moscow'                  => __( '(GMT +03:00) Europe/Moscow', 'wpjobster' ),
			'Europe/Simferopol'              => __( '(GMT +03:00) Europe/Simferopol', 'wpjobster' ),
			'Europe/Volgograd'               => __( '(GMT +03:00) Europe/Volgograd', 'wpjobster' ),
			'Indian/Antananarivo'            => __( '(GMT +03:00) Indian/Antananarivo', 'wpjobster' ),
			'Indian/Comoro'                  => __( '(GMT +03:00) Indian/Comoro', 'wpjobster' ),
			'Indian/Mayotte'                 => __( '(GMT +03:00) Indian/Mayotte', 'wpjobster' ),
			'Asia/Tehran'                    => __( '(GMT +03:30) Asia/Tehran', 'wpjobster' ),
			'Asia/Baku'                      => __( '(GMT +04:00) Asia/Baku', 'wpjobster' ),
			'Asia/Dubai'                     => __( '(GMT +04:00) Asia/Dubai', 'wpjobster' ),
			'Asia/Muscat'                    => __( '(GMT +04:00) Asia/Muscat', 'wpjobster' ),
			'Asia/Tbilisi'                   => __( '(GMT +04:00) Asia/Tbilisi', 'wpjobster' ),
			'Asia/Yerevan'                   => __( '(GMT +04:00) Asia/Yerevan', 'wpjobster' ),
			'Europe/Astrakhan'               => __( '(GMT +04:00) Europe/Astrakhan', 'wpjobster' ),
			'Europe/Samara'                  => __( '(GMT +04:00) Europe/Samara', 'wpjobster' ),
			'Europe/Saratov'                 => __( '(GMT +04:00) Europe/Saratov', 'wpjobster' ),
			'Europe/Ulyanovsk'               => __( '(GMT +04:00) Europe/Ulyanovsk', 'wpjobster' ),
			'Indian/Mahe'                    => __( '(GMT +04:00) Indian/Mahe', 'wpjobster' ),
			'Indian/Mauritius'               => __( '(GMT +04:00) Indian/Mauritius', 'wpjobster' ),
			'Indian/Reunion'                 => __( '(GMT +04:00) Indian/Reunion', 'wpjobster' ),
			'Asia/Kabul'                     => __( '(GMT +04:30) Asia/Kabul', 'wpjobster' ),
			'Antarctica/Mawson'              => __( '(GMT +05:00) Antarctica/Mawson', 'wpjobster' ),
			'Asia/Aqtau'                     => __( '(GMT +05:00) Asia/Aqtau', 'wpjobster' ),
			'Asia/Aqtobe'                    => __( '(GMT +05:00) Asia/Aqtobe', 'wpjobster' ),
			'Asia/Ashgabat'                  => __( '(GMT +05:00) Asia/Ashgabat', 'wpjobster' ),
			'Asia/Atyrau'                    => __( '(GMT +05:00) Asia/Atyrau', 'wpjobster' ),
			'Asia/Dushanbe'                  => __( '(GMT +05:00) Asia/Dushanbe', 'wpjobster' ),
			'Asia/Karachi'                   => __( '(GMT +05:00) Asia/Karachi', 'wpjobster' ),
			'Asia/Oral'                      => __( '(GMT +05:00) Asia/Oral', 'wpjobster' ),
			'Asia/Samarkand'                 => __( '(GMT +05:00) Asia/Samarkand', 'wpjobster' ),
			'Asia/Tashkent'                  => __( '(GMT +05:00) Asia/Tashkent', 'wpjobster' ),
			'Asia/Yekaterinburg'             => __( '(GMT +05:00) Asia/Yekaterinburg', 'wpjobster' ),
			'Indian/Kerguelen'               => __( '(GMT +05:00) Indian/Kerguelen', 'wpjobster' ),
			'Indian/Maldives'                => __( '(GMT +05:00) Indian/Maldives', 'wpjobster' ),
			'Asia/Colombo'                   => __( '(GMT +05:30) Asia/Colombo', 'wpjobster' ),
			'Asia/Kolkata'                   => __( '(GMT +05:30) Asia/Kolkata', 'wpjobster' ),
			'Asia/Kathmandu'                 => __( '(GMT +05:45) Asia/Kathmandu', 'wpjobster' ),
			'Antarctica/Vostok'              => __( '(GMT +06:00) Antarctica/Vostok', 'wpjobster' ),
			'Asia/Almaty'                    => __( '(GMT +06:00) Asia/Almaty', 'wpjobster' ),
			'Asia/Bishkek'                   => __( '(GMT +06:00) Asia/Bishkek', 'wpjobster' ),
			'Asia/Dhaka'                     => __( '(GMT +06:00) Asia/Dhaka', 'wpjobster' ),
			'Asia/Omsk'                      => __( '(GMT +06:00) Asia/Omsk', 'wpjobster' ),
			'Asia/Qyzylorda'                 => __( '(GMT +06:00) Asia/Qyzylorda', 'wpjobster' ),
			'Asia/Thimphu'                   => __( '(GMT +06:00) Asia/Thimphu', 'wpjobster' ),
			'Asia/Urumqi'                    => __( '(GMT +06:00) Asia/Urumqi', 'wpjobster' ),
			'Indian/Chagos'                  => __( '(GMT +06:00) Indian/Chagos', 'wpjobster' ),
			'Asia/Yangon'                    => __( '(GMT +06:30) Asia/Yangon', 'wpjobster' ),
			'Indian/Cocos'                   => __( '(GMT +06:30) Indian/Cocos', 'wpjobster' ),
			'Antarctica/Davis'               => __( '(GMT +07:00) Antarctica/Davis', 'wpjobster' ),
			'Asia/Bangkok'                   => __( '(GMT +07:00) Asia/Bangkok', 'wpjobster' ),
			'Asia/Barnaul'                   => __( '(GMT +07:00) Asia/Barnaul', 'wpjobster' ),
			'Asia/Ho_Chi_Minh'               => __( '(GMT +07:00) Asia/Ho_Chi_Minh', 'wpjobster' ),
			'Asia/Hovd'                      => __( '(GMT +07:00) Asia/Hovd', 'wpjobster' ),
			'Asia/Jakarta'                   => __( '(GMT +07:00) Asia/Jakarta', 'wpjobster' ),
			'Asia/Krasnoyarsk'               => __( '(GMT +07:00) Asia/Krasnoyarsk', 'wpjobster' ),
			'Asia/Novokuznetsk'              => __( '(GMT +07:00) Asia/Novokuznetsk', 'wpjobster' ),
			'Asia/Novosibirsk'               => __( '(GMT +07:00) Asia/Novosibirsk', 'wpjobster' ),
			'Asia/Phnom_Penh'                => __( '(GMT +07:00) Asia/Phnom_Penh', 'wpjobster' ),
			'Asia/Pontianak'                 => __( '(GMT +07:00) Asia/Pontianak', 'wpjobster' ),
			'Asia/Tomsk'                     => __( '(GMT +07:00) Asia/Tomsk', 'wpjobster' ),
			'Asia/Vientiane'                 => __( '(GMT +07:00) Asia/Vientiane', 'wpjobster' ),
			'Indian/Christmas'               => __( '(GMT +07:00) Indian/Christmas', 'wpjobster' ),
			'Asia/Brunei'                    => __( '(GMT +08:00) Asia/Brunei', 'wpjobster' ),
			'Asia/Choibalsan'                => __( '(GMT +08:00) Asia/Choibalsan', 'wpjobster' ),
			'Asia/Hong_Kong'                 => __( '(GMT +08:00) Asia/Hong_Kong', 'wpjobster' ),
			'Asia/Irkutsk'                   => __( '(GMT +08:00) Asia/Irkutsk', 'wpjobster' ),
			'Asia/Kuala_Lumpur'              => __( '(GMT +08:00) Asia/Kuala_Lumpur', 'wpjobster' ),
			'Asia/Kuching'                   => __( '(GMT +08:00) Asia/Kuching', 'wpjobster' ),
			'Asia/Macau'                     => __( '(GMT +08:00) Asia/Macau', 'wpjobster' ),
			'Asia/Makassar'                  => __( '(GMT +08:00) Asia/Makassar', 'wpjobster' ),
			'Asia/Manila'                    => __( '(GMT +08:00) Asia/Manila', 'wpjobster' ),
			'Asia/Shanghai'                  => __( '(GMT +08:00) Asia/Shanghai', 'wpjobster' ),
			'Asia/Singapore'                 => __( '(GMT +08:00) Asia/Singapore', 'wpjobster' ),
			'Asia/Taipei'                    => __( '(GMT +08:00) Asia/Taipei', 'wpjobster' ),
			'Asia/Ulaanbaatar'               => __( '(GMT +08:00) Asia/Ulaanbaatar', 'wpjobster' ),
			'Australia/Perth'                => __( '(GMT +08:00) Australia/Perth', 'wpjobster' ),
			'Asia/Pyongyang'                 => __( '(GMT +08:30) Asia/Pyongyang', 'wpjobster' ),
			'Australia/Eucla'                => __( '(GMT +08:45) Australia/Eucla', 'wpjobster' ),
			'Asia/Chita'                     => __( '(GMT +09:00) Asia/Chita', 'wpjobster' ),
			'Asia/Dili'                      => __( '(GMT +09:00) Asia/Dili', 'wpjobster' ),
			'Asia/Jayapura'                  => __( '(GMT +09:00) Asia/Jayapura', 'wpjobster' ),
			'Asia/Khandyga'                  => __( '(GMT +09:00) Asia/Khandyga', 'wpjobster' ),
			'Asia/Seoul'                     => __( '(GMT +09:00) Asia/Seoul', 'wpjobster' ),
			'Asia/Tokyo'                     => __( '(GMT +09:00) Asia/Tokyo', 'wpjobster' ),
			'Asia/Yakutsk'                   => __( '(GMT +09:00) Asia/Yakutsk', 'wpjobster' ),
			'Pacific/Palau'                  => __( '(GMT +09:00) Pacific/Palau', 'wpjobster' ),
			'Australia/Darwin'               => __( '(GMT +09:30) Australia/Darwin', 'wpjobster' ),
			'Antarctica/DumontDUrville'      => __( '(GMT +10:00) Antarctica/DumontDUrville', 'wpjobster' ),
			'Asia/Ust-Nera'                  => __( '(GMT +10:00) Asia/Ust-Nera', 'wpjobster' ),
			'Asia/Vladivostok'               => __( '(GMT +10:00) Asia/Vladivostok', 'wpjobster' ),
			'Australia/Brisbane'             => __( '(GMT +10:00) Australia/Brisbane', 'wpjobster' ),
			'Australia/Lindeman'             => __( '(GMT +10:00) Australia/Lindeman', 'wpjobster' ),
			'Pacific/Chuuk'                  => __( '(GMT +10:00) Pacific/Chuuk', 'wpjobster' ),
			'Pacific/Guam'                   => __( '(GMT +10:00) Pacific/Guam', 'wpjobster' ),
			'Pacific/Port_Moresby'           => __( '(GMT +10:00) Pacific/Port_Moresby', 'wpjobster' ),
			'Pacific/Saipan'                 => __( '(GMT +10:00) Pacific/Saipan', 'wpjobster' ),
			'Australia/Adelaide'             => __( '(GMT +10:30) Australia/Adelaide', 'wpjobster' ),
			'Australia/Broken_Hill'          => __( '(GMT +10:30) Australia/Broken_Hill', 'wpjobster' ),
			'Antarctica/Casey'               => __( '(GMT +11:00) Antarctica/Casey', 'wpjobster' ),
			'Antarctica/Macquarie'           => __( '(GMT +11:00) Antarctica/Macquarie', 'wpjobster' ),
			'Asia/Magadan'                   => __( '(GMT +11:00) Asia/Magadan', 'wpjobster' ),
			'Asia/Sakhalin'                  => __( '(GMT +11:00) Asia/Sakhalin', 'wpjobster' ),
			'Asia/Srednekolymsk'             => __( '(GMT +11:00) Asia/Srednekolymsk', 'wpjobster' ),
			'Australia/Currie'               => __( '(GMT +11:00) Australia/Currie', 'wpjobster' ),
			'Australia/Hobart'               => __( '(GMT +11:00) Australia/Hobart', 'wpjobster' ),
			'Australia/Lord_Howe'            => __( '(GMT +11:00) Australia/Lord_Howe', 'wpjobster' ),
			'Australia/Melbourne'            => __( '(GMT +11:00) Australia/Melbourne', 'wpjobster' ),
			'Australia/Sydney'               => __( '(GMT +11:00) Australia/Sydney', 'wpjobster' ),
			'Pacific/Bougainville'           => __( '(GMT +11:00) Pacific/Bougainville', 'wpjobster' ),
			'Pacific/Efate'                  => __( '(GMT +11:00) Pacific/Efate', 'wpjobster' ),
			'Pacific/Guadalcanal'            => __( '(GMT +11:00) Pacific/Guadalcanal', 'wpjobster' ),
			'Pacific/Kosrae'                 => __( '(GMT +11:00) Pacific/Kosrae', 'wpjobster' ),
			'Pacific/Norfolk'                => __( '(GMT +11:00) Pacific/Norfolk', 'wpjobster' ),
			'Pacific/Noumea'                 => __( '(GMT +11:00) Pacific/Noumea', 'wpjobster' ),
			'Pacific/Pohnpei'                => __( '(GMT +11:00) Pacific/Pohnpei', 'wpjobster' ),
			'Asia/Anadyr'                    => __( '(GMT +12:00) Asia/Anadyr', 'wpjobster' ),
			'Asia/Kamchatka'                 => __( '(GMT +12:00) Asia/Kamchatka', 'wpjobster' ),
			'Pacific/Fiji'                   => __( '(GMT +12:00) Pacific/Fiji', 'wpjobster' ),
			'Pacific/Funafuti'               => __( '(GMT +12:00) Pacific/Funafuti', 'wpjobster' ),
			'Pacific/Kwajalein'              => __( '(GMT +12:00) Pacific/Kwajalein', 'wpjobster' ),
			'Pacific/Majuro'                 => __( '(GMT +12:00) Pacific/Majuro', 'wpjobster' ),
			'Pacific/Nauru'                  => __( '(GMT +12:00) Pacific/Nauru', 'wpjobster' ),
			'Pacific/Tarawa'                 => __( '(GMT +12:00) Pacific/Tarawa', 'wpjobster' ),
			'Pacific/Wake'                   => __( '(GMT +12:00) Pacific/Wake', 'wpjobster' ),
			'Pacific/Wallis'                 => __( '(GMT +12:00) Pacific/Wallis', 'wpjobster' ),
			'Antarctica/McMurdo'             => __( '(GMT +13:00) Antarctica/McMurdo', 'wpjobster' ),
			'Pacific/Auckland'               => __( '(GMT +13:00) Pacific/Auckland', 'wpjobster' ),
			'Pacific/Enderbury'              => __( '(GMT +13:00) Pacific/Enderbury', 'wpjobster' ),
			'Pacific/Fakaofo'                => __( '(GMT +13:00) Pacific/Fakaofo', 'wpjobster' ),
			'Pacific/Tongatapu'              => __( '(GMT +13:00) Pacific/Tongatapu', 'wpjobster' ),
			'Pacific/Chatham'                => __( '(GMT +13:45) Pacific/Chatham', 'wpjobster' ),
			'Pacific/Apia'                   => __( '(GMT +14:00) Pacific/Apia', 'wpjobster' ),
			'Pacific/Kiritimati'             => __( '(GMT +14:00) Pacific/Kiritimati', 'wpjobster' )
		];

		foreach ( $timezone_arr as $value => $label ) {
			$timezone_names[$value] = $label;
		}

		if ( $tm_name && ! empty( $timezone_names[$tm_name] ) ) {
			return apply_filters( 'wpj_timezone_filter', $timezone_names[$tm_name] );
		}

		return apply_filters( 'wpj_timezones_list_filter', $timezone_names );
	}
}

if ( ! function_exists( 'wpj_set_site_timezone' ) ) {
	function wpj_set_site_timezone( $uid = '' ) {
		global $pagenow;

		$user_id = $uid ? $uid : get_current_user_id();

		$timezone_admin = wpj_get_option( 'timezone_string' );
		$timezone_user  = wpj_stripslashes( get_user_meta( $user_id, 'timezone_select', true ) );

		$timezone = '';

		if ( is_user_logged_in() ) {
			if ( is_admin() ) { // is dashboard
				if ( $timezone_admin ) $timezone = $timezone_admin;
				elseif ( $timezone_user ) $timezone = $timezone_user;

			} else { // is frontend
				if ( $timezone_user ) $timezone = $timezone_user;
				elseif ( $timezone_admin ) $timezone = $timezone_admin;

			}

		} elseif ( $timezone_admin ) $timezone = $timezone_admin;

		if ( ! $timezone || ( is_admin() && $pagenow == 'site-health.php' ) ) $timezone = 'UTC';

		if ( $timezone ) date_default_timezone_set( $timezone );

		return $timezone;
	}
}

if ( ! function_exists( 'wpj_date' ) ) {
	function wpj_date( $format = null, $timestamp = null, $timezone = null ) {
		if ( ! $timezone ) {
			$timezone = new DateTimeZone( wpj_set_site_timezone() );
		}

		if ( empty( $format ) ) {
			$date_format = wpj_get_option( 'date_format' ) ? wpj_get_option( 'date_format' ) : 'd-m-Y';
			$time_format = wpj_get_option( 'time_format' ) ? wpj_get_option( 'time_format' ) : 'H:i:s';
			$format      = $date_format . ' ' . $time_format;
		}

		if ( version_compare( get_bloginfo( 'version' ), '5.3', '<' ) ) {
			return date_i18n( $format, $timestamp, $timezone );

		} else {
			return wp_date( $format, $timestamp, $timezone );

		}
	}
}

if ( ! function_exists( 'wpj_time_or_date_format' ) ) {
	function wpj_time_or_date_format( $timestamp ) {
		$time_diff = time() - $timestamp;

		if ( $time_diff >= 0 && $time_diff < 86400 ) {
			$format = wpj_get_option( 'time_format' ) ? wpj_get_option( 'time_format' ) : 'H:i:s';

		} else {
			$format = wpj_get_option( 'date_format' ) ? wpj_get_option( 'date_format' ) : 'd-m-Y';

		}

		return $format;
	}
}