<?php
if ( ! function_exists( 'wpj_get_order' ) ) {
	function wpj_get_order( $oid = '', $return = '' ) {
		return wpj_get_job_order_by_id( $oid, $return );
	}
}

if ( ! function_exists( 'wpj_get_arbitration_in_review_number' ) ) {
	function wpj_get_arbitration_in_review_number() {
		return wpj_get_arbitrations_in_review_count();
	}
}

if ( ! function_exists( 'wpj_get_arbitration_details_by_id' ) ) {
	function wpj_get_arbitration_details_by_id( $id = '' ) {
		return wpj_get_arbitration_order( 'id, order_id, buyer_arbitration, seller_arbitration', ['id' => $id], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_arbitration_details_by_order_id' ) ) {
	function wpj_get_arbitration_details_by_order_id( $order_id = '' ) {
		return wpj_get_arbitration_order( '*', ['order_id' => $order_id], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_extended_delivery_by_message' ) ) {
	function wpj_get_extended_delivery_by_message( $oid = '', $message = '', $date = '' ) {
		return wpj_get_extended_delivery_order( 'days', ['order_id' => $oid, 'message' => $message, 'date_request' => $date], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_extended_delivery_by_oid' ) ) {
	function wpj_get_extended_delivery_by_oid( $oid = '', $status = '' ) {
		return wpj_get_extended_delivery_order( '*', ['order_id' => $oid, 'status' => $status], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_chatbox_message' ) ) {
	function wpj_get_chatbox_message( $id = '' ) {
		return wpj_get_order_notification_message( '*', ['id' => $id], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_private_message_by_id' ) ) {
	function wpj_get_private_message_by_id( $id = '' ) {
		return  wpj_get_pm_notify( '*', ['id' => $id], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_badge_order_by' ) ) {
	function wpj_get_badge_order_by( $column_name = '', $val = '' ) {
		return wpj_get_badge_order( '*', [$column_name => $val], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_featured_order_by' ) ) {
	function wpj_get_featured_order_by( $column_name = '', $val = '' ) {
		return wpj_get_feature_order( '*', [$column_name => $val], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_featured_order_value_by_oid' ) ) {
	function wpj_get_featured_order_value_by_oid( $column_name = '', $oid = '' ) {
		return wpj_get_feature_order( $column_name, ['id' => $oid], 'var' );
	}
}

if ( ! function_exists( 'wpj_get_topup_order_by' ) ) {
	function wpj_get_topup_order_by( $column_name = '', $val = '' ) {
		return wpj_get_topup_order( '*', [$column_name => $val], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_subscription_order_by' ) ) {
	function wpj_get_subscription_order_by( $column_name = 'id', $val = '', $status = 'active', $type_of_return = 'single' ) {
		$retrun = $type_of_return == 'multiple' ? 'results' : 'row';

		if ( $status == 'all' ) {
			return wpj_get_subscription_order( '*', [$column_name => $val], $retrun );

		} else {
			return wpj_get_subscription_order( '*', [$column_name => $val, 'subscription_status' => $status], $retrun );

		}
	}
}

if ( ! function_exists( 'wpj_get_custom_extra_order_by' ) ) {
	function wpj_get_custom_extra_order_by( $column_name = '', $val = '' ) {
		return wpj_get_custom_extra_order( '*', [$column_name => $val], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_tips_order_by' ) ) {
	function wpj_get_tips_order_by( $column_name = '', $val = '' ) {
		return wpj_get_tips_order( '*', [$column_name => $val], 'row' );
	}
}

if ( ! function_exists( 'wpj_get_site_curreny' ) ) {
	function wpj_get_site_curreny() {
		return wpj_get_site_currency();
	}
}

if ( ! function_exists( 'wpj_get_site_default_curreny' ) ) {
	function wpj_get_site_default_curreny() {
		return wpj_get_site_default_currency();
	}
}