<?php
if ( ! function_exists( 'wpj_get_site_processing_fees_percent' ) ) {
	function wpj_get_site_processing_fees_percent() {
		return wpj_get_option( 'wpjobster_buyer_processing_fees_percent' );
	}
}

if ( ! function_exists( 'wpj_get_site_fee_by_amount' ) ) {
	function wpj_get_site_fee_by_amount( $raw_amount, $order_id = '', $uid = '' ) {
		$amount_fee = 0;

		// get seller ID
		if ( ! $uid && isset( $order->pid ) ) {
			$uid = get_post_field( 'post_author', $order->pid );
		}

		// calculate by level or subscription
		$subscription_info = wpj_get_subscription_info( $uid );

		/**
		 * @var string $wpjobster_subscription_enabled
		 * @var string $wpjobster_fees_for_subscriber_enabled
		 * @var int $wpjobster_subscription_fees
		 */
		extract( $subscription_info );

		if ( $wpjobster_subscription_enabled == 'yes' && $wpjobster_fees_for_subscriber_enabled == 'yes' ) { // subscription
			if ( $wpjobster_subscription_fees && is_numeric( $wpjobster_subscription_fees ) ) {
				$percent_taken = $wpjobster_subscription_fees;

			} else {
				$percent_taken = 0;

			}

			$amount_fee = ( floatval( $percent_taken ) * floatval( $raw_amount ) ) / 100;

		} else { // level
			$site_fee_type = wpj_get_option( 'wpjobster_enable_site_fee' );

			if ( $site_fee_type == 'percent' ) { // percent
				$percent_taken = wpj_get_option( 'wpjobster_percent_fee_taken' );

				if ( ! is_numeric( $percent_taken ) ) $percent_taken = 0;

				$amount_fee = ( floatval( $percent_taken ) * floatval( $raw_amount ) ) / 100;

			} elseif ( $site_fee_type == 'fixed' ) { // fixed
				$solid_fee_taken = wpj_get_option( 'wpjobster_solid_fee_taken' );
				$amount_fee      = is_numeric( $solid_fee_taken ) ? $solid_fee_taken : 0;

			} elseif ( $site_fee_type == 'flexible' ) { // flexible
				if ( $uid != 0 ) {
					$user_level   = wpj_get_user_level( $uid );
					$flexible_fee = wpj_get_option( 'flexible-fee-settings' );

					$percent_fee_taken_range1_base = isset( $flexible_fee['flexible_fee_over'][1] ) ? $flexible_fee['flexible_fee_over'][1] : 0;
					$percent_fee_taken_range2_base = isset( $flexible_fee['flexible_fee_over'][2] ) ? $flexible_fee['flexible_fee_over'][2] : 0;
					$percent_fee_taken_range3_base = isset( $flexible_fee['flexible_fee_over'][3] ) ? $flexible_fee['flexible_fee_over'][3] : 0;

					if ( ! is_numeric( $percent_fee_taken_range1_base ) )
						$percent_fee_taken_range1_base = 0;

					if ( ! is_numeric( $percent_fee_taken_range2_base ) )
						$percent_fee_taken_range2_base = 0;

					if ( ! is_numeric( $percent_fee_taken_range3_base ) )
						$percent_fee_taken_range3_base = 0;

					if ( $percent_fee_taken_range3_base && $raw_amount > $percent_fee_taken_range3_base )
						$amount_range = 3;

					elseif ( $percent_fee_taken_range2_base && $raw_amount > $percent_fee_taken_range2_base )
						$amount_range = 2;

					elseif ( $percent_fee_taken_range1_base && $raw_amount > $percent_fee_taken_range1_base )
						$amount_range = 1;

					else
						$amount_range = 0;

					if ( isset( $flexible_fee['level' . $user_level . '_flexible_fee'][$amount_range] ) ) {
						$percent_taken = $flexible_fee['level' . $user_level . '_flexible_fee'][$amount_range];

						if ( ! is_numeric( $percent_taken ) ) {
							$percent_taken = $flexible_fee['level0_flexible_fee'][$amount_range];

							if ( ! is_numeric( $percent_taken ) ) {
								$percent_taken = 0;
							}
						}

					} else $percent_taken = 0;

				} else $percent_taken = 0;

				$amount_fee = ( $percent_taken * $raw_amount ) / 100;
			}
		}

		$amount_fee = apply_filters( 'wpj_site_fee_filter', $amount_fee, $order_id, $raw_amount );

		return round( $amount_fee, 2 );
	}
}

if ( ! function_exists( 'wpj_get_site_tax_percent' ) ) {
	function wpj_get_site_tax_percent( $country_code = '' ) {
		$tax_percent = 0;

		if ( wpj_get_option( 'wpjobster_enable_site_tax' ) == 'yes' ) {
			if ( ! $country_code ) {
				$country_code = get_user_meta( get_current_user_id(), 'country_code', true );
			}

			$country_tax_percent = wpj_get_option( 'country-tax-settings' );
			$country_indx        = array_search( $country_code, $country_tax_percent['country_name'] );

			if (
				is_numeric( $country_indx )
				&& wpj_multidimensional_array_has_value( $country_tax_percent['country_name'] )
				&& isset( $country_tax_percent['country_tax'][$country_indx] )
			) {
				$tax_percent = $country_tax_percent['country_tax'][$country_indx];

				return ( float ) apply_filters( 'wpj_apply_fees_by_category', $tax_percent );
			}

			$post_categories      = get_the_terms( wpj_get_post_id(), 'job_cat' );
			$category_tax_percent = wpj_get_option( 'category-tax-settings' );

			$subcategory_indx = '';

			if ( isset( $post_categories[1]->term_id ) ) {
				$subcategory_indx = array_search( $post_categories[1]->term_id, $category_tax_percent['category_name'] );
			}

			if (
				is_numeric( $subcategory_indx )
				&& wpj_multidimensional_array_has_value( $category_tax_percent['category_name'] )
				&& isset( $category_tax_percent['category_tax'][$country_indx] )
			) {
				$tax_percent = $category_tax_percent['category_tax'][$subcategory_indx];

				return ( float ) apply_filters( 'wpj_apply_fees_by_category', $tax_percent );
			}

			$category_indx = '';

			if ( isset( $post_categories[0]->term_id ) ) {
				$category_indx = array_search( $post_categories[0]->term_id, $category_tax_percent['category_name'] );
			}

			if (
				is_numeric( $category_indx )
				&& wpj_multidimensional_array_has_value( $category_tax_percent['category_name'] )
				&& isset( $category_tax_percent['category_tax'][$country_indx] )
			) {
				$tax_percent = $category_tax_percent['category_tax'][$category_indx];

				return ( float ) apply_filters( 'wpj_apply_fees_by_category', $tax_percent );
			}

			if ( empty( $tax_percent ) ) {
				$tax_percent = wpj_get_option( 'wpjobster_tax_percent' );

				return ( float ) apply_filters( 'wpj_apply_fees_by_category', $tax_percent );
			}
		}

		return $tax_percent;
	}
}

if ( ! function_exists( 'wpj_get_site_tax_by_amount' ) ) {
	function wpj_get_site_tax_by_amount( $price, $extr_ttl = 0, $shipping = 0, $buyer_processing_fees = 0 ) {
		$tax_amount = 0;

		if ( wpj_get_option( 'wpjobster_enable_site_tax' ) != 'no' ) {
			$total_taxable_amount = 0;

			if ( wpj_get_option( 'wpjobster_tax_over' ) == 'job' )
				$total_taxable_amount = floatval( $price ) + floatval( $extr_ttl ) + floatval( $shipping );

			elseif ( wpj_get_option( 'wpjobster_tax_over' ) == 'processing_fee' && $buyer_processing_fees > 0 )
				$total_taxable_amount = floatval( $buyer_processing_fees );

			elseif ( wpj_get_option( 'wpjobster_tax_over' ) == 'job_and_pf' )
				$total_taxable_amount = floatval( $price ) + floatval( $extr_ttl ) + floatval( $shipping ) + floatval( $buyer_processing_fees );

			$tax_amount = $total_taxable_amount * wpj_get_site_tax_percent() / 100;

		}

		return wpj_number_format_special( $tax_amount );
	}
}

if ( ! function_exists( 'wpj_get_site_processing_fee_by_amount' ) ) {
	function wpj_get_site_processing_fee_by_amount( $price, $extr_ttl, $shipping ) {
		$processing_fees_percent_amount = 0;

		$processing_fees_enabled = wpj_get_option( 'wpjobster_enable_buyer_processing_fees' );

		if ( $processing_fees_enabled == 'percent' ) {
			$buyer_processing_fees_percent = wpj_get_option( 'wpjobster_buyer_processing_fees_percent' );

			if ( $buyer_processing_fees_percent > 0 ) {
				$total_processing_amount = floatval( $price ) + floatval( $extr_ttl ) + floatval( $shipping );

				if ( $total_processing_amount > 0 ) {
					$processing_fees_percent_amount = $total_processing_amount * $buyer_processing_fees_percent / 100;

				} else {
					$processing_fees_percent_amount = 0;

				}

			} else {
				$processing_fees_percent_amount = 0;

			}
		}

		if ( $processing_fees_enabled == 'fixed' ) {
			$processing_fees_percent_amount = wpj_get_option( 'wpjobster_buyer_processing_fees' );

		}

		return wpj_number_format_special( $processing_fees_percent_amount );
	}
}