<?php
if ( ! function_exists( 'wpj_get_payment_gateways' ) ) {
	function wpj_get_payment_gateways() {
		$payment_gateways_list = apply_filters( 'wpj_payment_gateways_filter', [
			'cod'          => __( 'COD', 'wpjobster' ),
			'banktransfer' => __( 'Bank Transfer', 'wpjobster' )
		]);

		foreach ( $payment_gateways_list as $slug => $label ) {
			$payment_gateways[$slug] = [
				'label'             => $label,
				'action'            => 'wpjobster_taketo_' . $slug . '_gateway',
				'response_action'   => 'wpjobster_processafter_' . $slug . '_gateway',
				'unique_id'         => $slug
			];
		}

		ksort( $payment_gateways );

		return $payment_gateways;
	}
}

if ( ! function_exists( 'wpj_get_sms_payment_gateways' ) ) {
	function wpj_get_sms_payment_gateways() {
		$sms_gateways = apply_filters( 'wpj_sms_gateways_filter', [
			/*
			'twilio' => [
				'label' => __( 'Twilio 1', 'wpjobster' ),
				'show_settigs_form' => 'show_twilio_form',
				'unique_id' => 'twilio1'
			]
			*/
		]);

		ksort( $sms_gateways );

		return $sms_gateways;
	}
}

if ( ! function_exists( 'wpj_get_withdrawals_payment_gateways' ) ) {
	function wpj_get_withdrawals_payment_gateways( $withdrawal_only = false ) {
		if ( $withdrawal_only ) {
			$withdrawal_gateways = apply_filters( 'wpj_only_withdrawals_gateways_filter', ['payoneer'] );

			sort( $withdrawal_gateways );

			return $withdrawal_gateways;
		}

		$withdrawal_gateways = apply_filters( 'wpj_withdrawals_gateways_filter', ['paypal', 'payoneer', 'banktransfer'] );

		sort( $withdrawal_gateways );

		return $withdrawal_gateways;
	}
}

if ( ! function_exists( 'wpj_get_payment_types' ) ) {
	function wpj_get_payment_types( $exclude = [] ) {
		$payment_type_enable_arr = [
			'job_purchase'     => [
				'enable_label' => __( 'Enable for job purchase:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to purchase jobs through this payment gateway.', 'wpjobster' ),
			],
			'topup'            => [
				'enable_label' => __( 'Enable for top up:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to top up their balance through this payment gateway.', 'wpjobster' ),
			],
			'featured'         => [
				'enable_label' => __( 'Enable for featured job:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to pay for featured jobs through this payment gateway.', 'wpjobster' ),
			],
			'withdraw'       => [
				'enable_label' => __( 'Enable for withdraw:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to withdraw their balance through this payment gateway.', 'wpjobster' ),
			],
			'custom_extra'     => [
				'enable_label' => __( 'Enable for custom extra:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to pay for custom extras through this payment gateway.', 'wpjobster' ),
			],
			'tips'             => [
				'enable_label' => __( 'Enable for tips:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to pay for tips through this payment gateway.', 'wpjobster' ),
			],
			'subscription'     => [
				'enable_label' => __( 'Enable for subscription:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to pay for subscription through this payment gateway.', 'wpjobster' ),
			],
			'badge'            => [
				'enable_label' => __( 'Enable for badge:', 'wpjobster' ),
				'hint_label'   => __( 'Allow your users to pay for badges through this payment gateway.', 'wpjobster' ),
			]
		];

		if ( $exclude ) {
			foreach ( $exclude as $key => $value ) {
				if ( isset( $payment_type_enable_arr[$value] ) ) {
					unset( $payment_type_enable_arr[$value] );
				}
			}
		}

		return $payment_type_enable_arr;
	}
}

// HELPERS //

if ( ! function_exists( 'wpj_is_COD_only_payment' ) ) {
	function wpj_is_COD_only_payment() {
		$payment_methods = [];

		$wpjobster_payment_gateways = wpj_get_payment_gateways();

		if ( $wpjobster_payment_gateways ) {
			foreach ( $wpjobster_payment_gateways as $key => $method ) {
				if ( wpj_is_payment_type_enabled( $method['unique_id'], 'job_purchase' ) ) {
					array_push( $payment_methods, $method['unique_id'] );
				}
			}
		}

		if ( count( $payment_methods ) == 1 && $payment_methods[0] == 'cod' ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_COD_payment_allowed' ) ) {
	function wpj_is_COD_payment_allowed( $pid = '', $payment_type = '' ) {
		$post = get_post( $pid );

		$is_allowed = false;

		if ( wpj_is_payment_type_enabled( 'cod', $payment_type ) ) {
			if ( wpj_get_user_credit( $post->post_author ) >= wpj_get_site_fee_by_amount( get_post_meta( $pid, 'price', true ), '', $post->post_author ) ) {
				$is_allowed = true;
			}
		}

		return apply_filters( 'wpj_is_cod_payment_allowed_filter', $is_allowed, $pid, $payment_type );
	}
}

if ( ! function_exists( 'wpj_is_payment_type_enabled' ) ) {
	function wpj_is_payment_type_enabled( $payment_gateway = '', $payment_type = '', $no_parent = false ) {
		if ( $payment_gateway == '' || $payment_type == '' )
			return false; /* exit if no parameters */

		if ( strpos( $payment_gateway, '_automatic' ) !== false )
			$parent = str_replace( '_automatic', '', $payment_gateway );

		else
			$parent = $payment_gateway;

		if ( wpj_get_option( 'wpjobster_' . $parent . '_enable' ) != 'yes' && $no_parent != true )
			return false; /* exit if gateway disabled or option intentionally missing */

		if ( wpj_get_option( 'wpjobster_' . $payment_gateway . '_enable_' . $payment_type ) == 'yes' )
			return true; /* true if option explicitely set to yes */

		return false;
	}
}

if ( ! function_exists( 'wpj_is_payment_free' ) ) {
	function wpj_is_payment_free( $payment_type ) {
		$oid = WPJ_Form::post( 'oid' );

		if ( $payment_type == 'job_purchase' ) {
			return get_post_meta( WPJ_Form::post( 'jobid' ), 'price', true ) > 0 || get_post_meta( WPJ_Form::post( 'jobid' ), 'job_packages', true ) == 'yes' ? false : true;

		} elseif ( $payment_type == 'custom_extra' && $oid ) {
			$order         = wpj_get_job_order_by_id( $oid );
			$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
			$custom_extra  = $custom_extras[WPJ_Form::post( 'custom_extra' )];

			return $custom_extra->price > 0 ? false : true;

		} elseif ( $payment_type == 'tips' && $oid ) {
			$order = wpj_get_job_order_by_id( $oid );
			$tips  = wpj_json_decode( wpj_stripslashes( $order->tips ) );
			$tip   = $tips[WPJ_Form::post( 'tips' )];

			return $tip->amount > 0 ? false : true;

		} elseif ( $payment_type == 'featured' ) {
			return max( [ wpj_get_option( 'wpjobster_featured_price_homepage' ), wpj_get_option( 'wpjobster_featured_price_category' ), wpj_get_option( 'wpjobster_featured_price_subcategory' ) ] ) > 0 ? false : true;

		} elseif ( $payment_type == 'subscription' ) {
			return $order_price = max( [ wpj_get_subscription_min_price_by_level( 1 ), wpj_get_subscription_min_price_by_level( 2 ), wpj_get_subscription_min_price_by_level( 3 ) ] ) > 0 ? false : true;

		} elseif ( $payment_type == 'badge' ) {
			$badges_data = wpj_get_badge_info();

			return is_array( $badges_data['wpj_badge_price'] ) && max( $badges_data['wpj_badge_price'] ) > 0 ? false : true;

		} elseif ( $payment_type == 'topup' ) {
			$topup_data = wpj_get_option( 'topup-packages-settings' );

			return is_array( $topup_data['topup_cost'] ) && max( $topup_data['topup_cost'] ) > 0 ? false : true;

		}

		return false;
	}
}

if ( ! function_exists( 'wpj_payment_type_has_gateway_enabled' ) ) {
	function wpj_payment_type_has_gateway_enabled( $payment_type = '' ) {
		$wpjobster_payment_gateways = wpj_get_payment_gateways();

		if ( $wpjobster_payment_gateways ) {
			foreach ( $wpjobster_payment_gateways as $priority => $button_arr ) {
				if ( wpj_is_payment_type_enabled( $button_arr['unique_id'], $payment_type ) ) {
					return true;
				}
			}
		}

		$credits = wpj_get_user_credit( get_current_user_id() );

		if ( $credits > 0 ) return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_withdrawal_gateway_enabled_exist' ) ) {
	function wpj_withdrawal_gateway_enabled_exist( $ret_gateways = false ) {
		$gateways_arr = [];

		$gateways = wpj_get_withdrawals_payment_gateways();

		if ( $gateways ) {
			foreach ( $gateways as $key => $gateway ) {
				$no_parent = in_array( $gateway, wpj_get_withdrawals_payment_gateways( true ) );

				if ( wpj_is_payment_type_enabled( $gateway, 'withdraw', $no_parent ) ) {
					$gateways_arr[] = $gateway;

					if ( ! $ret_gateways ) return true;
				}
			}
		}

		if ( $ret_gateways ) return $gateways_arr;

		return false;
	}
}