<?php
if ( ! function_exists( 'wpj_get_language_by_uid' ) ) {
	function wpj_get_language_by_uid( $uid, $default_lang ) {
		$lang = get_user_meta( $uid, 'preferred_language', true );

		if ( ! $lang ) $lang = $default_lang;

		return $lang;
	}
}

if ( ! function_exists( 'wpj_get_language_by_code' ) ) {
	function wpj_get_language_by_code( $code = '' ) {
		$language_codes = [
			'' => '-' ,
			'en' => __( 'English' , 'wpjobster' ),
			'aa' => __( 'Afar' , 'wpjobster' ),
			'ab' => __( 'Abkhazian' , 'wpjobster' ),
			'af' => __( 'Afrikaans' , 'wpjobster' ),
			'am' => __( 'Amharic' , 'wpjobster' ),
			'ar' => __( 'Arabic' , 'wpjobster' ),
			'as' => __( 'Assamese' , 'wpjobster' ),
			'ay' => __( 'Aymara' , 'wpjobster' ),
			'az' => __( 'Azerbaijani' , 'wpjobster' ),
			'ba' => __( 'Bashkir' , 'wpjobster' ),
			'be' => __( 'Byelorussian' , 'wpjobster' ),
			'bg' => __( 'Bulgarian' , 'wpjobster' ),
			'bh' => __( 'Bihari' , 'wpjobster' ),
			'bi' => __( 'Bislama' , 'wpjobster' ),
			'bn' => __( 'Bengali/Bangla' , 'wpjobster' ),
			'bo' => __( 'Tibetan' , 'wpjobster' ),
			'br' => __( 'Breton' , 'wpjobster' ),
			'ca' => __( 'Catalan' , 'wpjobster' ),
			'co' => __( 'Corsican' , 'wpjobster' ),
			'cs' => __( 'Czech' , 'wpjobster' ),
			'cy' => __( 'Welsh' , 'wpjobster' ),
			'da' => __( 'Danish' , 'wpjobster' ),
			'de' => __( 'German' , 'wpjobster' ),
			'dz' => __( 'Bhutani' , 'wpjobster' ),
			'el' => __( 'Greek' , 'wpjobster' ),
			'eo' => __( 'Esperanto' , 'wpjobster' ),
			'es' => __( 'Spanish' , 'wpjobster' ),
			'et' => __( 'Estonian' , 'wpjobster' ),
			'eu' => __( 'Basque' , 'wpjobster' ),
			'fa' => __( 'Persian' , 'wpjobster' ),
			'fi' => __( 'Finnish' , 'wpjobster' ),
			'fj' => __( 'Fiji' , 'wpjobster' ),
			'fo' => __( 'Faeroese' , 'wpjobster' ),
			'fr' => __( 'French' , 'wpjobster' ),
			'fy' => __( 'Frisian' , 'wpjobster' ),
			'ga' => __( 'Irish' , 'wpjobster' ),
			'gd' => __( 'Scots/Gaelic' , 'wpjobster' ),
			'gl' => __( 'Galician' , 'wpjobster' ),
			'gn' => __( 'Guarani' , 'wpjobster' ),
			'gu' => __( 'Gujarati' , 'wpjobster' ),
			'ha' => __( 'Hausa' , 'wpjobster' ),
			'hi' => __( 'Hindi' , 'wpjobster' ),
			'hr' => __( 'Croatian' , 'wpjobster' ),
			'hu' => __( 'Hungarian' , 'wpjobster' ),
			'hy' => __( 'Armenian' , 'wpjobster' ),
			'ia' => __( 'Interlingua' , 'wpjobster' ),
			'ie' => __( 'Interlingue' , 'wpjobster' ),
			'ik' => __( 'Inupiak' , 'wpjobster' ),
			'in' => __( 'Indonesian' , 'wpjobster' ),
			'is' => __( 'Icelandic' , 'wpjobster' ),
			'it' => __( 'Italian' , 'wpjobster' ),
			'iw' => __( 'Hebrew' , 'wpjobster' ),
			'ja' => __( 'Japanese' , 'wpjobster' ),
			'ji' => __( 'Yiddish' , 'wpjobster' ),
			'jw' => __( 'Javanese' , 'wpjobster' ),
			'ka' => __( 'Georgian' , 'wpjobster' ),
			'kk' => __( 'Kazakh' , 'wpjobster' ),
			'kl' => __( 'Greenlandic' , 'wpjobster' ),
			'km' => __( 'Cambodian' , 'wpjobster' ),
			'kn' => __( 'Kannada' , 'wpjobster' ),
			'ko' => __( 'Korean' , 'wpjobster' ),
			'ks' => __( 'Kashmiri' , 'wpjobster' ),
			'ku' => __( 'Kurdish' , 'wpjobster' ),
			'ky' => __( 'Kirghiz' , 'wpjobster' ),
			'la' => __( 'Latin' , 'wpjobster' ),
			'ln' => __( 'Lingala' , 'wpjobster' ),
			'lo' => __( 'Laothian' , 'wpjobster' ),
			'lt' => __( 'Lithuanian' , 'wpjobster' ),
			'lv' => __( 'Latvian/Lettish' , 'wpjobster' ),
			'mg' => __( 'Malagasy' , 'wpjobster' ),
			'mi' => __( 'Maori' , 'wpjobster' ),
			'mk' => __( 'Macedonian' , 'wpjobster' ),
			'ml' => __( 'Malayalam' , 'wpjobster' ),
			'mn' => __( 'Mongolian' , 'wpjobster' ),
			'mo' => __( 'Moldavian' , 'wpjobster' ),
			'mr' => __( 'Marathi' , 'wpjobster' ),
			'ms' => __( 'Malay' , 'wpjobster' ),
			'mt' => __( 'Maltese' , 'wpjobster' ),
			'my' => __( 'Burmese' , 'wpjobster' ),
			'na' => __( 'Nauru' , 'wpjobster' ),
			'ne' => __( 'Nepali' , 'wpjobster' ),
			'nl' => __( 'Dutch' , 'wpjobster' ),
			'no' => __( 'Norwegian' , 'wpjobster' ),
			'oc' => __( 'Occitan' , 'wpjobster' ),
			'om' => __( '(Afan)/Oromoor/Oriya' , 'wpjobster' ),
			'pa' => __( 'Punjabi' , 'wpjobster' ),
			'pl' => __( 'Polish' , 'wpjobster' ),
			'ps' => __( 'Pashto/Pushto' , 'wpjobster' ),
			'pt' => __( 'Portuguese' , 'wpjobster' ),
			'qu' => __( 'Quechua' , 'wpjobster' ),
			'rm' => __( 'Rhaeto-Romance' , 'wpjobster' ),
			'rn' => __( 'Kirundi' , 'wpjobster' ),
			'ro' => __( 'Romanian' , 'wpjobster' ),
			'ru' => __( 'Russian' , 'wpjobster' ),
			'rw' => __( 'Kinyarwanda' , 'wpjobster' ),
			'sa' => __( 'Sanskrit' , 'wpjobster' ),
			'sd' => __( 'Sindhi' , 'wpjobster' ),
			'sg' => __( 'Sangro' , 'wpjobster' ),
			'sh' => __( 'Serbo-Croatian' , 'wpjobster' ),
			'si' => __( 'Singhalese' , 'wpjobster' ),
			'sk' => __( 'Slovak' , 'wpjobster' ),
			'sl' => __( 'Slovenian' , 'wpjobster' ),
			'sm' => __( 'Samoan' , 'wpjobster' ),
			'sn' => __( 'Shona' , 'wpjobster' ),
			'so' => __( 'Somali' , 'wpjobster' ),
			'sq' => __( 'Albanian' , 'wpjobster' ),
			'sr' => __( 'Serbian' , 'wpjobster' ),
			'ss' => __( 'Siswati' , 'wpjobster' ),
			'st' => __( 'Sesotho' , 'wpjobster' ),
			'su' => __( 'Sundanese' , 'wpjobster' ),
			'sv' => __( 'Swedish' , 'wpjobster' ),
			'sw' => __( 'Swahili' , 'wpjobster' ),
			'ta' => __( 'Tamil' , 'wpjobster' ),
			'te' => __( 'Tegulu' , 'wpjobster' ),
			'tg' => __( 'Tajik' , 'wpjobster' ),
			'th' => __( 'Thai' , 'wpjobster' ),
			'ti' => __( 'Tigrinya' , 'wpjobster' ),
			'tk' => __( 'Turkmen' , 'wpjobster' ),
			'tl' => __( 'Tagalog' , 'wpjobster' ),
			'tn' => __( 'Setswana' , 'wpjobster' ),
			'to' => __( 'Tonga' , 'wpjobster' ),
			'tr' => __( 'Turkish' , 'wpjobster' ),
			'ts' => __( 'Tsonga' , 'wpjobster' ),
			'tt' => __( 'Tatar' , 'wpjobster' ),
			'tw' => __( 'Twi' , 'wpjobster' ),
			'uk' => __( 'Ukrainian' , 'wpjobster' ),
			'ur' => __( 'Urdu' , 'wpjobster' ),
			'uz' => __( 'Uzbek' , 'wpjobster' ),
			'vi' => __( 'Vietnamese' , 'wpjobster' ),
			'vo' => __( 'Volapuk' , 'wpjobster' ),
			'wo' => __( 'Wolof' , 'wpjobster' ),
			'xh' => __( 'Xhosa' , 'wpjobster' ),
			'yo' => __( 'Yoruba' , 'wpjobster' ),
			'zh' => __( 'Chinese' , 'wpjobster' ),
			'zu' => __( 'Zulu' , 'wpjobster' )
		];

		$language_codes = apply_filters( 'wpj_languages_list_filter', $language_codes );

		if ( $code )
			return $language_codes[$code];

		else
			return $language_codes;
	}
}

if ( ! function_exists( 'wpj_get_preferred_languages' ) ) {
	function wpj_get_preferred_languages( $code = "" ) {
		$preferred_languages_array = [];

		for ( $i = 1; $i <= 10; $i++ ) {
			$wpjobster_language_x = trim( wpj_get_option( 'wpjobster_language_' . $i ) );

			if ( $wpjobster_language_x ) {
				$preferred_languages_array[$wpjobster_language_x] = wpj_get_language_by_code( $wpjobster_language_x );
			}
		}

		if ( $code ) {
			return $preferred_languages_array[$code];

		} else {
			return apply_filters( 'wpj_preferred_languages_list_filter', $preferred_languages_array );

		}
	}
}

if ( ! function_exists( 'wpj_db_strings_list' ) ) {
	function wpj_db_strings_list() {
		for ( $i = 0; $i <= 3; $i++ ) {
			${'level' . $i} = wpj_get_option( 'wpjobster_subscription_name_level' . $i );
		}

		$strings_arr = [
			'credits'      => _x( 'Credits', 'Credits gateway', 'wpjobster' ),
			'paypal'       => _x( 'PayPal', 'PayPal gateway', 'wpjobster' ),
			'cod'          => _x( 'COD', 'COD gateway', 'wpjobster' ),
			'banktransfer' => _x( 'Bank Transfer', 'Bank Transfer gateway', 'wpjobster' ),
			'fixed'        => _x( 'fixed', 'fixed rate', 'wpjobster' ),
			'hourly'       => _x( 'hourly', 'hourly rate', 'wpjobster' ),
			'daily'        => _x( 'daily', 'daily rate', 'wpjobster' ),
			'weekly'       => _x( 'weekly', 'weekly rate', 'wpjobster' ),
			'monthly'      => _x( 'monthly', 'monthly rate', 'wpjobster' ),
			'custom'       => _x( 'custom', 'custom rate', 'wpjobster' ),
			'package'      => _x( 'package', 'custom rate', 'wpjobster' ),
			'yes'          => _x( 'Yes', 'yes option', 'wpjobster' ),
			'no'           => _x( 'No', 'no option', 'wpjobster' ),
			'weekly'       => _x( 'Weekly', 'weekly subscription', 'wpjobster' ),
			'monthly'      => _x( 'Monthly', 'monthly subscription', 'wpjobster' ),
			'quarterly'    => _x( 'Quarterly', 'quarterly subscription', 'wpjobster' ),
			'yearly'       => _x( 'Yearly', 'yearly subscription', 'wpjobster' ),
			'lifetime'     => _x( 'Lifetime', 'lifetime subscription', 'wpjobster' ),
			'level0'       => $level0 ?? _x( 'Free', 'free subscription plan', 'wpjobster' ),
			'level1'       => $level1 ?? _x( 'Starter', 'starter subscription plan', 'wpjobster' ),
			'level2'       => $level2 ?? _x( 'Business', 'business subscription plan', 'wpjobster' ),
			'level3'       => $level3 ?? _x( 'Professional', 'professional subscription plan', 'wpjobster' ),
			'kilometers'   => _x( 'kilometers', 'kilometers radius placeholder', 'wpjobster' ),
			'miles'        => _x( 'miles', 'miles radius placeholder', 'wpjobster' ),
			'level0_lbl'   => _x( 'Level 0', 'level number label', 'wpjobster' ),
			'level1_lbl'   => _x( 'Level 1', 'level number label', 'wpjobster' ),
			'level2_lbl'   => _x( 'Level 2', 'level number label', 'wpjobster' ),
			'level3_lbl'   => _x( 'Level 3', 'level number label', 'wpjobster' ),
			'pending'      => _x( 'pending', 'order status', 'wpjobster' ),
			'expired'      => _x( 'expired', 'order status', 'wpjobster' ),
			'completed'    => _x( 'completed', 'order status', 'wpjobster' ),
			'payza'        => _x( 'Payza', 'Payment Gateway', 'wpjobster' ),
			'bank'         => _x( 'Bank', 'Payment Gateway', 'wpjobster' ),
		];

		return apply_filters( 'wpjobster_database_strings_filter', $strings_arr );
	}
}

if ( ! function_exists( 'wpj_translate_string' ) ) {
	function wpj_translate_string( $string ) {
		$strings_arr = wpj_db_strings_list();

		if ( wpj_in_array_r( $string, $strings_arr ) ) {
			foreach ( $strings_arr as $key => $str ) {
				if ( strtolower( $string ) == $key ) {
					return $str;
				}
			}

		}

		return $string;
	}
}

if ( ! function_exists( 'wpj_translate_custom_offer_title' ) ) {
	function wpj_translate_custom_offer_title( $title = '', $pid = '' ) {
		if ( $pid ) {
			$row = wpj_get_pm_notify( 'initiator, user', ['custom_offer' => $pid], 'row' );

			if ( $row ) {
				return sprintf( __( 'Private transaction between %s and %s', 'wpjobster' ), wpj_get_user_display_type( $row->initiator ), wpj_get_user_display_type( $row->user ) );
			}
		}

		return $title;
	}
}

if ( ! function_exists( 'wpj_translate_archive_months' ) ) {
	function wpj_translate_archive_months( $list ) {
		$patterns = [
			'/January/', '/February/', '/March/', '/April/', '/May/', '/June/', '/July/', '/August/', '/September/', '/October/',  '/November/', '/December/'
		];

		$replacements = [
			__( 'January','wpjobster' ),
			__( 'February','wpjobster' ),
			__( 'March','wpjobster' ),
			__( 'April','wpjobster' ),
			__( 'May','wpjobster' ),
			__( 'June','wpjobster' ),
			__( 'July','wpjobster' ),
			__( 'August','wpjobster' ),
			__( 'September','wpjobster' ),
			__( 'October','wpjobster' ),
			__( 'November','wpjobster' ),
			__( 'December','wpjobster' )
		];

		$list = preg_replace( $patterns, $replacements, $list );

		return $list;
	}
}

if ( ! function_exists( 'wpj_get_day_translation' ) ) {
	function wpj_get_day_translation( $days = '' ) {
		$days = WPJ_Form::post( 'value', $days );

		echo _n( 'day ', 'days ', $days, 'wpjobster' );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_is_translatepress_preview' ) ) {
	function wpj_is_translatepress_preview() {
		if ( class_exists( 'TRP_Translate_Press' ) ) {
			if (
				! empty( $_REQUEST['trp-edit-translation'] )
				&& $_REQUEST['trp-edit-translation'] == 'preview'
			) {
				return true;
			}
		}

		return false;
	}
}

// qTranslate-x functions
if ( function_exists( 'qtranxf_generateLanguageSelectCode' ) ) {
	function qtrans_removeLanguageURL( $url ) {
		$lang = qtranxf_getLanguage();

		$url = str_replace ( get_site_url() . '/' . $lang, get_site_url(), $url );
		$url = str_replace ( get_site_url() . '/' . $lang, get_site_url(), $url );

		return $url;
	}

	if ( function_exists( 'qtranxf_getLanguage' ) ) {
		add_filter( 'post_type_link', 'qtranxf_convertURL' );
	}

	if ( function_exists( 'qwpseo_stylesheet_url' ) ) {
		add_action( 'init', function() {
			remove_filter( 'wpseo_stylesheet_url', 'qwpseo_stylesheet_url' );
		});
	}
}