<?php
// Functions
if ( ! function_exists( 'wpj_get_post_status_legend' ) ) {
	function wpj_get_post_status_legend( $page ) {
		$job_page = apply_filters( 'wpj_job_page_status_filter', [
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'published', 'wpjobster' ),
				'description' => __( 'Your Job is visible and may be ordered by all users.', 'wpjobster' )
			],
			[
				'class'       => 'oe-yellow oe-full',
				'title'       => __( 'paused', 'wpjobster' ),
				'description' => __( 'No one can see your Job. You may reactivate it whenever you like.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange oe-full',
				'title'       => __( 'pending', 'wpjobster' ),
				'description' => __( 'Your Job is pending review and is not yet available.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red oe-full',
				'title'       => __( 'rejected', 'wpjobster' ),
				'description' => __( 'Your job failed to pass our review and is not visible to anyone.', 'wpjobster' )
			],
			[
				'class'       => 'oe-full',
				'title'       => __( 'disabled', 'wpjobster' ),
				'description' => __( 'Your job was automatically disabled.', 'wpjobster' )
			],
			[
				'class'       => 'oe-burgundy oe-full',
				'title'       => __( 'expired', 'wpjobster' ),
				'description' => __( 'Your job has expired.', 'wpjobster' )
			]
		]);

		$shopping_page = apply_filters( 'wpj_shopping_page_status_filter', [
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'active', 'wpjobster' ),
				'description' => __( 'The job is active and you wait for the seller to deliver.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green',
				'title'       => __( 'active', 'wpjobster' ),
				'description' => __( 'The job is active and the seller is waiting for your answer.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange oe-full',
				'title'       => __( 'pending', 'wpjobster' ),
				'description' => __( 'The buyer has not yet made the payment.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange',
				'title'       => __( 'modification', 'wpjobster' ),
				'description' => __( 'You requested a modification of the current job.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red oe-full',
				'title'       => __( 'problem', 'wpjobster' ),
				'description' => __( 'You requested a cancellation for the transaction.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red',
				'title'       => __( 'problem', 'wpjobster' ),
				'description' => __( 'The seller requested a cancellation and you need to respond.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'delivered', 'wpjobster' ),
				'description' => __( 'The job was delivered and you have to review it.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green-txt',
				'title'       => __( 'completed', 'wpjobster' ),
				'description' => __( 'The transaction was completed and accepted by you.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red-txt',
				'title'       => __( 'cancelled', 'wpjobster' ),
				'description' => __( 'You and the seller agreed to cancel the transaction.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red oe-full',
				'title'       => __( 'failed', 'wpjobster' ),
				'description' => __( 'Buyer\'s payment was declined', 'wpjobster' )
			],
			[
				'class'       => 'oe-burgundy',
				'title'       => __( 'expired', 'wpjobster' ),
				'description' => sprintf( __( 'More than %s days passed without the buyer paying', 'wpjobster' ), ( ! wpj_get_option( 'wpjobster_pending_jobs_days' ) && wpj_get_option( 'wpjobster_pending_jobs_days' ) == 0 ? 7 : wpj_get_option( 'wpjobster_pending_jobs_days' ) ) )
			]
		]);

		$sales_page = apply_filters( 'wpj_sales_page_status_filter', [
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'active', 'wpjobster' ),
				'description' => __( 'The job is active and you wait for an answer from the buyer.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green',
				'title'       => __( 'active', 'wpjobster' ),
				'description' => __( 'The job is active and the buyer is waiting for you to deliver.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange',
				'title'       => __( 'pending', 'wpjobster' ),
				'description' => __( 'The buyer has not yet made the payment.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange',
				'title'       => __( 'processing', 'wpjobster' ),
				'description' => __( 'The job has been paid and payment confirmation is awaited.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange',
				'title'       => __( 'modification', 'wpjobster' ),
				'description' => __( 'The buyer requested a modification and you need to deliver the job again.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red oe-full',
				'title'       => __( 'problem', 'wpjobster' ),
				'description' => __( 'You requested a cancellation for the current job.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red',
				'title'       => __( 'problem', 'wpjobster' ),
				'description' => __( 'The buyer requested a cancellation and you need to respond.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'delivered', 'wpjobster' ),
				'description' => __( 'You delivered the job and wait for the buyer to accept.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green-txt',
				'title'       => __( 'completed', 'wpjobster' ),
				'description' => __( 'The transaction was completed and accepted by the buyer.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red-txt',
				'title'       => __( 'cancelled', 'wpjobster' ),
				'description' => __( 'You and the buyer agreed to cancel the transaction.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red',
				'title'       => __( 'failed', 'wpjobster' ),
				'description' => __( 'Buyer\'s payment was declined', 'wpjobster' )
			],
			[
				'class'       => 'oe-burgundy',
				'title'       => __( 'expired', 'wpjobster' ),
				'description' => sprintf( __( 'More than %s days passed without the buyer paying', 'wpjobster' ), ( ! wpj_get_option( 'wpjobster_pending_jobs_days' ) && wpj_get_option( 'wpjobster_pending_jobs_days' ) == 0 ? 7 : wpj_get_option( 'wpjobster_pending_jobs_days' ) ) )
			]
		]);

		$request_page = apply_filters( 'wpj_request_page_status_filter', [
			[
				'class'       => 'oe-green oe-full',
				'title'       => __( 'published', 'wpjobster' ),
				'description' => __( 'Your request is visible and can be taken by all users.', 'wpjobster' )
			],
			[
				'class'       => 'oe-yellow oe-full',
				'title'       => __( 'paused', 'wpjobster' ),
				'description' => __( 'No one can see your Request. You may reactivate it whenever you like.', 'wpjobster' )
			],
			[
				'class'       => 'oe-orange oe-full',
				'title'       => __( 'pending', 'wpjobster' ),
				'description' => __( 'Your request is pending review and is not yet available.', 'wpjobster' )
			],
			[
				'class'       => 'oe-red oe-full',
				'title'       => __( 'rejected', 'wpjobster' ),
				'description' => __( 'Your request failed to pass our review and is not visible to anyone.', 'wpjobster' )
			],
			[
				'class'       => 'oe-burgundy oe-full',
				'title'       => __( 'assigned', 'wpjobster' ),
				'description' => __( 'Your request is assigned to a seller.', 'wpjobster' )
			],
			[
				'class'       => 'oe-green-txt',
				'title'       => __( 'completed', 'wpjobster' ),
				'description' => __( 'Your request was completed.', 'wpjobster' )
			]
		]);

		return ${$page . '_page'};
	}
}