<?php
if ( ! function_exists( 'wpj_get_user_level' ) ) {
	function wpj_get_user_level( $userid ) {
		$user_level = get_user_meta( $userid, 'user_level', true );

		if ( empty( $user_level ) && $user_level !== '0' ) {
			$wpjobster_default_level_nr = wpj_get_option( 'wpjobster_default_level_nr' );

			if ( $wpjobster_default_level_nr == '0' )
				$user_level = 0;
			else
				$user_level = $wpjobster_default_level_nr;
		}

		return $user_level;
	}
}

if ( ! function_exists( 'wpj_do_user_level_extras_check' ) ) {
	function wpj_do_user_level_extras_check( $userid ) {
		$level_chk = new WP_Query( "meta_key=closed&meta_value=0&post_status=publish,draft,pending&post_type=job&order=DESC&orderby=id&author=" . $userid );

		if ( $level_chk->have_posts() ) {
			$user_level = wpj_get_user_level( $userid );
			$total_allowed_extras = wpj_get_option( 'wpjobster_get_level' . $user_level . '_extras' );

			$wpjobster_subscription_info = wpj_get_subscription_info( $userid );

			/**
			 * @var number $wpjobster_subscription_noof_extras
			 */
			extract( $wpjobster_subscription_info );

			if ( $wpjobster_subscription_noof_extras )
				$total_allowed_extras =  $wpjobster_subscription_noof_extras;

			if ( ! is_numeric( $total_allowed_extras ) )
				$total_allowed_extras = 3;

			while ( $level_chk->have_posts() ) { $level_chk->the_post();
				$post_id = get_the_ID();

				$all_extras = 0;

				for ( $k_extras = 1; $k_extras <= 10; $k_extras++ ) {
					$extra_price = get_post_meta( $post_id, 'extra' . $k_extras . '_price', true );

					if ( trim( $extra_price ) != '' && trim( $extra_price ) != '0' ) $all_extras++;
				}

				if ( $all_extras > $total_allowed_extras ) {
					wpj_deactivate_job( $post_id, 'too_many_extras_added' );
					update_post_meta( $post_id, 'more_extras', 'yes' );

				} else {
					$more_extras = get_post_meta( $post_id, 'more_extras', true );

					if ( $more_extras == 'yes' ) {
						delete_post_meta( $post_id, 'more_extras' );

						$wpjobster_admin_approve_job = wpj_get_option( 'wpjobster_admin_approve_job' );

						if ( $wpjobster_admin_approve_job == "yes" ) {
							wp_update_post( ['ID' => $post_id, 'post_status' => 'draft'] );
							update_post_meta( $post_id, 'under_review', "1" );

						} else {
							wp_update_post( ['ID' => $post_id, 'post_status' => 'publish'] );
							update_post_meta( $post_id, 'under_review', "0" );

						}
					}
				}
			}

			wp_reset_query();
		}
	}
}

if ( ! function_exists( 'wpj_do_user_level_job_price_check' ) ) {
	function wpj_do_user_level_job_price_check( $userid ) {
		$level_chk = new WP_Query( "meta_key=closed&meta_value=0&post_status=publish,draft,pending&post_type=job&order=DESC&orderby=id&author=" . $userid );

		if ( $level_chk->have_posts() ) {
			$user_level = wpj_get_user_level( $userid );
			$job_price_allowed = wpj_get_option( 'wpjobster_level' . $user_level . '_max' );

			$wpjobster_subscription_info = wpj_get_subscription_info( $userid );

			/**
			 * @var number $wpjobster_subscription_max_job_price
			 */
			extract( $wpjobster_subscription_info );

			if ( $wpjobster_subscription_max_job_price )
				$job_price_allowed = $wpjobster_subscription_max_job_price;

			while ( $level_chk->have_posts() ) { $level_chk->the_post();
				$post_id = get_the_ID();

				$job_price = get_post_meta( $post_id, "price", true );

				if ( $job_price > $job_price_allowed ) {
					update_post_meta( $post_id, 'more_job_price', 'yes' );
					wpj_deactivate_job( $post_id, 'job_price_too_high' );

				} else {
					$more_job_price = get_post_meta( $post_id, 'more_job_price', true );

					if ( $more_job_price == 'yes' ) {
						delete_post_meta( $post_id, 'more_job_price' );

						$wpjobster_admin_approve_job = wpj_get_option( 'wpjobster_admin_approve_job' );

						if ( $wpjobster_admin_approve_job == "yes" ) {
							wp_update_post( ['ID' => $post_id, 'post_status' => 'draft'] );
							update_post_meta( $post_id, 'under_review', "1" );

						} else {
							wp_update_post( ['ID' => $post_id, 'post_status' => 'publish'] );
							update_post_meta( $post_id, 'under_review', "0" );

						}
					}
				}
			}

			wp_reset_query();
		}
	}
}

if ( ! function_exists( 'wpj_do_user_level_extras_price_check' ) ) {
	function wpj_do_user_level_extras_price_check( $userid, $pid = 0 ) {

		if ( $pid != 0 ) $pid_stmt = "&p=$pid";
		else $pid_stmt = "";

		$level_chk = new WP_Query( "meta_key=closed&meta_value=0&post_status=publish,draft,pending&post_type=job&order=DESC&orderby=id&author=" . $userid . $pid_stmt );

		if ( $level_chk->have_posts() ) {
			$user_level = wpj_get_user_level( $userid );
			$max_allowed_extra_price = wpj_get_option( 'wpjobster_level' . $user_level . '_max' );

			$wpjobster_subscription_info = wpj_get_subscription_info( $userid );

			/**
			 * @var number $wpjobster_subscription_max_job_price
			 * @var number $wpjobster_subscription_max_extra_price
			 * @var number $wpjobster_subscription_noof_extras
			 */
			extract( $wpjobster_subscription_info );

			if ( $wpjobster_subscription_max_job_price ) {
				$max_allowed_extra_price = $wpjobster_subscription_max_extra_price;
			}

			if ( ! $max_allowed_extra_price ) {
				return false;
			}

			while ( $level_chk->have_posts() ) { $level_chk->the_post();
				$post_id = get_the_ID();

				$do_more = 1;

				for ( $i = 1; $i <= $wpjobster_subscription_noof_extras && $do_more == 1; $i++ ) {
					$cur_extra_price = ( int )get_post_meta( $post_id, 'extra' . $i . '_price', true );

					if ( $cur_extra_price > $max_allowed_extra_price ) {
						update_post_meta( $post_id, 'more_extra_price', 'yes' );

						$do_more = 0;

						wpj_deactivate_job( $post_id, 'extras_price_too_high' );
					}

					if ( $i == $wpjobster_subscription_noof_extras && $do_more == 1 ) {

						if ( get_post_meta( $post_id, "more_extra_price", true ) == 'yes' ) {
							delete_post_meta( $post_id, 'more_extra_price' );

							$wpjobster_admin_approve_job = wpj_get_option( 'wpjobster_admin_approve_job' );

							if ( $wpjobster_admin_approve_job == "yes" ) {
								wp_update_post( ['ID' => $post_id, 'post_status' => 'draft'] );
								update_post_meta( $post_id, 'under_review', "1" );

							} else {
								wp_update_post( ['ID' => $post_id, 'post_status' => 'publish'] );
								update_post_meta( $post_id, 'under_review', "0" );

							}
						}
					}
				}
			}

			wp_reset_query();
		}

		return true;
	}
}