<?php
if ( ! function_exists( 'wpj_get_parameters_from_given_URL' ) ) {
	function wpj_get_parameters_from_given_URL( $url = '', $param = '' ) {
		if ( $url ) {
			$components = parse_url( $url );

			if ( ! empty( $components['query'] ) ) {
				parse_str( $components['query'], $params );

				if ( $param && isset( $params[$param] ) )
					return $params[$param];

				if ( $params )
					return $params;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_use_permalinks' ) ) {
	function wpj_use_permalinks() {
		global $wp_rewrite;

		if ( $wp_rewrite->using_permalinks() )
			return true;
		else
			return false;
	}
}

if ( ! function_exists( 'wpj_get_link_by_page_id_name' ) ) {
	function wpj_get_link_by_page_id_name( $page_id = '' ) {
		if ( $page_id == 'register' )
			return esc_url( wpj_get_register_link() );

		elseif ( $page_id == 'login' )
			return esc_url( wpj_get_login_link() );

		elseif ( $page_id == 'lostpassword' )
			return esc_url( wpj_get_lostpassword_link() );

		else
			return get_permalink( wpj_get_option( $page_id ) );
	}
}

if ( ! function_exists( 'wpj_get_site_url_link' ) ) {
	function wpj_get_site_url_link() {
		return get_site_url();
	}
}

if ( ! function_exists( 'wpj_is_ajax_call' ) ) {
	function wpj_is_ajax_call() {
		if ( wp_doing_ajax() ) return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_generate_settings_link' ) ) {
	function wpj_generate_settings_link( $plugin = '' ) {
		return '<a href="' . admin_url( 'admin.php?page=jobster-settings&tab=' . wpj_get_settings_tab_number_by_field_id( $plugin . '-settings' ) ) . '">' . __( 'Settings', 'wpjobster' ) . '</a>';
	}
}

if ( ! function_exists( 'wpj_get_my_account_link' ) ) {
	function wpj_get_my_account_link() {
		return get_permalink( wpj_get_option( 'wpjobster_my_account_page_id' ) );
	}
}

if ( ! function_exists( 'wpj_get_my_sales_link' ) ) {
	function wpj_get_my_sales_link() {
		$using_perm = wpj_use_permalinks();

		if ( $using_perm ) {
			return get_permalink( wpj_get_option( 'wpjobster_my_account_sales_page_id' ) );

		} else {
			return get_bloginfo( 'url' ) . "/?page_id=" . wpj_get_option( 'wpjobster_my_account_sales_page_id' ) . "&";

		}
	}
}

if ( ! function_exists( 'wpj_get_my_shopping_link' ) ) {
	function wpj_get_my_shopping_link() {
		$using_perm = wpj_use_permalinks();

		if ( $using_perm ) {
			return get_permalink( wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) );

		} else {
			return get_bloginfo( 'url' ) . "/?page_id=" . wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) . "&";

		}
	}
}

if ( ! function_exists( 'wpj_get_my_settings_link' ) ) {
	function wpj_get_my_settings_link() {
		return get_permalink( wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ) );
	}
}

if ( ! function_exists( 'wpj_get_new_job_link' ) ) {
	function wpj_get_new_job_link() {
		return get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) );
	}
}

if ( ! function_exists( 'wpj_get_new_request_link' ) ) {
	function wpj_get_new_request_link() {
		return get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) );
	}
}

if ( ! function_exists( 'wpj_get_user_profile_link' ) ) {
	function wpj_get_user_profile_link( $user = false ) {
		$user_profile_page_id = wpj_get_option( 'wpjobster_user_profile_page_id' );

		if ( $user === false ) {
			return get_permalink( $user_profile_page_id );

		} elseif ( is_object( $user ) ) {
			$userdata = get_userdata( $user->ID );

		} elseif ( is_numeric( $user ) ) {
			$userdata = get_userdata( $user );

		} elseif ( is_string( $user ) ) {
			$userdata = get_user_by( 'login', $user );

		} else {
			return get_permalink( $user_profile_page_id );

		}

		if ( is_object( $userdata ) && ! empty( $userdata->user_login ) ) {
			$user_login = $userdata->user_login;

		} else {
			return get_permalink( $user_profile_page_id );

		}

		return get_permalink( $user_profile_page_id ) . $user_login . ( $user_login ? '/' : '' );
	}
}

if ( ! function_exists( 'wpj_get_pm_link' ) ) {
	function wpj_get_pm_link( $user = '', $message_id = '' ) {
		$pm_page_id = wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' );

		if ( $user === false ) {
			return get_permalink( $pm_page_id );

		} elseif ( is_object( $user ) ) {
			$userdata   = get_userdata( $user->ID );
			$user_login = $userdata->user_login;

		} elseif ( is_numeric( $user ) ) {
			$userdata = get_userdata( $user );

			if ( ! is_object( $userdata ) ) {
				$user_login = $user;

			} else {
				$user_login = $userdata->user_login;

			}

		} elseif ( is_string( $user ) ) {
			$user_login = $user;

		}

		if ( empty( $user_login ) ) {
			return get_permalink( $pm_page_id );

		} else {
			return get_permalink( $pm_page_id ) . $user_login . ( $message_id ? '/' . $message_id : '' );

		}
	}
}

if ( ! function_exists( 'wpj_get_subscription_link' ) ) {
	function wpj_get_subscription_link() {
		return get_permalink( wpj_get_option( 'wpjobster_subscriptions_page_id' ) );
	}
}

if ( ! function_exists( 'wpj_get_payment_link' ) ) {
	function wpj_get_payment_link() {
		$using_perm = wpj_use_permalinks();

		if ( $using_perm ) {
			return get_permalink( wpj_get_option( 'wpjobster_my_account_payments_page_id' ) );

		} else {
			return get_bloginfo( 'url' ) . "?page_id=" . wpj_get_option( 'wpjobster_my_account_payments_page_id' ) . "&";

		}
	}
}

if ( ! function_exists( 'wpj_get_order_link' ) ) {
	function wpj_get_order_link( $oid, $status = '', $payment_type = '' ) {
		if ( $status )
			return get_permalink( wpj_get_option( 'wpjobster_order_page_id' ) ) . $oid . "?status=" . $status;

		if ( $status )
			return get_permalink( wpj_get_option( 'wpjobster_order_page_id' ) ) . $oid . "?payment_type=" . $payment_type;

		if ( $status && $payment_type )
			return get_permalink( wpj_get_option( 'wpjobster_order_page_id' ) ) . $oid . "?status=" . $status . "&payment_type=" . $payment_type;

		return get_permalink( wpj_get_option( 'wpjobster_order_page_id' ) ) . $oid;
	}
}

if ( ! function_exists( 'wpj_get_admin_order_link' ) ) {
	function wpj_get_admin_order_link( $payment_type = '' ) {
		if ( $payment_type == 'topup' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=topup';

		} elseif ( $payment_type == 'feature' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=featured';

		} elseif ( $payment_type == 'custom_extra' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=custom-extra';

		} elseif ( $payment_type == 'tips' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=tips';

		} elseif ( $payment_type == 'badge' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=badge';

		} elseif ( $payment_type == 'subscription' ) {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders&active_tab=subscription';

		} else {
			$admin_orders_url = get_admin_url() . 'admin.php?page=jobster-orders';

		}

		return $admin_orders_url;
	}
}

if ( ! function_exists( 'wpj_get_order_link_by_payment_type' ) ) {
	function wpj_get_order_link_by_payment_type( $payment_type, $id = '', $status = false, $message = false ) {
		if ( $payment_type == 'feature' ) {
			$status  = $status ? '?status=' . $status : '';
			$sign    = ! $status && $message ? '?' : '&';
			$message = $message ? $sign . 'message=' . $message : '';

			$featured_order = wpj_get_feature_order( 'job_id', ['id' => $id], 'row' );

			if ( isset ( $featured_order->job_id ) ) {
				$job_post  = get_post( $featured_order->job_id );

				return get_permalink( wpj_get_option( 'wpjobster_feature_page_id' ) ) . $job_post->post_name . $status . $message;

			} else {
				return get_permalink( wpj_get_option( 'wpjobster_feature_page_id' ) );

			}

		} elseif ( $payment_type == 'topup' ) {
			return get_permalink( wpj_get_option( 'wpjobster_topup_order_page_id' ) ) . $id;

		} elseif ( $payment_type == 'job_purchase' || $payment_type == 'custom_extra' || $payment_type == 'tips' ) {
			return wpj_get_order_link( $id );

		} elseif ( $payment_type == 'subscription' ) {
			$status = $status ? '&' . $status . '=1' : '';

			return get_permalink( wpj_get_option( 'wpjobster_subscriptions_page_id' ) ) . '?sub_action=details' . $status . '&message_code=' . $message;

		} elseif ( $payment_type == 'badge' ) {
			return get_permalink( wpj_get_option( 'wpjobster_badges_page_id' ) );

		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_login_link' ) ) {
	function wpj_get_login_link( $redirect_to = '' ) {

		$login_url = wpj_get_option( 'wpjobster_login_page_id' ) ? get_permalink( wpj_get_option( 'wpjobster_login_page_id' ) ) : wp_login_url();

		if ( ! empty( $redirect_to ) ) {
			$login_url = add_query_arg( 'redirect_to', urlencode( $redirect_to ), $login_url );
		}

		return $login_url;
	}
}

if ( ! function_exists( 'wpj_get_register_link' ) ) {
	function wpj_get_register_link( $redirect_to = '' ) {

		$register_url = wpj_get_option( 'wpjobster_register_page_id' ) ? get_permalink( wpj_get_option( 'wpjobster_register_page_id' ) ) : get_site_url() . '/wp-login.php?action=register';
		// didn't use wp_registration_url() because there is a filter to register_url in hook.php that creates an infinite loop

		if ( ! empty( $redirect_to ) ) {
			$register_url = add_query_arg( 'redirect_to', urlencode( $redirect_to ), $register_url );
		}

		return $register_url;
	}
}

if ( ! function_exists( 'wpj_get_lostpassword_link' ) ) {
	function wpj_get_lostpassword_link( $redirect_to = '' ) {

		$lostpassword_url = wpj_get_option( 'wpjobster_forgot_password_page_id' ) ? get_permalink( wpj_get_option( 'wpjobster_forgot_password_page_id' ) ) : get_site_url() . '/wp-login.php?action=lostpassword';
		// didn't use wp_lostpassword_url() because there is a filter to lostpassword_url in hook.php that creates an infinite loop

		if ( ! empty( $redirect_to ) ) {
			$lostpassword_url = add_query_arg( 'redirect_to', urlencode( $redirect_to ), $lostpassword_url );
		}

		return $lostpassword_url;
	}
}

if ( ! function_exists( 'wpj_get_pm_with_job_link' ) ) {
	function wpj_get_pm_with_job_link( $uid = '', $pid = '' ) {
		if ( ! $uid )
			$uid = get_post_field( 'post_author', $pid );

		if ( ! $pid )
			$pid = wpj_get_post_id();

		return wpj_get_pm_link( $uid ) . '?job_id=' . $pid;
	}
}

if ( ! function_exists( 'wpj_get_feature_link' ) ) {
	function wpj_get_feature_link( $pid = '' ) {
		if ( ! $pid ) $pid = wpj_get_post_id();

		return get_permalink( wpj_get_option( 'wpjobster_feature_page_id' ) ) . get_post( $pid )->post_name;
	}
}
