<?php
if ( ! function_exists( 'wpj_maintain_log' ) ) {
	function wpj_maintain_log( $order = '' ) {
		if ( ! $order ) {
			global $wp_query;

			if ( ! empty( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$orderid         = $order->id;
		$job_title       = $order->job_title;
		$mc_gross        = $order->mc_gross;
		$uid             = $order->uid;
		$pid             = $order->pid;
		$seller_id       = get_post_field( 'post_author', $pid );
		$processing_fees = $order->processing_fees;
		$tax_amount      = $order->tax_amount;

		$order_url = wpj_get_order_link( $orderid );

		$reason = __( 'Payment made for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

		wpj_add_history_log( ['tp' => '0', 'reason' => $reason, 'amount' => $mc_gross, 'uid' => $uid, 'oid' => $orderid, 'rid' => 3] );

		do_action( 'wpj_after_payment_made_for_log', $order );

		if ( $processing_fees > 0 ) {
			$reason = __( 'Processing fee for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			wpj_add_history_log( ['tp' => '0', 'reason' => $reason, 'amount' => $processing_fees, 'uid' => $uid, 'oid' => $orderid, 'rid' => 13] );

			do_action( 'wpj_after_processing_fee_for_log', $order );
		}

		if ( $tax_amount > 0 ) {
			$reason = __( 'Tax for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			wpj_add_history_log( ['tp' => '0', 'reason' => $reason, 'amount' => $tax_amount, 'uid' => $uid, 'oid' => $orderid, 'rid' => 14] );

			do_action( 'wpj_after_tax_for_log', $order );
		}

		$reason = __( 'Payment collected for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

		wpj_add_history_log( ['tp' => '2', 'reason' => $reason, 'amount' => $mc_gross, 'uid' => $seller_id, 'oid' => $orderid, 'rid' => 4] );

		do_action( 'wpj_after_payment_collected_for_log', $order );

		wpj_notify_user_translated( 'job_admin_purchased', 'admin', [
			'##username##' => wpj_get_user_display_type( $seller_id ),
			'##job_name##' => $job_title,
			'##job_link##' => get_post_permalink( $pid )
		] );
	}
}

if ( ! function_exists( 'wpj_add_history_log' ) ) {
	function wpj_add_history_log( $args = [] ) {
		// $tp == 1     => (+) Money received
		// $tp == 0     => (-) Money paid
		// $tp == 2     => ( ) Money Pending

		// $rid == 1    => Payment received from Site Admin
		// $rid == 2    => Payment withdrawn by Site Admin
		// $rid == 3    => Payment made for:                   #ORDER_URL
		// $rid == 4    => Payment collected for:              #ORDER_URL
		// $rid == 5    => Payment cleared for:                #ORDER_URL
		// $rid == 6    => Fee charged for:                    #ORDER_URL
		// $rid == 7    => Payment refunded for:               #ORDER_URL
		// $rid == 8    => Payment refunded for:               #ORDER_URL
		// $rid == 9    => Withdrawal to                       #METHOD: #DETAILS
		// $rid == 10   => Feature job:                        $details = $pid
		// $rid == 11   => Payment for subscription            weekly-level1-new|change|renew
		// $rid == 12   => Top Up account balance
		// $rid == 13   => Processing fee for:                 #ORDER_URL
		// $rid == 14   => Tax for:                            #ORDER_URL
		// $rid == 15   => Payment received from Affiliate System
		// $rid == 16   => Processing fee for custom extra:    #ORDER_URL
		// $rid == 17   => Tax for custom extra:               #ORDER_URL
		// $rid == 18   => Custom extra:                       #ORDER_URL
		// $rid == 19   => Payment collected for custom extra: #ORDER_URL
		// $rid == 20   => Payoneer fee for:                   #ORDER_URL
		// $rid == 21   => Discount for:                       #ORDER_URL
		// $rid == 22   => Processing fee for tips:            #ORDER_URL
		// $rid == 23   => Tax for tips:                       #ORDER_URL
		// $rid == 24   => Tips:                               #ORDER_URL
		// $rid == 25   => Payment collected for tips:         #ORDER_URL
		// $rid == 26   => Badge

		$defaults = [
			'tp'        => '',
			'reason'    => '',
			'amount'    => 0,
			'uid'       => '',
			'oid'       => '',
			'rid'       => '',
			'details'   => '',
			'payed_amt' => ''
		];

		$args = wp_parse_args( $args, $defaults );

		/**
		 * @var int $tp
		 * @var string $reason
		 * @var number $amount
		 * @var int $uid
		 * @var int $oid
		 * @var int $rid
		 * @var string $details
		 * @var number $payed_amt
		 */
		extract( $args );

		if ( $payed_amt != '' ) {
			$payedamount = $payed_amt;

		} elseif ( $oid > 0 ) {
			$row =  wpj_get_job_order( $fields = 'payedamount, mc_gross', ['id' => $oid], 'row' );

			$price_array  = explode( '|', $row->payedamount );

			if ( empty( $price_array[0] ) ) {
				$currency = WPJ_Form::post( 'mc_currency', wpj_get_site_currency() );

			} else {
				$currency = $price_array[0];

			}

			$payedamount = $row->mc_gross > 0 ? ( $amount * $price_array[1] / $row->mc_gross ) : 0;
			$payedamount = $currency . '|' . wpj_number_format_special( $payedamount, 2 );

		} else {
			global $wpjobster_currencies_array;

			$payedamount = $wpjobster_currencies_array[0] . '|' . wpj_number_format_special( $amount, 2 );

		}

		$id = wpj_insert_payment_transaction(
			[
				'uid'         => $uid,
				'oid'         => $oid,
				'rid'         => $rid,
				'details'     => esc_sql( $details ),
				'reason'      => esc_sql( $reason ),
				'datemade'    => current_time( 'timestamp', 1 ),
				'amount'      => $amount,
				'tp'          => $tp,
				'payedamount' => $payedamount
			],
			['%d', '%d', '%d', '%s', '%s', '%d', '%d', '%d', '%s']
		);

		wpj_insert_user_credit_log( ['job_payment_transaction_id' => $id], ['%d'], $uid );
	}
}

if ( ! function_exists( 'wpj_save_log_file' ) ) {
	function wpj_save_log_file( $path, $text ) {
		$fp = fopen( $path, 'a' );

		fwrite( $fp, $text . "\n" );

		fclose( $fp );
	}
}