<?php
if ( ! function_exists( 'wpj_mobile_body_class' ) ) {
	function wpj_mobile_body_class( $classes ) {
		if ( ! is_admin() ) {
			if ( wpj_is_handheld() )
				$classes[] = 'wpj-is-handheld';

			if ( wpj_is_mobile() )
				$classes[] = 'wpj-is-mobile';

			if ( wpj_is_tablet() )
				$classes[] = 'wpj-is-tablet';

			if ( wpj_is_ios() )
				$classes[] = 'wpj-is-ios';

			if ( wpj_is_android() )
				$classes[] = 'wpj-is-android';

			if ( wpj_is_jobsterapp() )
				$classes[] = 'wpj-is-jobsterapp wpj-is-iframe';

			if ( wpj_is_iframe_previous_pageload() === true )
				$classes[] = 'wpj-is-iframe';

			if ( wpj_is_iframe_previous_pageload() === null )
				$classes[] = 'wpj-maybe-iframe';
		}

		return $classes;
	}
}

if ( ! function_exists( 'wpj_mobile_detect_globals' ) ) {
	function wpj_mobile_detect_globals() {
		$wpj_mobile_detect = new Mobile_Detect();
		$wpj_mobile_detect->setDetectionType( 'extended' );

		$GLOBALS['wpj_mobile_detect'] = $wpj_mobile_detect;
	}
}

if ( ! function_exists( 'wpj_is_iframe_previous_pageload' ) ) {
	function wpj_is_iframe_previous_pageload() {
		if ( isset( $_COOKIE['wpj_is_iframe'] ) && $_COOKIE['wpj_is_iframe'] === 'true' ) {
			return true;

		} elseif ( isset( $_COOKIE['wpj_is_iframe'] ) && $_COOKIE['wpj_is_iframe'] === 'false' ) {
			return false;

		}

		return null;
	}
}

// detect any handheld device (both phone and tablet)
if ( ! function_exists( 'wpj_is_handheld' ) ) {
	function wpj_is_handheld() {
		global $wpj_mobile_detect;

		if ( ! $wpj_mobile_detect ) {
			$wpj_mobile_detect = new Mobile_Detect();
			$wpj_mobile_detect->setDetectionType( 'extended' );
		}

		if ( method_exists( $wpj_mobile_detect, 'isMobile' ) && is_callable( [$wpj_mobile_detect, 'isMobile'] ) ) {
			return apply_filters( 'wpj_is_handheld', $wpj_mobile_detect->isMobile(), $wpj_mobile_detect );
		}

		return false;
	}
}

// detect phone only (exclude tablets)
if ( ! function_exists( 'wpj_is_mobile' ) ) {
	function wpj_is_mobile() {
		global $wpj_mobile_detect;

		$result = null;

		if ( wpj_is_tablet() ) {
			$result = false;

		} else {
			$result = method_exists( $wpj_mobile_detect, 'isMobile' ) && is_callable( [$wpj_mobile_detect, 'isMobile'] ) ? $wpj_mobile_detect->isMobile() : false;

		}

		return apply_filters( 'wpj_is_mobile', $result, $wpj_mobile_detect );
	}
}

// detect tablet only
if ( ! function_exists( 'wpj_is_tablet' ) ) {
	function wpj_is_tablet() {
		global $wpj_mobile_detect;

		if ( method_exists( $wpj_mobile_detect, 'isTablet' ) && is_callable( [$wpj_mobile_detect, 'isTablet'] ) ) {
			return apply_filters( 'wpj_is_tablet', $wpj_mobile_detect->isTablet(), $wpj_mobile_detect );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_ios' ) ) {
	function wpj_is_ios() {
		global $wpj_mobile_detect;

		if ( method_exists( $wpj_mobile_detect, 'isiOS' ) && is_callable( [$wpj_mobile_detect, 'isiOS'] ) ) {
			return apply_filters( 'wpj_is_ios', $wpj_mobile_detect->isiOS(), $wpj_mobile_detect );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_android' ) ) {
	function wpj_is_android() {
		global $wpj_mobile_detect;

		if ( method_exists( $wpj_mobile_detect, 'isAndroidOS' ) && is_callable( [$wpj_mobile_detect, 'isAndroidOS'] ) ) {
			return apply_filters( 'wpj_is_android', $wpj_mobile_detect->isAndroidOS(), $wpj_mobile_detect );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_jobsterapp' ) ) {
	function wpj_is_jobsterapp() {
		global $wpj_mobile_detect;

		if ( method_exists( $wpj_mobile_detect, 'match' ) && is_callable( array( $wpj_mobile_detect, 'match' ) ) ) {
			return apply_filters( 'wpj_is_jobsterapp', $wpj_mobile_detect->match( 'JobsterApp' ), $wpj_mobile_detect );
		}
	}
}
