<?php

// Init options
if ( ! function_exists( 'wpj_get_option' ) ) {
	function wpj_get_option( $option ) {
		$options = get_option( 'jobster_settings' );

		$field      = get_option( 'jobster_settings_structure' );
		$field_type = isset( $field[$option] ) ? $field[$option] : '';

		if ( ! $field_type ) {
			if ( class_exists( 'Redux' ) && isset( $options[$option] ) ) {
				$field      = Redux::get_field( 'jobster_settings', $option );
				$field_type = isset( $field['type'] ) ? $field['type'] : '';
			}
		}

		if ( isset( $options[$option] ) && $field_type == 'switch' && $options[$option] == '1' )
			return 'yes';

		elseif ( isset( $options[$option] ) && $field_type == 'switch' && ( $options[$option] == '0' || $options[$option] == '' ) )
			return 'no';

		else
			return isset( $options[$option] ) ? $options[$option] : get_option( $option );
	}
}

if ( ! function_exists( 'wpj_get_design_option' ) ) {
	function wpj_get_design_option( $option = '' ) {
		$options = get_option( 'jobster_design' );

		if ( $option )
			return isset( $options[$option] ) ? $options[$option] : get_option( $option );

		else
			return $options;
	}
}

// Check options
if ( ! function_exists( 'wpj_bool_option' ) ) {
	function wpj_bool_option( $option ) {
		// returns true and false for options set as "yes" and "no"
		// returns true and false for options set as "true" and "false", case insensitive
		// returns false for empty() which includes:
		// str "", FALSE, [], NULL, str "0", int 0, float 0.0, empty $var

		$get_option = wpj_get_option( $option );

		if ( strtolower( $get_option ) === 'no'
			|| strtolower( $get_option ) === 'false'
			|| empty( $get_option )
		) {
			return false;
		}

		return true;
	}
}