<?php
if ( ! function_exists( 'wpj_get_seller_id' ) ) {
	function wpj_get_seller_id( $order = '' ) {
		if ( is_object( $order ) ) {
			$pid = wpj_get_job_order( 'pid', ['id' => $order->id], 'var' );

		} elseif ( is_numeric( $order ) ) {
			$pid = wpj_get_job_order( 'pid', ['id' => $order], 'var' );

		} elseif ( ! $order ) {
			global $wp_query;

			if ( ! empty( $wp_query->query_vars['oid'] ) ) {
				$pid = wpj_get_job_order( 'pid', ['id' => $wp_query->query_vars['oid']], 'var' );
			}
		}

		if ( empty( $pid ) ) {
			$pid = wpj_get_post_id();
		}

		return ! empty( $pid ) ? get_post_field( 'post_author', $pid ) : 0;
	}
}

if ( ! function_exists( 'wpj_get_buyer_id' ) ) {
	function wpj_get_buyer_id( $order = '' ) {
		if ( is_object( $order ) ) {
			return $order->uid;

		} elseif ( is_numeric( $order ) ) {
			return wpj_get_job_order( 'uid', ['id' => $order], 'var' );

		} elseif ( ! $order ) {
			global $wp_query;

			if ( ! empty( $wp_query->query_vars['oid'] ) ) {
				return wpj_get_job_order( 'uid', ['id' => $wp_query->query_vars['oid']], 'var' );
			}
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_get_buyer_by_payment_type' ) ) {
	function wpj_get_buyer_by_payment_type( $oid = '', $payment_type = '' ) {
		if ( $payment_type == 'topup' ) {
			return wpj_get_topup_order( 'user_id', ['id' => $oid], 'var' );

		} elseif ( $payment_type == 'feature' ) {
			return wpj_get_feature_order( 'user_id', ['id' => $oid], 'var' );

		} elseif ( $payment_type == 'custom_extra' ) {
			return wpj_get_custom_extra_order( 'user_id', ['id' => $oid], 'var' );

		} elseif ( $payment_type == 'tips' ) {
			return wpj_get_tips_order( 'user_id', ['id' => $oid], 'var' );

		} elseif ( $payment_type == 'subscription' ) {
			return wpj_get_subscription_order( 'user_id', ['id' => $oid], 'var' );

		} elseif ( $payment_type == 'badge' ) {
			return wpj_get_badge_order( 'user_id', ['id' => $oid], 'var' );

		} else {
			return wpj_get_job_order( 'uid', ['id' => $oid], 'var' );

		}
	}
}

if ( ! function_exists( 'wpj_get_order_status' ) ) {
	function wpj_get_order_status( $oid = '', $include_parentheses = true ) {
		if ( ! $oid ) {
			global $wp_query;

			if ( isset( $wp_query->query_vars['oid'] ) ) {
				$oid = esc_sql( $wp_query->query_vars['oid'] );
			}
		}

		$payment_status = wpj_get_job_order( 'payment_status', ['id' => $oid], 'var' );

		if ( $payment_status == 'pending' ) {
			$order_status = __( 'Deposit Waiting', 'wpjobster' );

		} elseif ( $payment_status == 'failed' ) {
			$order_status = __( 'Failed', 'wpjobster' );

		} elseif ( $payment_status == 'processing' ) {
			$order_status = __( 'Processing', 'wpjobster' );

		} elseif ( $payment_status == 'cancelled' ) {
			$order_status = __( 'Cancelled', 'wpjobster' );

		} elseif ( $payment_status == 'expired' ) {
			$order_status = __( 'Expired', 'wpjobster' );

		} elseif ( $payment_status != 'completed' && $payment_status ) {
			$order_status = wpj_translate_string( $payment_status );

		} elseif ( $payment_status ) {
			$order_status = __( 'Paid', 'wpjobster' );

		}

		return ! empty( $order_status ) ? ( $include_parentheses && $include_parentheses != 'false' ? ' (' . $order_status . ')' : $order_status ) : false;
	}
}

if ( ! function_exists( 'wpj_get_order_by_payment_type' ) ) {
	function wpj_get_order_by_payment_type( $payment_type = '', $oid = '', $return = '' ) {
		if ( is_numeric( $oid ) && $payment_type ) {
			if ( $payment_type == 'topup' )
				$order = wpj_get_topup_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'feature' )
				$order = wpj_get_feature_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'custom_extra' )
				$order = wpj_get_custom_extra_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'tips' )
				$order = wpj_get_tips_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'subscription' )
				$order = wpj_get_subscription_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'badge' )
				$order = wpj_get_badge_order( '*', ['id' => $oid], 'row' );

			elseif ( $payment_type == 'job_purchase' )
				$order = wpj_get_job_order( '*', ['id' => $oid], 'row' );

			return $return && isset( $order->$return ) ? $order->$return : $order;
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_orders_in_queue_count' ) ) {
	function wpj_get_orders_in_queue_count( $pid ) {
		if ( ! $pid ) {
			$pid = wpj_get_post_id();
		}

		$fake_queue      = get_post_meta( $pid, "fake_queue", true );
		$fake_queue_rand = get_post_meta( $pid, "fake_queue_rand", true );
		$fake_queue_exp  = get_post_meta( $pid, "fake_queue_exp", true );

		if ( $fake_queue ) {
			if ( $fake_queue_exp > current_time( 'timestamp', 1 ) ) {
				return $fake_queue_rand;

			} else {
				$rand = $fake_queue + rand( 0, round( $fake_queue / 3 ) );

				update_post_meta( $pid, 'fake_queue_exp', strtotime( "+3 days" ) );
				update_post_meta( $pid, 'fake_queue_rand', $rand );

				return $rand;
			}

		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_update_order_meta' ) ) {
	function wpj_update_order_meta( $oid = '', $meta_key = '', $meta_value = '' ) {
		if ( ! $oid ) {
			global $wp_query;

			if ( isset( $wp_query->query_vars['oid'] ) ) {
				$oid = esc_sql( $wp_query->query_vars['oid'] );
			}
		}

		$meta_key   = esc_sql( $meta_key );
		$meta_value = esc_sql( maybe_serialize( wpj_encode_emoji( $meta_value ) ) );

		if ( is_numeric( $oid ) ) {
			$result = wpj_update_job_order( [$meta_key => $meta_value], ['id' => $oid] );

			if ( $result ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_camouflage_oid' ) ) {
	function wpj_camouflage_oid( $oid = '', $date = '' ) {
		if ( ! $oid ) {
			global $wp_query;

			if ( isset( $wp_query->query_vars['oid'] ) ) {
				$oid = esc_sql( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! $date ) {
			$date = wpj_get_job_order( 'date_made', ['id' => $oid], 'var' );
		}

		if ( $date ) {
			$ret = 'I';
			$ret = $ret . date( "j", $date );
			$ret = $ret . date( "n", $date );
			$ret = $ret . 'D';

			$half = round( strlen( $oid ) / 2 );
			$end  = strlen( $oid );
			$ids  = str_split( $oid );

			for ( $i = 0; $i < $half; $i++ ) $ret = $ret . $ids[$i];

			$ret = $ret . date( "y", $date );

			for ( $i = $half; $i < $end; $i++ ) $ret = $ret . $ids[$i];

			return $ret;
		}

		return __( 'unknown', 'wpjobster' );
	}
}

if ( ! function_exists( 'wpj_get_checkout_total_price' ) ) {
	function wpj_get_checkout_total_price( $payment_type, $pid = '' ) {
		$order_price = 0;

		if ( ! $pid ) $pid = wpj_get_post_id( $pid );

		if ( $payment_type == 'badge' ) {
			$badges_data = wpj_get_badge_info();

			if ( ! empty( $badges_data['wpj_badge_price'] ) && is_array( $badges_data['wpj_badge_price'] ) )
				$order_price = min( $badges_data['wpj_badge_price'] );

		} elseif ( $payment_type == 'job_purchase' ) {
			$order_price = get_post_meta( wpj_get_post_id(), 'price', true );

			if ( ! is_numeric( $order_price ) || $order_price < 0 )
				$order_price = wpj_get_option( 'wpjobster_job_fixed_amount' );

			if ( get_post_meta( $pid, 'job_packages', true ) == 'yes' )
				$order_price = get_post_meta( $pid, 'package_price', true );

		} elseif ( $payment_type == 'featured' ) {
			if ( wpj_get_option( 'wpjobster_featured_price_homepage' ) || wpj_get_option( 'wpjobster_featured_price_category' ) || wpj_get_option( 'wpjobster_featured_price_subcategory' ) )
				$order_price = min([
					wpj_get_option( 'wpjobster_featured_price_homepage' ),
					wpj_get_option( 'wpjobster_featured_price_category' ),
					wpj_get_option( 'wpjobster_featured_price_subcategory' )
				]);

		} elseif ( $payment_type == 'topup' ) {
			$topup_data = wpj_get_option( 'topup-packages-settings' );

			if ( ! empty( $topup_data['topup_cost'] ) && is_array( $topup_data['topup_cost'] ) )
				$order_price = min( $topup_data['topup_cost'] );

		} elseif ( $payment_type == 'subscription' ) {
			if ( wpj_get_subscription_min_price_by_level( 1 ) || wpj_get_subscription_min_price_by_level( 2 ) || wpj_get_subscription_min_price_by_level( 3 ) )
				$order_price = min([
					wpj_get_subscription_min_price_by_level( 1 ),
					wpj_get_subscription_min_price_by_level( 2 ),
					wpj_get_subscription_min_price_by_level( 3 )
				]);

		} elseif ( $payment_type == 'custom_extra' ) {
			$custom_extra = wpj_get_payment_info_by_url( 'custom_extra' );

			if ( ! empty( $custom_extra->price ) )
				$order_price  = $custom_extra->price;

		} elseif ( $payment_type == 'tips' ) {
			$tip = wpj_get_payment_info_by_url( 'tip' );

			if ( ! empty( $tip->amount ) )
				$order_price = $tip->amount;

		}

		return $order_price;
	}
}

if ( ! function_exists( 'wpj_get_order_total_price' ) ) {
	function wpj_get_order_total_price( $order = '', $return = '' ) {
		if ( ! $order ) {
			global $wp_query;

			if ( isset( $wp_query->query_vars['oid'] ) ) {
				$order = esc_sql( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			$raw_amount      = $order->mc_gross;
			$processing_fees = $order->processing_fees;
			$tax_amount      = $order->tax_amount;

			// shipping
			$shipping = get_post_meta( $order->pid, 'shipping', true );

			if ( ! $shipping ) $shipping = 0;

			// extras
			$extras_price = 0;

			if ( $order->extra_fast != 0 ) $extras_price += $order->extra_fast_price * $order->extra_fast;

			if ( $order->extra_revision != 0 ) $extras_price += $order->extra_revision_price * $order->extra_revision;

			for ( $i = 1; $i <= 10; $i++ ) {
				if ( $order->{'extra' . $i} != 0 )
					$extras_price += $order->{'extra' . $i . '_price'} * $order->{'extra' . $i};
			}

			// check custom extra
			if ( ! empty ( $order->custom_extras ) ) {
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );

				if ( $custom_extras ) { $i = 0;
					foreach ( $custom_extras as $custom_extra ) {
						if ( $custom_extra->paid ) {
							$custom_extra_order = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $i], 'row' );

							if ( $custom_extra_order ) {
								$raw_amount      += isset( $custom_extra->price ) ? $custom_extra->price : 0;
								$processing_fees += isset( $custom_extra->processing_fees ) ? $custom_extra->processing_fees : 0;
								$tax_amount      += isset( $custom_extra->tax ) ? $custom_extra->tax : 0;
							} $i++;
						}
					}
				}
			}

			// check tips
			if ( ! empty ( $order->tips ) ) {
				$tips = wpj_json_decode( wpj_stripslashes( $order->tips ) );

				if ( $tips ) { $j = 0;
					foreach ( $tips as $tip ) {
						if ( $tip->paid ) {
							$tips_order = wpj_get_tips_order( '*', ['order_id' => $order->id, 'tips_id' => $j], 'row' );

							if ( $tips_order ) {
								$raw_amount      += isset( $tip->amount ) ? $tip->amount : 0;
								$processing_fees += isset( $tip->processing_fees ) ? $tip->processing_fees : 0;
								$tax_amount      += isset( $tip->tax ) ? $tip->tax : 0;
							} $j++;
						}
					}
				}
			}

			$admin_fee = wpj_get_site_fee_by_amount( $raw_amount, $order->id, wpj_get_seller_id( $order ) );

			if ( ! is_numeric( $admin_fee ) ) $admin_fee = 0;

			$total_order_price = $raw_amount + $processing_fees + $tax_amount;

			$data = [
				'amount'            => $raw_amount,
				'shipping'          => $shipping,
				'extras'            => $extras_price,
				'admin_commission'  => $admin_fee,
				'seller_commission' => $raw_amount - $admin_fee,
				'buyer_fee'         => $processing_fees,
				'tax'               => $tax_amount,
				'total'             => $total_order_price,
			];

			if ( $return && isset( $data[$return] ) ) return $data[$return];

			return $data;

		}

		return 0;
	}
}