<?php
function wpj_mark_order_as_accepted( $oid = '' ) {
	if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( $oid ) {
			$order = wpj_get_job_order_by_id( $oid );

			if ( $order ) {
				if ( ! $order->seller_confirmation || $order->seller_confirmation == 0 ) {
					// Add extra time to timer
					$expected = wpj_get_expected_delivery( $order->id ) + ( current_time( 'timestamp', 1 ) - $order->date_made );

					// Insert to orders
					wpj_update_job_order( ['seller_confirmation' => 1, 'expected_delivery' => $expected], ['id' => $order->id] );

					// Insert notification
					$this_notification = wpj_insert_order_notification( ['uid' => -47, 'oid' => $order->id, 'content' => __( 'Accepted by Seller', 'wpjobster' )], ['%d', '%d', '%s'] );

					if ( $this_notification > 0 ) {
						// Update notification
						wpj_update_user_notifications([
							'user1'       => $order->uid,
							'user2'       => get_post_field( 'post_author', $order->pid ),
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification,
							'notify_type' => 'order_accepted',
							'order_id'    => $order->id
						]);

						// Send emails
						wpj_notify_user_translated( 'order_accepted', $order->uid, [
							'##job_name##'              => $order->job_title,
							'##job_link##'              => urldecode( get_permalink( $order->pid ) ),
							'##transaction_page_link##' => wpj_get_order_link( $order->id ),
							'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made )
						]);

						// Mark order as delivered if instant
						if ( get_post_meta( $order->pid, 'instant', true ) == '1' ) {
							wpj_mark_order_as_delivered( $order->id );
						}
					}
				}
			}
		}
	}

	if ( wpj_is_ajax_call() ) wp_die();
}

function wpj_mark_order_as_rejected( $oid = '' ) {
	if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( $oid ) {
			$order = wpj_get_job_order_by_id( $oid );

			if ( $order ) {
				if ( ! $order->seller_confirmation || $order->seller_confirmation == 0 ) {
					// Insert to orders
					wpj_update_job_order( ['seller_confirmation' => 2], ['id' => $order->id] );

					// Insert notification
					$this_notification = wpj_insert_order_notification( ['uid' => -48, 'oid' => $order->id, 'content' => __( 'Rejected by Seller', 'wpjobster' )], ['%d', '%d', '%s'] );

					if ( $this_notification > 0 ) {
						// Update notification
						wpj_update_user_notifications([
							'user1'       => $order->uid,
							'user2'       => get_post_field( 'post_author', $order->pid ),
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification,
							'notify_type' => 'order_rejected',
							'order_id'    => $order->id
						]);

						// Send emails
						wpj_notify_user_translated( 'order_rejected', $order->uid, [
							'##job_name##'              => $order->job_title,
							'##job_link##'              => urldecode( get_permalink( $order->pid ) ),
							'##transaction_page_link##' => wpj_get_order_link( $order->id ),
							'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made )
						]);

						// Cancel order and refund buyer
						wpj_cancel_order_by_id( $order->id, 'rejected' );
					}
				}
			}
		}
	}

	if ( wpj_is_ajax_call() ) wp_die();
}