<?php
if ( ! function_exists( 'wpj_request_arbitration' ) ) {
	function wpj_request_arbitration( $oid = '', $message = '' ) {
		$oid     = WPJ_Form::post( 'oid', $oid );
		$message = WPJ_Form::post( 'message_to_admin', $message );

		$arbitration_arr['msg'] = '';
		$arbitration_arr['err'] = 0;

		if ( ! is_demo_user() ) {
			if ( $message ) {
				if ( $oid ) {
					$order = wpj_get_job_order_by_id( $oid );

					if ( $order ) {
						$seller_id = get_post_field( 'post_author', $order->pid );
						$buyer_id  = $order->uid;

						if ( get_current_user_id() == $seller_id ) {
							$query_uid           = -39;
							$request_from_buyer  = 0;
							$request_from_seller = 1;
							$notify_uid          = $buyer_id;
							$notify_sender_uid   = $seller_id;

						} elseif ( get_current_user_id() == $buyer_id ) {
							$query_uid           = -40;
							$request_from_buyer  = 1;
							$request_from_seller = 0;
							$notify_uid          = $seller_id;
							$notify_sender_uid   = $buyer_id;

						}

						if ( isset( $query_uid ) ) {
							$arbitration_exist = wpj_get_arbitration_order( 'id', ['order_id' => $order->id], 'row' );

							if ( $arbitration_exist ) {
								wpj_update_arbitration_order(
									[
										'request_from_buyer'  => $request_from_buyer,
										'request_from_seller' => $request_from_seller,
										'date_request'        => current_time( 'timestamp', 1 ),
										'message_to_support'  => $message
									],
									['order_id' => $order->id]
								);

							} else {
								wpj_insert_arbitration_order(
									[
										'order_id'             => $order->id,
										'request_from_buyer'   => $request_from_buyer,
										'request_from_seller'  => $request_from_seller,
										'message_to_support'   => $message,
									],
									['%d', '%d', '%d', '%s']
								);

							}

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => $query_uid, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notifications
								wpj_update_user_notifications([
									'user1'       => $notify_uid,
									'user2'       => $notify_sender_uid,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'arb_new_request',
									'order_id'    => $order->id
								]);

								// Send emails
								$email_info = [
									'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
									'##job_name##'              => $order->job_title,
									'##job_link##'              => urldecode( get_permalink( $order->pid ) ),
									'##transaction_page_link##' => wpj_get_order_link( $order->id )
								];

								wpj_notify_user_translated( 'admin_arbitration', 'admin',  $email_info + ['##username##' => wpj_get_user_display_type( get_current_user_id() )] );
								wpj_notify_user_translated( 'arb_new_request', $buyer_id,  $email_info + ['##username##' => wpj_get_user_display_type( $buyer_id )] );
								wpj_notify_user_translated( 'arb_new_request', $seller_id, $email_info + ['##username##' => wpj_get_user_display_type( $seller_id )] );

								$arbitration_arr['msg'] = __( 'The request for arbitration has been sent to admin. You will be notified when the support has made a decision!', 'wpjobster' );
								$arbitration_arr['err'] = 0;
							}

						} else {
							$arbitration_arr['msg'] = __( 'You\'re not allowed to request arbitration because you are a demo user!', 'wpjobster' );
							$arbitration_arr['err'] = 1;

						}

					} else {
						$arbitration_arr['msg'] = __( 'Invalid Order!', 'wpjobster' );
						$arbitration_arr['err'] = 1;

					}

				} else {
					$arbitration_arr['msg'] = __( 'Invalid Order ID!', 'wpjobster' );
					$arbitration_arr['err'] = 1;

				}

			} else {
				$arbitration_arr['msg'] = __( 'The message can not be empty!', 'wpjobster' );
				$arbitration_arr['err'] = 1;

			}

		} else {
			$arbitration_arr['msg'] = __( 'You\'re not the buyer or the seller of this order!', 'wpjobster' );
			$arbitration_arr['err'] = 1;

		}

		if ( wpj_is_ajax_call() ) {
			echo json_encode( $arbitration_arr );
			wp_die();

		}

		return $arbitration_arr;
	}
}

if ( ! function_exists( 'wpj_abort_arbitration' ) ) {
	function wpj_abort_arbitration( $oid = '' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( ! is_demo_user() ) {
			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );
					$buyer_id  = $order->uid;

					if ( get_current_user_id() == $seller_id ) {
						$is_seller   = 1;
						$is_buyer    = 0;
						$uid_to_send = $buyer_id;
						$uid_sender  = $seller_id;
						$query_uid   = -45;

					} elseif ( get_current_user_id() == $buyer_id ) {
						$is_seller   = 0;
						$is_buyer    = 1;
						$uid_to_send = $seller_id;
						$uid_sender  = $buyer_id;
						$query_uid   = -46;
					}

					if ( isset( $query_uid ) ) {
						$arbitration_exist = wpj_get_arbitration_order( 'request_from_buyer, request_from_seller', ['order_id' => $order->id], 'row' );

						if ( $arbitration_exist ) {
							if ( ( $arbitration_exist->request_from_seller == 1 && $is_seller == 1 ) || ( $arbitration_exist->request_from_buyer == 1 && $is_buyer == 1 ) ) {
								// Update order
								wpj_update_arbitration_order( ['request_from_buyer' => 0, 'request_from_seller' => 0], ['order_id' => $order->id] );
							}
						}
					}

					// Insert notification
					$this_notification = wpj_insert_order_notification( ['uid' => $query_uid, 'oid' => $order->id, 'content' => __( 'Arbitration Aborted', 'wpjobster' )], ['%d', '%d', '%s'] );

					if ( $this_notification > 0 ) {
						// Update notifications
						wpj_update_user_notifications([
							'user1'       => $uid_to_send,
							'user2'       => $uid_sender,
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification,
							'notify_type' => 'arb_request_aborted',
							'order_id'    => $order->id
						]);

						// Send emails
						$email_info = [
							'##username##'              => wpj_get_user_display_type( get_current_user_id() ),
							'##username_aborting##'     => wpj_get_user_display_type( $uid_sender ),
							'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
							'##job_name##'              => $order->job_title,
							'##job_link##'              => urldecode( get_permalink( $order->pid ) ),
							'##transaction_page_link##' => wpj_get_order_link( $order->id )
						];

						// Send emails
						wpj_notify_user_translated( 'arb_request_aborted', $buyer_id, $email_info );
						wpj_notify_user_translated( 'arb_request_aborted', $seller_id, $email_info );
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

// HELPERS

if ( ! function_exists( 'wpj_order_has_arbitration' ) ) {
	function wpj_order_has_arbitration( $order_id = '' ) {
		if ( $order_id ) {
			$arbitration_order = wpj_get_arbitration_order( 'request_from_buyer, request_from_seller, buyer_arbitration, seller_arbitration', ['order_id' => $order_id], 'row' );

			if ( $arbitration_order ) {
				if ( $arbitration_order->request_from_buyer == 0 && $arbitration_order->request_from_seller == 0 ) {
					return false;

				} elseif ( $arbitration_order->seller_arbitration == 0 && $arbitration_order->buyer_arbitration == 0 ) {
					return true;

				} elseif ( $arbitration_order->seller_arbitration == 1 ) {
					return false;

				} elseif ( $arbitration_order->buyer_arbitration == 1 ) {
					return true;

				}
			}
		}

		return false;
	}
}