<?php
if ( ! function_exists( 'wpj_cancel_pending_order' ) ) {
	function wpj_cancel_pending_order( $oid = '', $process = '' ) {
		$oid     = WPJ_Form::post( 'order_id', $oid );
		$process = WPJ_Form::post( 'process', $process );

		if ( $oid ) {
			$order = wpj_get_job_order_by_id( $oid );

			if ( $order ) {
				if ( $process == 'cancel'
					&& $order->uid == get_current_user_id()
					&& $order->payment_status == 'pending'
				) {
					$seller_id = get_post_field( 'post_author', $order->pid );
					$message   = __( 'Pending cancelled', 'wpjobster' );

					// Cancel the order
					wpj_cancel_order_by_id( $order->id, 'pending' );

					// Insert notification
					$this_notification1 = wpj_insert_order_notification( ['uid' => -21, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

					if ( $this_notification1 > 0 ) {
						// Update notifications
						wpj_update_user_notifications([
							'user1'       => $seller_id,
							'user2'       => $order->uid,
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification1,
							'notify_type' => 'cancel_ord_pending',
							'order_id'    => $order->id
						]);
					}

					// Insert notification
					$this_notification2 = wpj_insert_order_notification( ['uid' => -22, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

					if ( $this_notification2 > 0 ) {
						// Update notifications
						wpj_update_user_notifications([
							'user1'       => $order->uid,
							'user2'       => $seller_id,
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification2,
							'notify_type' => 'cancel_ord_pending',
							'order_id'    => $order->id
						]);
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_cancel_expired_order' ) ) {
	function wpj_cancel_expired_order( $oid = '' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( $oid ) {
			$order = wpj_get_job_order_by_id( $oid );

			if ( $order ) {
				if ( wpj_is_order_time_up( $order->id ) == 1 ) {
					$seller_id = get_post_field( 'post_author', $order->pid );
					$message   = __( 'Expired', 'wpjobster' );

					if ( $seller_id == get_current_user_id() || $order->uid == get_current_user_id() ) {
						// Cancel the order
						wpj_cancel_order_by_id( $order->id, 'expired' );

						// Insert notification
						$this_notification = wpj_insert_order_notification( ['uid' => -35, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

						if ( $this_notification > 0 ) {
							// Update notifications
							wpj_update_user_notifications([
								'user1'       => $order->uid,
								'user2'       => $seller_id,
								'type'        => 'notifications',
								'number'      => +1,
								'notify_id'   => $this_notification,
								'notify_type' => 'cancel_ord_expired',
								'order_id'    => $order->id
							]);

							// Send email
							$email_info = [
								'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
								'##transaction_page_link##' => wpj_get_order_link( $order->id ),
								'##job_name##'              => $order->job_title,
								'##job_link##'              => urldecode( get_permalink( $order->pid ) )
							];

							if ( wpj_is_custom_offer( $order->pid ) ) {
								wpj_notify_user_translated( 'cancel_offer_acc_seller', $order->uid,  $email_info + ['##sender_username##' => wpj_get_user_display_type( $seller_id )] );

							} else {
								wpj_notify_user_translated( 'cancel_ord_expired_seller', $seller_id, $email_info + ['##sender_username##' => wpj_get_user_display_type( $order->uid )] );
								wpj_notify_user_translated( 'cancel_ord_expired_buyer', $order->uid, $email_info + ['##sender_username##' => wpj_get_user_display_type( $seller_id )] );

							}
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

// HELPERS

if ( ! function_exists( 'wpj_cancel_order_by_id' ) ) {
	function wpj_cancel_order_by_id( $oid = '', $cancel_type = '', $from_cron = false ) {
		$oid         = WPJ_Form::post( 'oid', $oid );
		$cancel_type = WPJ_Form::post( 'cancel_type', $cancel_type );
		$from_cron   = WPJ_Form::post( 'from_cron', $from_cron );

		if ( $oid && $cancel_type ) {
			$order = wpj_get_job_order_by_id( $oid );

			if ( $order && $order->payment_status != 'cancelled' ) {
				// Action before
				do_action( 'wpj_before_order_is_cancelled', $order->id, 'job_purchase' );

				// Force cancellation
				$force_cancellation = wpj_get_cancellation_number_by_type( $cancel_type );

				// Refund
				wpj_refund_payment( $order, $order->id, $from_cron );

				// Update order
				$data = [
					'closed'             => 1,
					'force_cancellation' => $force_cancellation,
					'date_closed'        => current_time( 'timestamp', 1 ),
					'payment_status'     => 'cancelled'
				];

				if ( $cancel_type == 'mutual' ) {
					$data['accept_cancellation_request'] = 1;
					$data['date_accept_cancellation']    = current_time( 'timestamp', 1 );

				} else {
					$data['request_cancellation_from_seller'] = '0';
					$data['request_cancellation_from_buyer']  = '0';

				}

				wpj_update_job_order( $data, ['id' => $order->id] );

				// Custom offer
				if ( wpj_is_custom_offer( $order->pid ) ) {
					wpj_deactivate_custom_offer( $cancel_type, $order->pid, get_post_field( 'post_author', $order->pid ) );
				}

				// Action after
				do_action( 'wpj_after_order_is_cancelled', $order->id, 'job_purchase' );
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_cancel_all_orders_by_user' ) ) {
	function wpj_cancel_all_orders_by_user( $uid ) {
		$orders = wpj_get_job_orders_in_progress_by_user( $uid );

		if ( $orders ) {
			foreach ( $orders as $key => $order ) {
				wpj_cancel_order_by_id( $order->order_id, 'ban' );
			}
		}
	}
}

 /* Force cancellation
 *
 * 0 - active/completed order
 * 1 - closed from admin
 * 2 - delivery time expired
 * 3 - mutual cancellation
 * 4 - arbitration
 * 5 - user ban
 * 6 - rejected by seller
 * 7 - autoclose
 */
if ( ! function_exists( 'wpj_get_cancellation_number_by_type' ) ) {
	function wpj_get_cancellation_number_by_type( $cancel_type ) {
		$force_cancellation = 0;

		if ( $cancel_type ) {
			if ( $cancel_type == 'closed' )      { $force_cancellation = 1; }
			if ( $cancel_type == 'expired' )     { $force_cancellation = 2; }
			if ( $cancel_type == 'mutual' )      { $force_cancellation = 3; }
			if ( $cancel_type == 'arbitration' ) { $force_cancellation = 4; }
			if ( $cancel_type == 'ban' )         { $force_cancellation = 5; }
			if ( $cancel_type == 'rejected' )    { $force_cancellation = 6; }
			if ( $cancel_type == 'autoclose' )   { $force_cancellation = 7; }
			if ( $cancel_type == 'pending' )     { $force_cancellation = 8; }
		}

		return $force_cancellation;
	}
}

if ( ! function_exists( 'wpj_get_order_cancellation_message' ) ) {
	function wpj_get_order_cancellation_message( $order = '', $return = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$cancelled_by = '';
		$reason       = '';

		if ( $order ) {

			if ( $order->force_cancellation == 1 ) {
				$cancelled_by = __( 'Order cancelled by Admin', 'wpjobster' );
				$reason       = __( 'Order Closed', 'wpjobster' );

			} elseif ( $order->force_cancellation == 2 ) {
				$cancelled_by = __( 'Order cancelled by Buyer', 'wpjobster' );
				$reason       = __( 'Order Expired', 'wpjobster' );

			} elseif ( $order->force_cancellation == 3 ) {
				$cancelled_by = __( 'Order cancelled by User', 'wpjobster' );
				$reason       = __( 'Mutual Cancellation', 'wpjobster' );

			} elseif ( $order->force_cancellation == 4 ) {
				$cancelled_by = __( 'Order cancelled by Admin', 'wpjobster' );
				$reason       = __( 'Arbitration', 'wpjobster' );

			} elseif ( $order->force_cancellation == 5 ) {
				$cancelled_by = __( 'Order cancelled by Admin', 'wpjobster' );
				$reason       = __( 'User Ban', 'wpjobster' );

			} elseif ( $order->force_cancellation == 6 ) {
				$cancelled_by = __( 'Order cancelled by Seller', 'wpjobster' );
				$reason       = __( 'Order Rejected', 'wpjobster' );

			} elseif ( $order->force_cancellation == 7 ) {
				$cancelled_by = __( 'Order cancelled by System', 'wpjobster' );
				$reason       = __( 'Autoclosed because the seller didn\'t respond', 'wpjobster' );

			} elseif ( $order->force_cancellation == 8 ) {
				$cancelled_by = __( 'Order cancelled by Buyer', 'wpjobster' );
				$reason       = __( 'Buyer cancelled the order', 'wpjobster' );

			} else {
				$cancelled_by = __( 'Order cancelled', 'wpjobster' );
				$reason       = '';

			}

		}

		if ( ! $reason && $order ) {
			$payment_row = wpj_get_payment(['payment_type_id' => $order->id, 'payment_type' => 'job_purchase']);
			$reason      = $payment_row->payment_details ? $payment_row->payment_details : '-';
		}

		if ( $return == 'message' ) return $cancelled_by;

		if ( $return == 'reason' ) return $reason;

		return ['message' => $cancelled_by, 'reason' => $reason];
	}
}