<?php
/*
 * clearing_period='0' - initial order
 * clearing_period='1' - completed
 * clearing_period='2' - pending clearing
 * clearing_period='3' - clearing blocked by admin
 */
if ( ! function_exists( 'wpj_mark_order_as_cleared' ) ) {
	function wpj_mark_order_as_cleared( $orderid = '' ) {
		if ( $orderid ) {
			$order = wpj_get_job_order_by_id( $orderid );

			if ( $order ) {
				$seller_id = get_post_field( 'post_author', $order->pid );

				$raw_amount      = $order->mc_gross;
				$processing_fees = $order->processing_fees;
				$tax_amount      = $order->tax_amount;

				// check custom extras
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );

				if ( $custom_extras ) {
					$i = 0;

					foreach ( $custom_extras as $custom_extra ) {
						if ( $custom_extra->paid ) {
							$custom_extra_order_id = wpj_get_custom_extra_order( 'id', ['order_id' => $order->id, 'custom_extra_id' => $i], 'var' );
							$custom_extra_payment  = wpj_get_payment(['payment_type' => 'custom_extra', 'payment_type_id' => $custom_extra_order_id]);

							if ( $custom_extra_payment ) {
								$raw_amount      += $custom_extra_payment->amount;
								$processing_fees += $custom_extra_payment->fees;
								$tax_amount      += $custom_extra_payment->tax;
							}
						}

						$i++;
					}
				}

				// check tips
				$tips = wpj_json_decode( wpj_stripslashes( $order->tips ) );

				if ( $tips ) {
					$j = 0;

					foreach ( $tips as $tip ) {
						if ( $tip->paid ) {
							$tips_order_id = wpj_get_tips_order( 'id', ['order_id' => $order->id, 'tips_id' => $j], 'var' );
							$tips_payment  = wpj_get_payment(['payment_type' => 'tips', 'payment_type_id' => $tips_order_id]);

							if ( $tips_payment ) {
								$raw_amount      += $tips_payment->amount;
								$processing_fees += $tips_payment->fees;
								$tax_amount      += $tips_payment->tax;
							}
						}

						$j++;
					}
				}

				$raw_amount = apply_filters( 'wpj_raw_amount_update_filter', $raw_amount, $order->id );
				$amount_fee = wpj_get_site_fee_by_amount( $raw_amount, $order->id, $seller_id );

				// Update credit
				$current_cash = wpj_get_user_credit( $seller_id );

				if ( $order->payment_gateway == 'cod' ) {
					$seller_credit_remain = $current_cash - ( $amount_fee + $tax_amount + $processing_fees );

				} else {
					$seller_credit_remain = $current_cash + ( $raw_amount - $amount_fee );

				}

				wpj_update_user_credit( $seller_id, apply_filters( 'wpj_clearance_amount_filter', $seller_credit_remain, $order->id, $raw_amount ) );

				// Update statistics
				wpj_update_user_earned_amount( $seller_id, $raw_amount );
				wpj_update_completed_orders_amount( $order->uid, $raw_amount );

				// Add history log
				$order_url = wpj_get_order_link( $order->id );

				if ( $order->payment_gateway != 'cod' ) {
					$reason = __( 'Payment cleared for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $order->job_title . '</a>';

					wpj_add_history_log(['tp' => '1', 'reason' => $reason, 'amount' => $raw_amount, 'uid' => $seller_id, 'oid' => $order->id, 'rid' => 5]);

				} else {
					// Send balance negative email
					if ( $current_cash < 0 ) {
						wpj_notify_user_translated( 'balance_negative', $seller_id,['##amount_updated##' => $current_cash]);
					}

					if ( $processing_fees > 0 ) {
						$reason = __( 'Processing fee for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $order->job_title . '</a>';

						wpj_add_history_log(['tp' => '0', 'reason' => $reason, 'amount' => $processing_fees, 'uid' => $seller_id, 'oid' => $order->id, 'rid' => 13]);
					}

					if ( $tax_amount > 0 ) {
						$reason = __( 'Tax for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $order->job_title . '</a>';

						wpj_add_history_log(['tp' => '0', 'reason' => $reason, 'amount' => $tax_amount, 'uid' => $seller_id, 'oid' => $order->id, 'rid' => 14]);
					}

				}

				$reason = __( 'Fee charged for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $order->job_title . '</a>';

				wpj_add_history_log(['tp' => '0', 'reason' => $reason, 'amount' => $amount_fee, 'uid' => $seller_id, 'oid' => $order->id, 'rid' => 6]);

				// Update order
				wpj_update_job_order(['admin_fee' => $amount_fee], ['id' => $order->id]);

				// Actions
				do_action( 'wpj_after_job_payment_is_completed', $order->id, 'cleared' );
				do_action( 'wpj_after_job_cleared', $order->id, $seller_id );
			}
		}
	}
}