<?php
if ( ! function_exists( 'wpj_mark_order_as_completed' ) ) {
	function wpj_mark_order_as_completed( $oid = '', $complete_without_login = false ) {
		if ( ! is_user_logged_in() && ! $complete_without_login ) { die(); }

		if ( ! is_demo_user() ) {
			$oid = WPJ_Form::post( 'oid', $oid );

			if ( ! $oid ) $oid = get_query_var( 'oid' );

			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );

					// Get clearing period date
					$clear_now       = 0;
					$clearing_period = wpj_get_option( 'wpjobster_clearing_period' );

					if ( is_numeric( $clearing_period ) ) {
						if ( $clearing_period == 0 || $order->payment_gateway == 'cod' ) {
							$clear_now     = 1;
							$date_to_clear = current_time( 'timestamp', 1 );

						} else {
							$date_to_clear = strtotime( '+' . $clearing_period . ' days', current_time( 'timestamp', 1 ) );

						}

					} else {
						$date_to_clear = strtotime( '+14 days', current_time( 'timestamp', 1 ) );

					}

					if ( $order->completed == 0 && $order->done_seller == 1 && $order->closed != 1 ) {
						if ( $order->uid == get_current_user_id() || $complete_without_login ) {
							do_action( 'wpj_before_order_marked_as_completed', $order->id );

							// Update order
							wpj_update_job_order(
								[
									'clearing_period' => 2,
									'date_to_clear'   => $date_to_clear,
									'done_buyer'      => 1,
									'completed'       => 1,
									'date_completed'  => current_time( 'timestamp', 1 )
								],
								['id' => $order->id]
							);


							if ( wpj_is_custom_offer( $order->pid ) ) {
								wpj_complete_custom_offer( $order->pid, $order->id, $seller_id );

							} else {
								wpj_notify_user_translated( 'order_complete', $seller_id, [
									'##sender_username##'       => wpj_get_user_display_type( $order->uid ),
									'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
									'##transaction_page_link##' => wpj_get_order_link( $order->id ),
									'##job_name##'              => $order->job_title,
									'##job_link##'              => urldecode( get_permalink( $order->pid ) )
								]);

							}

							// Calculate FEE
							$raw_amount = $order->mc_gross;

							$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) ); // check custom extra
							if ( $custom_extras ) { $i = 0;
								foreach ( $custom_extras as $custom_extra ) {
									if ( $custom_extra->paid ) {
										$custom_extra_order   = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $i], 'row' );
										$custom_extra_payment = wpj_get_payment(['payment_type' => 'custom_extra', 'payment_type_id' => $custom_extra_order->id]);

										if ( $custom_extra_payment ) {
											$raw_amount += $custom_extra_payment->amount;
										}
									} $i++;
								}
							}

							$tips = wpj_json_decode( wpj_stripslashes( $order->tips ) ); // check tips
							if ( $tips ) { $j = 0;
								foreach ( $tips as $tip ) {
									if ( $tip->paid ) {
										$tips_order   = wpj_get_tips_order( '*', ['order_id' => $order->id, 'tips_id' => $j], 'row' );
										$tips_payment = wpj_get_payment(['payment_type' => 'tips', 'payment_type_id' => $tips_order->id]);

										if ( $tips_payment ) {
											$raw_amount += $tips_payment->amount;
										}
									} $j++;
								}
							}

							// Insert admin earnings
							wpj_insert_site_earnings( ['orderid' => $order->id, 'pid' => $order->pid, 'admin_fee' => wpj_get_site_fee_by_amount( $raw_amount, $order->id, $seller_id )], ['%d', '%d', '%s'] );

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => -2, 'oid' => $order->id, 'content' => __( 'Completed', 'wpjobster' )], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notification
								wpj_update_user_notifications([
									'user1'       => $seller_id,
									'user2'       => $order->uid,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'order_complete',
									'order_id'    => $order->id
								]);
							}

							if ( $clear_now ) {
								// Update order
								wpj_update_job_order( ['clearing_period' => 1], ['id' => $order->id] );

								// Mark order as cleared
								wpj_mark_order_as_cleared( $order->id );

							}

							do_action( 'wpj_after_order_marked_as_completed', $order->id );
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

// HELPERS

if ( ! function_exists( 'wpj_is_order_completed' ) ) {
	function wpj_is_order_completed( $order = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$seller_id = get_post_field( 'post_author', $order->pid );

		$completed = 0;

		if ( get_current_user_id() != $seller_id ) {
			if ( $order->done_buyer == 1 ) $completed = 1;
		}

		if ( get_current_user_id() == $seller_id ) {
			if ( $order->done_buyer == 1 ) $completed = 1;
			if ( $order->done_buyer == -1 ) $completed = -1;
		}

		return $completed;

	}
}

if ( ! function_exists( 'wpj_order_can_be_closed' ) ) {
	function wpj_order_can_be_closed( $order = '', $action = 'closed' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$seller_id = get_post_field( 'post_author', $order->pid );

		$can_be_closed      = 0;
		$can_request_closed = 0;

		if ( get_current_user_id() != $seller_id ) {

			$can_be_closed      = 0;
			$can_request_closed = 1;

			if ( get_current_user_id() == $order->uid && $order->expected_delivery < current_time( 'timestamp', 1 ) )
				$can_be_closed = 1;

			if ( $order->closed == 1 ) {
				$can_be_closed      = 0;
				$can_request_closed = 0;
			}

			if ( $order->completed == 1 ) {
				$can_be_closed      = 0;
				$can_request_closed = 0;
			}
		}

		if ( get_current_user_id() == $seller_id ) {

			$can_request_closed = 1;

			if ( $order->closed == 1 ) $can_request_closed = 0;

			if ( $order->completed == 1 ) {
				$can_be_closed      = 0;
				$can_request_closed = 0;
			}
		}

		$can_request_closed = apply_filters( 'wpj_order_can_be_closed_filter', $can_request_closed, $order );

		return $action == 'request' ? $can_request_closed : $can_be_closed;
	}
}