<?php // CUSTOM OFFER

if ( ! function_exists( 'wpj_request_custom_offer' ) ) {
	function wpj_request_custom_offer( $args = [] ) {
		if ( is_array( $args ) ) {
			/**
			 * @var string $content
			 * @var int $datemade
			 * @var int $initiator
			 * @var int $user
			 * @var int $custom_offer
			 * @var int $pid
			 * @var string $page
			 * @var string $unique_id
			 * @var string $attached
			 */
			extract( $args );
		}

		if ( ! isset( $_POST['token'] ) ) {
			$msg = wpj_get_custom_offer_status( 'csrf_empty' );

		} elseif ( ! wp_verify_nonce( $_POST['token'], 'new-custom-offer-request' ) ) {
			$msg = wpj_get_custom_offer_status( 'csrf_not_match' );

		} else {
			if ( empty( $content ) )      $content        = WPJ_Form::post( 'content' );
			if ( empty( $datemade ) )     $datemade       = WPJ_Form::post( 'datemade', current_time( 'timestamp', 1 ) );
			if ( empty( $initiator ) )    $initiator      = WPJ_Form::post( 'initiator', get_current_user_id() );
			if ( empty( $user ) )         $user           = WPJ_Form::post( 'user' );
			if ( empty( $custom_offer ) ) $custom_offer   = WPJ_Form::post( 'custom_offer' );
			if ( empty( $pid ) )          $pid            = WPJ_Form::post( 'pid', wpj_get_post_id() );
			if ( empty( $page ) )         $page           = WPJ_Form::post( 'page' );
			if ( empty( $unique_id ) )    $unique_id      = WPJ_Form::post( 'unique_id' );

			$content = trim( nl2br( strip_tags( htmlspecialchars( wpj_encode_emoji( $content ) ) ) ) );

			if ( get_current_user_id() == $user ) {
				$msg = wpj_get_custom_offer_status( 'request_yourself' );

			} elseif ( ! is_user_logged_in() ) {
				$msg = wpj_get_custom_offer_status( 'request_logged_in' );

			} elseif ( ! $content && apply_filters( 'wpj_request_custom_offer_display_description_filter', true ) ) {
				$msg = wpj_get_custom_offer_status( 'empty_request' );

			} else {
				$pid = $page == 'single_job' || $page == 'single_job_mobile' || $page == 'single_job_pc' ? $pid : '';

				if ( empty( $attached ) )
					$attached = WPJ_Form::post( 'hidden_files_custom_offer_attachments_' . $unique_id );

				if ( ! is_demo_user() ) {
					$this_pm = wpj_save_private_message( [
						'content'          => $content,
						'datemade'         => $datemade,
						'initiator'        => $initiator,
						'user'             => $user,
						'attached'         => $attached ,
						'custom_offer'     => $custom_offer,
						'associate_job_id' => $pid
					]);

					do_action( 'wpj_after_request_custom_offer_saved', $this_pm, $_POST, 'request' );
				}

				$msg = wpj_get_custom_offer_status( 'request_sent' );

			}

		}

		if ( isset( $this_pm ) ) $row = wpj_get_pm_notify( '*', ['id' => $this_pm], 'row' );

		$return_arr = [
			'user'            => ! empty( $user ) ? $user : '',
			'pm_id'           => ! empty( $this_pm ) ? $this_pm : '',
			'message_date'    => ! empty( $row ) ? wpj_chat_get_message_date( $row ) : '',
			'custom_offer'    => ! empty( $row ) ? wpj_chat_get_custom_offer_info( $row ) : '',
			'message'         => $msg,
		];

		wp_send_json( $return_arr );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_send_custom_offer' ) ) {
	function wpj_send_custom_offer( $args = [] ) {
		if ( is_array( $args ) ) {
			/**
			 * @var string $content
			 * @var int $datemade
			 * @var int $initiator
			 * @var int $user
			 * @var float $price
			 * @var int $delivery
			 * @var int $oid
			 * @var int $pid
			 */
			extract( $args );
		}

		$active_job_required  = wpj_get_option( 'wpjobster_active_job_cutom_offer' );
		$enable_custom_extras = wpj_get_option( 'wpjobster_enable_custom_extras' );

		$custom_extra_form = ( ! empty( $_POST['custom_extra_form'] ) && $_POST['custom_extra_form'] == 'true' );

		if ( $custom_extra_form && $enable_custom_extras != 'yes' ) {
			$msg = wpj_get_custom_offer_status( 'custom_extras_not_enabled' );

		} elseif ( $active_job_required == 'yes' && wpj_get_user_jobs_count( get_current_user_id(), 'active' ) < 1 ) {
			$msg = wpj_get_custom_offer_status( 'not_eligible' );

		} elseif ( ! isset( $_POST['token'] ) ) {
			$msg = wpj_get_custom_offer_status( 'csrf_empty' );

		} elseif ( ! wp_verify_nonce( $_POST['token'], 'new-custom-offer-send' ) ) {
			$msg = wpj_get_custom_offer_status( 'csrf_not_match' );

		} else {
			if ( empty( $content ) )   $content   = WPJ_Form::post( 'content' );
			if ( empty( $datemade ) )  $datemade  = WPJ_Form::post( 'datemade', current_time( 'timestamp', 1 ) );
			if ( empty( $initiator ) ) $initiator = WPJ_Form::post( 'initiator', get_current_user_id() );
			if ( empty( $user ) )      $user      = WPJ_Form::post( 'user' );
			if ( empty( $price ) )     $price     = WPJ_Form::post( 'price' );
			if ( empty( $delivery ) )  $delivery  = WPJ_Form::post( 'delivery' );
			if ( empty( $oid ) )       $oid       = WPJ_Form::post( 'oid' );
			if ( empty( $pid ) )       $pid       = WPJ_Form::post( 'pid', wpj_get_post_id() );

			$content = trim( nl2br( strip_tags( htmlspecialchars( wpj_encode_emoji( $content ) ) ) ) );

			if ( get_post_type( $pid ) == 'job' ) {
				$associate_request_id = '';
				$associate_job_id     = $pid;

			} elseif ( get_post_type( $pid ) == 'request' ) {
				$associate_request_id = $pid;
				$associate_job_id     = '';

			} else {
				$associate_request_id = '';
				$associate_job_id     = '';

			}

			$associate_job_id     = apply_filters( 'wpj_associate_job_id_filter', $associate_job_id );
			$associate_request_id = apply_filters( 'wpj_associate_request_id_filter', $associate_request_id );

			if ( $custom_extra_form ) {
				if ( wpj_get_user_feature_status( 'wpjobster_enable_min_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
					$price_min = wpj_get_user_feature_value( 'min_customextrasamount', 'min_customextrasamount' );
				else
					$price_min = 0;

				if ( wpj_get_user_feature_status( 'wpjobster_enable_max_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
					$price_max = wpj_get_user_feature_value( 'max_customextrasamount', 'max_customextrasamount' );
				else
					$price_max = '';

			} else {
				$price_min = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[1];
				$price_max = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[2];

				if ( ! is_numeric( $price_min ) || ! is_numeric( $price_max ) || $price_min > $price_max ) {
					$price_min = 5;
					$price_max = 5000;
				}
			}

			if ( get_current_user_id() == $user && ! $custom_extra_form ) {
				$msg = wpj_get_custom_offer_status( 'offer_yourself' );

			} elseif ( ! $content && apply_filters( 'wpj_send_custom_offer_display_description_filter', true ) ) {
				$msg = wpj_get_custom_offer_status( 'empty_offer' );

			} elseif ( ( $price < $price_min || $price > $price_max ) && apply_filters( 'wpj_send_custom_offer_display_price_filter', true ) ) {
				$msg = ! $custom_extra_form ? wpj_get_custom_offer_status( 'wrong_price' ) : wpj_get_custom_offer_status( 'wrong_price', true );

			} elseif ( ( $delivery < 1 || $delivery > wpj_get_option( 'wpjobster_request_max_delivery_days' ) ) && apply_filters( 'wpj_send_custom_offer_display_days_filter', true ) ) {
				$msg = wpj_get_custom_offer_status( 'wrong_delivery' );

			} elseif ( $custom_extra_form && ! $oid ) {
				$msg = wpj_get_custom_offer_status( 'something_wrong', true );

			} elseif ( $custom_extra_form && wpj_get_option( 'wpjobster_enable_custom_extras' ) != 'yes' ) {
				$msg = wpj_get_custom_offer_status( 'something_wrong', true );

			} else {
				if ( ! $custom_extra_form ) {
					$post_title = sprintf( __( "Private transaction between %s and %s", "wpjobster" ), wpj_get_user_display_type( $initiator ), wpj_get_user_display_type( $user ) );

					$post = [
						'post_title'   => $post_title,
						'post_content' => $content,
						'post_author'  => $initiator,
						'post_status'  => 'publish',
						'post_type'    => 'offer'
					];

					$post_id = wp_insert_post( $post );

					if ( $post_id == 0 ) {
						$msg = wpj_get_custom_offer_status( 'something_wrong' );

					} else {
						if ( ! is_demo_user() ) {
							do_action( 'wpj_before_send_custom_offer_saved', $post_id, $_POST, 'send' );

							update_post_meta( $post_id, 'price', $price );
							update_post_meta( $post_id, 'max_days', $delivery );
							update_post_meta( $post_id, 'offer_buyer', $user );
							update_post_meta( $post_id, 'offer_date', $datemade );
							update_post_meta( $post_id, 'offer_date_expire', strtotime( '+7 days', $datemade ) );
							update_post_meta( $post_id, 'offer_accepted', 0 );
							update_post_meta( $post_id, 'offer_declined', 0 );
							update_post_meta( $post_id, 'offer_withdrawn', 0 );
							update_post_meta( $post_id, 'offer_expired', 0 );

							$this_pm = wpj_save_private_message([
								'content'              => $content,
								'datemade'             => $datemade,
								'initiator'            => $initiator,
								'user'                 => $user,
								'custom_offer'         => $post_id,
								'associate_request_id' => $associate_request_id,
								'associate_job_id'     => $associate_job_id
							]);
						}

						$msg = wpj_get_custom_offer_status( 'offer_sent' );

					}

				} else {
					// is custom extra
					$msg = wpj_insert_custom_extra_to_job_purchase_order([
						'oid'       => $oid,
						'content'   => $content,
						'price'     => $price,
						'delivery'  => $delivery,
						'initiator' => $initiator
					]);
				}
			}
		}

		if ( isset( $this_pm ) ) $row = wpj_get_pm_notify( '*', ['id' => $this_pm], 'row' );

		$return_arr = [
			'user'            => ! empty( $user ) ? $user : '',
			'pm_id'           => ! empty( $this_pm ) ? $this_pm : '',
			'message_date'    => ! empty( $row ) ? wpj_chat_get_message_date( $row ) : '',
			'custom_offer'    => ! empty( $row ) ? wpj_chat_get_custom_offer_info( $row ) : '',
			'message'         => ! empty( $msg ) ? $msg : ''
		];

		wp_send_json( $return_arr );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_accept_custom_offer' ) ) {
	function wpj_accept_custom_offer( $pid = '', $oid = '', $bid = '', $sid = '' ) {
		$request_id = wpj_get_pm_notify( 'associate_request_id', ['initiator' => $sid, 'custom_offer' => $pid], 'var' );

		// Update metas
		if ( $request_id ) {
			if ( get_post_meta( $request_id, 'request_autoclose', true ) == 'yes' ) {
				update_post_meta( $request_id, 'assigned', 1 );
				update_post_meta( $request_id, 'assigned_to', $sid );
				update_post_meta( $request_id, 'assigned_order', $oid );
				update_post_meta( $request_id, 'active', 2 );
			}
		}

		update_post_meta( $pid, 'offer_accepted', 1 );

		// Send emails
		$date_made = wpj_get_job_order_by_id( $oid, 'date_made' );

		wpj_notify_user_translated( 'offer_acc_buyer', $bid, [
			'##sender_username##'       => wpj_get_user_display_type( $sid ),
			'##transaction_page_link##' => wpj_get_order_link( $oid ),
			'##private_message_link##'  => wpj_get_pm_link( $sid ),
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made )
		] );

		wpj_notify_user_translated( 'offer_acc_seller', $sid, [
			'##sender_username##'       => wpj_get_user_display_type( $bid ),
			'##transaction_page_link##' => wpj_get_order_link( $oid ),
			'##private_message_link##'  => wpj_get_pm_link( $bid ),
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made )
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_decline_custom_offer' ) ) {
	function wpj_decline_custom_offer( $pid = '', $pm_id = '' ) {
		if ( ! is_demo_user() ) {
			$pid      = WPJ_Form::post( 'custom_offer', $pid );
			$pm_id    = WPJ_Form::post( 'pm_id', $pm_id );
			$buyer_id = get_post_meta( $pid, 'offer_buyer', true );

			if ( $pid && $buyer_id == get_current_user_id() ) {
				$seller_id = get_post_field( 'post_author', $pid );

				// Update meta
				update_post_meta( $pid, 'offer_declined', 1 );

				// Update notification
				wpj_update_user_notifications( [
					'user1'       => $seller_id,
					'user2'       => $buyer_id,
					'type'        => 'messages',
					'number'      => +1,
					'notify_id'   => $pm_id,
					'notify_type' => 'decline_custom_offer',
					'order_id'    => $pid
				] );

				// Send email
				wpj_notify_user_translated( 'offer_decl', $seller_id, [
					'##private_message_link##' => wpj_get_pm_link( get_current_user_id() )
				] );
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_withdraw_custom_offer' ) ) {
	function wpj_withdraw_custom_offer( $pid = '', $pm_id = '' ) {
		if ( ! is_demo_user() ) {
			$pid       = WPJ_Form::post( 'custom_offer', $pid );
			$pm_id     = WPJ_Form::post( 'pm_id', $pm_id );
			$seller_id = get_post_field( 'post_author', $pid );

			if ( $pid && $seller_id == get_current_user_id() ) {
				$buyer_id = get_post_meta( $pid, 'offer_buyer', true );

				// Update meta
				update_post_meta( $pid, 'offer_withdrawn', 1 );

				// Send live notification
				wpj_update_user_notifications( [
					'user1'       => $buyer_id,
					'user2'       => $seller_id,
					'type'        => 'messages',
					'number'      => +1,
					'notify_id'   => $pm_id,
					'notify_type' => 'widthdraw_custom_offer',
					'order_id'    => $pid
				] );

				// Send email
				wpj_notify_user_translated( 'offer_withdr', $buyer_id, [
					'##sender_username##'      => wpj_get_user_display_type( $seller_id ),
					'##private_message_link##' => wpj_get_pm_link( get_current_user_id() )
				] );
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_cancel_custom_offer' ) ) {
	function wpj_cancel_custom_offer( $email_reason = '', $oid = '', $sid = '', $bid = '' ) {
		$date_made = wpj_get_job_order_by_id( $oid, 'date_made' );

		if ( $sid && $bid ) {
			wpj_notify_user_translated( $email_reason, $bid, [
				'##sender_username##'       => wpj_get_user_display_type( $sid ),
				'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
				'##transaction_page_link##' => wpj_get_order_link( $oid )
			]);

			wpj_notify_user_translated( $email_reason, $sid, [
				'##sender_username##'       => wpj_get_user_display_type( $bid ),
				'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
				'##transaction_page_link##' => wpj_get_order_link( $oid )
			]);

		} else {
			wpj_notify_user_translated( $email_reason, $sid, [
				'##sender_username##'       => wpj_get_user_display_type( $bid ),
				'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
				'##transaction_page_link##' => wpj_get_order_link( $oid )
			]);

		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_deactivate_custom_offer' ) ) {
	function wpj_deactivate_custom_offer( $reason = '', $pid = '', $uid = '' ) {
		$request_id = wpj_get_pm_notify( 'associate_request_id', ['initiator' => $uid, 'custom_offer' => $pid], 'var' );

		if ( $request_id ) {
			if ( get_post_meta( $request_id, 'request_autoclose', true ) == 'yes' ) {
				delete_post_meta( $request_id, 'assigned' );
				delete_post_meta( $request_id, 'completed' );

				update_post_meta( $request_id, 'active', 0 );
				update_post_meta( $request_id, 'cancelled', 1 );
				update_post_meta( $request_id, 'cancelled_reason', $reason );
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_modify_custom_offer' ) ) {
	function wpj_modify_custom_offer( $oid = '', $uid = '' ) {
		$order = wpj_get_job_order_by_id( $oid );

		wpj_notify_user_translated( 'mod_offer_buyer', $uid, [
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $order->date_made ),
			'##transaction_page_link##' => wpj_get_order_link( $oid ),
			'##sender_username##'       => wpj_get_user_display_type( get_post_field( 'post_author', $order->pid ) )
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_deliver_custom_offer' ) ) {
	function wpj_deliver_custom_offer( $oid = '', $uid = '' ) {
		$date_made = wpj_get_job_order_by_id( $oid, 'date_made' );

		wpj_notify_user_translated( 'order_offer_delivered', $uid, [
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
			'##transaction_page_link##' => wpj_get_order_link( $oid )
		]);

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_complete_custom_offer' ) ) {
	function wpj_complete_custom_offer( $pid = '', $oid = '', $uid = '' ) {
		$request_id = wpj_get_pm_notify( 'associate_request_id', ['initiator' => $uid, 'custom_offer' => $pid], 'var' );

		if ( $request_id ) {
			if ( get_post_meta( $request_id, 'request_autoclose', true ) == 'yes' ) {
				update_post_meta( $request_id, 'completed', 1 );
				update_post_meta( $request_id, 'active', 2 );

				delete_post_meta( $request_id, 'assigned' );
			}
		}

		$date_made = wpj_get_job_order_by_id( $oid, 'date_made' );

		wpj_notify_user_translated( 'order_offer_complete', $uid, [
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
			'##transaction_page_link##' => wpj_get_order_link( $oid )
		]);

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_rate_custom_offer' ) ) {
	function wpj_rate_custom_offer( $oid = '', $bid = '', $sid = '' ) {
		$date_made = wpj_get_job_order_by_id( $oid, 'date_made' );

		wpj_notify_user_translated( 'new_offer_feedback', $bid, [
			'##transaction_number##'    => wpj_camouflage_oid( $oid, $date_made ),
			'##transaction_page_link##' => wpj_get_order_link( $oid ),
			'##sender_username##'       => wpj_get_user_display_type( $sid )
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_expire_custom_offer' ) ) {
	function wpj_expire_custom_offer( $pid = '', $bid = '', $sid = '' ) {
		if ( get_post_meta( $pid, 'offer_expired', true ) == 0 ) {
			if ( current_time( 'timestamp', 1 ) > get_post_meta( $pid, 'offer_date_expire', true ) ) {
				update_post_meta( $pid, 'offer_expired', 1 );

				if (
					get_post_meta($pid, 'offer_withdrawn', true) != 1
					&& get_post_meta($pid, 'offer_accepted', true) != 1
					&& get_post_meta($pid, 'offer_declined', true) != 1
				) {
					wpj_notify_user_translated('offer_exp', $bid, [
						'##sender_username##' => wpj_get_user_display_type($sid),
						'##private_message_link##' => wpj_get_pm_link($sid)
					]);

				}
			}
		}
	}
}

// HELPERS

if ( ! function_exists( 'wpj_is_custom_offer' ) ) {
	function wpj_is_custom_offer( $pid ) {
		if ( $pid && get_post_type( $pid ) == 'offer' )
			return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_get_custom_offer_title' ) ) {
	function wpj_get_custom_offer_title( $pid = '', $post_author = '' ) {
		if ( $pid && $post_author && wpj_is_custom_offer( $pid ) ) {
			return sprintf( __( 'Private transaction with %s', 'wpjobster' ), wpj_get_user_display_type( $post_author ) );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_custom_offer_status' ) ) {
	function wpj_get_custom_offer_status( $key = null, $extra = false ) {

		if ( $extra ) {
			if ( wpj_get_user_feature_status( 'wpjobster_enable_min_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
				$price_min = wpj_get_user_feature_value( 'min_customextrasamount', 'min_customextrasamount' );

			else
				$price_min = 0;

			if ( wpj_get_user_feature_status( 'wpjobster_enable_max_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
				$price_max = wpj_get_user_feature_value( 'max_customextrasamount', 'max_customextrasamount' );

			else
				$price_max = '';

		} else {
			$price_min = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[1];
			$price_max = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[2];

			if ( ! is_numeric( $price_min ) || ! is_numeric( $price_max ) || $price_min > $price_max ) {
				$price_min = 5;
				$price_max = 5000;
			}

		}

		$status = [
			'ok' => [
				'description' =>  __( 'All good', 'wpjobster' ),
				'cssClass'    => 'noon',
				'code'        => 'success'
			],
			'message_sent' => [
				'description' => __( 'Your message was successfully sent.', 'wpjobster' ),
				'cssClass'    => 'success-container',
				'code'        => 'success'
			],
			'request_sent' => [
				'description' => __( 'Your request was successfully sent.', 'wpjobster' ),
				'cssClass'    => 'success-container',
				'code'        => 'success'
			],
			'offer_sent' => [
				'description' => __( 'Your offer was successfully sent.', 'wpjobster' ),
				'cssClass'    => 'success-container',
				'code'        => 'success'
			],
			'message_already_sent' => [
				'description' => __( 'Your message was already sent.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'request_already_sent' => [
				'description' => __( 'Your request was already sent.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'offer_already_sent' => [
				'description' => __( 'Your offer was already sent.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'something_wrong' => [
				'description' => __( 'Something went wrong... Please try again.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'empty_message' => [
				'description' => __( 'The message cannot be empty.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'empty_request' => [
				'description' => __( 'The request cannot be empty.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'empty_offer' => [
				'description' => __( 'The offer cannot be empty.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'request_yourself' => [
				'description' => __( 'You cannot send a request to yourself.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'offer_yourself' => [
				'description' => __( 'You cannot send a offer to yourself.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'wrong_price' => [
				'description' => __( 'The price must be in the following range:', 'wpjobster' ) . ' ' . $price_min . ' - ' . $price_max . ' ' . wpj_get_site_default_currency(),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'wrong_delivery' => [
				'description' => sprintf( __( 'The delivery time must be between 1 and %s days.', 'wpjobster' ), wpj_get_option( 'wpjobster_request_max_delivery_days' ) ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'not_eligible' => [
				'description' => __( 'You need to have at least one active job in order to send custom offers.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'custom_extras_not_enabled' => [
				'description' => __( 'Custom extras are not enabled.', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'request_logged_in' => [
				'description' => __( 'You must be logged in to request custom offer. If you want to login, click <a href="' . wpj_get_login_link() . '" class="login-link">here</a>', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'csrf_empty' => [
				'description' => __( 'The verification token is empty', 'wpjobster' ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			],
			'csrf_not_match' => [
				'description' => __( "The verification token doesn't match", "wpjobster" ),
				'cssClass'    => 'error-container',
				'code'        => 'error'
			]
		];

		if ( $extra ) {
			$status['offer_sent']['description']         = __( 'Your extra was successfully sent.', 'wpjobster' );
			$status['offer_already_sent']['description'] = __( 'Your extra was already sent.', 'wpjobster' );
			$status['empty_offer']['description']        = __( 'The extra cannot be empty.', 'wpjobster' );
			$status['offer_yourself']['description']     = __( 'You cannot send an extra to yourself.', 'wpjobster' );
			$status['not_eligible']['description']       = __( 'You need to have at least one active job in order to send custom extras.', 'wpjobster' );
		}

		$status = apply_filters( 'wpj_custom_offer_status_filter', $status );

		if ( ! empty( $key ) )
			return $status[$key];

		else
			return $status['something_wrong'];
	}
}

if ( ! function_exists( 'wpj_check_offer_veracity' ) ) {
	function wpj_check_offer_veracity( $pid = '', $seller_id = '' ) {
		$buyer_id = get_post_meta( $pid, 'offer_buyer', true );

		if ( $buyer_id != get_current_user_id() )
			return get_bloginfo( 'url' );

		wpj_expire_custom_offer( $pid, $buyer_id, $seller_id );

		if ( get_post_meta( $pid, 'offer_expired', true ) == 1
			|| get_post_meta( $pid, 'offer_withdrawn', true ) == 1
			|| get_post_meta( $pid, 'offer_accepted', true ) == 1
			|| get_post_meta( $pid, 'offer_declined', true ) == 1
		)
			return get_bloginfo( 'url' );

		return false;
	}
}

if ( ! function_exists( 'wpj_get_user_proposals' ) ) {
	function wpj_get_user_proposals( $uid = '', $type = 'send', $return = 'count' ) {

		if ( ! $uid ) $uid = get_current_user_id();

		if ( $type ) {
			if ( $type == 'send' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'offer',
					'author'         => $uid,
					'post_status'    => ['publish']
				];

				$result = new WPJ_Load_More_Posts( $args + [
					'function_name'   => 'wpj_display_proposal_list_items',
					'container_class' => 'all-proposals-page',
					'params'          => 'send'
				]);

			} elseif ( $type == 'received' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'offer',
					'post_status'    => ['publish'],
					'meta_query'     => [
						[
							'key'     => 'offer_buyer',
							'value'   => $uid,
							'compare' => '='
						]
					]
				];

				$result = new WPJ_Load_More_Posts( $args + [
					'function_name'   => 'wpj_display_proposal_list_items',
					'container_class' => 'all-proposals-page',
					'params'          => 'received'
				]);

			}

			if ( isset( $args ) && isset( $result ) ) {
				if ( $return == 'query' )
					return apply_filters( 'wpj_user_proposals_' . $type . '_query_filter', $args );

				if ( $return == 'result' )
					return apply_filters( 'wpj_user_proposals_' . $type . '_result_filter', $result );

				if ( $return == 'count' ) {
					$result_cnt = new WP_Query( $args );
					return apply_filters( 'wpj_user_proposals_' . $type . '_count_filter', $result_cnt->post_count );
				}
			}
		}

		return 0;

	}
}