<?php
if ( ! function_exists( 'wpj_is_order_time_up' ) ) {
	function wpj_is_order_time_up( $order = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			$current_date = strtotime( date( 'Y-m-d H:i:s' ) );
			$order_date   = strtotime( wpj_get_order_expected_time( $order->id ) );

			if (
				wpj_bool_option( 'wpjobster_enable_delivery_time' )
				&& ( get_post_meta( $order->pid, 'max_days', true )
					|| get_post_meta( $order->pid, 'job_packages', true ) == 'yes' )
			) {

				if ( $current_date <= $order_date ) {
					return 0;

				} else {
					return 1;

				}

			} else {
				return 0;

			}
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_get_order_expected_time' ) ) {
	function wpj_get_order_expected_time( $order = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			$order_payment_data = wpj_get_payment(['payment_type' => 'job_purchase', 'payment_type_id' => $order->id]);

			if ( $order_payment_data ) {
				if ( $order_payment_data->payment_made_on && $order_payment_data->payment_made_on != 0 ) {
					$date = $order_payment_data->payment_made_on;

				} else {
					$date = $order_payment_data->datemade;

				}

			} else {
				$date = date( 'D M d Y H:i:s O' );

			}

			$order_expected_delivery = $order->expected_delivery;

			$package_id = get_post_meta( $order->pid, 'order_package_no_' . $order->id, true );

			if ( is_numeric( $package_id ) && $package_id < 3 && get_post_meta( $order->pid, 'job_packages', true ) == 'yes' )
				$max_days = get_post_meta( $order->pid, 'package_max_days', true )[$package_id];

			else
				$max_days = get_post_meta( $order->pid, 'max_days', true );

			if ( $order_expected_delivery && $order_expected_delivery != 0 ) {
				$timer_date = date( 'D M d Y H:i:s O', $order_expected_delivery );

			} elseif ( $order->extra_fast != 0 ) {
				$timer_date = date( 'D M d Y H:i:s O', $date + ( 24 * 3600 * intval( get_post_meta( $order->pid, 'extra_fast_days', true ) ) ) );

			} else {
				$timer_date = date( 'D M d Y H:i:s O', $date + ( 24 * 3600 * intval( $max_days ) ) );

			}

			return $timer_date;

		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_expected_delivery' ) ) {
	function wpj_get_expected_delivery( $order = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			if ( ! $order->expected_delivery ) {
				$package_id = get_post_meta( $order->pid, 'order_package_no_' . $order->id, true );

				if ( is_numeric( $package_id ) && $package_id < 3 && get_post_meta( $order->pid, 'job_packages', true ) == 'yes' )
					$max_days = get_post_meta( $order->pid, 'package_max_days', true )[$package_id];

				else
					$max_days = get_post_meta( $order->pid, 'max_days', true );

				if ( $order->extra_fast != 0 ) $max_days = $order->extra_fast_days;

				if ( $order->extra1 > 0 ) $max_days += $order->extra1_days;
				if ( $order->extra2 > 0 ) $max_days += $order->extra2_days;
				if ( $order->extra3 > 0 ) $max_days += $order->extra3_days;
				if ( $order->extra4 > 0 ) $max_days += $order->extra4_days;
				if ( $order->extra5 > 0 ) $max_days += $order->extra5_days;
				if ( $order->extra6 > 0 ) $max_days += $order->extra6_days;
				if ( $order->extra7 > 0 ) $max_days += $order->extra7_days;
				if ( $order->extra8 > 0 ) $max_days += $order->extra8_days;
				if ( $order->extra9 > 0 ) $max_days += $order->extra9_days;
				if ( $order->extra10 > 0 ) $max_days += $order->extra10_days;

				if ( $order->extra_revision_days > 0 ) $max_days += $order->extra_revision_days;

				$expected = $order->date_made + ( 24 * 3600 * $max_days );
				$expected = apply_filters( 'wpj_expected_delivery_filter', $expected, $order );

				// Update order
				wpj_update_job_order( ['expected_delivery' => $expected], ['id' => $order->id] );

				return $expected;
			}

			return $order->expected_delivery;
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_update_expected_delivery' ) ) {
	function wpj_update_expected_delivery( $order = '', $new_date = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order && $new_date ) {
			wpj_update_job_order( ['expected_delivery' => $new_date], ['id' => $order->id] );
		}

		return true;
	}
}

if ( ! function_exists( 'wpj_update_expected_delivery_add_days' ) ) {
	function wpj_update_expected_delivery_add_days( $order, $days ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			$expected = wpj_get_expected_delivery( $order );
			$expected = apply_filters( 'wpj_expected_delivery_add_days_filter', $expected + ( 24 * 3600 * $days ), $order, $days );

			wpj_update_job_order( ['expected_delivery' => $expected], ['id' => $order->id] );

			return $expected;
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_set_order_delivery_time' ) ) {
	function wpj_set_order_delivery_time( $order = '' ) {
		if ( ! $order ) $order = get_query_var( 'oid' );

		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( $order ) {
			// Mark order as delivered if instant
			if ( get_post_meta( $order->pid, 'instant', true ) == '1' && wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) != 'yes' )
				wpj_mark_order_as_delivered( $order->id, 1 );

			// Get max days
			$package_id = get_post_meta( $order->pid, 'order_package_no_' . $order->id, true );

			if ( is_numeric( $package_id ) && $package_id < 3 && get_post_meta( $order->pid, 'job_packages', true ) == 'yes' )
				$max_days = get_post_meta( $order->pid, 'package_max_days', true )[$package_id];

			else
				$max_days = get_post_meta( $order->pid, 'max_days', true );

			if ( get_post_meta( $order->pid, 'job_packages', true ) == 'yes' && $order->expected_delivery )
				$max_days = $order->expected_delivery;

			if ( $order->extra_fast != 0 )
				$max_days = $order->extra_fast_days;

			if ( $order->extra1 > 0 )  $max_days += $order->extra1_days;
			if ( $order->extra2 > 0 )  $max_days += $order->extra2_days;
			if ( $order->extra3 > 0 )  $max_days += $order->extra3_days;
			if ( $order->extra4 > 0 )  $max_days += $order->extra4_days;
			if ( $order->extra5 > 0 )  $max_days += $order->extra5_days;
			if ( $order->extra6 > 0 )  $max_days += $order->extra6_days;
			if ( $order->extra7 > 0 )  $max_days += $order->extra7_days;
			if ( $order->extra8 > 0 )  $max_days += $order->extra8_days;
			if ( $order->extra9 > 0 )  $max_days += $order->extra9_days;
			if ( $order->extra10 > 0 ) $max_days += $order->extra10_days;

			if ( $order->extra_revision_days > 0 ) $max_days += $order->extra_revision_days;

			$max_days = apply_filters( 'wpj_delivery_days_filter', $max_days, $order );

			if ( $max_days ) {
				$expected_delivery = current_time( 'timestamp', 1 ) + ( 24 * 3600 * $max_days );
				$expected_delivery = apply_filters( 'wpj_expected_delivery_filter', $expected_delivery, $order );

				wpj_update_expected_delivery( $order, $expected_delivery );
			}
		}
	}
}