<?php
if ( ! function_exists( 'wpj_request_extend_order_delivery_time' ) ) {
	function wpj_request_extend_order_delivery_time( $oid = '', $message = '', $days = '' ) {
		$oid     = WPJ_Form::post( 'oid', $oid );
		$message = WPJ_Form::post( 'extended_days_message', $message );
		$days    = WPJ_Form::post( 'extended_days_selector', $days );

		if ( ! is_demo_user() ) {
			if ( $message ) {
				if ( $days ) {
					if ( $oid ) {
						$order = wpj_get_job_order_by_id( $oid );

						if ( $order ) {
							$seller_id      = get_post_field( 'post_author', $order->pid );
							$extended_exist = wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id], 'var' );

							if ( $extended_exist ) {
								wpj_update_extend_delivery_time_order(
									[
										'message'           => $message,
										'days'              => $days,
										'date_modification' => current_time( 'timestamp', 1 ),
										'status'            => 0
									],
									['order_id' => $order->id]
								);

							} else {
								wpj_insert_extend_delivery_time_order(
									[
										'order_id' => $order->id,
										'message'  => $message,
										'days'     => $days
									],
									['%d', '%s', '%d']
								);

							}

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => -49, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notifications
								wpj_update_user_notifications([
									'user1'       => $order->uid,
									'user2'       => $seller_id,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'extend_delivery_request',
									'order_id'    => $order->id
								]);

								// Send email
								wpj_notify_user_translated( 'extend_delivery_request', $order->uid, [
									'##transaction_number##'      => wpj_camouflage_oid( $order->id, $order->date_made ),
									'##transaction_page_link##'   => wpj_get_order_link( $order->id ),
									'##sender_username##'         => wpj_get_user_display_type( $seller_id ),
									'##job_name##'                => $order->job_title,
									'##job_link##'                => urldecode( get_permalink( $order->pid ) ),
									'##extend_delivery_message##' => $message,
									'##extend_delivery_days##'    => $days
								]);
							}
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_abort_extend_delivery_time' ) ) {
	function wpj_abort_extend_delivery_time( $oid = '' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( ! is_demo_user() ) {
			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );

					$updated = wpj_update_extend_delivery_time_order(
						['date_modification' => current_time( 'timestamp', 1 ), 'status' => 3],
						['order_id' => $order->id, 'status' => 0]
					);

					if ( $updated ) {
						// Insert notification
						$this_notification = wpj_insert_order_notification( ['uid' => -50, 'oid' => $order->id, 'content' => __( 'Extended Aborted', 'wpjobster')], ['%d', '%d', '%s'] );

						if ( $this_notification > 0 ) {
							// Update notifications
							wpj_update_user_notifications([
								'user1'       => $order->uid,
								'user2'       => $seller_id,
								'type'        => 'notifications',
								'number'      => +1,
								'notify_id'   => $this_notification,
								'notify_type' => 'extend_delivery_abort',
								'order_id'    => $order->id
							]);

							// Send email
							$extended_order = wpj_get_extended_delivery_order( 'id, message, days', ['order_id' => $order->id, 'status' => 0], 'row' );

							wpj_notify_user_translated( 'extend_delivery_abort', $order->uid, [
								'##transaction_number##'      => wpj_camouflage_oid( $order->id, $order->date_made ),
								'##transaction_page_link##'   => wpj_get_order_link( $order->id ),
								'##sender_username##'         => wpj_get_user_display_type( $seller_id ),
								'##job_name##'                => $order->job_title,
								'##job_link##'                => urldecode( get_permalink( $order->pid ) ),
								'##extend_delivery_message##' => $extended_order->message,
								'##extend_delivery_days##'    => $extended_order->days
							]);
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_accept_extend_delivery_time' ) ) {
	function wpj_accept_extend_delivery_time( $oid = '' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( ! is_demo_user() ) {
			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );

					$updated = wpj_update_extend_delivery_time_order(
						['date_modification' => current_time( 'timestamp', 1 ), 'status' => 1],
						['order_id' => $order->id, 'status' => 0]
					);

					if ( $updated ) {
						// Insert notification
						$this_notification = wpj_insert_order_notification( ['uid' => -51, 'oid' => $order->id, 'content' => __( 'Accepted', 'wpjobster')], ['%d', '%d', '%s'] );

						if ( $this_notification > 0 ) {
							// Get order
							$extended_order = wpj_get_extended_delivery_order( 'id, days, message', ['order_id' => $order->id, 'status' => 1], 'row' );

							// Add days
							wpj_update_expected_delivery_add_days( $order->id, $extended_order->days );

							// Update notifications
							wpj_update_user_notifications([
								'user1'       => $seller_id,
								'user2'       => $order->uid,
								'type'        => 'notifications',
								'number'      => +1,
								'notify_id'   => $this_notification,
								'notify_type' => 'extend_delivery_accept',
								'order_id'    => $order->id
							]);

							// Send email
							wpj_notify_user_translated( 'extend_delivery_accept', $seller_id, [
								'##transaction_number##'      => wpj_camouflage_oid( $order->id, $order->date_made ),
								'##transaction_page_link##'   => wpj_get_order_link( $order->id ),
								'##sender_username##'         => wpj_get_user_display_type( $order->uid ),
								'##job_name##'                => $order->job_title,
								'##job_link##'                => urldecode( get_permalink( $order->pid ) ),
								'##extend_delivery_message##' => $extended_order->message,
								'##extend_delivery_days##'    => $extended_order->days
							]);
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_deny_extend_delivery_time' ) ) {
	function wpj_deny_extend_delivery_time( $oid = '' ) {
		$oid = WPJ_Form::post( 'oid', $oid );

		if ( ! is_demo_user() ) {
			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );

					$updated = wpj_update_extend_delivery_time_order(
						['date_modification' => current_time( 'timestamp', 1 ), 'status' => 2],
						['order_id' => $order->id, 'status' => 0]
					);

					if ( $updated ) {
						// Insert notification
						$this_notification = wpj_insert_order_notification( ['uid' => -52, 'oid' => $order->id, 'content' => __( 'Declined', 'wpjobster')], ['%d', '%d', '%s'] );

						if ( $this_notification > 0 ) {
							// Update notifications
							wpj_update_user_notifications([
								'user1'       => $seller_id,
								'user2'       => $order->uid,
								'type'        => 'notifications',
								'number'      => +1,
								'notify_id'   => $this_notification,
								'notify_type' => 'extend_delivery_decline',
								'order_id'    => $order->id
							]);

							// Send email
							$extended_order = wpj_get_extended_delivery_order( 'id, message, days', ['order_id' => $order->id], 'row' );

							wpj_notify_user_translated( 'extend_delivery_decline', $seller_id, [
								'##transaction_number##'      => wpj_camouflage_oid( $order->id, $order->date_made ),
								'##transaction_page_link##'   => wpj_get_order_link( $order->id ),
								'##sender_username##'         => wpj_get_user_display_type( $order->uid ),
								'##job_name##'                => $order->job_title,
								'##job_link##'                => urldecode( get_permalink( $order->pid ) ),
								'##extend_delivery_message##' => $extended_order->message,
								'##extend_delivery_days##'    => $extended_order->days
							]);
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}