<?php
if ( ! function_exists( 'wpj_get_order_extras_info' ) ) {
	function wpj_get_order_extras_info( $selected_extras = '', $pid = '' ) {

		if ( ! $selected_extras ) {
			$extras = explode( '|', WPJ_Form::get( 'extras' ) );
			if ( count( $extras ) <= 1 ) $extras = explode( '_', WPJ_Form::get( 'extras' ) );

			$extras_amounts = explode( '|', WPJ_Form::get( 'extras_amounts' ) );
			if ( count( $extras_amounts ) <= 1 ) $extras_amounts = explode( '_', WPJ_Form::get( 'extras_amounts' ) );

			$selected_extras = ( count( $extras ) - 1 ) . '|' . implode( '|', $extras ) . substr( implode( '|', $extras_amounts ), 0, -1 );
		}

		// Order extras
		$order_extras_sep = explode( '|', $selected_extras );
		$order_extras     = $order_extras_sep[0];

		$extra          = [];
		$extra_quantity = [];

		for ( $i = 1; $i <= $order_extras; $i++ ) {
			$extra[$i] = $order_extras_sep[0 + $i];
			$extra_quantity[$i] = $order_extras_sep[0 + $i + $order_extras];
		}

		$extras_arr = [];

		for ( $i = 1; $i <= 10; $i++ ) {
			if ( isset( $extra[$i] ) ) {
				$extras_arr['extra' . $extra[$i]] = 0;
				if ( ! empty( $extra[$i] ) ) {
					$extras_arr['extra' . $extra[$i]] = $extra_quantity[$i];
				}
			}
		}

		for ( $i = 1; $i <= 10; $i++ ) {
			if ( isset( $extras_arr['extra' . $i] ) ) {
				$extra[$i] = $extras_arr['extra' . $i];
			} else {
				$extra[$i] = 0;
			}
		}

		if ( isset( $extras_arr['extraf'] ) ) {
			$extra['f'] = $extras_arr['extraf'];
		} else {
			$extra['f'] = 0;
		}

		if ( isset( $extras_arr['extrar'] ) ) {
			$extra['r'] = $extras_arr['extrar'];
		} else {
			$extra['r'] = 0;
		}

		// Total selected extras price
		$extras_price = 0;
		if ( count( $extras_arr ) ) {

			for ( $i = 1; $i <= 10; $i++ ) {
				if ( isset( $extras_arr['extra' . $i] ) && $extras_arr['extra' . $i] != 0 ) {
					$extra_price   = get_post_meta( $pid, 'extra' . $i . '_price', true );
					$extras_price += $extra_price * $extras_arr['extra' . $i];
				}
			}

			if ( isset( $extras_arr['extraf'] ) && $extras_arr['extraf'] != 0 ) {
				$efd_price     = get_post_meta( $pid, 'extra_fast_price', true );
				$extras_price += $efd_price * $extras_arr['extraf'];
			}

			if ( isset( $extras_arr['extrar'] ) && $extras_arr['extrar'] != 0 ) {
				$ad_price      = get_post_meta( $pid, 'extra_revision_price', true );
				$extras_price += $ad_price * $extras_arr['extrar'];
			}

		}

		// Extras info
		$extra_prices = [];
		$extra_titles = [];
		$extra_days   = [];

		for ( $i = 1; $i <= 10; $i++ ) {
			$extra_prices[$i] = get_post_meta( $pid, "extra" . $i . "_price", true );
			$extra_titles[$i] = esc_sql( wpj_encode_emoji( get_post_meta( $pid, "extra" . $i . "_content", true ) ) );
			$extra_days[$i]   = get_post_meta( $pid, "max_days_ex_" . $i, true );

			if ( ! is_numeric( $extra_days[$i] ) )
				$extra_days[$i] = 0;
		}

		$extra_fast_amount = $extra_fast_price = $extra_fast_days = 0;
		if ( isset( $extras_arr['extraf'] ) && $extras_arr['extraf'] != 0 ) {
			$extra_fast_amount = $extras_arr['extraf'];
			$extra_fast_price  = get_post_meta( $pid, 'extra_fast_price', true );
			$extra_fast_days   = get_post_meta( $pid, 'extra_fast_days', true );
		}

		$extra_revision_amount = $extra_revision_price = $extra_revision_days = 0;
		if ( isset( $extras_arr['extrar'] ) && $extras_arr['extrar'] != 0 ) {
			$extra_revision_amount = $extras_arr['extrar'];
			$extra_revision_price  = get_post_meta( $pid, 'extra_revision_price', true );
			$extra_revision_days   = get_post_meta( $pid, 'extra_revision_days', true );
		}

		$extras_info = [];

		$extras_info['extras_price'] = $extras_price;

		for ( $i = 1; $i <= 10; $i++ ) {
			$extras_info['extra' . $i]            = $extra[$i];
			$extras_info['extra' . $i . '_price'] = $extra_prices[$i];
			$extras_info['extra' . $i . '_title'] = $extra_titles[$i];
			$extras_info['extra' . $i . '_days']  = $extra_days[$i];
		}

		$extras_info['extra_fast_amount'] = $extra_fast_amount;
		$extras_info['extra_fast_price']  = $extra_fast_price;
		$extras_info['extra_fast_days']   = $extra_fast_days;

		$extras_info['extra_revision_amount'] = $extra_revision_amount;
		$extras_info['extra_revision_price']  = $extra_revision_price;
		$extras_info['extra_revision_days']   = $extra_revision_days;

		return $extras_info;

	}
}

if ( ! function_exists( 'wpj_get_checkout_extras_info' ) ) {
	function wpj_get_checkout_extras_info( $pid = '', $payment_type = '', $ret_var = 'all' ) {
		$extra_job_add = [];
		$extra_price   = 0;
		$h             = 0;

		if ( $payment_type == 'job_purchase' ) {
			$sts = 0;

			if ( wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != "no" )
				$sts = wpj_get_user_feature_value( 'extras', 'noof_extras', 0, get_current_user_id() );

			for ( $k = 1; $k <= $sts; $k++ ) {
				$extra_price   = get_post_meta( $pid, 'extra' . $k . '_price',   true );
				$extra_content = get_post_meta( $pid, 'extra' . $k . '_content', true );
				$extra_enabled = get_post_meta( $pid, 'extra' . $k . '_enabled', true );

				if ( is_numeric( $extra_price ) && ! empty( $extra_content ) ) {
					$extra_job_add[$h]['content']  = $extra_content;
					$extra_job_add[$h]['price']    = $extra_price;
					$extra_job_add[$h]['extra_nr'] = $k;
					$extra_job_add[$h]['enabled']  = $extra_enabled;
					$h++;
				}
			}
		}

		if ( $ret_var == 'extra_job_add' ) return $extra_job_add;
		if ( $ret_var == 'extra_price' ) return $extra_price;

		return ['extra_job_add' => $extra_job_add, 'extra_price' => $extra_price];
	}
}