<?php
if ( ! function_exists( 'wpj_save_inserted_review' ) ) {
	function wpj_save_inserted_review( $oid = '', $rid = '', $stars = '', $reason = '', $sample = '', $skills = '', $user_type = '' ) {
		if ( ! is_user_logged_in() ) die();

		$oid       = WPJ_Form::post( 'oid', $oid );
		$rid       = WPJ_Form::post( 'rid', $rid );
		$stars     = WPJ_Form::post( 'stars', $stars );
		$reason    = WPJ_Form::post( 'reason', $reason );
		$sample    = WPJ_Form::post( 'sample', $sample );
		$skills    = WPJ_Form::post( 'skills', $skills );
		$user_type = WPJ_Form::post( 'user_type', $user_type );

		if ( ! $oid ) $oid = get_query_var( 'oid' );

		$order = wpj_get_job_order_by_id( $oid );

		if ( $reason ) $reason = esc_sql( urldecode( $reason ) );

		if ( $user_type == 'seller' && get_current_user_id() == get_post_field( 'post_author', $order->pid ) )
			wpj_save_seller_rating( $order, $stars, $reason );

		elseif ( $user_type == 'buyer' && get_current_user_id() == $order->uid )
			wpj_save_buyer_rating( $order, $rid, $stars, $reason, $sample, $skills );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_save_buyer_rating' ) ) {
	function wpj_save_buyer_rating( $order, $rid, $stars, $reason, $sample, $skills ) {
		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( ! is_demo_user() ) {
			$seller_id = get_post_field( 'post_author', $order->pid );

			// Sample
			// reupload so we can apply watermark without breaking the delivered image
			$attach_id = '';

			if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' && $sample ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				require_once( ABSPATH . 'wp-admin/includes/image.php' );

				$image_path    = get_attached_file( $sample );
				$uploaded_bits = wp_upload_bits( basename( $image_path ), null, file_get_contents( $image_path ) );
				$file_array    = ['name' => basename( $image_path ), 'tmp_name' => $uploaded_bits['file']];

				// Get attachment id
				$attach_id = media_handle_sideload( $file_array, $order->pid );

				if ( is_wp_error( $attach_id ) ) {
					// Delete file
					@unlink( $file_array['tmp_name'] );

				} else {
					// Get attachment data
					$attach_data = wp_get_attachment_metadata( $attach_id );

					// Update meta
					update_post_meta( $attach_id, 'is_review', 1 );

					// Action
					do_action( 'wpj_after_file_complete_upload_action', $attach_data, $attach_id );

				}
			}

			// Skills
			if ( $skills ) {
				foreach ( $skills as $tag_key => $tag_value ) {
					$current_arr = get_user_meta( $seller_id, 'user_skills_thumbsup', true );

					if ( ! $current_arr ) {
						update_user_meta( $seller_id, 'user_skills_thumbsup', [$tag_value => 1] );

					} else {
						if ( isset( $current_arr[$tag_value] ) ) $current_arr[$tag_value] += 1;
						else $current_arr[$tag_value] = 1;

						update_user_meta( $seller_id, 'user_skills_thumbsup', $current_arr );

					}
				}
			}

			// Update job rating table
			wpj_update_job_rating(['grade' => $stars, 'reason' => $reason, 'awarded' => 1, 'sample' => $attach_id], ['id' => $rid]);

			// Update job rating avg meta
			wpj_update_job_rating_metas( $order->pid );

			// Update job rating meta
			$rating = get_post_meta( $order->pid, 'rating', true );

			if ( empty( $rating ) ) $rating = 0;

			$rating = $rating + 1;

			update_post_meta( $order->pid, 'rating', $rating );

			// Insert notification
			$this_notification = wpj_insert_order_notification(['uid' => -18, 'oid' => $order->id, 'content' => __( 'Reviewed by the buyer', 'wpjobster' )], ['%d', '%d', '%s']);

			if ( $this_notification > 0 ) {
				// Update notification
				wpj_update_user_notifications([
					'user1'       => $seller_id,
					'user2'       => get_current_user_id(),
					'type'        => 'notifications',
					'number'      => +1,
					'notify_id'   => $this_notification,
					'notify_type' => 'new_feedback',
					'order_id'    => $order->id
				]);

				// Send emails
				if ( wpj_is_custom_offer( $order->pid ) ) {
					wpj_rate_custom_offer( $order->id, $seller_id, get_current_user_id() );

				} else {
					wpj_notify_user_translated( 'new_feedback', $seller_id, [
						'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
						'##transaction_page_link##' => wpj_get_order_link( $order->id ),
						'##sender_username##'       => wpj_get_user_display_type( get_current_user_id() ),
						'##job_name##'              => $order->job_title,
						'##job_link##'              => urldecode( get_permalink( $order->pid ) )
					]);

				}
			}
		}
	}
}

if ( ! function_exists( 'wpj_save_seller_rating' ) ) {
	function wpj_save_seller_rating( $order, $stars, $reason ) {
		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		if ( ! is_demo_user() ) {
			$seller_id = get_post_field( 'post_author', $order->pid );

			// Insert seller rating
			wpj_insert_job_seller_rating(
				['orderid' => $order->id, 'uid' => $order->uid, 'pid' => $order->pid, 'grade' => $stars, 'reason' => $reason],
				['%d', '%d', '%d', '%d', '%s']
			);

			// Update job rating meta
			$rating = get_post_meta( $order->pid, 'rating', true );

			if ( empty( $rating ) ) $rating = 0;

			$rating = $rating + 1;

			update_post_meta( $order->pid, 'rating', $rating );

			// Insert notification
			$this_notification = wpj_insert_order_notification(['uid' => -19, 'oid' => $order->id, 'content' => __( 'Reviewed by the seller', 'wpjobster' )], ['%d', '%d', '%s']);

			if ( $this_notification > 0 ) {
				// Update notification
				wpj_update_user_notifications([
					'user1'       => $order->uid,
					'user2'       => $seller_id,
					'type'        => 'notifications',
					'number'      => +1,
					'notify_id'   => $this_notification,
					'notify_type' => 'new_feedback',
					'order_id'    => $order->id
				]);

				// Send emails
				if ( wpj_is_custom_offer( $order->pid ) ) {
					wpj_rate_custom_offer( $order->id, $order->uid, $seller_id );

				} else {
					wpj_notify_user_translated( 'new_feedback', $order->uid, [
						'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
						'##transaction_page_link##' => wpj_get_order_link( $order->id ),
						'##sender_username##'       => wpj_get_user_display_type( $seller_id ),
						'##job_name##'              => $order->job_title,
						'##job_link##'              => urldecode( get_permalink( $order->pid ) )
					]);

				}
			}
		}
	}
}