<?php
if ( ! function_exists( 'wpj_request_mutual_cancelation' ) ) {
	function wpj_request_mutual_cancelation( $oid = '', $message = '', $process_action = '' ) {
		if ( ! is_demo_user() && is_user_logged_in() ) {
			$oid            = WPJ_Form::post( 'oid', $oid );
			$message        = WPJ_Form::post( 'message_to_buyer', $message );
			$process_action = WPJ_Form::post( 'process_action', $process_action );

			if ( ! $oid ) $oid = get_query_var( 'oid' );

			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					if ( $order->request_cancellation_from_buyer != 1 && $order->request_cancellation_from_seller != 1 ) {
						$seller_id = get_post_field( 'post_author', $order->pid );

						if ( $process_action == 'confirm_cancellation_from_seller' ) { // Seller
							$uid_val            = -8;
							$to_user            = $order->uid;
							$from_user          = $seller_id;
							$email_reason       = 'cancel_seller';
							$email_offer_reason = 'cancel_offer_seller';
							$db_message_to      = 'message_to_buyer';
							$db_request_from    = 'request_cancellation_from_seller';

						} elseif ( $process_action == 'confirm_cancellation_from_buyer' ) { // Buyer
							$uid_val            = -9;
							$to_user            = $seller_id;
							$from_user          = $order->uid;
							$email_reason       = 'cancel_buyer';
							$email_offer_reason = 'cancel_offer_buyer';
							$db_message_to      = 'message_to_seller';
							$db_request_from    = 'request_cancellation_from_buyer';

						}

						if ( isset( $uid_val ) ) {
							// Update order
							wpj_update_job_order(
								[
									$db_message_to                => addslashes( $message ),
									$db_request_from              => 1,
									'accept_cancellation_request' => 0,
									'date_request_cancellation'   => current_time( 'timestamp', 1 ),
								],
								['id' => $order->id]
							);

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => $uid_val, 'oid' => $order->id, 'content' => $message], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notifications
								wpj_update_user_notifications([
									'user1'       => $to_user,
									'user2'       => $from_user,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'mutual_cancellation_request',
									'order_id'    => $order->id
								]);

								// Send emails
								if ( wpj_is_custom_offer( $order->pid ) ) {
									wpj_cancel_custom_offer( $email_offer_reason, $order->id, $to_user );

								} else {
									wpj_notify_user_translated( $email_reason, $to_user, [
										'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
										'##transaction_page_link##' => wpj_get_order_link( $order->id ),
										'##sender_username##'       => wpj_get_user_display_type( $from_user ),
										'##job_name##'              => $order->job_title,
										'##job_link##'              => urldecode( get_permalink( $order->pid ) )
									]);

								}
							}
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_abort_mutual_cancelation' ) ) {
	function wpj_abort_mutual_cancelation( $oid = '' ) {
		if ( ! is_demo_user() && is_user_logged_in() ) {
			$oid = WPJ_Form::post( 'oid', $oid );

			if ( ! $oid ) $oid = get_query_var( 'oid' );

			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					if ( $order->request_cancellation_from_buyer == 1 || $order->request_cancellation_from_seller == 1 ) {
						$seller_id = get_post_field( 'post_author', $order->pid );

						if ( $seller_id == get_current_user_id() && $order->request_cancellation_from_seller == 1  ) { // Seller
							$uid_val            = -16;
							$to_user            = $order->uid;
							$from_user          = $seller_id;
							$email_reason       = 'cancel_abort_seller';
							$email_offer_reason = 'cancel_offer_abort_seller';
							$db_request_from    = 'request_cancellation_from_seller';

						} elseif ( $order->uid == get_current_user_id() && $order->request_cancellation_from_buyer == 1 ) { // Buyer
							$uid_val            = -17;
							$to_user            = $seller_id;
							$from_user          = $order->uid;
							$email_reason       = 'cancel_abort_buyer';
							$email_offer_reason = 'cancel_offer_abort_buyer';
							$db_request_from    = 'request_cancellation_from_buyer';

						}

						if ( isset( $uid_val ) ) {
							// Update order
							wpj_update_job_order([$db_request_from => 0], ['id' => $order->id]);

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => $uid_val, 'oid' => $order->id, 'content' => __( 'Cancellation Aborted', 'wpjobster' )], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notifications
								wpj_update_user_notifications([
									'user1'       => $to_user,
									'user2'       => $from_user,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'mutual_cancellation_abort',
									'order_id'    => $order->id
								]);

								// Send emails
								if ( wpj_is_custom_offer( $order->pid ) ) {
									wpj_cancel_custom_offer( $email_offer_reason, $order->id, $to_user );

								} else {
									wpj_notify_user_translated( $email_reason, $to_user, [
										'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
										'##transaction_page_link##' => wpj_get_order_link( $order->id ),
										'##sender_username##'       => wpj_get_user_display_type( $from_user ),
										'##job_name##'              => $order->job_title,
										'##job_link##'              => urldecode( get_permalink( $order->pid ) )
									]);

								}
							}
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_answer_mutual_cancellation' ) ) {
	function wpj_answer_mutual_cancellation( $oid = '', $accept = '' ) {
		if ( ! is_demo_user() && is_user_logged_in() ) {
			$oid    = WPJ_Form::post( 'oid', $oid );
			$accept = WPJ_Form::post( 'accept', $accept );

			if ( ! $oid ) $oid = get_query_var( 'oid' );

			if ( $oid && $accept ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					if ( $order->accept_cancellation_request == 0 ) {
						$seller_id = get_post_field( 'post_author', $order->pid );

						if ( $order->uid == get_current_user_id() && $order->request_cancellation_from_seller == 1 ) { // Buyer
							if ( $accept == 'yes' ) {
								$uid_val            = -10;
								$email_reason       = 'cancel_acc_buyer';
								$email_offer_reason = 'cancel_offer_acc_buyer';

							} elseif ( $accept == 'no' ) {
								$uid_val             = -11;
								$email_reason        = 'cancel_decl_buyer';
								$email_offer_reason  = 'cancel_offer_decl_buyer';

							}

							$to_user   = $seller_id;
							$from_user = $order->uid;

						} elseif ( $seller_id == get_current_user_id() && $order->request_cancellation_from_buyer == 1 ) { // Seller
							if ( $accept == 'yes' ) {
								$uid_val            = -12;
								$email_reason       = 'cancel_acc_seller';
								$email_offer_reason = 'cancel_offer_acc_seller';

							} elseif ( $accept == 'no' ) {
								$uid_val             = -13;
								$email_reason        = 'cancel_decl_seller';
								$email_offer_reason  = 'cancel_offer_decl_seller';

							}

							$from_user = $seller_id;
							$to_user   = $order->uid;

						}

						if ( isset( $uid_val ) ) {
							if ( $accept == 'yes' ) {
								// Cancel the order
								wpj_cancel_order_by_id( $order->id, 'mutual' );

							} else {
								// Update order
								wpj_update_job_order(
									[
										'request_cancellation_from_seller' => 0,
										'request_cancellation_from_buyer'  => 0,
										'accept_cancellation_request'      => -1,
									],
									['id' => $order->id]
								);

							}

							// Insert notification
							$this_notification = wpj_insert_order_notification( ['uid' => $uid_val, 'oid' => $order->id, 'content' => sprintf( __( 'Answer: %s', 'wpjobster' ), $accept)], ['%d', '%d', '%s'] );

							if ( $this_notification > 0 ) {
								// Update notifications
								wpj_update_user_notifications([
									'user1'       => $to_user,
									'user2'       => $from_user,
									'type'        => 'notifications',
									'number'      => +1,
									'notify_id'   => $this_notification,
									'notify_type' => 'mutual_cancellation_answer',
									'order_id'    => $order->id
								]);

								// Send emails
								if ( wpj_is_custom_offer( $order->pid ) ) {
									wpj_cancel_custom_offer( $email_offer_reason, $order->id, $to_user );

								} else {
									wpj_notify_user_translated( $email_reason, $to_user, [
										'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
										'##transaction_page_link##' => wpj_get_order_link( $order->id ),
										'##sender_username##'       => wpj_get_user_display_type( $from_user ),
										'##job_name##'              => $order->job_title,
										'##job_link##'              => urldecode( get_permalink( $order->pid ) )
									]);

								}
							}
						}
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}